"""
pysbf2 Performance benchmarking utility

Usage (kwargs optional): python3 benchmark.py cycles=10000

Created on 19 May 2025

:author: semuadmin
:copyright: SEMU Consulting © 2021
:license: BSD 3-Clause
"""

# pylint: disable=line-too-long

from io import BytesIO
from sys import argv
from time import process_time_ns
from platform import version as osver, python_version
from pysbf2.sbfreader import SBFReader
from pysbf2._version import __version__ as sbfver

SBFMESSAGES = [
    b"$@\xd0\xd1\xa3\x0f@\x00\xf0PV\x18?\tM\x02\x00\x00\xa09\xb0+\x06\x00\x00\x00\x8a\xbb\x00\x00\x00\xb1\x00\x00\x90<\x00T0\xbf\x00\xc0l\xbe\x00\x1az\xbf\x00\x00\x80,\x00\x10\x9f;\x03K\t\x00\x02\x00\x01\x00",
    b"$@\x1b\x12\xc0\x0f \x00 \xc6V\x18?\tM\x02\x00\x00\xd0'\x00\x00P0\x80\x97\x06\x00?\x00\x00\xb1",
    b"$@\x14\x80\x18\x100\x000\xedV\x18?\t\xac\x00\x00\x00\x003\x00\x00\xd03\x00\x00\x98\xb5\x00\x00\xf85\x00\x00\xe4G\x00\x00\xa0\xc7\x00\x00\xf0I\x00\x00\xe8\xc9",
    b"$@\xce\xa0\xc2\x0f(\x00(\x95W\x18?\t`\x02P\x00\x00\x00\xe6Hc\xa9\x0f\x15\x0fc\x00\x00\x03Y\x00\x00\x00\x00\x00\x00\x00\x00",
    b"$@Yr\xc4\x0f(\x00\x00lX\x18?\t*\t\x08\x00\xfc\x01\x00\x00@1\x00\x00\x00\x00\x00\x00\x10\xbe\x00\x00\xf0<\x00\x00,\xba",
    b"$@\xba,\x05\x170\x00\xf0\xbbY\x18?\t\t\x00\x00\x00`2\x00\x00\xc02\x00\x00\x80\xb3\x00\x00\x00\xb4\x00\x00\xccG\x00\x00\x00H\x00\x00\x80\xc7\x00\x00\xe0\xc8",
    b"$@\xe7\x8a\x06\x17(\x00\xf0\xbbY\x18?\t\t\x00\x00\x00\x00\xa8\x00\x00\x00\x00\x00\x00(\xbe\x00\x00\t\x00?\x12\x89\x07\x12\x00\x00H",
    b"$@aF\x19\x10 \x00\x10\nZ\x18?\t\xac\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\xbe\x04=\x06\x04",
    b"$@$W\xa2\x0f\x98\x00\x18\\Z\x18?\tM\x02\x00\x00\x00\xe0\x9c@\xb5@\x00\x00\x00\xa5`\xe3\xd5?\x00\x00\x00\x00\xb9\xc6<?\x00\x00\x00\xe7\xab\xa4\xd3?\x00\x00\x00\xc3\x9c\xdf\xc6\xbf\x00\x00\x80\x8aD\n\xe6\xbf\x00J\x02\xb1\x00\x00z\xae\x00\x14\x980\x00\xe0 \xb6\x00\xb0\x886\x00(|C\x00 R\xc2\x00\x00\x802\x00\x00\xe0\xb2h7\x06\x00h7\x06\x00\x00\x00\x00\x00\x00\x00\x0e\xac\x00\x00\x00\x80\x02`(\xbf?\t?\t,\x00\x11\x00\x00\xffk\xff\x00\x00`1\x00\x00\x901\xf9\x02\x95\xd0\x03\xbe\xad\xde",
    b"$@F\xdd\xa4/d\x00P#[\x18?\t9\n\x00\x00\x00\xf8Z\xbf\xd1@\x00\x00\x00 \x0eT\xba\xc0\x00\x00\x00 \x8b7\xd0@\x94\xed\x11@\x80\xba\x9e\xbd\x14\x81!\xc0\x00\x00\x00\x00\x00\x00\x800\x00\x00\x80\xb0\x00\x00\x00\x80\x80\x00\t9\x00\x00\xa01\xae?\x06\x00?\x01\x1e\x01\x00\x00\xdd\x04\x01\x03\x00\x00\xfc\x01\x90\x01\x01\x00\x00\x00",
    b"$@\\\xc7\x04\x17<\x00\xb0\x07]\x18?\t\x06\x00\x00\x88\\;\x00\x00\t\x00\x00\xe8o<\x00@,\xb1@\x0c\xa1E8\x8a\x1d?X\xd5P\xbe\xe83G\xbf\x00\x00\xa0\xad\x00\x00\xc4\xb9?\x0b\x00\x00",
    b"$@K^\xad\x0f\xfc\x03\xd0\xc0\xe3\x17?\t2\x0c\x08\x00\x00\x00\x03\x00\x00\x00C\x00Q\x00V\x01\x01\x00\x00\x00\xf3\x00\"\x00\x00\x00\x04\x00\x00\x00\xad@\x11\x00!\x01\x02\x00\x00\x00\x11\x00\x00\x00\x00\x00T\x00\x00\x00\xaa\x00\x0c\x0f\x0b\x01\x03\x00\x00\x00\x04\x05\x00\x00\x00\x00\x06\x00\x00\x00'A\x11\x00\x0c\x01\x04\x00\x00\x00\x11\x00\x00\x00\x00\x00\xad\x00\x00\x00;\x00\x01\x00,\x01\x05\x00\x00\x00\x03\x00\x02\x00\x00\x00\xa8\x00\x00\x00\x99\x00\x01\x00$\x01\x06\x00\x00\x00\x03\x00\x02\x00\x00\x00\x1f\x00\x00\x00Z@\x11\x00\x0c\x01\x07\x00\x00\x00\x11\x00\x00\x00\x00\x00\x16\x00\x00\x00\x05\x01\x11\x00\x0b\x01\x08\x00\x00\x00\x13\x00\x02\x00\x00\x00\x11\x00\x00\x00\x06\x01Q\x006\x01\t\x00\x00\x00\xf3\x00\"\x00\x00\x00\x02\x00\x00\x00|\x00\x11\x00\x1e\x01\n\x00\x00\x00\x13\x00\x02\x00\x00\x00\xf0\x00\x00\x00\xff\xc1\x00\x00\x80\x01\x0b\x00\x00\x001\x00\x00\x00\x00\x00\x1c\x00\x00\x00?@\x11\x00\x11\x01\x0c\x00\x00\x00\x11\x00\x00\x00\x00\x00S\x00\x00\x001A\x04\x05U\x01\r\x00\x00\x00\x0c\x0f\x08\n\x00\x00\x13\x00\x00\x00-A\x11\x00'\x01\x0e\x00\x00\x00\x11\x00\x00\x00\x00\x00\x0c\x00\x00\x00bA\x11\x00\x03\x01\x0f\x00\x00\x00\x11\x00\x00\x00\x00\x00\t\x00\x00\x00\xc4@\x11\x00\x06\x01\x10\x00\x00\x00\x11\x00\x00\x00\x00\x00[\x00\x00\x00\xf5\x00\x04\x05\t\x01\x11\x00\x00\x00\x0c\x07\x08\x00\x00\x00 \x00\x00\x00#\x00\x11\x00\x08\x01\x12\x00\x00\x00\x11\x00\x00\x00\x00\x00\x01\x00\x00\x00u\x00Q\x00;\x01\x13\x00\x00\x00S\x00\x02\x00\x00\x00`\x00\x00\x00$A\x04\x05\x1e\x01\x14\x00\x00\x00\x0c\r\x08\x00\x00\x00\x0e\x00\x00\x00\xf4\x00Q\x00\x02\x01\x15\x00\x00\x00Q\x00\x00\x00\x00\x00N\x00\x00\x00\x92@\x04\x01/\x01\x17\x00\x00\x00\x0c\x01\x00\x00\x00\x00I\x00\x00\x00B\x00\x04\x05+\x01\x18\x00\x00\x00\x04\x07\x00\x02\x00\x00U\x00\x00\x00n\x00\x04\x01'\x01\x19\x00\x00\x00\x0c\x01\x08\x00\x00\x00K\x00\x00\x00\x1e\x00\x04\x00\x05\x01\x1a\x00\x00\x00\x04\x00\x00\x00\x00\x00M\x00\x00\x00\xbb@\x04\x00\n\x01\x1b\x00\x00\x00\x04\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xd7\x00\x11\x00H\x01\x1c\x00\x00\x003\x00\"\x00\x00\x00\xdf\x00\x00\x00\xad@\x11\x00I\x01\x1d\x00\x00\x003\x00\"\x00\x00\x00e\x00\x00\x00WA\x04\x00\t\x01\x1e\x00\x00\x00\x04\x00\x00\x00\x00\x00'\x04\x00\x00$\x00\x01\x00\x10\x01\x1f\x00\x00\x00\x01\x00\x00\x00\x00\x000\x08\x00\x00aA\x01\x00\x0e\x01 \x00\x00\x00\x01\x00\x00\x00\x00\x009\n\x00\x00;A\x01\x00\x10\x01!\x00\x00\x00\x01\x00\x00\x00\x00\x00(\r\x00\x00>\x00\x01\x00F\x01#\x00\x00\x00\x01\x00\x00\x00\x00\x00)\x0e\x00\x00\xc6@A\x003\x01$\x00\x00\x00\xc3\x00\x82\x00\x00\x006\x0c\x00\x00\x88\x00\x01\x00\x04\x01%\x00\x00\x00\x01\x00\x00\x00\x00\x008\x0b\x00\x00:AA\x00I\x01'\x00\x00\x00\xc1\x00\x80\x00\x00\x00*\t\x00\x00\xd1@\x01\x00\x04\x01)\x00\x00\x00\x01\x00\x00\x00\x00\x00\x95\x00\x00\x00L@\x00\x00\x12\x01*\x00\x00\x00\x01\x00\x00\x00\x00\x00\x91\x00\x00\x00q\x00\x00\x00\n\x01+\x00\x00\x00\x01\x00\x00\x00\x00\x00\x9a\x00\x00\x003\x00\x00\x00\x13\x01,\x00\x00\x00\x01\x00\x00\x00\x00\x00\x92\x00\x00\x00>@\x00\x00\x14\x01-\x00\x00\x00\x01\x00\x00\x00\x00\x00\x9c\x00\x00\x007@\x00\x00\x15\x01.\x00\x00\x00\x01\x00\x00\x00\x00\x00\xaa\x00\x00\x00/A\x00\x00$\x01/\x00\x00\x00\x01\x00\x00\x00\x00\x00>\x06\x00\x00\xff\xc1\x00\x00\x80\x011\x00\x00\x00\x01\x00\x00\x00\x00\x00>\x03\x00\x00\xff\xc1\x00\x00\x80\x012\x00\x00\x00A\x00\x00\x00\x00\x00\x97\x00\x00\x00\xff\xc1\x00\x00\x80\x013\x00\x00\x00\x01\x00\x00\x00\x00\x00\xd6\x00\x00\x00\xff\xc1\x00\x00\x80\x014\x00\x00\x00\x01\x00\x00\x00\x00\x00>\x02\x00\x00\xff\xc1\x00\x00\x80\x016\x00\x00\x00\x01\x00\x00\x00\x00\x00\x98\x00\x00\x00\xff\xc1\x00\x00\x80\x017\x00\x00\x00\x01\x00\x00\x00\x00\x00\x9b\x00\x00\x00\xff\xc1\x00\x00\x80\x018\x00\x00\x00\x01\x00\x00\x00\x00\x00",
    b'$@\xf3\xe9\xac\x0f\x88\x01\xd0\xc0\xe3\x17?\t/\x08\x03\x00)\x1a\x96!\x00\x02\x04\x00\xabC\xc6\x0c\x01\x01\x06\x00fs\xbf\x04\x01\x01\x16\x00\xdfe[\x04\x00\x02\x1f\x00\x10#\xbb\x04\x01\x01\x1c\x00m\x18\xa6\x06\x01\x01\x02\x00P0\xbd\x0b\x00\x02\x13\x00\x8au9\x0f\x01\x01\x11\x00\x85f9\x15\x00\x02\x01\x00\x97-\x04\x17\x00\x02\x0c\x00H\x8a\x1a\x01\x01\x01\t\x00rL`\x02\x01\x01\x0e\x00X_\xa1\x00\x00\x02 \x00\xd8\r\x12\x03\x00\x01S\x00\x15w\x0f!\x01\x02T\x00iB,\x04\x00\x02I\x00\xc4\x19\xcf\x10\x00\x02]\x00\x0bs9\x07\x00\x01`\x00\x11r\x9a\x0b\x01\x02N\x00\xe58^\x12\x01\x02U\x00"+\x17\x0f\x00\x02[\x00\xd8_j\x03\x00\x02K\x00\xbb\x0b\xf8\x01\x00\x01M\x00\xf6H\xd5\x03\x01\x01e\x00\x03\x86m\x03\x01\x018\x0b\x95zu\x1c\x01\x02\'\x04\x1f\x0ea\x06\x00\x010\x08\xe5\x89\xa2\x05\x01\x019\n\xdezn\x06\x01\x01)\x0e-M\xd3\x13\x01\x027\x05\x7f4p\x13\x00\x01(\r1\x18M\x1b\x00\x016\x0c\xfe4t\x01\x00\x01/\x01\xfdv\xdf\x02\x00\x011\x07\xa7\x11\\\x00\x01\x01*\t\x89Qe\x01\x01\x01\xdf\x00eC\x8e\x1c\x01\x02\x95\x00\xdd\x1d\t\x07\x01\x01\x91\x00\xfa+\x14\x04\x00\x01\x9a\x00\xe6\x13z\x07\x00\x01\xa8\x00\xe2;3\x0e\x00\x02\x92\x00"\x18\xde\x07\x01\x01\x9c\x00o\x15\x14\x08\x01\x01\xaa\x00Zv;\x0e\x01\x01\xad\x00\x02\x17Y\x11\x00\x02\xa7\x00\xd0S\x05\x1c\x00\x02\xa6\x00\xa7\n\x8c\x01\x01\x01',
    b'$@\x02N\xfa\x0fL\x00\xd0\xc0\xe3\x17?\t\x03\x14\x01a\xff\xffP\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00! \xff\xff\x1c\x00\x00\x00\x03\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00" \xff\xff\x12\x00\x00\x00\x12\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00',
    b"$@\xfc\x18\xfb/L\x00\xd0\xc0\xe3\x17?\t\x03\x10\x04\x00\x00\x00\x01\x02\x0b\x00\xd3Tu\x00\xd3Tu\x00\x01\x00\x00\x00!<\x00\x00@'\x00\x00!\x00\xfa\x00\x04\x04\x00\x00\x04\x04\x00\x00\x01\x00\x00\x00\"\x00\xfa\x00\xba\x00\x00\x00\xba\x00\x00\x00\x01\x00\x00\x00",
    b"$@\xc8\x85\xae/@\x00\xd0\xc0\xe3\x17?\t\x18\x00\xb5\x14\x00\x00r\x00\x00\x00\x00\x00\x00\x00\x08\x04\t\x9c\x03(]\x00\x04']\x00\x0c'`\x00\x05&`\x00\x06'd\x00\x00)[\x00\x01+f\x00\x0b+]\x00",
    b"$@\xd0\xcd\xf2\x0f\x1c\x00\xd0\xc0\xe3\x17?\t\x05\x00\x0b\n\x01\x03\x15\n\x1f\x00\x00\x03\x00\x00",
    b"$@\x01\x11\xd5\x0f\x10\x00\xd0\xc0\xe3\x17?\t\x00\x04",
    b"$@\r\xab\x1a\x10\x10\x00\xd0\xc0\xe3\x17?\t\x00\x04",
    b"$@\\\xdd\xdb/$\x00\xd0\xc0\xe3\x17?\t\x01\x10\x0b\n\x01\x03\x01\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\xff\x00\x00",
    b"$@\x18\xd3\xfc\x0f\x14\x00\xd0\xc0\xe3\x17?\t\x00\x08\x00\x00\x00\x00",
    b"$@\xfc\xc7\t0 \x00\xd0\xc0\xe3\x17?\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    b"$@(;\x8e\x10\x10\x00\xd0\xc0\xe3\x17?\t\x00\x04",
    b"$@\xea\t\x95\x104\x00\xd0\xc0\xe3\x17?\t\x008\xf9\x02\x95\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    b"$@YJ\xad\x0f\x10\x04\xb8\xc4\xe3\x17?\t3\x0c\x08\x00\x00\x00\x03\x00\x00\x00C\x00Q\x00V\x01\x01\x00\x00\x00\xf3\x00\"\x00\x00\x00\x04\x00\x00\x00\xad@\x11\x00!\x01\x02\x00\x00\x00\x11\x00\x00\x00\x00\x00T\x00\x00\x00\xaa\x00\x0c\x0f\x0b\x01\x03\x00\x00\x00\x04\x05\x00\x00\x00\x00\x06\x00\x00\x00'A\x11\x00\x0c\x01\x04\x00\x00\x00\x11\x00\x00\x00\x00\x00\xad\x00\x00\x00;\x00\x01\x00,\x01\x05\x00\x00\x00\x03\x00\x00\x00\x00\x00\xa8\x00\x00\x00\x99\x00\x11\x00$\x01\x06\x00\x00\x00\x13\x00\x02\x00\x00\x00\x1f\x00\x00\x00Z@\x11\x00\x0c\x01\x07\x00\x00\x00\x11\x00\x00\x00\x00\x00\x16\x00\x00\x00\x05\x01Q\x00\x0b\x01\x08\x00\x00\x00S\x00\x02\x00\x00\x00\x11\x00\x00\x00\x06\x01Q\x006\x01\t\x00\x00\x00\xf3\x00\"\x00\x00\x00\x02\x00\x00\x00|\x00\x11\x00\x1e\x01\n\x00\x00\x00\x13\x00\x02\x00\x00\x00\xf0\x00\x00\x00\xff\xc1\x00\x00\x80\x01\x0b\x00\x00\x000\x00\x00\x00\x00\x00\x1c\x00\x00\x00?@\x11\x00\x11\x01\x0c\x00\x00\x00\x11\x00\x00\x00\x00\x00S\x00\x00\x001A\x04\x05U\x01\r\x00\x00\x00\x0c\x0f\x08\n\x00\x00\x13\x00\x00\x00-A\x11\x00'\x01\x0e\x00\x00\x00\x11\x00\x00\x00\x00\x00\x0c\x00\x00\x00bA\x11\x00\x03\x01\x0f\x00\x00\x00\x11\x00\x00\x00\x00\x00[\x00\x00\x00\xf5\x00\x04\x05\t\x01\x11\x00\x00\x00\x0c\x07\x08\x00\x00\x00\x01\x00\x00\x00u\x00Q\x00;\x01\x13\x00\x00\x00S\x00\x02\x00\x00\x00`\x00\x00\x00$A\x04\x04\x1e\x01\x14\x00\x00\x00\x0c\x0c\x08\x00\x00\x00\x0e\x00\x00\x00\xf4\x00Q\x00\x02\x01\x15\x00\x00\x00Q\x00\x00\x00\x00\x00]\x00\x00\x00'\x01\x04\x00\x12\x01\x16\x00\x00\x00\x04\x00\x00\x00\x00\x00N\x00\x00\x00\x92@\x04\x04/\x01\x17\x00\x00\x00\x0c\x04\x08\x00\x00\x00I\x00\x00\x00B\x00\x04\x01+\x01\x18\x00\x00\x00\x04\x03\x00\x02\x00\x00U\x00\x00\x00n\x00\x04\x01'\x01\x19\x00\x00\x00\x0c\x01\x08\x00\x00\x00K\x00\x00\x00\x1e\x00\x04\x00\x05\x01\x1a\x00\x00\x00\x04\x00\x00\x00\x00\x00M\x00\x00\x00\xbb@\x04\x00\n\x01\x1b\x00\x00\x00\x04\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xd7\x00\x11\x00H\x01\x1c\x00\x00\x003\x00\"\x00\x00\x00\xdf\x00\x00\x00\xad@\x11\x00I\x01\x1d\x00\x00\x003\x00\"\x00\x00\x00e\x00\x00\x00WA\x04\x00\t\x01\x1e\x00\x00\x00\x04\x00\x00\x00\x00\x00'\x04\x00\x00$\x00\x01\x00\x10\x01\x1f\x00\x00\x00\x01\x00\x00\x00\x00\x000\x08\x00\x00aA\x01\x00\x0e\x01 \x00\x00\x00\x01\x00\x00\x00\x00\x009\n\x00\x00;A\x01\x00\x10\x01!\x00\x00\x00\x01\x00\x00\x00\x00\x00(\r\x00\x00>\x00\x01\x00F\x01#\x00\x00\x00\x01\x00\x00\x00\x00\x00)\x0e\x00\x00\xc6@A\x003\x01$\x00\x00\x00\xc3\x00\x80\x00\x00\x006\x0c\x00\x00\x88\x00\x01\x00\x04\x01%\x00\x00\x00\x01\x00\x00\x00\x00\x008\x0b\x00\x00:AA\x00I\x01'\x00\x00\x00\xc1\x00\x80\x00\x00\x001\x07\x00\x00-@\x01\x00\x01\x01(\x00\x00\x00\x01\x00\x00\x00\x00\x00*\t\x00\x00\xd1@\x01\x00\x04\x01)\x00\x00\x00\x01\x00\x00\x00\x00\x00\x95\x00\x00\x00L@\x00\x00\x12\x01*\x00\x00\x00\x05\x00\x00\x00\x00\x00\x91\x00\x00\x00q\x00\x00\x00\n\x01+\x00\x00\x00\x01\x00\x00\x00\x00\x00\x9a\x00\x00\x003\x00\x00\x00\x13\x01,\x00\x00\x00\x01\x00\x00\x00\x00\x00\x92\x00\x00\x00>@\x00\x00\x14\x01-\x00\x00\x00\x01\x00\x00\x00\x00\x00\x9c\x00\x00\x007@\x00\x00\x15\x01.\x00\x00\x00\x01\x00\x00\x00\x00\x00\xaa\x00\x00\x00/A\x00\x00$\x01/\x00\x00\x00\x01\x00\x00\x00\x00\x00\xe7\x00\x00\x00\xff\xc1\x00\x00\x80\x011\x00\x00\x00\x01\x00\x00\x00\x00\x00\xe8\x00\x00\x00\xff\xc1\x00\x00\x80\x012\x00\x00\x00\x01\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xff\xc1\x00\x00\x80\x013\x00\x00\x00\x01\x00\x00\x00\x00\x00\xe4\x00\x00\x00\xff\xc1\x00\x00\x80\x014\x00\x00\x00\x01\x00\x00\x00\x00\x00\xea\x00\x00\x00\xff\xc1\x00\x00\x80\x015\x00\x00\x00\x01\x00\x00\x00\x00\x00\xe5\x00\x00\x00\xff\xc1\x00\x00\x80\x016\x00\x00\x00\x01\x00\x00\x00\x00\x00\xe6\x00\x00\x00\xff\xc1\x00\x00\x80\x017\x00\x00\x00\x01\x00\x00\x00\x00\x00\xeb\x00\x00\x00\xff\xc1\x00\x00\x80\x018\x00\x00\x00\x01\x00\x00\x00\x00\x00",
    b'$@_7\xac\x0f\x88\x01\xb8\xc4\xe3\x17?\t/\x08\x03\x00)\x1a\x96!\x00\x02\x04\x00\xabC\xc6\x0c\x01\x01\x06\x00fs\xbf\x04\x01\x01\x16\x00\xdfe[\x04\x00\x02\x1f\x00\x10#\xbb\x04\x01\x01\x1c\x00m\x18\xa6\x06\x01\x01\x02\x00P0\xbd\x0b\x00\x02\x13\x00\x8au9\x0f\x01\x01\x11\x00\x85f9\x15\x00\x02\x01\x00\x97-\x04\x17\x00\x02\x0c\x00H\x8a\x1a\x01\x01\x01\t\x00rL`\x02\x01\x01\x0e\x00X_\xa1\x00\x00\x02 \x00\xd8\r\x12\x03\x00\x01S\x00\x15w\x0f!\x01\x02T\x00iB,\x04\x00\x02I\x00\xc4\x19\xcf\x10\x00\x02]\x00\x0bs9\x07\x00\x01`\x00\x11r\x9a\x0b\x01\x02N\x00\xe58^\x12\x01\x02U\x00"+\x17\x0f\x00\x02[\x00\xd8_j\x03\x00\x02K\x00\xbb\x0b\xf8\x01\x00\x01M\x00\xf6H\xd5\x03\x01\x01e\x00\x03\x86m\x03\x01\x018\x0b\x95zu\x1c\x01\x02\'\x04\x1f\x0ea\x06\x00\x010\x08\xe5\x89\xa2\x05\x01\x019\n\xdezn\x06\x01\x01)\x0e-M\xd3\x13\x01\x027\x05\x7f4p\x13\x00\x01(\r1\x18M\x1b\x00\x016\x0c\xfe4t\x01\x00\x01/\x01\xfdv\xdf\x02\x00\x011\x07\xa7\x11\\\x00\x01\x01*\t\x89Qe\x01\x01\x01\xdf\x00eC\x8e\x1c\x01\x02\x95\x00\xdd\x1d\t\x07\x01\x01\x91\x00\xfa+\x14\x04\x00\x01\x9a\x00\xe6\x13z\x07\x00\x01\xa8\x00\xe2;3\x0e\x00\x02\x92\x00"\x18\xde\x07\x01\x01\x9c\x00o\x15\x14\x08\x01\x01\xaa\x00Zv;\x0e\x01\x01\xad\x00\x02\x17Y\x11\x00\x02\xa7\x00\xd0S\x05\x1c\x00\x02\xa6\x00\xa7\n\x8c\x01\x01\x01',
    b'$@\xb2\xa2\xfa\x0fL\x00\xb8\xc4\xe3\x17?\t\x03\x14\x01a\xff\xffP\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00! \xff\xff\x1c\x00\x00\x00\x03\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00" \xff\xff\x12\x00\x00\x00\x12\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00',
    b'$@!\t\xfb/L\x00\xb8\xc4\xe3\x17?\t\x03\x10\x04\x00\x00\x00\x01\x02\x0b\x00\xbd`u\x00\xbd`u\x00\x01\x00\x00\x00!=\x00\x00@&\x00\x00!\x00\xfa\x00\x04\x04\x00\x00\x04\x04\x00\x00\x01\x00\x00\x00"\x00\xfa\x00\xba\x00\x00\x00\xba\x00\x00\x00\x01\x00\x00\x00',
    b"$@\xcd\x10\xae/@\x00\xb8\xc4\xe3\x17?\t\x17\x00\xb6\x14\x00\x00r\x00\x00\x00\x00\x00\x00\x00\x08\x04\t\x9c\x03([\x00\x04']\x00\x0c'`\x00\x05&`\x00\x06'd\x00\x00)[\x00\x01+f\x00\x0b+]\x00",
    b"$@\xbdS\xf2\x0f\x1c\x00\xb8\xc4\xe3\x17?\t\x05\x00\x0b\n\x01\x03\x15\n\x1f\x00\x00\x03\x00\x00",
    b"$@\xa5C\xd5\x0f\x10\x00\xb8\xc4\xe3\x17?\t\x00\x04",
    b"$@\xa9\xf9\x1a\x10\x10\x00\xb8\xc4\xe3\x17?\t\x00\x04",
    b"$@h\xda\xdb/$\x00\xb8\xc4\xe3\x17?\t\x01\x10\x0b\n\x01\x03\x01\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\xff\x00\x00",
    b"$@\x17*\xfc\x0f\x14\x00\xb8\xc4\xe3\x17?\t\x00\x08\x00\x00\x00\x00",
    b"$@\x03z\t0 \x00\xb8\xc4\xe3\x17?\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    b"$@\x8ci\x8e\x10\x10\x00\xb8\xc4\xe3\x17?\t\x00\x04",
    b"$@Y)\x95\x104\x00\xb8\xc4\xe3\x17?\t\x008\xf9\x02\x95\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    b"$@\x8fg\xad\x0fp\x03\xa0\xc8\xe3\x17?\t+\x0c\x08\x00\x00\x00\x03\x00\x00\x00C\x00Q\x00V\x01\x01\x00\x00\x00\xf3\x00\"\x00\x00\x00T\x00\x00\x00\xaa\x00\x0c\x03\x0b\x01\x03\x00\x00\x00\x04\x01\x00\x00\x00\x00\x06\x00\x00\x00'A\x11\x00\x0c\x01\x04\x00\x00\x00\x11\x00\x00\x00\x00\x00\xad\x00\x00\x00;\x00\x11\x00,\x01\x05\x00\x00\x00\x13\x00\x00\x00\x00\x00\xa8\x00\x00\x00\x99\x00\x01\x00$\x01\x06\x00\x00\x00\x03\x00\x02\x00\x00\x00\x1f\x00\x00\x00Z@Q\x00\x0c\x01\x07\x00\x00\x00Q\x00\x00\x00\x00\x00\x16\x00\x00\x00\x05\x01\x11\x00\x0b\x01\x08\x00\x00\x00\x13\x00\x02\x00\x00\x00\x11\x00\x00\x00\x06\x01Q\x006\x01\t\x00\x00\x00\xf3\x00\"\x00\x00\x00\x02\x00\x00\x00|\x00\x11\x00\x1e\x01\n\x00\x00\x00\x13\x00\x02\x00\x00\x00\xf0\x00\x00\x00\xff\xc1\x00\x00\x80\x01\x0b\x00\x00\x000\x00\x00\x00\x00\x00\x1c\x00\x00\x00?@\x11\x00\x11\x01\x0c\x00\x00\x00\x11\x00\x00\x00\x00\x00S\x00\x00\x001A\x04\x05U\x01\r\x00\x00\x00\x0c\x0f\x08\n\x00\x00\x13\x00\x00\x00-A\x11\x00'\x01\x0e\x00\x00\x00\x11\x00\x00\x00\x00\x00\x0c\x00\x00\x00bAQ\x00\x03\x01\x0f\x00\x00\x00Q\x00\x00\x00\x00\x00\t\x00\x00\x00\xc4@\x11\x00\x06\x01\x10\x00\x00\x00\x11\x00\x00\x00\x00\x00[\x00\x00\x00\xf5\x00\x04\x05\t\x01\x11\x00\x00\x00\x0c\x07\x08\x00\x00\x00 \x00\x00\x00#\x00\x11\x00\x08\x01\x12\x00\x00\x00\x11\x00\x00\x00\x00\x00\x01\x00\x00\x00u\x00Q\x00;\x01\x13\x00\x00\x00S\x00\x02\x00\x00\x00`\x00\x00\x00$A\x04\x05\x1e\x01\x14\x00\x00\x00\x0c\r\x08\x00\x00\x00\x0e\x00\x00\x00\xf4\x00Q\x00\x02\x01\x15\x00\x00\x00Q\x00\x00\x00\x00\x00]\x00\x00\x00&\x01\x04\x00\x12\x01\x16\x00\x00\x00\x04\x00\x00\x00\x00\x00N\x00\x00\x00\x92@\x04\x01/\x01\x17\x00\x00\x00\x0c\x01\x08\x00\x00\x00I\x00\x00\x00B\x00\x04\x05+\x01\x18\x00\x00\x00\x04\x07\x00\x02\x00\x00U\x00\x00\x00n\x00\x04\x04'\x01\x19\x00\x00\x00\x0c\x04\x08\x00\x00\x00K\x00\x00\x00\x1e\x00\x04\x01\x05\x01\x1a\x00\x00\x00\x04\x01\x00\x00\x00\x00M\x00\x00\x00\xbb@\x04\x00\n\x01\x1b\x00\x00\x00\x04\x00\x00\x00\x00\x00\xa7\x00\x00\x00\xd7\x00\x11\x00H\x01\x1c\x00\x00\x003\x00\"\x00\x00\x00\xdf\x00\x00\x00\xac@\x11\x00I\x01\x1d\x00\x00\x003\x00\"\x00\x00\x00e\x00\x00\x00WA\x04\x00\t\x01\x1e\x00\x00\x00\x04\x00\x00\x00\x00\x00'\x04\x00\x00$\x00\x01\x00\x10\x01\x1f\x00\x00\x00\x01\x00\x00\x00\x00\x007\x05\x00\x00\x86\x00\x01\x002\x01\"\x00\x00\x00\x01\x00\x00\x00\x00\x00)\x0e\x00\x00\xc6@A\x003\x01$\x00\x00\x00\xc3\x00\x82\x00\x00\x00/\x01\x00\x001\x01\x01\x00\x07\x01&\x00\x00\x00\x01\x00\x00\x00\x00\x008\x0b\x00\x00:AA\x00I\x01'\x00\x00\x00\xc1\x00\x80\x00\x00\x001\x07\x00\x00-@\x01\x00\x01\x01(\x00\x00\x00\x01\x00\x00\x00\x00\x00*\t\x00\x00\xd1@\x01\x00\x04\x01)\x00\x00\x00\x01\x00\x00\x00\x00\x00\x92\x00\x00\x00>@\x00\x00\x14\x01-\x00\x00\x00\x05\x00\x00\x00\x00\x00\x9c\x00\x00\x007@\x00\x00\x15\x01.\x00\x00\x00\x01\x00\x00\x00\x00\x00\xa6\x00\x00\x00\x1b@\x00\x00\x04\x010\x00\x00\x00\x01\x00\x00\x00\x00\x00\xc2\x00\x00\x00\xff\xc1\x00\x00\x80\x011\x00\x00\x00\x01\x00\x00\x00\x00\x00\xc3\x00\x00\x00\xff\xc1\x00\x00\x80\x014\x00\x00\x00\x01\x00\x00\x00\x00\x00\xc4\x00\x00\x00\xff\xc1\x00\x00\x80\x017\x00\x00\x00\x01\x00\x00\x00\x00\x00\xc1\x00\x00\x00\xff\xc1\x00\x00\x80\x018\x00\x00\x00\x01\x00\x00\x00\x00\x00",
    b"$@x\xa5\xac\x0f\x88\x01\xa0\xc8\xe3\x17?\t/\x08\x03\x00%\x1a\x93!\x00\x02\x04\x00\xabC\xc9\x0c\x01\x01\x06\x00gs\xc1\x04\x01\x01\x16\x00\xdeeZ\x04\x00\x02\x1f\x00\x0e#\xbd\x04\x01\x01\x1c\x00k\x18\xa6\x06\x01\x01\x02\x00Q0\xbb\x0b\x00\x02\x13\x00\x88u:\x0f\x01\x01\x11\x00\x81f8\x15\x00\x02\x01\x00\x98-\x02\x17\x00\x02\x0c\x00F\x8a\x1b\x01\x01\x01\t\x00rLb\x02\x01\x01\x0e\x00V_\x9f\x00\x00\x02 \x00\xd8\r\x10\x03\x00\x01S\x00\x17w\x10!\x01\x02T\x00iB*\x04\x00\x02I\x00\xc2\x19\xcf\x10\x00\x02]\x00\ts8\x07\x00\x01`\x00\x12r\x9c\x0b\x01\x02N\x00\xe48`\x12\x01\x02U\x00#+\x15\x0f\x00\x02[\x00\xd7_h\x03\x00\x02K\x00\xba\x0b\xf6\x01\x00\x01M\x00\xf6H\xd7\x03\x01\x01e\x00\x02\x86n\x03\x01\x018\x0b\x94zx\x1c\x01\x02'\x04\x1f\x0e^\x06\x00\x010\x08\xe3\x89\xa2\x05\x01\x019\n\xdfzq\x06\x01\x01)\x0e.M\xd6\x13\x01\x027\x05\x814m\x13\x00\x01(\r,\x18J\x1b\x00\x016\x0c\xff4r\x01\x00\x01/\x01\xfbv\xde\x02\x00\x011\x07\xa5\x11]\x00\x01\x01*\t\x8aQg\x01\x01\x01\xdf\x00aC\x90\x1c\x01\x02\x95\x00\xdd\x1d\n\x07\x01\x01\x91\x00\xfa+\x14\x04\x00\x01\x9a\x00\xe6\x13x\x07\x00\x01\xa8\x00\xe2;1\x0e\x00\x02\x92\x00!\x18\xdf\x07\x01\x01\x9c\x00n\x15\x15\x08\x01\x01\xaa\x00Yv=\x0e\x01\x01\xad\x00\x02\x17W\x11\x00\x02\xa7\x00\xcaS\x03\x1c\x00\x02\xa6\x00\xa5\n\x8d\x01\x01\x01",
    b'$@X\x11\xfa\x0fL\x00\xa0\xc8\xe3\x17?\t\x03\x14\x01a\xff\xffP\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00! \xff\xff\x1c\x00\x00\x00\x03\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00" \xff\xff\x12\x00\x00\x00\x12\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00',
    b'$@?\x07\xfb/L\x00\xa0\xc8\xe3\x17?\t\x03\x10\x04\x00\x00\x00\x01\x02\x0b\x00\x07lu\x00\x07lu\x00\x01\x00\x00\x00!:\x00\x00@)\x00\x00!\x00\xfa\x00\x04\x04\x00\x00\x04\x04\x00\x00\x01\x00\x00\x00"\x00\xfa\x00\xba\x00\x00\x00\xba\x00\x00\x00\x01\x00\x00\x00',
    b"$@.f\xae/@\x00\xa0\xc8\xe3\x17?\t\x17\x00\xb7\x14\x00\x00r\x00\x00\x00\x00\x00\x00\x00\x08\x04\t\x9c\x03([\x00\x04']\x00\x0c']\x00\x05&`\x00\x06'd\x00\x00)[\x00\x01+f\x00\x0b+]\x00",
    b"$@v]\xf2\x0f\x1c\x00\xa0\xc8\xe3\x17?\t\x05\x00\x0b\n\x01\x03\x15\n\x1f\x00\x00\x03\x00\x00",
    b"$@\xa02\xd5\x0f\x10\x00\xa0\xc8\xe3\x17?\t\x00\x04",
    b"$@\xac\x88\x1a\x10\x10\x00\xa0\xc8\xe3\x17?\t\x00\x04",
    b"$@Cy\xdb/$\x00\xa0\xc8\xe3\x17?\t\x01\x10\x0b\n\x01\x03\x01\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\xff\x00\x00",
    b"$@&\xf5\xfc\x0f\x14\x00\xa0\xc8\xe3\x17?\t\x00\x08\x00\x00\x00\x00",
    b"$@_\x0e\t0 \x00\xa0\xc8\xe3\x17?\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    b"$@\x89\x18\x8e\x10\x10\x00\xa0\xc8\xe3\x17?\t\x00\x04",
    b"$@\x05\xd6\x95\x104\x00\xa0\xc8\xe3\x17?\t\x008\xf9\x02\x95\xd0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
]
msgb = b""
for msg in SBFMESSAGES:
    msgb += msg
SBFBYTES = msgb


def progbar(i: int, lim: int, inc: int = 20):
    """
    Display progress bar on console.

    :param int i: iteration
    :param int lim: max iterations
    :param int inc: bar increments (20)
    """

    i = min(i, lim)
    pct = int(i * inc / lim)
    if not i % int(lim / inc):
        print(
            f"{int(pct*100/inc):02}% " + "\u2593" * pct + "\u2591" * (inc - pct),
            end="\r",
        )


def benchmark(**kwargs) -> float:
    """
    pyrtcm Performance benchmark test.

    :param int cycles: (kwarg) number of test cycles (10,000)
    :returns: benchmark as transactions/second
    :rtype: float
    :raises: SBFStreamError
    """

    cyc = int(kwargs.get("cycles", 5000))
    txnc = len(SBFMESSAGES)
    txnt = txnc * cyc

    print(
        f"\nOperating system: {osver()}",
        f"\nPython version: {python_version()}",
        f"\npysbf2 version: {sbfver}",
        f"\nTest cycles: {cyc:,}",
        f"\nTxn per cycle: {txnc:,}",
    )

    start = process_time_ns()
    print(f"\nBenchmark test started at {start}")
    for i in range(cyc):
        progbar(i, cyc)
        stream = BytesIO(SBFBYTES)
        sbr = SBFReader(stream, parsing=True)
        for _, _ in sbr:
            pass
    end = process_time_ns()
    print(f"Benchmark test ended at {end}.")
    duration = end - start
    msglen = len(SBFBYTES) * cyc
    txs = round(txnt * 1e9 / duration, 2)
    kbs = round(msglen * 1e9 / duration / 2**10, 2)

    print(
        f"\n{txnt:,} messages processed in {duration/1e9:,.3f} seconds = {txs:,.2f} txns/second, {kbs:,.2f} kB/second.\n"
    )

    return txs, kbs


def main():
    """
    CLI Entry point.

    args as benchmark() method
    """

    benchmark(**dict(arg.split("=") for arg in argv[1:]))


if __name__ == "__main__":
    main()
