"""
List of geodetic datums with delta values relative to WGS84.

epd = ellipsoid.
a = semi-major axis.
f = flattening.
dx, dy, dz parameters are WGS-84 X, Y, Z parameters minus the specified datum X, Y, Z in meters.

Source:
http://ncgia.ucsb.edu/units/u015/tables/table03.html

Created on 16 Jan 2023

:author: semuadmin
"""
# pylint: disable=too-many-lines

DATUMS = {
    "Adindan": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -166,
        "dy": -15,
        "dz": 204,
    },
    "Afgooye": {
        "epd": "Krassovsky",
        "a": 6378029,
        "f": 298.299999956546,
        "dx": -43,
        "dy": -163,
        "dz": 45,
    },
    "Ain_El_Abd_1970": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -150,
        "dy": -251,
        "dz": -2,
    },
    "Alaska_(NAD-27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -5,
        "dy": 135,
        "dz": 172,
    },
    "Alaska/Canada_NAD-27": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -9,
        "dy": 151,
        "dz": 185,
    },
    "Anna_1_Astro_1965": {
        "epd": "Australian_National",
        "a": 6378114,
        "f": 298.250000043564,
        "dx": -491,
        "dy": -22,
        "dz": 435,
    },
    "ARC-1950_mean": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -143,
        "dy": -90,
        "dz": -294,
    },
    "ARC-1960_mean": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -160,
        "dy": -8,
        "dz": -300,
    },
    "Ascension_Island_58": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -207,
        "dy": 107,
        "dz": 52,
    },
    "Astro_B4_Sor.Atoll": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 114,
        "dy": -116,
        "dz": -333,
    },
    'Astro_Beacon_"E"': {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 145,
        "dy": 75,
        "dz": -272,
    },
    "Astro_Pos_71/4": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -320,
        "dy": 550,
        "dz": -494,
    },
    "Astronomic_Stn._52": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 124,
        "dy": -234,
        "dz": -25,
    },
    "Australian_Geodetic_1984": {
        "epd": "Australian_National",
        "a": 6378114,
        "f": 298.250000043564,
        "dx": -134,
        "dy": -48,
        "dz": 149,
    },
    "Bahamas_(NAD-27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -4,
        "dy": 154,
        "dz": 178,
    },
    "Bellevue_(IGN)": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -127,
        "dy": -769,
        "dz": 472,
    },
    "Bermuda_1957": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -73,
        "dy": 213,
        "dz": 296,
    },
    "Bogota_Observatory": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 307,
        "dy": 304,
        "dz": -318,
    },
    "Bukit_Rimpah": {
        "epd": "Bessel_1841",
        "a": 6378876.845,
        "f": 299.152812838242,
        "dx": -384,
        "dy": 664,
        "dz": -48,
    },
    "Camp_Area_Astro": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -104,
        "dy": -129,
        "dz": 239,
    },
    "Campo_Inchauspe": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -148,
        "dy": 136,
        "dz": 90,
    },
    "Canada_Mean_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -10,
        "dy": 158,
        "dz": 187,
    },
    "Canal_Zone_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 0,
        "dy": 125,
        "dz": 201,
    },
    "Canton_Island_1966": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 298,
        "dy": -304,
        "dz": -375,
    },
    "Cape": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -136,
        "dy": -108,
        "dz": -292,
    },
    "Cape_Canaveral_mean": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -2,
        "dy": 150,
        "dz": 181,
    },
    "Carribean_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -7,
        "dy": 152,
        "dz": 178,
    },
    "Carthage": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -263,
        "dy": 6,
        "dz": 431,
    },
    "Central_America_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 0,
        "dy": 125,
        "dz": 194,
    },
    "Chatham_1971": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 175,
        "dy": -38,
        "dz": 113,
    },
    "Chua_Astro": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -134,
        "dy": 229,
        "dz": -29,
    },
    "Corrego_Alegre": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -206,
        "dy": 172,
        "dz": -6,
    },
    "Corrego_Alegre_(Provisional)": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -206,
        "dy": 172,
        "dz": -6,
    },
    "Cuba_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -9,
        "dy": 152,
        "dz": 178,
    },
    "Cyprus": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -104,
        "dy": -101,
        "dz": -140,
    },
    "Djakarta(Batavia)": {
        "epd": "Bessel_1841",
        "a": 6378876.845,
        "f": 299.152812838242,
        "dx": -377,
        "dy": 681,
        "dz": -50,
    },
    "DOS_1968": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 230,
        "dy": -199,
        "dz": -752,
    },
    "Easter_lsland_1967": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 211,
        "dy": 147,
        "dz": 111,
    },
    "Egypt": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -130,
        "dy": -117,
        "dz": -151,
    },
    "European_1950": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -87,
        "dy": -96,
        "dz": -120,
    },
    "European_1950_mean": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -87,
        "dy": -98,
        "dz": -121,
    },
    "European_1979_mean": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -86,
        "dy": -98,
        "dz": -119,
    },
    "Finnish_Nautical_Chart": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -78,
        "dy": -231,
        "dz": -97,
    },
    "Gandajika_Base": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -133,
        "dy": -321,
        "dz": 50,
    },
    "Geodetic_Datum_49": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 84,
        "dy": -22,
        "dz": 209,
    },
    "Ghana": {
        "epd": "WGS-84",
        "a": 6378137,
        "f": 298.257223563,
        "dx": 0,
        "dy": 0,
        "dz": 0,
    },
    "Greenland_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 11,
        "dy": 114,
        "dz": 195,
    },
    "Guam_1963": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -100,
        "dy": -248,
        "dz": 259,
    },
    "Gunung_Segara": {
        "epd": "Bessel_1841",
        "a": 6378876.845,
        "f": 299.152812838242,
        "dx": -403,
        "dy": 684,
        "dz": 41,
    },
    "Gunung_Serindung_1962": {
        "epd": "WGS-84",
        "a": 6378137,
        "f": 298.257223563,
        "dx": 0,
        "dy": 0,
        "dz": 0,
    },
    "GUX_1_Astro": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 252,
        "dy": -209,
        "dz": -751,
    },
    "Herat_North": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -333,
        "dy": -222,
        "dz": 114,
    },
    "Hjorsey_1955": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -73,
        "dy": 46,
        "dz": -86,
    },
    "Hong_Kong_1963": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -156,
        "dy": -271,
        "dz": -189,
    },
    "Hu-Tzu-Shan": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -634,
        "dy": -549,
        "dz": -201,
    },
    "Indian": {
        "epd": "Everest",
        "a": 6378997.655,
        "f": 300.801699992346,
        "dx": 289,
        "dy": 734,
        "dz": 257,
    },
    "Iran": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -117,
        "dy": -132,
        "dz": -164,
    },
    "Ireland_1965": {
        "epd": "Modified_Airy",
        "a": 6378933.811,
        "f": 299.324964577565,
        "dx": 506,
        "dy": -122,
        "dz": 611,
    },
    "ISTS_073_Astro_69": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 208,
        "dy": -435,
        "dz": -229,
    },
    "Johnston_Island_61": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 191,
        "dy": -77,
        "dz": -204,
    },
    "Kandawala": {
        "epd": "Everest",
        "a": 6378997.655,
        "f": 300.801699992346,
        "dx": -97,
        "dy": 787,
        "dz": 86,
    },
    "Kerguelen_Island": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 145,
        "dy": -187,
        "dz": 103,
    },
    "Kertau_48": {
        "epd": "Modified_Everest",
        "a": 6378969.937,
        "f": 300.801699992346,
        "dx": -11,
        "dy": 851,
        "dz": 5,
    },
    "L.C._5_Astro": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 42,
        "dy": 124,
        "dz": 147,
    },
    "La_Reunion": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 94,
        "dy": -948,
        "dz": -1262,
    },
    "Liberia_1964": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -90,
        "dy": 40,
        "dz": 88,
    },
    "Luzon": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -133,
        "dy": -77,
        "dz": -51,
    },
    "Mahe_1971": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": 41,
        "dy": -220,
        "dz": -134,
    },
    "Marco_Astro": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -289,
        "dy": -124,
        "dz": 60,
    },
    "Masirah_Is._(Nahrwan)": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -247,
        "dy": -148,
        "dz": 369,
    },
    "Massawa": {
        "epd": "Bessel_1841",
        "a": 6378876.845,
        "f": 299.152812838242,
        "dx": 639,
        "dy": 405,
        "dz": 60,
    },
    "Merchich": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": 31,
        "dy": 146,
        "dz": 47,
    },
    "Mexico_(NAD27)": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -12,
        "dy": 130,
        "dz": 190,
    },
    "Midway_Astro_61": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 912,
        "dy": -58,
        "dz": 1227,
    },
    "Mindanao": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -133,
        "dy": -79,
        "dz": -72,
    },
    "Minna": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -92,
        "dy": -93,
        "dz": 122,
    },
    "Montjong_Lowe": {
        "epd": "WGS-84",
        "a": 6378137,
        "f": 298.257223563,
        "dx": 0,
        "dy": 0,
        "dz": 0,
    },
    "Nahrwan": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -231,
        "dy": -196,
        "dz": 482,
    },
    "Naparima_BWI": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -2,
        "dy": 374,
        "dz": 172,
    },
    "North_America_83": {
        "epd": "GRS_80",
        "a": 6378137,
        "f": 298.257222139682,
        "dx": 0,
        "dy": 0,
        "dz": 0,
    },
    "North_America_1927_mean": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": -8,
        "dy": 160,
        "dz": 176,
    },
    "Observatorio_1966": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -425,
        "dy": -169,
        "dz": 81,
    },
    "Old_Egyptian": {
        "epd": "Helmert_1906",
        "a": 6378074,
        "f": 298.299999956546,
        "dx": -130,
        "dy": 110,
        "dz": -13,
    },
    "Old_Hawaiian_mean": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 89,
        "dy": -279,
        "dz": -183,
    },
    "Old_Hawaiian_Kauai": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 45,
        "dy": -290,
        "dz": -172,
    },
    "Old_Hawaiian_Maui": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 65,
        "dy": -290,
        "dz": -190,
    },
    "Old_Hawaiian_Oahu": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 56,
        "dy": -284,
        "dz": -181,
    },
    "Oman": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -346,
        "dy": -1,
        "dz": 224,
    },
    "Ordnance_Survey_of_Great_Britain_36": {
        "epd": "Airy",
        "a": 6378710.604,
        "f": 299.324964577565,
        "dx": 375,
        "dy": -111,
        "dz": 431,
    },
    "Pico_De_Las_Nieves": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -307,
        "dy": -92,
        "dz": 127,
    },
    "Pitcairn_Astro_67": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 185,
        "dy": 165,
        "dz": 42,
    },
    "Potsdam_Rauenberg_DHDN": {
        "epd": "Bessel_1841",
        "a": 6378876.845,
        "f": 299.152812838242,
        "dx": 606,
        "dy": 23,
        "dz": 413,
    },
    "Provisional_South_American_1956_mean": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -288,
        "dy": 175,
        "dz": -376,
    },
    "Provisional_South_Chilean_1963": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 16,
        "dy": 196,
        "dz": 93,
    },
    "Puerto_Rico": {
        "epd": "Clarke_1866",
        "a": 6378067.6,
        "f": 294.978698229674,
        "dx": 11,
        "dy": 72,
        "dz": -101,
    },
    "Pulkovo_1942": {
        "epd": "Krassovsky",
        "a": 6378029,
        "f": 298.299999956546,
        "dx": 28,
        "dy": -130,
        "dz": -95,
    },
    "Qornoq": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 164,
        "dy": 138,
        "dz": -189,
    },
    "Quatar_National": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -128,
        "dy": -283,
        "dz": 22,
    },
    "Rome_1940": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -225,
        "dy": -65,
        "dz": 9,
    },
    "S_42": {
        "epd": "Krassovsky",
        "a": 6378029,
        "f": 298.299999956546,
        "dx": 28,
        "dy": -121,
        "dz": -77,
    },
    "S.E.Asia_(Indian)": {
        "epd": "Everest",
        "a": 6378997.655,
        "f": 300.801699992346,
        "dx": 173,
        "dy": 750,
        "dz": 264,
    },
    "SAD-69/Brazil": {
        "epd": "South_American_1969",
        "a": 6378114,
        "f": 298.250000043564,
        "dx": -60,
        "dy": -2,
        "dz": -41,
    },
    "Santa_Braz": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -203,
        "dy": 141,
        "dz": 53,
    },
    "Santo_(DOS)": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": 170,
        "dy": 42,
        "dz": 84,
    },
    "Sapper_Hill_43": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -355,
        "dy": 16,
        "dz": 74,
    },
    "Schwarzeck": {
        "epd": "Bessel_1841_(Namibia)",
        "a": 6378790.135,
        "f": 299.152812838242,
        "dx": 616,
        "dy": 97,
        "dz": -251,
    },
    "Sicily": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -97,
        "dy": -88,
        "dz": -135,
    },
    "Sierra_Leone_1960": {
        "epd": "WGS-84",
        "a": 6378137,
        "f": 298.257223563,
        "dx": 0,
        "dy": 0,
        "dz": 0,
    },
    "South_American_1969_mean": {
        "epd": "South_American_1969",
        "a": 6378114,
        "f": 298.250000043564,
        "dx": -57,
        "dy": 1,
        "dz": -41,
    },
    "South_Asia": {
        "epd": "Modified_Fischer_1960",
        "a": 6378119,
        "f": 298.299999956546,
        "dx": 7,
        "dy": -10,
        "dz": -26,
    },
    "Southeast_Base": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -499,
        "dy": -249,
        "dz": 314,
    },
    "Southwest_Base": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -104,
        "dy": 167,
        "dz": -38,
    },
    "Tananarive_Observatory_25": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -189,
        "dy": -242,
        "dz": -91,
    },
    "Thai/Viet_(Indian)": {
        "epd": "Everest",
        "a": 6378997.655,
        "f": 300.801699992346,
        "dx": 214,
        "dy": 836,
        "dz": 303,
    },
    "Timbalai_1948": {
        "epd": "Everest",
        "a": 6378997.655,
        "f": 300.801699992346,
        "dx": -689,
        "dy": 691,
        "dz": -45,
    },
    "Tokyo_mean": {
        "epd": "Bessel_1841",
        "a": 6378876.845,
        "f": 299.152812838242,
        "dx": -128,
        "dy": 481,
        "dz": 664,
    },
    "Tristan_Astro_1968": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -632,
        "dy": 438,
        "dz": -609,
    },
    "Unites_Arab_Emirates_(Nahrwan)": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": -249,
        "dy": -156,
        "dz": 381,
    },
    "Viti_Levu_1916": {
        "epd": "Clarke_1880",
        "a": 6378024.855,
        "f": 293.464999995854,
        "dx": 51,
        "dy": 391,
        "dz": -36,
    },
    "Wake-Eniwetok_60": {
        "epd": "Hough",
        "a": 6378004,
        "f": 297.000000022571,
        "dx": 101,
        "dy": 52,
        "dz": -39,
    },
    "WGS-72": {
        "epd": "WGS-72",
        "a": 6378139,
        "f": 298.259999999113,
        "dx": 0,
        "dy": 0,
        "dz": 5,
    },
    "WGS-84": {
        "epd": "WGS-84",
        "a": 6378137,
        "f": 298.257223563,
        "dx": 0,
        "dy": 0,
        "dz": 0,
    },
    "Yacare": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -155,
        "dy": 171,
        "dz": 37,
    },
    "Zanderij": {
        "epd": "International",
        "a": 6377886,
        "f": 297.000000022571,
        "dx": -265,
        "dy": 120,
        "dz": -358,
    },
}
