Pikchr (pronounced "picture") is a [PIC][1]-like markup
language for diagrams in technical documentation.  Pikchr is
designed to be embedded in [fenced code blocks][2] of
Markdown or similar mechanisms of other documentation markup languages.

[1]: https://en.wikipedia.org/wiki/Pic_language
[2]: https://spec.commonmark.org/0.29/#fenced-code-blocks

For example, the diagram:

``` pikchr
arrow right 200% "Markdown" "Source"
box rad 10px "Markdown" "Formatter" "(markdown.c)" fit
arrow right 200% "HTML+SVG" "Output"
arrow <-> down 70% from last box.s
box same "Pikchr" "Formatter" "(pikchr.c)" fit
```

Is generated by 7 lines of Markdown:

~~~~~~
   ``` pikchr
   arrow right 200% "Markdown" "Source"
   box rad 10px "Markdown" "Formatter" "(markdown.c)" fit
   arrow right 200% "HTML+SVG" "Output"
   arrow <-> down 70% from last box.s
   box same "Pikchr" "Formatter" "(pikchr.c)" fit
   ```
~~~~~~

Pikchr diagrams can appear in:

  *  Documentation
  *  Wiki pages
  *  Tickets and bug reports
  *  Forum posts
  *  Check-in comments
  *  Anywhere else that Markdown or similar markup languages are used

Pikchr diagrams are easy to generate.  The language is simple.
There is lots of documentation and examples on-line (links below).
Anyone who is comfortable using Markdown should be able to pick up Pikchr
with minimal extra effort.

Pikchr is safe for use in internet-facing applications.  Hostile
Pikchr scripts cause no harm (apart from generating ugly diagrams).

## Demos

  *  [Example Pikchr Scripts](./doc/examples.md)
     ([light-mode](/doc/trunk/doc/examples.md?skin=default&once) or
      [dark-mode](/doc/trunk/doc/examples.md?skin=darkmode&once))
  *  [](/pikchrshow) &larr; Enter Pikchr text and see the result on-line
  *  [Source text for this page](./homepage.md?mimetype=text/plain)

## Pikchr Documentation

  *  [Purpose And Scope Of Pikchr](./doc/purpose.md)
  *  [Pikchr User Manual](./doc/userman.md)
  *  [An Example Of How A Pikchr Script Is Written](./doc/teardown01.md)
  *  [Pikchr Language Spec](./doc/grammar.md)
  *  [Differences From PIC](./doc/differences.md)
  *  [Invoking Pikchr From Markdown](./doc/usepikchr.md)
  *  [How To Build Pikchr From Source](./doc/build.md)
  *  [Use Case: SQLite Syntax Diagrams](./doc/sqlitesyntax.md)

## Copies Of Historical PIC Documentation

  *  [BWK paper on the original PIC](/uv/pic.pdf)
  *  [DPIC Documentation](/uv/dpic-doc.pdf)
  *  [ESR GnuPIC Docs](/uv/gpic.pdf)

## Source Code

  *  [Download](./doc/download.md)
  *  [How To Build Pikchr From Source](./doc/build.md)
  *  [How To Integrate Pikchr Into Other Applications][integ]

## External Links

  *  [Go port of pikchr](https://github.com/gopikchr/gopikchr) and
     a [blog post](https://zellyn.com/gopikchr-a-yakshave/) about how
     that port came to be, both by Zellyn Hunter.
  *  [mdbook-pikchr](https://crates.io/crates/mdbook-pikchr), by
     Konstantin Podsvirov, is a pikchr-aware preprocessor for mdBook.
  *  Support for pikchr in [IntelliJ-based
     IDEs](https://github.com/YannCebron/IntelliPikchr/) by Yann Cébron.
  *  pikchr has been integrated into the [kroki.io](https://kroki.io/)
     diagram-rendering service.
  *  The 8th programming language added pikchr support [in version
     22.04](https://8th-dev.com/forum/index.php/topic,2473.0.html).
  *  [Node.js pikchr module](https://github.com/tenuki/pikchr) by
     David Weil.
  *  A [pikchr filter for
     pandoc](https://code.jboy.space/pikchr-filter/doc/trunk/README.md)
     implemented in Lua.
  *  [Adamantine Pick](https://github.com/notlibrary/obsidian-adamantine-pick)
     adds pikchr support to the Obsidian knowledge-base app.

## Source-Code License: 0-clause BSD

The Pikchr source code is a self-contained original work.  It has no
external dependencies apart from the standard C library and does not
use code taken from the internet or other external sources.  All of the Pikchr
source code is released under a [zero-clause BSD license][0BSD].  After being
processed using [Lemon][lemon], the Pikchr source code is a single
file of C89 named "`pikchr.c`".  These features
are designed to make Pikchr [easy to integrate into other systems][integ].

[0BSD]: https://spdx.org/licenses/0BSD.html
[lemon]: https://www.sqlite.org/lemon.html
[integ]: doc/integrate.md
