# About

Passphrase is a small, simple passphrase generator.

[![builds.sr.ht status](https://builds.sr.ht/~alva/passphrase.svg)](https://builds.sr.ht/~alva/passphrase?)

## Background

I was using Bitwarden's passphrase generator, which is good,
except it only uses English words, and is also very slow.
So I made this one. It's pretty fast
(over 6000 times faster than `bw generate -p`,)
and you can use any wordlist, or standard input.
An English wordlist is included, and is the default.

## Building

The program is written in [Zig](https://ziglang.org),
so you will need the Zig compiler,
which is called `zig` in most package managers.
You can also [download a static build](https://ziglang.org/download/) if it's not packaged for you.

To build and install the program:

```shell
zig build -Doptimize=ReleaseFast --prefix ~/.local
```

It installs an executable file in `$PREFIX/bin`,
so that should be in your `$PATH`.

To run the tests:

```shell
zig build test
```

To build the manpage:

```shell
zig build doc
```

## Usage

Use `passphrase -h` to see the available options.

Use `passphrase -f path/to/dictionary` or `command-that-outputs-words | passphrase`
for a custom dictionary.

If the output is piped into another command,
for example `passphrase | wl-copy` to put the passphrase in the clipboard,
the ending newline is omitted, so that it can be safely pasted.
