//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// バスエラー(デバイス)
//

#include "buserr.h"

// コンストラクタ
BusErrDevice::BusErrDevice()
	: inherited(OBJ_BUSERR)
{
	ClearAlias();
	AddAlias("BusErr");
}

// デストラクタ
BusErrDevice::~BusErrDevice()
{
}

busdata
BusErrDevice::Read(busaddr addr)
{
	uint32 datasize = addr.GetSize();

	putlog(1, "$%08x.%u", addr.Addr(), datasize);
	busdata data = BusData::BusErr;
	data |= busdata::Size(datasize);
	return data;
}

busdata
BusErrDevice::Write(busaddr addr, uint32 data)
{
	uint32 datasize = addr.GetSize();

	putlog(1, "$%08x.%u <- %0*X", addr.Addr(), datasize, datasize * 2, data);
	busdata r = BusData::BusErr;
	r |= busdata::Size(datasize);
	return r;
}

busdata
BusErrDevice::Peek1(uint32 addr)
{
	return BusData::BusErr;
}

