<!--
 nono
 Copyright (C) 2024 nono project
 Licensed under nono-license.txt
-->
<?php require_once "common.php"; ?>
<html>
<head>
<?php
	get_version();
	print_head_common();
?>
<title>nono: Human68k mode</title>
</head>
<body>
<h3>nono の Human68k モード</h3>
<div style="text-align: right"><?php print "nono {$nono_ver} ({$nono_date})";
?></div>
<?php linkto("index", "[Back]"); ?>
<hr>
nono には通常の特定ハードウェア (X68030 など) の完全仮想化機能の他に、
コマンドラインから Human68k の実行ファイルを直接実行する機能があります。
ここでは雑に Human68k モードと呼んだりしています。

<h4>使い方</h4>
起動方法は以下の通りです。
<blockquote>
<tt>nono-cli -H [<i>other options</i>...] -X <i>executable</i> [<i>argument</i>...]</tt><br>
</blockquote>
<tt>-H</tt> オプションで Human68k モードであることを指定します。
nono の他のオプションもだいたいそのまま使えますが
<tt>-c</tt> と <tt>-X</tt> オプションは通常モードとは挙動が変わります。

<dl>
<dt><tt>-c <i>vmpath</i></tt>
<dd><tt>-c</tt> オプションは VM ディレクトリか設定ファイルを指定します。
<tt>-c</tt> オプションが省略された場合、通常モードでは
<i>vmpath</i> をカレントディレクトリとしてそこから設定ファイルを読みましたが、
Human68k モードでは匿名モードとなります。
匿名モードは VM ディレクトリがなく、そのためホストの SRAM.DAT
を読み書きしません。
SRAM は初期状態のものをオンメモリで用意し、
アプリケーション終了時にそのまま破棄します。
これによりカレントディレクトリに SRAM.DAT を用意する手間と
カレントディレクトリに SRAM.DAT が書き出される問題がなくなります。
実行するアプリケーションから
SRAM.DAT にアクセスしたい場合は <tt>-c</tt> オプションで
VM ディレクトリパスを明示します。
<p>
<dt><tt>-X <i>executable</i> [<i>arguments</i>...]</tt>
<dd>通常モードでは <tt>-X</tt> オプションは
ホストファイルシステムにある実行ファイルのパスを指定していました。
Human68k でもここまでは同じですが、
実行ファイルに続いてコマンドライン引数を指定することが出来ます。
またこれにより <tt>-X</tt> オプションよりも後ろに
nono の他のコマンドラインオプションを書くことは出来ませんので
順序に注意してください。

</dl>
<p>
CLI 版(<tt>nono-cli</tt>) だけでなく
GUI 版(<tt>nono</tt>) でも Human68k モードは動作しますが、
メイン画面ウィンドウには何も映りません。
デバッグ用のモニタウィンドウが使えるだけです。

<h4>サポート状況</h4>
拡張子 .X と .R の形式の実行ファイルをサポートしています
(.Z 形式も一応サポートしていますが現物を見たことないので詳細不明)。
また、Human68k の実行ファイルではありませんが
ELF の m68k オブジェクトファイル (.o) も外部ラベルがないなどの条件を満たせば、
テキストセクションを .R 形式のように先頭から実行可能です
(<tt>DOS _EXIT</tt> で終了します)。
<p>
Human68k 実行ファイルのうち、
ハードウェアの I/O を直接叩いているようなものは動作しません。
現状、標準入出力など簡単な DOS コール、IOCS コールのみサポートしています。


<h4>使用例</h4>
以下を実行すると、nono の 68030 CPU の整数命令が
正しく実装されているかを確認することが出来ます。
<blockquote><tt>nono-cli -HX XEiJ/misc/instructiontest.x all</tt>
</blockquote>

<hr>
nono project
</body>
</html>
