/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.util.Enumeration;
import java.util.Hashtable;
import org.javacc.jjtree.ASTBNFDeclaration;
import org.javacc.jjtree.ASTBNFNodeScope;
import org.javacc.jjtree.ASTBNFNonTerminal;
import org.javacc.jjtree.ASTExpansionNodeScope;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.ASTProduction;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.SimpleNode;
import org.javacc.jjtree.Token;
import org.javacc.jjtree.TokenUtils;
import org.javacc.parser.Options;

public class NodeScope {
    private ASTProduction production;
    private ASTNodeDescriptor node_descriptor;
    private String closedVar;
    private String exceptionVar;
    private String nodeVar;
    private int scopeNumber;

    NodeScope(ASTProduction p, ASTNodeDescriptor n) {
        this.production = p;
        if (n == null) {
            String nm = this.production.name;
            if (Options.B("NODE_DEFAULT_VOID")) {
                nm = "void";
            }
            this.node_descriptor = ASTNodeDescriptor.indefinite(nm);
        } else {
            this.node_descriptor = n;
        }
        this.scopeNumber = this.production.getNodeScopeNumber(this);
        this.nodeVar = this.constructVariable("n");
        this.closedVar = this.constructVariable("c");
        this.exceptionVar = this.constructVariable("e");
    }

    boolean isVoid() {
        return this.node_descriptor.isVoid();
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.nodeVar;
    }

    private String constructVariable(String id) {
        String s = "000" + this.scopeNumber;
        return "jjt" + id + s.substring(s.length() - 3, s.length());
    }

    boolean usesCloseNodeVar() {
        return true;
    }

    void insertOpenNodeDeclaration(IO io, String indent) {
        this.insertOpenNodeCode(io, indent);
    }

    void insertOpenNodeCode(IO io, String indent) {
        String type = this.node_descriptor.getNodeType();
        NodeFiles.ensure(io, type);
        io.print(indent + type + " " + this.nodeVar + " = ");
        if (Options.B("NODE_FACTORY")) {
            if (Options.B("NODE_USES_PARSER")) {
                String p = Options.B("STATIC") ? "null" : "this";
                io.println("(" + type + ")" + type + ".jjtCreate(" + p + ", " + this.node_descriptor.getNodeId() + ");");
            } else {
                io.println("(" + type + ")" + type + ".jjtCreate(" + this.node_descriptor.getNodeId() + ");");
            }
        } else if (Options.B("NODE_USES_PARSER")) {
            String p = Options.B("STATIC") ? "null" : "this";
            io.println("new " + type + "(" + p + ", " + this.node_descriptor.getNodeId() + ");");
        } else {
            io.println("new " + type + "(" + this.node_descriptor.getNodeId() + ");");
        }
        if (this.usesCloseNodeVar()) {
            io.println(indent + "boolean " + this.closedVar + " = true;");
        }
        io.println(indent + this.node_descriptor.openNode(this.nodeVar));
        if (Options.B("NODE_SCOPE_HOOK")) {
            io.println(indent + "jjtreeOpenNodeScope(" + this.nodeVar + ");");
        }
    }

    void insertCloseNodeCode(IO io, String indent, boolean isFinal) {
        io.println(indent + this.node_descriptor.closeNode(this.nodeVar));
        if (this.usesCloseNodeVar() && !isFinal) {
            io.println(indent + this.closedVar + " = false;");
        }
        if (Options.B("NODE_SCOPE_HOOK")) {
            io.println(indent + "jjtreeCloseNodeScope(" + this.nodeVar + ");");
        }
    }

    void insertOpenNodeAction(IO io, String indent) {
        io.println(indent + "{");
        this.insertOpenNodeCode(io, indent + "  ");
        io.println(indent + "}");
    }

    void insertCloseNodeAction(IO io, String indent) {
        io.println(indent + "{");
        this.insertCloseNodeCode(io, indent + "  ", false);
        io.println(indent + "}");
    }

    private void insertCatchBlocks(IO io, Enumeration thrown_names, String indent) {
        if (thrown_names.hasMoreElements()) {
            io.println(indent + "} catch (Throwable " + this.exceptionVar + ") {");
            if (this.usesCloseNodeVar()) {
                io.println(indent + "  if (" + this.closedVar + ") {");
                io.println(indent + "    jjtree.clearNodeScope(" + this.nodeVar + ");");
                io.println(indent + "    " + this.closedVar + " = false;");
                io.println(indent + "  } else {");
                io.println(indent + "    jjtree.popNode();");
                io.println(indent + "  }");
            }
            while (thrown_names.hasMoreElements()) {
                String thrown = (String)thrown_names.nextElement();
                io.println(indent + "  if (" + this.exceptionVar + " instanceof " + thrown + ") {");
                io.println(indent + "    throw (" + thrown + ")" + this.exceptionVar + ";");
                io.println(indent + "  }");
            }
            io.println(indent + "  throw (Error)" + this.exceptionVar + ";");
        }
    }

    void tryTokenSequence(IO io, String indent, Token first, Token last) {
        io.println(indent + "try {");
        SimpleNode.closeJJTreeComment(io);
        Token t = first;
        while (t != last.next) {
            TokenUtils.print(t, io, "jjtThis", this.nodeVar);
            t = t.next;
        }
        SimpleNode.openJJTreeComment(io, null);
        io.println();
        Enumeration thrown_names = this.production.throws_list.elements();
        this.insertCatchBlocks(io, thrown_names, indent);
        io.println(indent + "} finally {");
        if (this.usesCloseNodeVar()) {
            io.println(indent + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(io, indent + "    ", true);
            io.println(indent + "  }");
        }
        io.println(indent + "}");
        SimpleNode.closeJJTreeComment(io);
    }

    private static void findThrown(Hashtable thrown_set, SimpleNode expansion_unit) {
        String nt;
        ASTProduction prod;
        if (expansion_unit instanceof ASTBNFNonTerminal && (prod = (ASTProduction)JJTreeGlobals.productions.get(nt = expansion_unit.getFirstToken().image)) != null) {
            Enumeration e = prod.throws_list.elements();
            while (e.hasMoreElements()) {
                String t = (String)e.nextElement();
                thrown_set.put(t, t);
            }
        }
        int i = 0;
        while (i < expansion_unit.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)expansion_unit.jjtGetChild(i);
            NodeScope.findThrown(thrown_set, n);
            ++i;
        }
    }

    void tryExpansionUnit(IO io, String indent, SimpleNode expansion_unit) {
        io.println(indent + "try {");
        SimpleNode.closeJJTreeComment(io);
        expansion_unit.print(io);
        SimpleNode.openJJTreeComment(io, null);
        io.println();
        Hashtable thrown_set = new Hashtable();
        NodeScope.findThrown(thrown_set, expansion_unit);
        Enumeration thrown_names = thrown_set.elements();
        this.insertCatchBlocks(io, thrown_names, indent);
        io.println(indent + "} finally {");
        if (this.usesCloseNodeVar()) {
            io.println(indent + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(io, indent + "    ", true);
            io.println(indent + "  }");
        }
        io.println(indent + "}");
        SimpleNode.closeJJTreeComment(io);
    }

    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).node_scope;
        }
        Node n = node.jjtGetParent();
        while (n != null) {
            if (n instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)n).node_scope;
            }
            if (n instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)n).node_scope;
            }
            if (n instanceof ASTExpansionNodeScope) {
                return ((ASTExpansionNodeScope)n).node_scope;
            }
            n = n.jjtGetParent();
        }
        return null;
    }
}

