/*
 * Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * This package contains the classes that should be used to store
 * X500 Principal and X500 Private Credentials in a
 * <i>Subject</i>.
 *
 * <h2>Package Specification</h2>
 *
 * <ul>
 *   <li><a href="https://tools.ietf.org/html/rfc1779">
 *     RFC 1779: A String Representation of Distinguished Names</a></li>
 *   <li><a href="https://tools.ietf.org/html/rfc2253">
 *     RFC 2253: Lightweight Directory Access Protocol (v3):
 *     UTF-8 String Representation of Distinguished Names</a></li>
 *   <li><a href="https://tools.ietf.org/html/rfc5280">
 *     RFC 5280: Internet X.509 Public Key Infrastructure
 *     Certificate and Certificate Revocation List (CRL) Profile</a></li>
 *   <li><a href="https://tools.ietf.org/html/rfc4512">
 *     RFC 4512: Lightweight Directory Access Protocol (LDAP):
 *     Directory Information Models</a></li>
 * </ul>
 *
 * @since 1.4
 */
package javax.security.auth.x500;
