// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

// Code generated by "make store-layers"
// DO NOT EDIT

package retrylayer

import (
	"context"
	timepkg "time"

	"github.com/go-sql-driver/mysql"
	"github.com/lib/pq"
	"github.com/mattermost/mattermost-server/v6/model"
	"github.com/mattermost/mattermost-server/v6/store"
	"github.com/pkg/errors"
)

const mySQLDeadlockCode = uint16(1213)

type RetryLayer struct {
	store.Store
	AuditStore                store.AuditStore
	BotStore                  store.BotStore
	ChannelStore              store.ChannelStore
	ChannelMemberHistoryStore store.ChannelMemberHistoryStore
	ClusterDiscoveryStore     store.ClusterDiscoveryStore
	CommandStore              store.CommandStore
	CommandWebhookStore       store.CommandWebhookStore
	ComplianceStore           store.ComplianceStore
	EmojiStore                store.EmojiStore
	FileInfoStore             store.FileInfoStore
	GroupStore                store.GroupStore
	JobStore                  store.JobStore
	LicenseStore              store.LicenseStore
	LinkMetadataStore         store.LinkMetadataStore
	OAuthStore                store.OAuthStore
	PluginStore               store.PluginStore
	PostStore                 store.PostStore
	PreferenceStore           store.PreferenceStore
	ProductNoticesStore       store.ProductNoticesStore
	ReactionStore             store.ReactionStore
	RemoteClusterStore        store.RemoteClusterStore
	RetentionPolicyStore      store.RetentionPolicyStore
	RoleStore                 store.RoleStore
	SchemeStore               store.SchemeStore
	SessionStore              store.SessionStore
	SharedChannelStore        store.SharedChannelStore
	StatusStore               store.StatusStore
	SystemStore               store.SystemStore
	TeamStore                 store.TeamStore
	TermsOfServiceStore       store.TermsOfServiceStore
	ThreadStore               store.ThreadStore
	TokenStore                store.TokenStore
	UploadSessionStore        store.UploadSessionStore
	UserStore                 store.UserStore
	UserAccessTokenStore      store.UserAccessTokenStore
	UserTermsOfServiceStore   store.UserTermsOfServiceStore
	WebhookStore              store.WebhookStore
}

func (s *RetryLayer) Audit() store.AuditStore {
	return s.AuditStore
}

func (s *RetryLayer) Bot() store.BotStore {
	return s.BotStore
}

func (s *RetryLayer) Channel() store.ChannelStore {
	return s.ChannelStore
}

func (s *RetryLayer) ChannelMemberHistory() store.ChannelMemberHistoryStore {
	return s.ChannelMemberHistoryStore
}

func (s *RetryLayer) ClusterDiscovery() store.ClusterDiscoveryStore {
	return s.ClusterDiscoveryStore
}

func (s *RetryLayer) Command() store.CommandStore {
	return s.CommandStore
}

func (s *RetryLayer) CommandWebhook() store.CommandWebhookStore {
	return s.CommandWebhookStore
}

func (s *RetryLayer) Compliance() store.ComplianceStore {
	return s.ComplianceStore
}

func (s *RetryLayer) Emoji() store.EmojiStore {
	return s.EmojiStore
}

func (s *RetryLayer) FileInfo() store.FileInfoStore {
	return s.FileInfoStore
}

func (s *RetryLayer) Group() store.GroupStore {
	return s.GroupStore
}

func (s *RetryLayer) Job() store.JobStore {
	return s.JobStore
}

func (s *RetryLayer) License() store.LicenseStore {
	return s.LicenseStore
}

func (s *RetryLayer) LinkMetadata() store.LinkMetadataStore {
	return s.LinkMetadataStore
}

func (s *RetryLayer) OAuth() store.OAuthStore {
	return s.OAuthStore
}

func (s *RetryLayer) Plugin() store.PluginStore {
	return s.PluginStore
}

func (s *RetryLayer) Post() store.PostStore {
	return s.PostStore
}

func (s *RetryLayer) Preference() store.PreferenceStore {
	return s.PreferenceStore
}

func (s *RetryLayer) ProductNotices() store.ProductNoticesStore {
	return s.ProductNoticesStore
}

func (s *RetryLayer) Reaction() store.ReactionStore {
	return s.ReactionStore
}

func (s *RetryLayer) RemoteCluster() store.RemoteClusterStore {
	return s.RemoteClusterStore
}

func (s *RetryLayer) RetentionPolicy() store.RetentionPolicyStore {
	return s.RetentionPolicyStore
}

func (s *RetryLayer) Role() store.RoleStore {
	return s.RoleStore
}

func (s *RetryLayer) Scheme() store.SchemeStore {
	return s.SchemeStore
}

func (s *RetryLayer) Session() store.SessionStore {
	return s.SessionStore
}

func (s *RetryLayer) SharedChannel() store.SharedChannelStore {
	return s.SharedChannelStore
}

func (s *RetryLayer) Status() store.StatusStore {
	return s.StatusStore
}

func (s *RetryLayer) System() store.SystemStore {
	return s.SystemStore
}

func (s *RetryLayer) Team() store.TeamStore {
	return s.TeamStore
}

func (s *RetryLayer) TermsOfService() store.TermsOfServiceStore {
	return s.TermsOfServiceStore
}

func (s *RetryLayer) Thread() store.ThreadStore {
	return s.ThreadStore
}

func (s *RetryLayer) Token() store.TokenStore {
	return s.TokenStore
}

func (s *RetryLayer) UploadSession() store.UploadSessionStore {
	return s.UploadSessionStore
}

func (s *RetryLayer) User() store.UserStore {
	return s.UserStore
}

func (s *RetryLayer) UserAccessToken() store.UserAccessTokenStore {
	return s.UserAccessTokenStore
}

func (s *RetryLayer) UserTermsOfService() store.UserTermsOfServiceStore {
	return s.UserTermsOfServiceStore
}

func (s *RetryLayer) Webhook() store.WebhookStore {
	return s.WebhookStore
}

type RetryLayerAuditStore struct {
	store.AuditStore
	Root *RetryLayer
}

type RetryLayerBotStore struct {
	store.BotStore
	Root *RetryLayer
}

type RetryLayerChannelStore struct {
	store.ChannelStore
	Root *RetryLayer
}

type RetryLayerChannelMemberHistoryStore struct {
	store.ChannelMemberHistoryStore
	Root *RetryLayer
}

type RetryLayerClusterDiscoveryStore struct {
	store.ClusterDiscoveryStore
	Root *RetryLayer
}

type RetryLayerCommandStore struct {
	store.CommandStore
	Root *RetryLayer
}

type RetryLayerCommandWebhookStore struct {
	store.CommandWebhookStore
	Root *RetryLayer
}

type RetryLayerComplianceStore struct {
	store.ComplianceStore
	Root *RetryLayer
}

type RetryLayerEmojiStore struct {
	store.EmojiStore
	Root *RetryLayer
}

type RetryLayerFileInfoStore struct {
	store.FileInfoStore
	Root *RetryLayer
}

type RetryLayerGroupStore struct {
	store.GroupStore
	Root *RetryLayer
}

type RetryLayerJobStore struct {
	store.JobStore
	Root *RetryLayer
}

type RetryLayerLicenseStore struct {
	store.LicenseStore
	Root *RetryLayer
}

type RetryLayerLinkMetadataStore struct {
	store.LinkMetadataStore
	Root *RetryLayer
}

type RetryLayerOAuthStore struct {
	store.OAuthStore
	Root *RetryLayer
}

type RetryLayerPluginStore struct {
	store.PluginStore
	Root *RetryLayer
}

type RetryLayerPostStore struct {
	store.PostStore
	Root *RetryLayer
}

type RetryLayerPreferenceStore struct {
	store.PreferenceStore
	Root *RetryLayer
}

type RetryLayerProductNoticesStore struct {
	store.ProductNoticesStore
	Root *RetryLayer
}

type RetryLayerReactionStore struct {
	store.ReactionStore
	Root *RetryLayer
}

type RetryLayerRemoteClusterStore struct {
	store.RemoteClusterStore
	Root *RetryLayer
}

type RetryLayerRetentionPolicyStore struct {
	store.RetentionPolicyStore
	Root *RetryLayer
}

type RetryLayerRoleStore struct {
	store.RoleStore
	Root *RetryLayer
}

type RetryLayerSchemeStore struct {
	store.SchemeStore
	Root *RetryLayer
}

type RetryLayerSessionStore struct {
	store.SessionStore
	Root *RetryLayer
}

type RetryLayerSharedChannelStore struct {
	store.SharedChannelStore
	Root *RetryLayer
}

type RetryLayerStatusStore struct {
	store.StatusStore
	Root *RetryLayer
}

type RetryLayerSystemStore struct {
	store.SystemStore
	Root *RetryLayer
}

type RetryLayerTeamStore struct {
	store.TeamStore
	Root *RetryLayer
}

type RetryLayerTermsOfServiceStore struct {
	store.TermsOfServiceStore
	Root *RetryLayer
}

type RetryLayerThreadStore struct {
	store.ThreadStore
	Root *RetryLayer
}

type RetryLayerTokenStore struct {
	store.TokenStore
	Root *RetryLayer
}

type RetryLayerUploadSessionStore struct {
	store.UploadSessionStore
	Root *RetryLayer
}

type RetryLayerUserStore struct {
	store.UserStore
	Root *RetryLayer
}

type RetryLayerUserAccessTokenStore struct {
	store.UserAccessTokenStore
	Root *RetryLayer
}

type RetryLayerUserTermsOfServiceStore struct {
	store.UserTermsOfServiceStore
	Root *RetryLayer
}

type RetryLayerWebhookStore struct {
	store.WebhookStore
	Root *RetryLayer
}

func isRepeatableError(err error) bool {
	var pqErr *pq.Error
	var mysqlErr *mysql.MySQLError
	switch {
	case errors.As(errors.Cause(err), &pqErr):
		if pqErr.Code == "40001" || pqErr.Code == "40P01" {
			return true
		}
	case errors.As(errors.Cause(err), &mysqlErr):
		if mysqlErr.Number == mySQLDeadlockCode {
			return true
		}
	}
	return false
}

func (s *RetryLayerAuditStore) Get(user_id string, offset int, limit int) (model.Audits, error) {

	tries := 0
	for {
		result, err := s.AuditStore.Get(user_id, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAuditStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.AuditStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerAuditStore) Save(audit *model.Audit) error {

	tries := 0
	for {
		err := s.AuditStore.Save(audit)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) Get(userID string, includeDeleted bool) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.Get(userID, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) GetAll(options *model.BotGetOptions) ([]*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.GetAll(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) PermanentDelete(userID string) error {

	tries := 0
	for {
		err := s.BotStore.PermanentDelete(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) Save(bot *model.Bot) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.Save(bot)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerBotStore) Update(bot *model.Bot) (*model.Bot, error) {

	tries := 0
	for {
		result, err := s.BotStore.Update(bot)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AnalyticsDeletedTypeCount(teamID string, channelType model.ChannelType) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AnalyticsDeletedTypeCount(teamID, channelType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AnalyticsTypeCount(teamID string, channelType model.ChannelType) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AnalyticsTypeCount(teamID, channelType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Autocomplete(userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelListWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Autocomplete(userID, term, includeDeleted, isGuest)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AutocompleteInTeam(teamID string, userID string, term string, includeDeleted bool, isGuest bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AutocompleteInTeam(teamID, userID, term, includeDeleted, isGuest)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) AutocompleteInTeamForSearch(teamID string, userID string, term string, includeDeleted bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.AutocompleteInTeamForSearch(teamID, userID, term, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) ClearAllCustomRoleAssignments() error {

	tries := 0
	for {
		err := s.ChannelStore.ClearAllCustomRoleAssignments()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) ClearCaches() {

	s.ChannelStore.ClearCaches()

}

func (s *RetryLayerChannelStore) ClearSidebarOnTeamLeave(userID string, teamID string) error {

	tries := 0
	for {
		err := s.ChannelStore.ClearSidebarOnTeamLeave(userID, teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CountPostsAfter(channelID string, timestamp int64, userID string) (int, int, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelStore.CountPostsAfter(channelID, timestamp, userID)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CreateDirectChannel(userID *model.User, otherUserID *model.User, channelOptions ...model.ChannelOption) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CreateDirectChannel(userID, otherUserID, channelOptions...)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CreateInitialSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CreateInitialSidebarCategories(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) CreateSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.CreateSidebarCategory(userID, teamID, newCategory)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Delete(channelID string, time int64) error {

	tries := 0
	for {
		err := s.ChannelStore.Delete(channelID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) DeleteSidebarCategory(categoryID string) error {

	tries := 0
	for {
		err := s.ChannelStore.DeleteSidebarCategory(categoryID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) DeleteSidebarChannelsByPreferences(preferences model.Preferences) error {

	tries := 0
	for {
		err := s.ChannelStore.DeleteSidebarChannelsByPreferences(preferences)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Get(id string, allowFromCache bool) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Get(id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAll(teamID string) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAll(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelMembersById(id string) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelMembersById(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelMembersForUser(userID string, allowFromCache bool, includeDeleted bool) (map[string]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelMembersForUser(userID, allowFromCache, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelMembersNotifyPropsForChannel(channelID string, allowFromCache bool) (map[string]model.StringMap, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelMembersNotifyPropsForChannel(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannels(page int, perPage int, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannels(page, perPage, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelsCount(opts store.ChannelSearchOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelsCount(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllChannelsForExportAfter(limit int, afterID string) ([]*model.ChannelForExport, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllChannelsForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetAllDirectChannelsForExportAfter(limit int, afterID string) ([]*model.DirectChannelForExport, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetAllDirectChannelsForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByName(team_id string, name string, allowFromCache bool) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByName(team_id, name, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByNameIncludeDeleted(team_id string, name string, allowFromCache bool) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByNameIncludeDeleted(team_id, name, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetByNames(team_id string, names []string, allowFromCache bool) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetByNames(team_id, names, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelCounts(teamID string, userID string) (*model.ChannelCounts, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelCounts(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelMembersForExport(userID string, teamID string) ([]*model.ChannelMemberForExport, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelMembersForExport(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelMembersTimezones(channelID string) ([]model.StringMap, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelMembersTimezones(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelUnread(channelID string, userID string) (*model.ChannelUnread, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelUnread(channelID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannels(teamID string, userID string, opts *model.ChannelSearchOpts) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannels(teamID, userID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsBatchForIndexing(startTime int64, startChannelID string, limit int) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsBatchForIndexing(startTime, startChannelID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsByIds(channelIds []string, includeDeleted bool) ([]*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsByIds(channelIds, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsByScheme(schemeID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsByScheme(schemeID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsByUser(userID string, includeDeleted bool, lastDeleteAt int, pageSize int, fromChannelID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsByUser(userID, includeDeleted, lastDeleteAt, pageSize, fromChannelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsWithCursor(teamId string, userId string, opts *model.ChannelSearchOpts, afterChannelID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsWithCursor(teamId, userId, opts, afterChannelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetChannelsWithTeamDataByIds(channelIds []string, includeDeleted bool) ([]*model.ChannelWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetChannelsWithTeamDataByIds(channelIds, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetDeleted(team_id string, offset int, limit int, userID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetDeleted(team_id, offset, limit, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetDeletedByName(team_id string, name string) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetDeletedByName(team_id, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetFileCount(channelID string) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetFileCount(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetForPost(postID string) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetGuestCount(channelID string, allowFromCache bool) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetGuestCount(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMany(ids []string, allowFromCache bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMany(ids, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMember(ctx context.Context, channelID string, userID string) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMember(ctx, channelID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberCount(channelID string, allowFromCache bool) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberCount(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberCountFromCache(channelID string) int64 {

	return s.ChannelStore.GetMemberCountFromCache(channelID)

}

func (s *RetryLayerChannelStore) GetMemberCountsByGroup(ctx context.Context, channelID string, includeTimezones bool) ([]*model.ChannelMemberCountByGroup, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberCountsByGroup(ctx, channelID, includeTimezones)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMemberForPost(postID string, userID string) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMemberForPost(postID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembers(channelID string, offset int, limit int) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembers(channelID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersByChannelIds(channelIds []string, userID string) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersByChannelIds(channelIds, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersByIds(channelID string, userIds []string) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersByIds(channelID, userIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersForUser(teamID string, userID string) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersForUser(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersForUserWithCursor(userID string, afterChannel string, afterUser string, limit int, lastUpdateAt int) (model.ChannelMembers, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersForUserWithCursor(userID, afterChannel, afterUser, limit, lastUpdateAt)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersForUserWithPagination(userID string, page int, perPage int) (model.ChannelMembersWithTeamData, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersForUserWithPagination(userID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMembersInfoByChannelIds(channelIDs []string) (map[string][]*model.User, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMembersInfoByChannelIds(channelIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetMoreChannels(teamID string, userID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetMoreChannels(teamID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPinnedPostCount(channelID string, allowFromCache bool) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPinnedPostCount(channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPinnedPosts(channelID string) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPinnedPosts(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPrivateChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPrivateChannelsForTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPublicChannelsByIdsForTeam(teamID string, channelIds []string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPublicChannelsByIdsForTeam(teamID, channelIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetPublicChannelsForTeam(teamID string, offset int, limit int) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetPublicChannelsForTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategories(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategory(categoryID string) (*model.SidebarCategoryWithChannels, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategory(categoryID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetSidebarCategoryOrder(userID string, teamID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetSidebarCategoryOrder(userID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetTeamChannels(teamID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetTeamChannels(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetTeamForChannel(channelID string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetTeamForChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GetTeamMembersForChannel(channelID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GetTeamMembersForChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) GroupSyncedChannelCount() (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.GroupSyncedChannelCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) IncrementMentionCount(channelID string, userIDs []string, isRoot bool) error {

	tries := 0
	for {
		err := s.ChannelStore.IncrementMentionCount(channelID, userIDs, isRoot)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) InvalidateAllChannelMembersForUser(userID string) {

	s.ChannelStore.InvalidateAllChannelMembersForUser(userID)

}

func (s *RetryLayerChannelStore) InvalidateCacheForChannelMembersNotifyProps(channelID string) {

	s.ChannelStore.InvalidateCacheForChannelMembersNotifyProps(channelID)

}

func (s *RetryLayerChannelStore) InvalidateChannel(id string) {

	s.ChannelStore.InvalidateChannel(id)

}

func (s *RetryLayerChannelStore) InvalidateChannelByName(teamID string, name string) {

	s.ChannelStore.InvalidateChannelByName(teamID, name)

}

func (s *RetryLayerChannelStore) InvalidateGuestCount(channelID string) {

	s.ChannelStore.InvalidateGuestCount(channelID)

}

func (s *RetryLayerChannelStore) InvalidateMemberCount(channelID string) {

	s.ChannelStore.InvalidateMemberCount(channelID)

}

func (s *RetryLayerChannelStore) InvalidatePinnedPostCount(channelID string) {

	s.ChannelStore.InvalidatePinnedPostCount(channelID)

}

func (s *RetryLayerChannelStore) IsUserInChannelUseCache(userID string, channelID string) bool {

	return s.ChannelStore.IsUserInChannelUseCache(userID, channelID)

}

func (s *RetryLayerChannelStore) MigrateChannelMembers(fromChannelID string, fromUserID string) (map[string]string, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.MigrateChannelMembers(fromChannelID, fromUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDelete(channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDelete(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDeleteByTeam(teamID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDeleteByTeam(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDeleteMembersByChannel(channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDeleteMembersByChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) PermanentDeleteMembersByUser(userID string) error {

	tries := 0
	for {
		err := s.ChannelStore.PermanentDeleteMembersByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) RemoveAllDeactivatedMembers(channelID string) error {

	tries := 0
	for {
		err := s.ChannelStore.RemoveAllDeactivatedMembers(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) RemoveMember(channelID string, userID string) error {

	tries := 0
	for {
		err := s.ChannelStore.RemoveMember(channelID, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) RemoveMembers(channelID string, userIds []string) error {

	tries := 0
	for {
		err := s.ChannelStore.RemoveMembers(channelID, userIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) ResetAllChannelSchemes() error {

	tries := 0
	for {
		err := s.ChannelStore.ResetAllChannelSchemes()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Restore(channelID string, time int64) error {

	tries := 0
	for {
		err := s.ChannelStore.Restore(channelID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Save(channel *model.Channel, maxChannelsPerTeam int64) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Save(channel, maxChannelsPerTeam)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SaveDirectChannel(channel *model.Channel, member1 *model.ChannelMember, member2 *model.ChannelMember) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SaveDirectChannel(channel, member1, member2)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SaveMember(member *model.ChannelMember) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SaveMember(member)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SaveMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SaveMultipleMembers(members)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchAllChannels(term string, opts store.ChannelSearchOpts) (model.ChannelListWithTeamData, int64, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelStore.SearchAllChannels(term, opts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchArchivedInTeam(teamID string, term string, userID string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchArchivedInTeam(teamID, term, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchForUserInTeam(userID string, teamID string, term string, includeDeleted bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchForUserInTeam(userID, teamID, term, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchGroupChannels(userID string, term string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchGroupChannels(userID, term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchInTeam(teamID string, term string, includeDeleted bool) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchInTeam(teamID, term, includeDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SearchMore(userID string, teamID string, term string) (model.ChannelList, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.SearchMore(userID, teamID, term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SetDeleteAt(channelID string, deleteAt int64, updateAt int64) error {

	tries := 0
	for {
		err := s.ChannelStore.SetDeleteAt(channelID, deleteAt, updateAt)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) SetShared(channelId string, shared bool) error {

	tries := 0
	for {
		err := s.ChannelStore.SetShared(channelId, shared)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) Update(channel *model.Channel) (*model.Channel, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.Update(channel)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateLastViewedAt(channelIds []string, userID string) (map[string]int64, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateLastViewedAt(channelIds, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateLastViewedAtPost(unreadPost *model.Post, userID string, mentionCount int, mentionCountRoot int, setUnreadCountRoot bool) (*model.ChannelUnreadAt, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateLastViewedAtPost(unreadPost, userID, mentionCount, mentionCountRoot, setUnreadCountRoot)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMember(member *model.ChannelMember) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMember(member)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMemberNotifyProps(channelID string, userID string, props map[string]string) (*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMemberNotifyProps(channelID, userID, props)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMembersRole(channelID string, userIDs []string) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateMembersRole(channelID, userIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateMultipleMembers(members []*model.ChannelMember) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UpdateMultipleMembers(members)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, []*model.SidebarCategoryWithChannels, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelStore.UpdateSidebarCategories(userID, teamID, categories)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarCategoryOrder(userID string, teamID string, categoryOrder []string) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateSidebarCategoryOrder(userID, teamID, categoryOrder)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarChannelCategoryOnMove(channel *model.Channel, newTeamID string) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateSidebarChannelCategoryOnMove(channel, newTeamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UpdateSidebarChannelsByPreferences(preferences model.Preferences) error {

	tries := 0
	for {
		err := s.ChannelStore.UpdateSidebarChannelsByPreferences(preferences)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelStore) UserBelongsToChannels(userID string, channelIds []string) (bool, error) {

	tries := 0
	for {
		result, err := s.ChannelStore.UserBelongsToChannels(userID, channelIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) GetChannelsLeftSince(userID string, since int64) ([]string, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.GetChannelsLeftSince(userID, since)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) GetUsersInChannelDuring(startTime int64, endTime int64, channelID string) ([]*model.ChannelMemberHistoryResult, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.GetUsersInChannelDuring(startTime, endTime, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) LogJoinEvent(userID string, channelID string, joinTime int64) error {

	tries := 0
	for {
		err := s.ChannelMemberHistoryStore.LogJoinEvent(userID, channelID, joinTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) LogLeaveEvent(userID string, channelID string, leaveTime int64) error {

	tries := 0
	for {
		err := s.ChannelMemberHistoryStore.LogLeaveEvent(userID, channelID, leaveTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.ChannelMemberHistoryStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerChannelMemberHistoryStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ChannelMemberHistoryStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Cleanup() error {

	tries := 0
	for {
		err := s.ClusterDiscoveryStore.Cleanup()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Delete(discovery *model.ClusterDiscovery) (bool, error) {

	tries := 0
	for {
		result, err := s.ClusterDiscoveryStore.Delete(discovery)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Exists(discovery *model.ClusterDiscovery) (bool, error) {

	tries := 0
	for {
		result, err := s.ClusterDiscoveryStore.Exists(discovery)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) GetAll(discoveryType string, clusterName string) ([]*model.ClusterDiscovery, error) {

	tries := 0
	for {
		result, err := s.ClusterDiscoveryStore.GetAll(discoveryType, clusterName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) Save(discovery *model.ClusterDiscovery) error {

	tries := 0
	for {
		err := s.ClusterDiscoveryStore.Save(discovery)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerClusterDiscoveryStore) SetLastPingAt(discovery *model.ClusterDiscovery) error {

	tries := 0
	for {
		err := s.ClusterDiscoveryStore.SetLastPingAt(discovery)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) AnalyticsCommandCount(teamID string) (int64, error) {

	tries := 0
	for {
		result, err := s.CommandStore.AnalyticsCommandCount(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Delete(commandID string, time int64) error {

	tries := 0
	for {
		err := s.CommandStore.Delete(commandID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Get(id string) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) GetByTeam(teamID string) ([]*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.GetByTeam(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) GetByTrigger(teamID string, trigger string) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.GetByTrigger(teamID, trigger)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) PermanentDeleteByTeam(teamID string) error {

	tries := 0
	for {
		err := s.CommandStore.PermanentDeleteByTeam(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.CommandStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Save(webhook *model.Command) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.Save(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandStore) Update(hook *model.Command) (*model.Command, error) {

	tries := 0
	for {
		result, err := s.CommandStore.Update(hook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandWebhookStore) Cleanup() {

	s.CommandWebhookStore.Cleanup()

}

func (s *RetryLayerCommandWebhookStore) Get(id string) (*model.CommandWebhook, error) {

	tries := 0
	for {
		result, err := s.CommandWebhookStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandWebhookStore) Save(webhook *model.CommandWebhook) (*model.CommandWebhook, error) {

	tries := 0
	for {
		result, err := s.CommandWebhookStore.Save(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerCommandWebhookStore) TryUse(id string, limit int) error {

	tries := 0
	for {
		err := s.CommandWebhookStore.TryUse(id, limit)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) ComplianceExport(compliance *model.Compliance, cursor model.ComplianceExportCursor, limit int) ([]*model.CompliancePost, model.ComplianceExportCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ComplianceStore.ComplianceExport(compliance, cursor, limit)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) Get(id string) (*model.Compliance, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) GetAll(offset int, limit int) (model.Compliances, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.GetAll(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) MessageExport(cursor model.MessageExportCursor, limit int) ([]*model.MessageExport, model.MessageExportCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ComplianceStore.MessageExport(cursor, limit)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) Save(compliance *model.Compliance) (*model.Compliance, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.Save(compliance)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerComplianceStore) Update(compliance *model.Compliance) (*model.Compliance, error) {

	tries := 0
	for {
		result, err := s.ComplianceStore.Update(compliance)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Delete(emoji *model.Emoji, time int64) error {

	tries := 0
	for {
		err := s.EmojiStore.Delete(emoji, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Get(ctx context.Context, id string, allowFromCache bool) (*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.Get(ctx, id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) GetByName(ctx context.Context, name string, allowFromCache bool) (*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.GetByName(ctx, name, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) GetList(offset int, limit int, sort string) ([]*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.GetList(offset, limit, sort)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) GetMultipleByName(names []string) ([]*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.GetMultipleByName(names)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Save(emoji *model.Emoji) (*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.Save(emoji)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerEmojiStore) Search(name string, prefixOnly bool, limit int) ([]*model.Emoji, error) {

	tries := 0
	for {
		result, err := s.EmojiStore.Search(name, prefixOnly, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) AttachToPost(fileID string, postID string, creatorID string) error {

	tries := 0
	for {
		err := s.FileInfoStore.AttachToPost(fileID, postID, creatorID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) ClearCaches() {

	s.FileInfoStore.ClearCaches()

}

func (s *RetryLayerFileInfoStore) CountAll() (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.CountAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) DeleteForPost(postID string) (string, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.DeleteForPost(postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Get(id string) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetByIds(ids []string) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetByIds(ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetByPath(path string) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetByPath(path)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetFilesBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.FileForIndexing, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetFilesBatchForIndexing(startTime, startFileID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetForPost(postID string, readFromMaster bool, includeDeleted bool, allowFromCache bool) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetForPost(postID, readFromMaster, includeDeleted, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetForUser(userID string) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetFromMaster(id string) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetFromMaster(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) GetWithOptions(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.GetWithOptions(page, perPage, opt)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) InvalidateFileInfosForPostCache(postID string, deleted bool) {

	s.FileInfoStore.InvalidateFileInfosForPostCache(postID, deleted)

}

func (s *RetryLayerFileInfoStore) PermanentDelete(fileID string) error {

	tries := 0
	for {
		err := s.FileInfoStore.PermanentDelete(fileID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) PermanentDeleteByUser(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.PermanentDeleteByUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Save(info *model.FileInfo) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Save(info)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Search(paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.FileInfoList, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Search(paramsList, userID, teamID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) SetContent(fileID string, content string) error {

	tries := 0
	for {
		err := s.FileInfoStore.SetContent(fileID, content)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerFileInfoStore) Upsert(info *model.FileInfo) (*model.FileInfo, error) {

	tries := 0
	for {
		result, err := s.FileInfoStore.Upsert(info)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) AdminRoleGroupsForSyncableMember(userID string, syncableID string, syncableType model.GroupSyncableType) ([]string, error) {

	tries := 0
	for {
		result, err := s.GroupStore.AdminRoleGroupsForSyncableMember(userID, syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) ChannelMembersMinusGroupMembers(channelID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {

	tries := 0
	for {
		result, err := s.GroupStore.ChannelMembersMinusGroupMembers(channelID, groupIDs, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) ChannelMembersToAdd(since int64, channelID *string, includeRemovedMembers bool) ([]*model.UserChannelIDPair, error) {

	tries := 0
	for {
		result, err := s.GroupStore.ChannelMembersToAdd(since, channelID, includeRemovedMembers)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) ChannelMembersToRemove(channelID *string) ([]*model.ChannelMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.ChannelMembersToRemove(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountChannelMembersMinusGroupMembers(channelID string, groupIDs []string) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountChannelMembersMinusGroupMembers(channelID, groupIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountGroupsByChannel(channelID string, opts model.GroupSearchOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountGroupsByChannel(channelID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountGroupsByTeam(teamID string, opts model.GroupSearchOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountGroupsByTeam(teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CountTeamMembersMinusGroupMembers(teamID string, groupIDs []string) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CountTeamMembersMinusGroupMembers(teamID, groupIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Create(group *model.Group) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Create(group)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CreateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CreateGroupSyncable(groupSyncable)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) CreateWithUserIds(group *model.GroupWithUserIds) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.CreateWithUserIds(group)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Delete(groupID string) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Delete(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DeleteGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DeleteGroupSyncable(groupID, syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DeleteMember(groupID string, userID string) (*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DeleteMember(groupID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DeleteMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DeleteMembers(groupID, userIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) DistinctGroupMemberCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.DistinctGroupMemberCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Get(groupID string) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Get(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetAllBySource(groupSource model.GroupSource) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetAllBySource(groupSource)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetAllGroupSyncablesByGroupId(groupID string, syncableType model.GroupSyncableType) ([]*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetAllGroupSyncablesByGroupId(groupID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByIDs(groupIDs []string) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByIDs(groupIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByName(name string, opts model.GroupSearchOpts) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByName(name, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByRemoteID(remoteID string, groupSource model.GroupSource) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByRemoteID(remoteID, groupSource)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetByUser(userID string) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetByUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupSyncable(groupID string, syncableID string, syncableType model.GroupSyncableType) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupSyncable(groupID, syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroups(page int, perPage int, opts model.GroupSearchOpts) ([]*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroups(page, perPage, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupsAssociatedToChannelsByTeam(teamID string, opts model.GroupSearchOpts) (map[string][]*model.GroupWithSchemeAdmin, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupsAssociatedToChannelsByTeam(teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupsByChannel(channelID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupsByChannel(channelID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetGroupsByTeam(teamID string, opts model.GroupSearchOpts) ([]*model.GroupWithSchemeAdmin, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetGroupsByTeam(teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMember(groupID string, userID string) (*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMember(groupID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberCount(groupID string) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberCount(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsers(groupID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsers(groupID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersInTeam(groupID string, teamID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersInTeam(groupID, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersNotInChannel(groupID string, channelID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersNotInChannel(groupID, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetMemberUsersPage(groupID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GetNonMemberUsersPage(groupID string, page int, perPage int) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GetNonMemberUsersPage(groupID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupChannelCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupChannelCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupCountBySource(source model.GroupSource) (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupCountBySource(source)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupCountWithAllowReference() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupCountWithAllowReference()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupMemberCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupMemberCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) GroupTeamCount() (int64, error) {

	tries := 0
	for {
		result, err := s.GroupStore.GroupTeamCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) PermanentDeleteMembersByUser(userID string) error {

	tries := 0
	for {
		err := s.GroupStore.PermanentDeleteMembersByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) PermittedSyncableAdmins(syncableID string, syncableType model.GroupSyncableType) ([]string, error) {

	tries := 0
	for {
		result, err := s.GroupStore.PermittedSyncableAdmins(syncableID, syncableType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) TeamMembersMinusGroupMembers(teamID string, groupIDs []string, page int, perPage int) ([]*model.UserWithGroups, error) {

	tries := 0
	for {
		result, err := s.GroupStore.TeamMembersMinusGroupMembers(teamID, groupIDs, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) TeamMembersToAdd(since int64, teamID *string, includeRemovedMembers bool) ([]*model.UserTeamIDPair, error) {

	tries := 0
	for {
		result, err := s.GroupStore.TeamMembersToAdd(since, teamID, includeRemovedMembers)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) TeamMembersToRemove(teamID *string) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.TeamMembersToRemove(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) Update(group *model.Group) (*model.Group, error) {

	tries := 0
	for {
		result, err := s.GroupStore.Update(group)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) UpdateGroupSyncable(groupSyncable *model.GroupSyncable) (*model.GroupSyncable, error) {

	tries := 0
	for {
		result, err := s.GroupStore.UpdateGroupSyncable(groupSyncable)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) UpsertMember(groupID string, userID string) (*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.UpsertMember(groupID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerGroupStore) UpsertMembers(groupID string, userIDs []string) ([]*model.GroupMember, error) {

	tries := 0
	for {
		result, err := s.GroupStore.UpsertMembers(groupID, userIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Cleanup(expiryTime int64, batchSize int) error {

	tries := 0
	for {
		err := s.JobStore.Cleanup(expiryTime, batchSize)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Delete(id string) (string, error) {

	tries := 0
	for {
		result, err := s.JobStore.Delete(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Get(id string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByStatus(status string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByStatus(status)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByType(jobType string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByType(jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypeAndStatus(jobType string, status string) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypeAndStatus(jobType, status)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypePage(jobType string, offset int, limit int) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypePage(jobType, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllByTypesPage(jobTypes []string, offset int, limit int) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllByTypesPage(jobTypes, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetAllPage(offset int, limit int) ([]*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetAllPage(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetCountByStatusAndType(status string, jobType string) (int64, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetCountByStatusAndType(status, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetNewestJobByStatusAndType(status string, jobType string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetNewestJobByStatusAndType(status, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) GetNewestJobByStatusesAndType(statuses []string, jobType string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.GetNewestJobByStatusesAndType(statuses, jobType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) Save(job *model.Job) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.Save(job)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) UpdateOptimistically(job *model.Job, currentStatus string) (bool, error) {

	tries := 0
	for {
		result, err := s.JobStore.UpdateOptimistically(job, currentStatus)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) UpdateStatus(id string, status string) (*model.Job, error) {

	tries := 0
	for {
		result, err := s.JobStore.UpdateStatus(id, status)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerJobStore) UpdateStatusOptimistically(id string, currentStatus string, newStatus string) (bool, error) {

	tries := 0
	for {
		result, err := s.JobStore.UpdateStatusOptimistically(id, currentStatus, newStatus)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLicenseStore) Get(id string) (*model.LicenseRecord, error) {

	tries := 0
	for {
		result, err := s.LicenseStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLicenseStore) GetAll() ([]*model.LicenseRecord, error) {

	tries := 0
	for {
		result, err := s.LicenseStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLicenseStore) Save(license *model.LicenseRecord) (*model.LicenseRecord, error) {

	tries := 0
	for {
		result, err := s.LicenseStore.Save(license)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLinkMetadataStore) Get(url string, timestamp int64) (*model.LinkMetadata, error) {

	tries := 0
	for {
		result, err := s.LinkMetadataStore.Get(url, timestamp)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerLinkMetadataStore) Save(linkMetadata *model.LinkMetadata) (*model.LinkMetadata, error) {

	tries := 0
	for {
		result, err := s.LinkMetadataStore.Save(linkMetadata)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) DeleteApp(id string) error {

	tries := 0
	for {
		err := s.OAuthStore.DeleteApp(id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAccessData(token string) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAccessData(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAccessDataByRefreshToken(token string) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAccessDataByRefreshToken(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAccessDataByUserForApp(userID string, clientId string) ([]*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAccessDataByUserForApp(userID, clientId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetApp(id string) (*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetApp(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAppByUser(userID string, offset int, limit int) ([]*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAppByUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetApps(offset int, limit int) ([]*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetApps(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAuthData(code string) (*model.AuthData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAuthData(code)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetAuthorizedApps(userID string, offset int, limit int) ([]*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetAuthorizedApps(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) GetPreviousAccessData(userID string, clientId string) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.GetPreviousAccessData(userID, clientId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) PermanentDeleteAuthDataByUser(userID string) error {

	tries := 0
	for {
		err := s.OAuthStore.PermanentDeleteAuthDataByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAccessData(token string) error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAccessData(token)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAllAccessData() error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAllAccessData()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) RemoveAuthData(code string) error {

	tries := 0
	for {
		err := s.OAuthStore.RemoveAuthData(code)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) SaveAccessData(accessData *model.AccessData) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.SaveAccessData(accessData)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) SaveApp(app *model.OAuthApp) (*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.SaveApp(app)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) SaveAuthData(authData *model.AuthData) (*model.AuthData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.SaveAuthData(authData)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) UpdateAccessData(accessData *model.AccessData) (*model.AccessData, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.UpdateAccessData(accessData)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerOAuthStore) UpdateApp(app *model.OAuthApp) (*model.OAuthApp, error) {

	tries := 0
	for {
		result, err := s.OAuthStore.UpdateApp(app)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) CompareAndDelete(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {

	tries := 0
	for {
		result, err := s.PluginStore.CompareAndDelete(keyVal, oldValue)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) CompareAndSet(keyVal *model.PluginKeyValue, oldValue []byte) (bool, error) {

	tries := 0
	for {
		result, err := s.PluginStore.CompareAndSet(keyVal, oldValue)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) Delete(pluginID string, key string) error {

	tries := 0
	for {
		err := s.PluginStore.Delete(pluginID, key)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) DeleteAllExpired() error {

	tries := 0
	for {
		err := s.PluginStore.DeleteAllExpired()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) DeleteAllForPlugin(PluginID string) error {

	tries := 0
	for {
		err := s.PluginStore.DeleteAllForPlugin(PluginID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) Get(pluginID string, key string) (*model.PluginKeyValue, error) {

	tries := 0
	for {
		result, err := s.PluginStore.Get(pluginID, key)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) List(pluginID string, page int, perPage int) ([]string, error) {

	tries := 0
	for {
		result, err := s.PluginStore.List(pluginID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) SaveOrUpdate(keyVal *model.PluginKeyValue) (*model.PluginKeyValue, error) {

	tries := 0
	for {
		result, err := s.PluginStore.SaveOrUpdate(keyVal)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPluginStore) SetWithOptions(pluginID string, key string, value []byte, options model.PluginKVSetOptions) (bool, error) {

	tries := 0
	for {
		result, err := s.PluginStore.SetWithOptions(pluginID, key, value, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsPostCount(teamID string, mustHaveFile bool, mustHaveHashtag bool) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsPostCount(teamID, mustHaveFile, mustHaveHashtag)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsPostCountsByDay(options *model.AnalyticsPostCountsOptions) (model.AnalyticsRows, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsPostCountsByDay(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) AnalyticsUserCountsWithPostsByDay(teamID string) (model.AnalyticsRows, error) {

	tries := 0
	for {
		result, err := s.PostStore.AnalyticsUserCountsWithPostsByDay(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) ClearCaches() {

	s.PostStore.ClearCaches()

}

func (s *RetryLayerPostStore) Delete(postID string, time int64, deleteByID string) error {

	tries := 0
	for {
		err := s.PostStore.Delete(postID, time, deleteByID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Get(ctx context.Context, id string, opts model.GetPostsOptions, userID string, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.Get(ctx, id, opts, userID, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetDirectPostParentsForExportAfter(limit int, afterID string) ([]*model.DirectPostForExport, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetDirectPostParentsForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetEtag(channelID string, allowFromCache bool, collapsedThreads bool) string {

	return s.PostStore.GetEtag(channelID, allowFromCache, collapsedThreads)

}

func (s *RetryLayerPostStore) GetFlaggedPosts(userID string, offset int, limit int) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetFlaggedPosts(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetFlaggedPostsForChannel(userID string, channelID string, offset int, limit int) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetFlaggedPostsForChannel(userID, channelID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetFlaggedPostsForTeam(userID string, teamID string, offset int, limit int) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetFlaggedPostsForTeam(userID, teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetLastPostRowCreateAt() (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetLastPostRowCreateAt()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetMaxPostSize() int {

	return s.PostStore.GetMaxPostSize()

}

func (s *RetryLayerPostStore) GetOldest() (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetOldest()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetOldestEntityCreationTime() (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetOldestEntityCreationTime()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetParentsForExportAfter(limit int, afterID string) ([]*model.PostForExport, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetParentsForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostAfterTime(channelID string, time int64, collapsedThreads bool) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostAfterTime(channelID, time, collapsedThreads)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostIdAfterTime(channelID string, time int64, collapsedThreads bool) (string, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostIdAfterTime(channelID, time, collapsedThreads)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostIdBeforeTime(channelID string, time int64, collapsedThreads bool) (string, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostIdBeforeTime(channelID, time, collapsedThreads)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPosts(options model.GetPostsOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPosts(options, allowFromCache, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsAfter(options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsAfter(options, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsBatchForIndexing(startTime int64, startPostID string, limit int) ([]*model.PostForIndexing, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsBatchForIndexing(startTime, startPostID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsBefore(options model.GetPostsOptions, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsBefore(options, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsByIds(postIds []string) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsByIds(postIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsCreatedAt(channelID string, time int64) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsCreatedAt(channelID, time)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsSince(options model.GetPostsSinceOptions, allowFromCache bool, sanitizeOptions map[string]bool) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetPostsSince(options, allowFromCache, sanitizeOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetPostsSinceForSync(options model.GetPostsSinceForSyncOptions, cursor model.GetPostsSinceForSyncCursor, limit int) ([]*model.Post, model.GetPostsSinceForSyncCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.GetPostsSinceForSync(options, cursor, limit)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetRepliesForExport(parentID string) ([]*model.ReplyForExport, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetRepliesForExport(parentID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) GetSingle(id string, inclDeleted bool) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.GetSingle(id, inclDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) HasAutoResponsePostByUserSince(options model.GetPostsSinceOptions, userId string) (bool, error) {

	tries := 0
	for {
		result, err := s.PostStore.HasAutoResponsePostByUserSince(options, userId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) InvalidateLastPostTimeCache(channelID string) {

	s.PostStore.InvalidateLastPostTimeCache(channelID)

}

func (s *RetryLayerPostStore) Overwrite(post *model.Post) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.Overwrite(post)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) OverwriteMultiple(posts []*model.Post) ([]*model.Post, int, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.OverwriteMultiple(posts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.PostStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteByChannel(channelID string) error {

	tries := 0
	for {
		err := s.PostStore.PermanentDeleteByChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.PostStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Save(post *model.Post) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.Save(post)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) SaveMultiple(posts []*model.Post) ([]*model.Post, int, error) {

	tries := 0
	for {
		result, resultVar1, err := s.PostStore.SaveMultiple(posts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Search(teamID string, userID string, params *model.SearchParams) (*model.PostList, error) {

	tries := 0
	for {
		result, err := s.PostStore.Search(teamID, userID, params)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) SearchPostsForUser(paramsList []*model.SearchParams, userID string, teamID string, page int, perPage int) (*model.PostSearchResults, error) {

	tries := 0
	for {
		result, err := s.PostStore.SearchPostsForUser(paramsList, userID, teamID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPostStore) Update(newPost *model.Post, oldPost *model.Post) (*model.Post, error) {

	tries := 0
	for {
		result, err := s.PostStore.Update(newPost, oldPost)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) CleanupFlagsBatch(limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.CleanupFlagsBatch(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) Delete(userID string, category string, name string) error {

	tries := 0
	for {
		err := s.PreferenceStore.Delete(userID, category, name)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteCategory(userID string, category string) error {

	tries := 0
	for {
		err := s.PreferenceStore.DeleteCategory(userID, category)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteCategoryAndName(category string, name string) error {

	tries := 0
	for {
		err := s.PreferenceStore.DeleteCategoryAndName(category, name)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) Get(userID string, category string, name string) (*model.Preference, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.Get(userID, category, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) GetAll(userID string) (model.Preferences, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.GetAll(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) GetCategory(userID string, category string) (model.Preferences, error) {

	tries := 0
	for {
		result, err := s.PreferenceStore.GetCategory(userID, category)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) PermanentDeleteByUser(userID string) error {

	tries := 0
	for {
		err := s.PreferenceStore.PermanentDeleteByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerPreferenceStore) Save(preferences model.Preferences) error {

	tries := 0
	for {
		err := s.PreferenceStore.Save(preferences)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) Clear(notices []string) error {

	tries := 0
	for {
		err := s.ProductNoticesStore.Clear(notices)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) ClearOldNotices(currentNotices model.ProductNotices) error {

	tries := 0
	for {
		err := s.ProductNoticesStore.ClearOldNotices(currentNotices)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) GetViews(userID string) ([]model.ProductNoticeViewState, error) {

	tries := 0
	for {
		result, err := s.ProductNoticesStore.GetViews(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerProductNoticesStore) View(userID string, notices []string) error {

	tries := 0
	for {
		err := s.ProductNoticesStore.View(userID, notices)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) BulkGetForPosts(postIds []string) ([]*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.BulkGetForPosts(postIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) Delete(reaction *model.Reaction) (*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.Delete(reaction)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) DeleteAllWithEmojiName(emojiName string) error {

	tries := 0
	for {
		err := s.ReactionStore.DeleteAllWithEmojiName(emojiName)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetForPost(postID string, allowFromCache bool) ([]*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetForPost(postID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetForPostSince(postId string, since int64, excludeRemoteId string, inclDeleted bool) ([]*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetForPostSince(postId, since, excludeRemoteId, inclDeleted)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetTopForTeamSince(teamID string, userID string, since int64, offset int, limit int) (*model.TopReactionList, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetTopForTeamSince(teamID, userID, since, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) GetTopForUserSince(userID string, teamID string, since int64, offset int, limit int) (*model.TopReactionList, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.GetTopForUserSince(userID, teamID, since, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) PermanentDeleteBatch(endTime int64, limit int64) (int64, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.PermanentDeleteBatch(endTime, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerReactionStore) Save(reaction *model.Reaction) (*model.Reaction, error) {

	tries := 0
	for {
		result, err := s.ReactionStore.Save(reaction)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Delete(remoteClusterId string) (bool, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Delete(remoteClusterId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Get(remoteClusterId string) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Get(remoteClusterId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) GetAll(filter model.RemoteClusterQueryFilter) ([]*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.GetAll(filter)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Save(rc *model.RemoteCluster) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Save(rc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) SetLastPingAt(remoteClusterId string) error {

	tries := 0
	for {
		err := s.RemoteClusterStore.SetLastPingAt(remoteClusterId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) Update(rc *model.RemoteCluster) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.Update(rc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRemoteClusterStore) UpdateTopics(remoteClusterId string, topics string) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.RemoteClusterStore.UpdateTopics(remoteClusterId, topics)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) AddChannels(policyId string, channelIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.AddChannels(policyId, channelIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) AddTeams(policyId string, teamIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.AddTeams(policyId, teamIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Delete(id string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.Delete(id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Get(id string) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetAll(offset int, limit int) ([]*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetAll(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannelPoliciesCountForUser(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannelPoliciesCountForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannelPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForChannel, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannelPoliciesForUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannels(policyId string, offset int, limit int) (model.ChannelListWithTeamData, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannels(policyId, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetChannelsCount(policyId string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetChannelsCount(policyId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetCount() (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeamPoliciesCountForUser(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeamPoliciesCountForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeamPoliciesForUser(userID string, offset int, limit int) ([]*model.RetentionPolicyForTeam, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeamPoliciesForUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeams(policyId string, offset int, limit int) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeams(policyId, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) GetTeamsCount(policyId string) (int64, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.GetTeamsCount(policyId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Patch(patch *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.Patch(patch)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) RemoveChannels(policyId string, channelIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.RemoveChannels(policyId, channelIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) RemoveTeams(policyId string, teamIds []string) error {

	tries := 0
	for {
		err := s.RetentionPolicyStore.RemoveTeams(policyId, teamIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRetentionPolicyStore) Save(policy *model.RetentionPolicyWithTeamAndChannelIDs) (*model.RetentionPolicyWithTeamAndChannelCounts, error) {

	tries := 0
	for {
		result, err := s.RetentionPolicyStore.Save(policy)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) AllChannelSchemeRoles() ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.AllChannelSchemeRoles()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) ChannelHigherScopedPermissions(roleNames []string) (map[string]*model.RolePermissions, error) {

	tries := 0
	for {
		result, err := s.RoleStore.ChannelHigherScopedPermissions(roleNames)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) ChannelRolesUnderTeamRole(roleName string) ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.ChannelRolesUnderTeamRole(roleName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) Delete(roleID string) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.Delete(roleID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) Get(roleID string) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.Get(roleID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) GetAll() ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) GetByName(ctx context.Context, name string) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.GetByName(ctx, name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) GetByNames(names []string) ([]*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.GetByNames(names)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) PermanentDeleteAll() error {

	tries := 0
	for {
		err := s.RoleStore.PermanentDeleteAll()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerRoleStore) Save(role *model.Role) (*model.Role, error) {

	tries := 0
	for {
		result, err := s.RoleStore.Save(role)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) CountByScope(scope string) (int64, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.CountByScope(scope)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) CountWithoutPermission(scope string, permissionID string, roleScope model.RoleScope, roleType model.RoleType) (int64, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.CountWithoutPermission(scope, permissionID, roleScope, roleType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) Delete(schemeID string) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.Delete(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) Get(schemeID string) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.Get(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) GetAllPage(scope string, offset int, limit int) ([]*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.GetAllPage(scope, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) GetByName(schemeName string) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.GetByName(schemeName)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) PermanentDeleteAll() error {

	tries := 0
	for {
		err := s.SchemeStore.PermanentDeleteAll()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSchemeStore) Save(scheme *model.Scheme) (*model.Scheme, error) {

	tries := 0
	for {
		result, err := s.SchemeStore.Save(scheme)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) AnalyticsSessionCount() (int64, error) {

	tries := 0
	for {
		result, err := s.SessionStore.AnalyticsSessionCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Cleanup(expiryTime int64, batchSize int64) error {

	tries := 0
	for {
		err := s.SessionStore.Cleanup(expiryTime, batchSize)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Get(ctx context.Context, sessionIDOrToken string) (*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.Get(ctx, sessionIDOrToken)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetLastSessionRowCreateAt() (int64, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetLastSessionRowCreateAt()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetSessions(userID string) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetSessions(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetSessionsExpired(thresholdMillis int64, mobileOnly bool, unnotifiedOnly bool) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetSessionsExpired(thresholdMillis, mobileOnly, unnotifiedOnly)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) GetSessionsWithActiveDeviceIds(userID string) ([]*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.GetSessionsWithActiveDeviceIds(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) PermanentDeleteSessionsByUser(teamID string) error {

	tries := 0
	for {
		err := s.SessionStore.PermanentDeleteSessionsByUser(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Remove(sessionIDOrToken string) error {

	tries := 0
	for {
		err := s.SessionStore.Remove(sessionIDOrToken)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) RemoveAllSessions() error {

	tries := 0
	for {
		err := s.SessionStore.RemoveAllSessions()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) Save(session *model.Session) (*model.Session, error) {

	tries := 0
	for {
		result, err := s.SessionStore.Save(session)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateDeviceId(id string, deviceID string, expiresAt int64) (string, error) {

	tries := 0
	for {
		result, err := s.SessionStore.UpdateDeviceId(id, deviceID, expiresAt)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateExpiredNotify(sessionid string, notified bool) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateExpiredNotify(sessionid, notified)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateExpiresAt(sessionID string, time int64) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateExpiresAt(sessionID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateLastActivityAt(sessionID string, time int64) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateLastActivityAt(sessionID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateProps(session *model.Session) error {

	tries := 0
	for {
		err := s.SessionStore.UpdateProps(session)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSessionStore) UpdateRoles(userID string, roles string) (string, error) {

	tries := 0
	for {
		result, err := s.SessionStore.UpdateRoles(userID, roles)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Delete(channelId string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Delete(channelId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) DeleteRemote(remoteId string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.DeleteRemote(remoteId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Get(channelId string) (*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Get(channelId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetAll(offset int, limit int, opts model.SharedChannelFilterOpts) ([]*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetAll(offset, limit, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetAllCount(opts model.SharedChannelFilterOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetAllCount(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetAttachment(fileId string, remoteId string) (*model.SharedChannelAttachment, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetAttachment(fileId, remoteId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemote(id string) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemote(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemoteByIds(channelId string, remoteId string) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemoteByIds(channelId, remoteId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemoteForUser(remoteId string, userId string) (*model.RemoteCluster, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemoteForUser(remoteId, userId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemotes(opts model.SharedChannelRemoteFilterOpts) ([]*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemotes(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetRemotesStatus(channelId string) ([]*model.SharedChannelRemoteStatus, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetRemotesStatus(channelId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetSingleUser(userID string, channelID string, remoteID string) (*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetSingleUser(userID, channelID, remoteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetUsersForSync(filter model.GetUsersForSyncFilter) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetUsersForSync(filter)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) GetUsersForUser(userID string) ([]*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.GetUsersForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) HasChannel(channelID string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.HasChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) HasRemote(channelID string, remoteId string) (bool, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.HasRemote(channelID, remoteId)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Save(sc *model.SharedChannel) (*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Save(sc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) SaveAttachment(remote *model.SharedChannelAttachment) (*model.SharedChannelAttachment, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.SaveAttachment(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) SaveRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.SaveRemote(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) SaveUser(remote *model.SharedChannelUser) (*model.SharedChannelUser, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.SaveUser(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) Update(sc *model.SharedChannel) (*model.SharedChannel, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.Update(sc)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateAttachmentLastSyncAt(id string, syncTime int64) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateAttachmentLastSyncAt(id, syncTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateRemote(remote *model.SharedChannelRemote) (*model.SharedChannelRemote, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.UpdateRemote(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateRemoteCursor(id string, cursor model.GetPostsSinceForSyncCursor) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateRemoteCursor(id, cursor)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpdateUserLastSyncAt(userID string, channelID string, remoteID string) error {

	tries := 0
	for {
		err := s.SharedChannelStore.UpdateUserLastSyncAt(userID, channelID, remoteID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSharedChannelStore) UpsertAttachment(remote *model.SharedChannelAttachment) (string, error) {

	tries := 0
	for {
		result, err := s.SharedChannelStore.UpsertAttachment(remote)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) Get(userID string) (*model.Status, error) {

	tries := 0
	for {
		result, err := s.StatusStore.Get(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) GetByIds(userIds []string) ([]*model.Status, error) {

	tries := 0
	for {
		result, err := s.StatusStore.GetByIds(userIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) GetTotalActiveUsersCount() (int64, error) {

	tries := 0
	for {
		result, err := s.StatusStore.GetTotalActiveUsersCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) ResetAll() error {

	tries := 0
	for {
		err := s.StatusStore.ResetAll()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) SaveOrUpdate(status *model.Status) error {

	tries := 0
	for {
		err := s.StatusStore.SaveOrUpdate(status)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) UpdateExpiredDNDStatuses() ([]*model.Status, error) {

	tries := 0
	for {
		result, err := s.StatusStore.UpdateExpiredDNDStatuses()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerStatusStore) UpdateLastActivityAt(userID string, lastActivityAt int64) error {

	tries := 0
	for {
		err := s.StatusStore.UpdateLastActivityAt(userID, lastActivityAt)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) Get() (model.StringMap, error) {

	tries := 0
	for {
		result, err := s.SystemStore.Get()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) GetByName(name string) (*model.System, error) {

	tries := 0
	for {
		result, err := s.SystemStore.GetByName(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) InsertIfExists(system *model.System) (*model.System, error) {

	tries := 0
	for {
		result, err := s.SystemStore.InsertIfExists(system)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) PermanentDeleteByName(name string) (*model.System, error) {

	tries := 0
	for {
		result, err := s.SystemStore.PermanentDeleteByName(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) Save(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.Save(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) SaveOrUpdate(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.SaveOrUpdate(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) SaveOrUpdateWithWarnMetricHandling(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.SaveOrUpdateWithWarnMetricHandling(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerSystemStore) Update(system *model.System) error {

	tries := 0
	for {
		err := s.SystemStore.Update(system)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) AnalyticsGetTeamCountForScheme(schemeID string) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.AnalyticsGetTeamCountForScheme(schemeID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) AnalyticsTeamCount(opts *model.TeamSearch) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.AnalyticsTeamCount(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) ClearAllCustomRoleAssignments() error {

	tries := 0
	for {
		err := s.TeamStore.ClearAllCustomRoleAssignments()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) ClearCaches() {

	s.TeamStore.ClearCaches()

}

func (s *RetryLayerTeamStore) Get(id string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetActiveMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetActiveMemberCount(teamID, restrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAll() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllForExportAfter(limit int, afterID string) ([]*model.TeamForExport, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllForExportAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllPage(offset int, limit int, opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllPage(offset, limit, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllPrivateTeamListing() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllPrivateTeamListing()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetAllTeamListing() ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetAllTeamListing()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByInviteId(inviteID string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByInviteId(inviteID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByName(name string) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByName(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetByNames(name []string) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetByNames(name)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetChannelUnreadsForAllTeams(excludeTeamID string, userID string) ([]*model.ChannelUnread, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetChannelUnreadsForAllTeams(excludeTeamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetChannelUnreadsForTeam(teamID string, userID string) ([]*model.ChannelUnread, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetChannelUnreadsForTeam(teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetCommonTeamIDsForTwoUsers(userID string, otherUserID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetCommonTeamIDsForTwoUsers(userID, otherUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMany(ids []string) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMany(ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMember(ctx context.Context, teamID string, userID string) (*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMember(ctx, teamID, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMembers(teamID string, offset int, limit int, teamMembersGetOptions *model.TeamMembersGetOptions) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMembers(teamID, offset, limit, teamMembersGetOptions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetMembersByIds(teamID string, userIds []string, restrictions *model.ViewUsersRestrictions) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetMembersByIds(teamID, userIds, restrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamMembersForExport(userID string) ([]*model.TeamMemberForExport, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamMembersForExport(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsByScheme(schemeID string, offset int, limit int) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsByScheme(schemeID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsByUserId(userID string) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsByUserId(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsForUser(ctx context.Context, userID string) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsForUser(ctx, userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTeamsForUserWithPagination(userID string, page int, perPage int) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTeamsForUserWithPagination(userID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetTotalMemberCount(teamID string, restrictions *model.ViewUsersRestrictions) (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetTotalMemberCount(teamID, restrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GetUserTeamIds(userID string, allowFromCache bool) ([]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GetUserTeamIds(userID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) GroupSyncedTeamCount() (int64, error) {

	tries := 0
	for {
		result, err := s.TeamStore.GroupSyncedTeamCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) InvalidateAllTeamIdsForUser(userID string) {

	s.TeamStore.InvalidateAllTeamIdsForUser(userID)

}

func (s *RetryLayerTeamStore) MigrateTeamMembers(fromTeamID string, fromUserID string) (map[string]string, error) {

	tries := 0
	for {
		result, err := s.TeamStore.MigrateTeamMembers(fromTeamID, fromUserID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) PermanentDelete(teamID string) error {

	tries := 0
	for {
		err := s.TeamStore.PermanentDelete(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveAllMembersByTeam(teamID string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveAllMembersByTeam(teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveAllMembersByUser(userID string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveAllMembersByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveMember(teamID string, userID string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveMember(teamID, userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) RemoveMembers(teamID string, userIds []string) error {

	tries := 0
	for {
		err := s.TeamStore.RemoveMembers(teamID, userIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) ResetAllTeamSchemes() error {

	tries := 0
	for {
		err := s.TeamStore.ResetAllTeamSchemes()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) Save(team *model.Team) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.Save(team)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SaveMember(member *model.TeamMember, maxUsersPerTeam int) (*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SaveMember(member, maxUsersPerTeam)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SaveMultipleMembers(members []*model.TeamMember, maxUsersPerTeam int) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SaveMultipleMembers(members, maxUsersPerTeam)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchAll(opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SearchAll(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchAllPaged(opts *model.TeamSearch) ([]*model.Team, int64, error) {

	tries := 0
	for {
		result, resultVar1, err := s.TeamStore.SearchAllPaged(opts)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchOpen(opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SearchOpen(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) SearchPrivate(opts *model.TeamSearch) ([]*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.SearchPrivate(opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) Update(team *model.Team) (*model.Team, error) {

	tries := 0
	for {
		result, err := s.TeamStore.Update(team)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateLastTeamIconUpdate(teamID string, curTime int64) error {

	tries := 0
	for {
		err := s.TeamStore.UpdateLastTeamIconUpdate(teamID, curTime)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateMember(member *model.TeamMember) (*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UpdateMember(member)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateMembersRole(teamID string, userIDs []string) error {

	tries := 0
	for {
		err := s.TeamStore.UpdateMembersRole(teamID, userIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UpdateMultipleMembers(members []*model.TeamMember) ([]*model.TeamMember, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UpdateMultipleMembers(members)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTeamStore) UserBelongsToTeams(userID string, teamIds []string) (bool, error) {

	tries := 0
	for {
		result, err := s.TeamStore.UserBelongsToTeams(userID, teamIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTermsOfServiceStore) Get(id string, allowFromCache bool) (*model.TermsOfService, error) {

	tries := 0
	for {
		result, err := s.TermsOfServiceStore.Get(id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTermsOfServiceStore) GetLatest(allowFromCache bool) (*model.TermsOfService, error) {

	tries := 0
	for {
		result, err := s.TermsOfServiceStore.GetLatest(allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTermsOfServiceStore) Save(termsOfService *model.TermsOfService) (*model.TermsOfService, error) {

	tries := 0
	for {
		result, err := s.TermsOfServiceStore.Save(termsOfService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) DeleteMembershipForUser(userId string, postID string) error {

	tries := 0
	for {
		err := s.ThreadStore.DeleteMembershipForUser(userId, postID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) DeleteOrphanedRows(limit int) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.DeleteOrphanedRows(limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) Get(id string) (*model.Thread, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetMembershipForUser(userId string, postID string) (*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetMembershipForUser(userId, postID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetMembershipsForUser(userId string, teamID string) ([]*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetMembershipsForUser(userId, teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetPosts(threadID string, since int64) ([]*model.Post, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetPosts(threadID, since)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTeamsUnreadForUser(userID string, teamIDs []string) (map[string]*model.TeamUnread, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTeamsUnreadForUser(userID, teamIDs)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadFollowers(threadID string, fetchOnlyActive bool) ([]string, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadFollowers(threadID, fetchOnlyActive)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadForUser(teamID string, threadMembership *model.ThreadMembership, extended bool) (*model.ThreadResponse, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadForUser(teamID, threadMembership, extended)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadUnreadReplyCount(threadMembership *model.ThreadMembership) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadUnreadReplyCount(threadMembership)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetThreadsForUser(userId string, teamID string, opts model.GetUserThreadsOpts) ([]*model.ThreadResponse, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetThreadsForUser(userId, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalThreads(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalThreads(userId, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalUnreadMentions(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalUnreadMentions(userId, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) GetTotalUnreadThreads(userId string, teamID string, opts model.GetUserThreadsOpts) (int64, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.GetTotalUnreadThreads(userId, teamID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MaintainMembership(userID string, postID string, opts store.ThreadMembershipOpts) (*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.MaintainMembership(userID, postID, opts)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAllAsRead(userID string, threadIds []string) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAllAsRead(userID, threadIds)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAllAsReadByChannels(userID string, channelIDs []string) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAllAsReadByChannels(userID, channelIDs)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAllAsReadByTeam(userID string, teamID string) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAllAsReadByTeam(userID, teamID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) MarkAsRead(userID string, threadID string, timestamp int64) error {

	tries := 0
	for {
		err := s.ThreadStore.MarkAsRead(userID, threadID, timestamp)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) PermanentDeleteBatchForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) PermanentDeleteBatchThreadMembershipsForRetentionPolicies(now int64, globalPolicyEndTime int64, limit int64, cursor model.RetentionPolicyCursor) (int64, model.RetentionPolicyCursor, error) {

	tries := 0
	for {
		result, resultVar1, err := s.ThreadStore.PermanentDeleteBatchThreadMembershipsForRetentionPolicies(now, globalPolicyEndTime, limit, cursor)
		if err == nil {
			return result, resultVar1, nil
		}
		if !isRepeatableError(err) {
			return result, resultVar1, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, resultVar1, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerThreadStore) UpdateMembership(membership *model.ThreadMembership) (*model.ThreadMembership, error) {

	tries := 0
	for {
		result, err := s.ThreadStore.UpdateMembership(membership)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) Cleanup(expiryTime int64) {

	s.TokenStore.Cleanup(expiryTime)

}

func (s *RetryLayerTokenStore) Delete(token string) error {

	tries := 0
	for {
		err := s.TokenStore.Delete(token)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) GetAllTokensByType(tokenType string) ([]*model.Token, error) {

	tries := 0
	for {
		result, err := s.TokenStore.GetAllTokensByType(tokenType)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) GetByToken(token string) (*model.Token, error) {

	tries := 0
	for {
		result, err := s.TokenStore.GetByToken(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) RemoveAllTokensByType(tokenType string) error {

	tries := 0
	for {
		err := s.TokenStore.RemoveAllTokensByType(tokenType)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerTokenStore) Save(recovery *model.Token) error {

	tries := 0
	for {
		err := s.TokenStore.Save(recovery)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Delete(id string) error {

	tries := 0
	for {
		err := s.UploadSessionStore.Delete(id)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Get(id string) (*model.UploadSession, error) {

	tries := 0
	for {
		result, err := s.UploadSessionStore.Get(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) GetForUser(userID string) ([]*model.UploadSession, error) {

	tries := 0
	for {
		result, err := s.UploadSessionStore.GetForUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Save(session *model.UploadSession) (*model.UploadSession, error) {

	tries := 0
	for {
		result, err := s.UploadSessionStore.Save(session)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUploadSessionStore) Update(session *model.UploadSession) error {

	tries := 0
	for {
		err := s.UploadSessionStore.Update(session)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsActiveCount(time int64, options model.UserCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsActiveCount(time, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsActiveCountForPeriod(startTime int64, endTime int64, options model.UserCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsActiveCountForPeriod(startTime, endTime, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetExternalUsers(hostDomain string) (bool, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetExternalUsers(hostDomain)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetGuestCount() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetGuestCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetInactiveUsersCount() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetInactiveUsersCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AnalyticsGetSystemAdminCount() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.AnalyticsGetSystemAdminCount()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) AutocompleteUsersInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) (*model.UserAutocompleteInChannel, error) {

	tries := 0
	for {
		result, err := s.UserStore.AutocompleteUsersInChannel(teamID, channelID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ClearAllCustomRoleAssignments() error {

	tries := 0
	for {
		err := s.UserStore.ClearAllCustomRoleAssignments()
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ClearCaches() {

	s.UserStore.ClearCaches()

}

func (s *RetryLayerUserStore) Count(options model.UserCountOptions) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.Count(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) DeactivateGuests() ([]string, error) {

	tries := 0
	for {
		result, err := s.UserStore.DeactivateGuests()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) DemoteUserToGuest(userID string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.DemoteUserToGuest(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Get(ctx context.Context, id string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.Get(ctx, id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAll() ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAll()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllAfter(limit int, afterID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllAfter(limit, afterID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllNotInAuthService(authServices []string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllNotInAuthService(authServices)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllProfiles(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllProfiles(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllProfilesInChannel(ctx context.Context, channelID string, allowFromCache bool) (map[string]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllProfilesInChannel(ctx, channelID, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAllUsingAuthService(authService string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAllUsingAuthService(authService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetAnyUnreadPostCountForChannel(userID string, channelID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetAnyUnreadPostCountForChannel(userID, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByAuth(authData *string, authService string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByAuth(authData, authService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByEmail(email string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByEmail(email)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetByUsername(username string) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetByUsername(username)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetChannelGroupUsers(channelID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetChannelGroupUsers(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetEtagForAllProfiles() string {

	return s.UserStore.GetEtagForAllProfiles()

}

func (s *RetryLayerUserStore) GetEtagForProfiles(teamID string) string {

	return s.UserStore.GetEtagForProfiles(teamID)

}

func (s *RetryLayerUserStore) GetEtagForProfilesNotInTeam(teamID string) string {

	return s.UserStore.GetEtagForProfilesNotInTeam(teamID)

}

func (s *RetryLayerUserStore) GetForLogin(loginID string, allowSignInWithUsername bool, allowSignInWithEmail bool) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetForLogin(loginID, allowSignInWithUsername, allowSignInWithEmail)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetKnownUsers(userID string) ([]string, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetKnownUsers(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetMany(ctx context.Context, ids []string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetMany(ctx, ids)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetNewUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetNewUsersForTeam(teamID, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfileByGroupChannelIdsForUser(userID string, channelIds []string) (map[string][]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfileByGroupChannelIdsForUser(userID, channelIds)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfileByIds(ctx context.Context, userIds []string, options *store.UserGetByIdsOpts, allowFromCache bool) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfileByIds(ctx, userIds, options, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfiles(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfiles(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesByUsernames(usernames []string, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesByUsernames(usernames, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesInChannel(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesInChannel(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesInChannelByStatus(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesInChannelByStatus(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesNotInChannel(teamID string, channelId string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesNotInChannel(teamID, channelId, groupConstrained, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesNotInTeam(teamID string, groupConstrained bool, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesNotInTeam(teamID, groupConstrained, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetProfilesWithoutTeam(options *model.UserGetOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetProfilesWithoutTeam(options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetRecentlyActiveUsersForTeam(teamID string, offset int, limit int, viewRestrictions *model.ViewUsersRestrictions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetRecentlyActiveUsersForTeam(teamID, offset, limit, viewRestrictions)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetSystemAdminProfiles() (map[string]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetSystemAdminProfiles()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetTeamGroupUsers(teamID string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetTeamGroupUsers(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUnreadCount(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUnreadCount(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUnreadCountForChannel(userID string, channelID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUnreadCountForChannel(userID, channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUsersBatchForIndexing(startTime int64, startFileID string, limit int) ([]*model.UserForIndexing, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUsersBatchForIndexing(startTime, startFileID, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) GetUsersWithInvalidEmails(page int, perPage int, restrictedDomains string) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.GetUsersWithInvalidEmails(page, perPage, restrictedDomains)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) InferSystemInstallDate() (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.InferSystemInstallDate()
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) InsertUsers(users []*model.User) error {

	tries := 0
	for {
		err := s.UserStore.InsertUsers(users)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) InvalidateProfileCacheForUser(userID string) {

	s.UserStore.InvalidateProfileCacheForUser(userID)

}

func (s *RetryLayerUserStore) InvalidateProfilesInChannelCache(channelID string) {

	s.UserStore.InvalidateProfilesInChannelCache(channelID)

}

func (s *RetryLayerUserStore) InvalidateProfilesInChannelCacheByUser(userID string) {

	s.UserStore.InvalidateProfilesInChannelCacheByUser(userID)

}

func (s *RetryLayerUserStore) IsEmpty(excludeBots bool) (bool, error) {

	tries := 0
	for {
		result, err := s.UserStore.IsEmpty(excludeBots)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) PermanentDelete(userID string) error {

	tries := 0
	for {
		err := s.UserStore.PermanentDelete(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) PromoteGuestToUser(userID string) error {

	tries := 0
	for {
		err := s.UserStore.PromoteGuestToUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ResetAuthDataToEmailForUsers(service string, userIDs []string, includeDeleted bool, dryRun bool) (int, error) {

	tries := 0
	for {
		result, err := s.UserStore.ResetAuthDataToEmailForUsers(service, userIDs, includeDeleted, dryRun)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) ResetLastPictureUpdate(userID string) error {

	tries := 0
	for {
		err := s.UserStore.ResetLastPictureUpdate(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Save(user *model.User) (*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.Save(user)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Search(teamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.Search(teamID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchInChannel(channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchInChannel(channelID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchInGroup(groupID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchNotInChannel(teamID string, channelID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchNotInChannel(teamID, channelID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchNotInGroup(groupID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchNotInGroup(groupID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchNotInTeam(notInTeamID string, term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchNotInTeam(notInTeamID, term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) SearchWithoutTeam(term string, options *model.UserSearchOptions) ([]*model.User, error) {

	tries := 0
	for {
		result, err := s.UserStore.SearchWithoutTeam(term, options)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) Update(user *model.User, allowRoleUpdate bool) (*model.UserUpdate, error) {

	tries := 0
	for {
		result, err := s.UserStore.Update(user, allowRoleUpdate)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateAuthData(userID string, service string, authData *string, email string, resetMfa bool) (string, error) {

	tries := 0
	for {
		result, err := s.UserStore.UpdateAuthData(userID, service, authData, email, resetMfa)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateFailedPasswordAttempts(userID string, attempts int) error {

	tries := 0
	for {
		err := s.UserStore.UpdateFailedPasswordAttempts(userID, attempts)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateLastPictureUpdate(userID string) error {

	tries := 0
	for {
		err := s.UserStore.UpdateLastPictureUpdate(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateMfaActive(userID string, active bool) error {

	tries := 0
	for {
		err := s.UserStore.UpdateMfaActive(userID, active)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateMfaSecret(userID string, secret string) error {

	tries := 0
	for {
		err := s.UserStore.UpdateMfaSecret(userID, secret)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateNotifyProps(userID string, props map[string]string) error {

	tries := 0
	for {
		err := s.UserStore.UpdateNotifyProps(userID, props)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdatePassword(userID string, newPassword string) error {

	tries := 0
	for {
		err := s.UserStore.UpdatePassword(userID, newPassword)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) UpdateUpdateAt(userID string) (int64, error) {

	tries := 0
	for {
		result, err := s.UserStore.UpdateUpdateAt(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserStore) VerifyEmail(userID string, email string) (string, error) {

	tries := 0
	for {
		result, err := s.UserStore.VerifyEmail(userID, email)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Delete(tokenID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.Delete(tokenID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) DeleteAllForUser(userID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.DeleteAllForUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Get(tokenID string) (*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.Get(tokenID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) GetAll(offset int, limit int) ([]*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.GetAll(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) GetByToken(tokenString string) (*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.GetByToken(tokenString)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) GetByUser(userID string, page int, perPage int) ([]*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.GetByUser(userID, page, perPage)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Save(token *model.UserAccessToken) (*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.Save(token)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) Search(term string) ([]*model.UserAccessToken, error) {

	tries := 0
	for {
		result, err := s.UserAccessTokenStore.Search(term)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) UpdateTokenDisable(tokenID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.UpdateTokenDisable(tokenID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserAccessTokenStore) UpdateTokenEnable(tokenID string) error {

	tries := 0
	for {
		err := s.UserAccessTokenStore.UpdateTokenEnable(tokenID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserTermsOfServiceStore) Delete(userID string, termsOfServiceId string) error {

	tries := 0
	for {
		err := s.UserTermsOfServiceStore.Delete(userID, termsOfServiceId)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserTermsOfServiceStore) GetByUser(userID string) (*model.UserTermsOfService, error) {

	tries := 0
	for {
		result, err := s.UserTermsOfServiceStore.GetByUser(userID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerUserTermsOfServiceStore) Save(userTermsOfService *model.UserTermsOfService) (*model.UserTermsOfService, error) {

	tries := 0
	for {
		result, err := s.UserTermsOfServiceStore.Save(userTermsOfService)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) AnalyticsIncomingCount(teamID string) (int64, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.AnalyticsIncomingCount(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) AnalyticsOutgoingCount(teamID string) (int64, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.AnalyticsOutgoingCount(teamID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) ClearCaches() {

	s.WebhookStore.ClearCaches()

}

func (s *RetryLayerWebhookStore) DeleteIncoming(webhookID string, time int64) error {

	tries := 0
	for {
		err := s.WebhookStore.DeleteIncoming(webhookID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) DeleteOutgoing(webhookID string, time int64) error {

	tries := 0
	for {
		err := s.WebhookStore.DeleteOutgoing(webhookID, time)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncoming(id string, allowFromCache bool) (*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncoming(id, allowFromCache)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingByChannel(channelID string) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingByChannel(channelID)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingByTeam(teamID string, offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingByTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingByTeamByUser(teamID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingList(offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingList(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetIncomingListByUser(userID string, offset int, limit int) ([]*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetIncomingListByUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoing(id string) (*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoing(id)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByChannel(channelID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByChannel(channelID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByChannelByUser(channelID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByChannelByUser(channelID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByTeam(teamID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByTeam(teamID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingByTeamByUser(teamID string, userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingByTeamByUser(teamID, userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingList(offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingList(offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) GetOutgoingListByUser(userID string, offset int, limit int) ([]*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.GetOutgoingListByUser(userID, offset, limit)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) InvalidateWebhookCache(webhook string) {

	s.WebhookStore.InvalidateWebhookCache(webhook)

}

func (s *RetryLayerWebhookStore) PermanentDeleteIncomingByChannel(channelID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteIncomingByChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) PermanentDeleteIncomingByUser(userID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteIncomingByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) PermanentDeleteOutgoingByChannel(channelID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteOutgoingByChannel(channelID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) PermanentDeleteOutgoingByUser(userID string) error {

	tries := 0
	for {
		err := s.WebhookStore.PermanentDeleteOutgoingByUser(userID)
		if err == nil {
			return nil
		}
		if !isRepeatableError(err) {
			return err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) SaveIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.SaveIncoming(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) SaveOutgoing(webhook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.SaveOutgoing(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) UpdateIncoming(webhook *model.IncomingWebhook) (*model.IncomingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.UpdateIncoming(webhook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayerWebhookStore) UpdateOutgoing(hook *model.OutgoingWebhook) (*model.OutgoingWebhook, error) {

	tries := 0
	for {
		result, err := s.WebhookStore.UpdateOutgoing(hook)
		if err == nil {
			return result, nil
		}
		if !isRepeatableError(err) {
			return result, err
		}
		tries++
		if tries >= 3 {
			err = errors.Wrap(err, "giving up after 3 consecutive repeatable transaction failures")
			return result, err
		}
		timepkg.Sleep(100 * timepkg.Millisecond)
	}

}

func (s *RetryLayer) Close() {
	s.Store.Close()
}

func (s *RetryLayer) DropAllTables() {
	s.Store.DropAllTables()
}

func (s *RetryLayer) LockToMaster() {
	s.Store.LockToMaster()
}

func (s *RetryLayer) MarkSystemRanUnitTests() {
	s.Store.MarkSystemRanUnitTests()
}

func (s *RetryLayer) SetContext(context context.Context) {
	s.Store.SetContext(context)
}

func (s *RetryLayer) TotalMasterDbConnections() int {
	return s.Store.TotalMasterDbConnections()
}

func (s *RetryLayer) TotalReadDbConnections() int {
	return s.Store.TotalReadDbConnections()
}

func (s *RetryLayer) TotalSearchDbConnections() int {
	return s.Store.TotalSearchDbConnections()
}

func (s *RetryLayer) UnlockFromMaster() {
	s.Store.UnlockFromMaster()
}

func New(childStore store.Store) *RetryLayer {
	newStore := RetryLayer{
		Store: childStore,
	}

	newStore.AuditStore = &RetryLayerAuditStore{AuditStore: childStore.Audit(), Root: &newStore}
	newStore.BotStore = &RetryLayerBotStore{BotStore: childStore.Bot(), Root: &newStore}
	newStore.ChannelStore = &RetryLayerChannelStore{ChannelStore: childStore.Channel(), Root: &newStore}
	newStore.ChannelMemberHistoryStore = &RetryLayerChannelMemberHistoryStore{ChannelMemberHistoryStore: childStore.ChannelMemberHistory(), Root: &newStore}
	newStore.ClusterDiscoveryStore = &RetryLayerClusterDiscoveryStore{ClusterDiscoveryStore: childStore.ClusterDiscovery(), Root: &newStore}
	newStore.CommandStore = &RetryLayerCommandStore{CommandStore: childStore.Command(), Root: &newStore}
	newStore.CommandWebhookStore = &RetryLayerCommandWebhookStore{CommandWebhookStore: childStore.CommandWebhook(), Root: &newStore}
	newStore.ComplianceStore = &RetryLayerComplianceStore{ComplianceStore: childStore.Compliance(), Root: &newStore}
	newStore.EmojiStore = &RetryLayerEmojiStore{EmojiStore: childStore.Emoji(), Root: &newStore}
	newStore.FileInfoStore = &RetryLayerFileInfoStore{FileInfoStore: childStore.FileInfo(), Root: &newStore}
	newStore.GroupStore = &RetryLayerGroupStore{GroupStore: childStore.Group(), Root: &newStore}
	newStore.JobStore = &RetryLayerJobStore{JobStore: childStore.Job(), Root: &newStore}
	newStore.LicenseStore = &RetryLayerLicenseStore{LicenseStore: childStore.License(), Root: &newStore}
	newStore.LinkMetadataStore = &RetryLayerLinkMetadataStore{LinkMetadataStore: childStore.LinkMetadata(), Root: &newStore}
	newStore.OAuthStore = &RetryLayerOAuthStore{OAuthStore: childStore.OAuth(), Root: &newStore}
	newStore.PluginStore = &RetryLayerPluginStore{PluginStore: childStore.Plugin(), Root: &newStore}
	newStore.PostStore = &RetryLayerPostStore{PostStore: childStore.Post(), Root: &newStore}
	newStore.PreferenceStore = &RetryLayerPreferenceStore{PreferenceStore: childStore.Preference(), Root: &newStore}
	newStore.ProductNoticesStore = &RetryLayerProductNoticesStore{ProductNoticesStore: childStore.ProductNotices(), Root: &newStore}
	newStore.ReactionStore = &RetryLayerReactionStore{ReactionStore: childStore.Reaction(), Root: &newStore}
	newStore.RemoteClusterStore = &RetryLayerRemoteClusterStore{RemoteClusterStore: childStore.RemoteCluster(), Root: &newStore}
	newStore.RetentionPolicyStore = &RetryLayerRetentionPolicyStore{RetentionPolicyStore: childStore.RetentionPolicy(), Root: &newStore}
	newStore.RoleStore = &RetryLayerRoleStore{RoleStore: childStore.Role(), Root: &newStore}
	newStore.SchemeStore = &RetryLayerSchemeStore{SchemeStore: childStore.Scheme(), Root: &newStore}
	newStore.SessionStore = &RetryLayerSessionStore{SessionStore: childStore.Session(), Root: &newStore}
	newStore.SharedChannelStore = &RetryLayerSharedChannelStore{SharedChannelStore: childStore.SharedChannel(), Root: &newStore}
	newStore.StatusStore = &RetryLayerStatusStore{StatusStore: childStore.Status(), Root: &newStore}
	newStore.SystemStore = &RetryLayerSystemStore{SystemStore: childStore.System(), Root: &newStore}
	newStore.TeamStore = &RetryLayerTeamStore{TeamStore: childStore.Team(), Root: &newStore}
	newStore.TermsOfServiceStore = &RetryLayerTermsOfServiceStore{TermsOfServiceStore: childStore.TermsOfService(), Root: &newStore}
	newStore.ThreadStore = &RetryLayerThreadStore{ThreadStore: childStore.Thread(), Root: &newStore}
	newStore.TokenStore = &RetryLayerTokenStore{TokenStore: childStore.Token(), Root: &newStore}
	newStore.UploadSessionStore = &RetryLayerUploadSessionStore{UploadSessionStore: childStore.UploadSession(), Root: &newStore}
	newStore.UserStore = &RetryLayerUserStore{UserStore: childStore.User(), Root: &newStore}
	newStore.UserAccessTokenStore = &RetryLayerUserAccessTokenStore{UserAccessTokenStore: childStore.UserAccessToken(), Root: &newStore}
	newStore.UserTermsOfServiceStore = &RetryLayerUserTermsOfServiceStore{UserTermsOfServiceStore: childStore.UserTermsOfService(), Root: &newStore}
	newStore.WebhookStore = &RetryLayerWebhookStore{WebhookStore: childStore.Webhook(), Root: &newStore}
	return &newStore
}
