// Code generated by mockery v2.10.4. DO NOT EDIT.

// Regenerate this file using `make plugin-mocks`.

package plugintest

import (
	io "io"
	http "net/http"

	mock "github.com/stretchr/testify/mock"

	model "github.com/mattermost/mattermost-server/v6/model"
)

// API is an autogenerated mock type for the API type
type API struct {
	mock.Mock
}

// AddChannelMember provides a mock function with given fields: channelId, userID
func (_m *API) AddChannelMember(channelId string, userID string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(channelId, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// AddReaction provides a mock function with given fields: reaction
func (_m *API) AddReaction(reaction *model.Reaction) (*model.Reaction, *model.AppError) {
	ret := _m.Called(reaction)

	var r0 *model.Reaction
	if rf, ok := ret.Get(0).(func(*model.Reaction) *model.Reaction); ok {
		r0 = rf(reaction)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Reaction)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Reaction) *model.AppError); ok {
		r1 = rf(reaction)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// AddUserToChannel provides a mock function with given fields: channelId, userID, asUserId
func (_m *API) AddUserToChannel(channelId string, userID string, asUserId string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID, asUserId)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID, asUserId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(channelId, userID, asUserId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CopyFileInfos provides a mock function with given fields: userID, fileIds
func (_m *API) CopyFileInfos(userID string, fileIds []string) ([]string, *model.AppError) {
	ret := _m.Called(userID, fileIds)

	var r0 []string
	if rf, ok := ret.Get(0).(func(string, []string) []string); ok {
		r0 = rf(userID, fileIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(userID, fileIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateBot provides a mock function with given fields: bot
func (_m *API) CreateBot(bot *model.Bot) (*model.Bot, *model.AppError) {
	ret := _m.Called(bot)

	var r0 *model.Bot
	if rf, ok := ret.Get(0).(func(*model.Bot) *model.Bot); ok {
		r0 = rf(bot)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Bot) *model.AppError); ok {
		r1 = rf(bot)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateChannel provides a mock function with given fields: channel
func (_m *API) CreateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	ret := _m.Called(channel)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(*model.Channel) *model.Channel); ok {
		r0 = rf(channel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Channel) *model.AppError); ok {
		r1 = rf(channel)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateChannelSidebarCategory provides a mock function with given fields: userID, teamID, newCategory
func (_m *API) CreateChannelSidebarCategory(userID string, teamID string, newCategory *model.SidebarCategoryWithChannels) (*model.SidebarCategoryWithChannels, *model.AppError) {
	ret := _m.Called(userID, teamID, newCategory)

	var r0 *model.SidebarCategoryWithChannels
	if rf, ok := ret.Get(0).(func(string, string, *model.SidebarCategoryWithChannels) *model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, newCategory)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.SidebarCategoryWithChannels)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, *model.SidebarCategoryWithChannels) *model.AppError); ok {
		r1 = rf(userID, teamID, newCategory)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateCommand provides a mock function with given fields: cmd
func (_m *API) CreateCommand(cmd *model.Command) (*model.Command, error) {
	ret := _m.Called(cmd)

	var r0 *model.Command
	if rf, ok := ret.Get(0).(func(*model.Command) *model.Command); ok {
		r0 = rf(cmd)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.Command) error); ok {
		r1 = rf(cmd)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateOAuthApp provides a mock function with given fields: app
func (_m *API) CreateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	ret := _m.Called(app)

	var r0 *model.OAuthApp
	if rf, ok := ret.Get(0).(func(*model.OAuthApp) *model.OAuthApp); ok {
		r0 = rf(app)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OAuthApp)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.OAuthApp) *model.AppError); ok {
		r1 = rf(app)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreatePost provides a mock function with given fields: post
func (_m *API) CreatePost(post *model.Post) (*model.Post, *model.AppError) {
	ret := _m.Called(post)

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(*model.Post) *model.Post); ok {
		r0 = rf(post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Post) *model.AppError); ok {
		r1 = rf(post)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateSession provides a mock function with given fields: session
func (_m *API) CreateSession(session *model.Session) (*model.Session, *model.AppError) {
	ret := _m.Called(session)

	var r0 *model.Session
	if rf, ok := ret.Get(0).(func(*model.Session) *model.Session); ok {
		r0 = rf(session)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Session)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Session) *model.AppError); ok {
		r1 = rf(session)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeam provides a mock function with given fields: team
func (_m *API) CreateTeam(team *model.Team) (*model.Team, *model.AppError) {
	ret := _m.Called(team)

	var r0 *model.Team
	if rf, ok := ret.Get(0).(func(*model.Team) *model.Team); ok {
		r0 = rf(team)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Team) *model.AppError); ok {
		r1 = rf(team)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeamMember provides a mock function with given fields: teamID, userID
func (_m *API) CreateTeamMember(teamID string, userID string) (*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userID)

	var r0 *model.TeamMember
	if rf, ok := ret.Get(0).(func(string, string) *model.TeamMember); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(teamID, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeamMembers provides a mock function with given fields: teamID, userIds, requestorId
func (_m *API) CreateTeamMembers(teamID string, userIds []string, requestorId string) ([]*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userIds, requestorId)

	var r0 []*model.TeamMember
	if rf, ok := ret.Get(0).(func(string, []string, string) []*model.TeamMember); ok {
		r0 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []string, string) *model.AppError); ok {
		r1 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateTeamMembersGracefully provides a mock function with given fields: teamID, userIds, requestorId
func (_m *API) CreateTeamMembersGracefully(teamID string, userIds []string, requestorId string) ([]*model.TeamMemberWithError, *model.AppError) {
	ret := _m.Called(teamID, userIds, requestorId)

	var r0 []*model.TeamMemberWithError
	if rf, ok := ret.Get(0).(func(string, []string, string) []*model.TeamMemberWithError); ok {
		r0 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMemberWithError)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []string, string) *model.AppError); ok {
		r1 = rf(teamID, userIds, requestorId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateUser provides a mock function with given fields: user
func (_m *API) CreateUser(user *model.User) (*model.User, *model.AppError) {
	ret := _m.Called(user)

	var r0 *model.User
	if rf, ok := ret.Get(0).(func(*model.User) *model.User); ok {
		r0 = rf(user)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.User) *model.AppError); ok {
		r1 = rf(user)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// CreateUserAccessToken provides a mock function with given fields: token
func (_m *API) CreateUserAccessToken(token *model.UserAccessToken) (*model.UserAccessToken, *model.AppError) {
	ret := _m.Called(token)

	var r0 *model.UserAccessToken
	if rf, ok := ret.Get(0).(func(*model.UserAccessToken) *model.UserAccessToken); ok {
		r0 = rf(token)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UserAccessToken)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.UserAccessToken) *model.AppError); ok {
		r1 = rf(token)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// DeleteChannel provides a mock function with given fields: channelId
func (_m *API) DeleteChannel(channelId string) *model.AppError {
	ret := _m.Called(channelId)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(channelId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteChannelMember provides a mock function with given fields: channelId, userID
func (_m *API) DeleteChannelMember(channelId string, userID string) *model.AppError {
	ret := _m.Called(channelId, userID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string) *model.AppError); ok {
		r0 = rf(channelId, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteCommand provides a mock function with given fields: commandID
func (_m *API) DeleteCommand(commandID string) error {
	ret := _m.Called(commandID)

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(commandID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteEphemeralPost provides a mock function with given fields: userID, postId
func (_m *API) DeleteEphemeralPost(userID string, postId string) {
	_m.Called(userID, postId)
}

// DeleteOAuthApp provides a mock function with given fields: appID
func (_m *API) DeleteOAuthApp(appID string) *model.AppError {
	ret := _m.Called(appID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(appID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeletePost provides a mock function with given fields: postId
func (_m *API) DeletePost(postId string) *model.AppError {
	ret := _m.Called(postId)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeletePreferencesForUser provides a mock function with given fields: userID, preferences
func (_m *API) DeletePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	ret := _m.Called(userID, preferences)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []model.Preference) *model.AppError); ok {
		r0 = rf(userID, preferences)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteTeam provides a mock function with given fields: teamID
func (_m *API) DeleteTeam(teamID string) *model.AppError {
	ret := _m.Called(teamID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteTeamMember provides a mock function with given fields: teamID, userID, requestorId
func (_m *API) DeleteTeamMember(teamID string, userID string, requestorId string) *model.AppError {
	ret := _m.Called(teamID, userID, requestorId)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) *model.AppError); ok {
		r0 = rf(teamID, userID, requestorId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DeleteUser provides a mock function with given fields: userID
func (_m *API) DeleteUser(userID string) *model.AppError {
	ret := _m.Called(userID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// DisablePlugin provides a mock function with given fields: id
func (_m *API) DisablePlugin(id string) *model.AppError {
	ret := _m.Called(id)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// EnablePlugin provides a mock function with given fields: id
func (_m *API) EnablePlugin(id string) *model.AppError {
	ret := _m.Called(id)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// ExecuteSlashCommand provides a mock function with given fields: commandArgs
func (_m *API) ExecuteSlashCommand(commandArgs *model.CommandArgs) (*model.CommandResponse, error) {
	ret := _m.Called(commandArgs)

	var r0 *model.CommandResponse
	if rf, ok := ret.Get(0).(func(*model.CommandArgs) *model.CommandResponse); ok {
		r0 = rf(commandArgs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.CommandResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*model.CommandArgs) error); ok {
		r1 = rf(commandArgs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ExtendSessionExpiry provides a mock function with given fields: sessionID, newExpiry
func (_m *API) ExtendSessionExpiry(sessionID string, newExpiry int64) *model.AppError {
	ret := _m.Called(sessionID, newExpiry)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int64) *model.AppError); ok {
		r0 = rf(sessionID, newExpiry)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// GetBot provides a mock function with given fields: botUserId, includeDeleted
func (_m *API) GetBot(botUserId string, includeDeleted bool) (*model.Bot, *model.AppError) {
	ret := _m.Called(botUserId, includeDeleted)

	var r0 *model.Bot
	if rf, ok := ret.Get(0).(func(string, bool) *model.Bot); ok {
		r0 = rf(botUserId, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, bool) *model.AppError); ok {
		r1 = rf(botUserId, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetBots provides a mock function with given fields: options
func (_m *API) GetBots(options *model.BotGetOptions) ([]*model.Bot, *model.AppError) {
	ret := _m.Called(options)

	var r0 []*model.Bot
	if rf, ok := ret.Get(0).(func(*model.BotGetOptions) []*model.Bot); ok {
		r0 = rf(options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Bot)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.BotGetOptions) *model.AppError); ok {
		r1 = rf(options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetBundlePath provides a mock function with given fields:
func (_m *API) GetBundlePath() (string, error) {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannel provides a mock function with given fields: channelId
func (_m *API) GetChannel(channelId string) (*model.Channel, *model.AppError) {
	ret := _m.Called(channelId)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string) *model.Channel); ok {
		r0 = rf(channelId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(channelId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelByName provides a mock function with given fields: teamID, name, includeDeleted
func (_m *API) GetChannelByName(teamID string, name string, includeDeleted bool) (*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, name, includeDeleted)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(teamID, name, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, bool) *model.AppError); ok {
		r1 = rf(teamID, name, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelByNameForTeamName provides a mock function with given fields: teamName, channelName, includeDeleted
func (_m *API) GetChannelByNameForTeamName(teamName string, channelName string, includeDeleted bool) (*model.Channel, *model.AppError) {
	ret := _m.Called(teamName, channelName, includeDeleted)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, string, bool) *model.Channel); ok {
		r0 = rf(teamName, channelName, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, bool) *model.AppError); ok {
		r1 = rf(teamName, channelName, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMember provides a mock function with given fields: channelId, userID
func (_m *API) GetChannelMember(channelId string, userID string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(channelId, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMembers provides a mock function with given fields: channelId, page, perPage
func (_m *API) GetChannelMembers(channelId string, page int, perPage int) (model.ChannelMembers, *model.AppError) {
	ret := _m.Called(channelId, page, perPage)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func(string, int, int) model.ChannelMembers); ok {
		r0 = rf(channelId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(channelId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMembersByIds provides a mock function with given fields: channelId, userIds
func (_m *API) GetChannelMembersByIds(channelId string, userIds []string) (model.ChannelMembers, *model.AppError) {
	ret := _m.Called(channelId, userIds)

	var r0 model.ChannelMembers
	if rf, ok := ret.Get(0).(func(string, []string) model.ChannelMembers); ok {
		r0 = rf(channelId, userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ChannelMembers)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(channelId, userIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelMembersForUser provides a mock function with given fields: teamID, userID, page, perPage
func (_m *API) GetChannelMembersForUser(teamID string, userID string, page int, perPage int) ([]*model.ChannelMember, *model.AppError) {
	ret := _m.Called(teamID, userID, page, perPage)

	var r0 []*model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string, int, int) []*model.ChannelMember); ok {
		r0 = rf(teamID, userID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.ChannelMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(teamID, userID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelSidebarCategories provides a mock function with given fields: userID, teamID
func (_m *API) GetChannelSidebarCategories(userID string, teamID string) (*model.OrderedSidebarCategories, *model.AppError) {
	ret := _m.Called(userID, teamID)

	var r0 *model.OrderedSidebarCategories
	if rf, ok := ret.Get(0).(func(string, string) *model.OrderedSidebarCategories); ok {
		r0 = rf(userID, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OrderedSidebarCategories)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userID, teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelStats provides a mock function with given fields: channelId
func (_m *API) GetChannelStats(channelId string) (*model.ChannelStats, *model.AppError) {
	ret := _m.Called(channelId)

	var r0 *model.ChannelStats
	if rf, ok := ret.Get(0).(func(string) *model.ChannelStats); ok {
		r0 = rf(channelId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelStats)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(channelId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetChannelsForTeamForUser provides a mock function with given fields: teamID, userID, includeDeleted
func (_m *API) GetChannelsForTeamForUser(teamID string, userID string, includeDeleted bool) ([]*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, userID, includeDeleted)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func(string, string, bool) []*model.Channel); ok {
		r0 = rf(teamID, userID, includeDeleted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, bool) *model.AppError); ok {
		r1 = rf(teamID, userID, includeDeleted)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetCommand provides a mock function with given fields: commandID
func (_m *API) GetCommand(commandID string) (*model.Command, error) {
	ret := _m.Called(commandID)

	var r0 *model.Command
	if rf, ok := ret.Get(0).(func(string) *model.Command); ok {
		r0 = rf(commandID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(commandID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetConfig provides a mock function with given fields:
func (_m *API) GetConfig() *model.Config {
	ret := _m.Called()

	var r0 *model.Config
	if rf, ok := ret.Get(0).(func() *model.Config); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Config)
		}
	}

	return r0
}

// GetDiagnosticId provides a mock function with given fields:
func (_m *API) GetDiagnosticId() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetDirectChannel provides a mock function with given fields: userId1, userId2
func (_m *API) GetDirectChannel(userId1 string, userId2 string) (*model.Channel, *model.AppError) {
	ret := _m.Called(userId1, userId2)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(string, string) *model.Channel); ok {
		r0 = rf(userId1, userId2)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userId1, userId2)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetEmoji provides a mock function with given fields: emojiId
func (_m *API) GetEmoji(emojiId string) (*model.Emoji, *model.AppError) {
	ret := _m.Called(emojiId)

	var r0 *model.Emoji
	if rf, ok := ret.Get(0).(func(string) *model.Emoji); ok {
		r0 = rf(emojiId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Emoji)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(emojiId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetEmojiByName provides a mock function with given fields: name
func (_m *API) GetEmojiByName(name string) (*model.Emoji, *model.AppError) {
	ret := _m.Called(name)

	var r0 *model.Emoji
	if rf, ok := ret.Get(0).(func(string) *model.Emoji); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Emoji)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetEmojiImage provides a mock function with given fields: emojiId
func (_m *API) GetEmojiImage(emojiId string) ([]byte, string, *model.AppError) {
	ret := _m.Called(emojiId)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(emojiId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 string
	if rf, ok := ret.Get(1).(func(string) string); ok {
		r1 = rf(emojiId)
	} else {
		r1 = ret.Get(1).(string)
	}

	var r2 *model.AppError
	if rf, ok := ret.Get(2).(func(string) *model.AppError); ok {
		r2 = rf(emojiId)
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).(*model.AppError)
		}
	}

	return r0, r1, r2
}

// GetEmojiList provides a mock function with given fields: sortBy, page, perPage
func (_m *API) GetEmojiList(sortBy string, page int, perPage int) ([]*model.Emoji, *model.AppError) {
	ret := _m.Called(sortBy, page, perPage)

	var r0 []*model.Emoji
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.Emoji); ok {
		r0 = rf(sortBy, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Emoji)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(sortBy, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFile provides a mock function with given fields: fileId
func (_m *API) GetFile(fileId string) ([]byte, *model.AppError) {
	ret := _m.Called(fileId)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(fileId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(fileId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFileInfo provides a mock function with given fields: fileId
func (_m *API) GetFileInfo(fileId string) (*model.FileInfo, *model.AppError) {
	ret := _m.Called(fileId)

	var r0 *model.FileInfo
	if rf, ok := ret.Get(0).(func(string) *model.FileInfo); ok {
		r0 = rf(fileId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.FileInfo)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(fileId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFileInfos provides a mock function with given fields: page, perPage, opt
func (_m *API) GetFileInfos(page int, perPage int, opt *model.GetFileInfosOptions) ([]*model.FileInfo, *model.AppError) {
	ret := _m.Called(page, perPage, opt)

	var r0 []*model.FileInfo
	if rf, ok := ret.Get(0).(func(int, int, *model.GetFileInfosOptions) []*model.FileInfo); ok {
		r0 = rf(page, perPage, opt)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.FileInfo)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(int, int, *model.GetFileInfosOptions) *model.AppError); ok {
		r1 = rf(page, perPage, opt)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetFileLink provides a mock function with given fields: fileId
func (_m *API) GetFileLink(fileId string) (string, *model.AppError) {
	ret := _m.Called(fileId)

	var r0 string
	if rf, ok := ret.Get(0).(func(string) string); ok {
		r0 = rf(fileId)
	} else {
		r0 = ret.Get(0).(string)
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(fileId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroup provides a mock function with given fields: groupId
func (_m *API) GetGroup(groupId string) (*model.Group, *model.AppError) {
	ret := _m.Called(groupId)

	var r0 *model.Group
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(groupId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(groupId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupByName provides a mock function with given fields: name
func (_m *API) GetGroupByName(name string) (*model.Group, *model.AppError) {
	ret := _m.Called(name)

	var r0 *model.Group
	if rf, ok := ret.Get(0).(func(string) *model.Group); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Group)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupChannel provides a mock function with given fields: userIds
func (_m *API) GetGroupChannel(userIds []string) (*model.Channel, *model.AppError) {
	ret := _m.Called(userIds)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func([]string) *model.Channel); ok {
		r0 = rf(userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(userIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupMemberUsers provides a mock function with given fields: groupID, page, perPage
func (_m *API) GetGroupMemberUsers(groupID string, page int, perPage int) ([]*model.User, *model.AppError) {
	ret := _m.Called(groupID, page, perPage)

	var r0 []*model.User
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.User); ok {
		r0 = rf(groupID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(groupID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupsBySource provides a mock function with given fields: groupSource
func (_m *API) GetGroupsBySource(groupSource model.GroupSource) ([]*model.Group, *model.AppError) {
	ret := _m.Called(groupSource)

	var r0 []*model.Group
	if rf, ok := ret.Get(0).(func(model.GroupSource) []*model.Group); ok {
		r0 = rf(groupSource)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(model.GroupSource) *model.AppError); ok {
		r1 = rf(groupSource)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetGroupsForUser provides a mock function with given fields: userID
func (_m *API) GetGroupsForUser(userID string) ([]*model.Group, *model.AppError) {
	ret := _m.Called(userID)

	var r0 []*model.Group
	if rf, ok := ret.Get(0).(func(string) []*model.Group); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Group)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetLDAPUserAttributes provides a mock function with given fields: userID, attributes
func (_m *API) GetLDAPUserAttributes(userID string, attributes []string) (map[string]string, *model.AppError) {
	ret := _m.Called(userID, attributes)

	var r0 map[string]string
	if rf, ok := ret.Get(0).(func(string, []string) map[string]string); ok {
		r0 = rf(userID, attributes)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]string)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []string) *model.AppError); ok {
		r1 = rf(userID, attributes)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetLicense provides a mock function with given fields:
func (_m *API) GetLicense() *model.License {
	ret := _m.Called()

	var r0 *model.License
	if rf, ok := ret.Get(0).(func() *model.License); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.License)
		}
	}

	return r0
}

// GetOAuthApp provides a mock function with given fields: appID
func (_m *API) GetOAuthApp(appID string) (*model.OAuthApp, *model.AppError) {
	ret := _m.Called(appID)

	var r0 *model.OAuthApp
	if rf, ok := ret.Get(0).(func(string) *model.OAuthApp); ok {
		r0 = rf(appID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OAuthApp)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(appID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPluginConfig provides a mock function with given fields:
func (_m *API) GetPluginConfig() map[string]interface{} {
	ret := _m.Called()

	var r0 map[string]interface{}
	if rf, ok := ret.Get(0).(func() map[string]interface{}); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]interface{})
		}
	}

	return r0
}

// GetPluginStatus provides a mock function with given fields: id
func (_m *API) GetPluginStatus(id string) (*model.PluginStatus, *model.AppError) {
	ret := _m.Called(id)

	var r0 *model.PluginStatus
	if rf, ok := ret.Get(0).(func(string) *model.PluginStatus); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PluginStatus)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(id)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPlugins provides a mock function with given fields:
func (_m *API) GetPlugins() ([]*model.Manifest, *model.AppError) {
	ret := _m.Called()

	var r0 []*model.Manifest
	if rf, ok := ret.Get(0).(func() []*model.Manifest); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Manifest)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func() *model.AppError); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPost provides a mock function with given fields: postId
func (_m *API) GetPost(postId string) (*model.Post, *model.AppError) {
	ret := _m.Called(postId)

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(string) *model.Post); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(postId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostThread provides a mock function with given fields: postId
func (_m *API) GetPostThread(postId string) (*model.PostList, *model.AppError) {
	ret := _m.Called(postId)

	var r0 *model.PostList
	if rf, ok := ret.Get(0).(func(string) *model.PostList); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(postId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsAfter provides a mock function with given fields: channelId, postId, page, perPage
func (_m *API) GetPostsAfter(channelId string, postId string, page int, perPage int) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, postId, page, perPage)

	var r0 *model.PostList
	if rf, ok := ret.Get(0).(func(string, string, int, int) *model.PostList); ok {
		r0 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsBefore provides a mock function with given fields: channelId, postId, page, perPage
func (_m *API) GetPostsBefore(channelId string, postId string, page int, perPage int) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, postId, page, perPage)

	var r0 *model.PostList
	if rf, ok := ret.Get(0).(func(string, string, int, int) *model.PostList); ok {
		r0 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(channelId, postId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsForChannel provides a mock function with given fields: channelId, page, perPage
func (_m *API) GetPostsForChannel(channelId string, page int, perPage int) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, page, perPage)

	var r0 *model.PostList
	if rf, ok := ret.Get(0).(func(string, int, int) *model.PostList); ok {
		r0 = rf(channelId, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(channelId, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPostsSince provides a mock function with given fields: channelId, time
func (_m *API) GetPostsSince(channelId string, time int64) (*model.PostList, *model.AppError) {
	ret := _m.Called(channelId, time)

	var r0 *model.PostList
	if rf, ok := ret.Get(0).(func(string, int64) *model.PostList); ok {
		r0 = rf(channelId, time)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostList)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int64) *model.AppError); ok {
		r1 = rf(channelId, time)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPreferencesForUser provides a mock function with given fields: userID
func (_m *API) GetPreferencesForUser(userID string) ([]model.Preference, *model.AppError) {
	ret := _m.Called(userID)

	var r0 []model.Preference
	if rf, ok := ret.Get(0).(func(string) []model.Preference); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.Preference)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetProfileImage provides a mock function with given fields: userID
func (_m *API) GetProfileImage(userID string) ([]byte, *model.AppError) {
	ret := _m.Called(userID)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetPublicChannelsForTeam provides a mock function with given fields: teamID, page, perPage
func (_m *API) GetPublicChannelsForTeam(teamID string, page int, perPage int) ([]*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, page, perPage)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.Channel); ok {
		r0 = rf(teamID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(teamID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetReactions provides a mock function with given fields: postId
func (_m *API) GetReactions(postId string) ([]*model.Reaction, *model.AppError) {
	ret := _m.Called(postId)

	var r0 []*model.Reaction
	if rf, ok := ret.Get(0).(func(string) []*model.Reaction); ok {
		r0 = rf(postId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Reaction)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(postId)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetServerVersion provides a mock function with given fields:
func (_m *API) GetServerVersion() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetSession provides a mock function with given fields: sessionID
func (_m *API) GetSession(sessionID string) (*model.Session, *model.AppError) {
	ret := _m.Called(sessionID)

	var r0 *model.Session
	if rf, ok := ret.Get(0).(func(string) *model.Session); ok {
		r0 = rf(sessionID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Session)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(sessionID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetSystemInstallDate provides a mock function with given fields:
func (_m *API) GetSystemInstallDate() (int64, *model.AppError) {
	ret := _m.Called()

	var r0 int64
	if rf, ok := ret.Get(0).(func() int64); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(int64)
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func() *model.AppError); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeam provides a mock function with given fields: teamID
func (_m *API) GetTeam(teamID string) (*model.Team, *model.AppError) {
	ret := _m.Called(teamID)

	var r0 *model.Team
	if rf, ok := ret.Get(0).(func(string) *model.Team); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamByName provides a mock function with given fields: name
func (_m *API) GetTeamByName(name string) (*model.Team, *model.AppError) {
	ret := _m.Called(name)

	var r0 *model.Team
	if rf, ok := ret.Get(0).(func(string) *model.Team); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamIcon provides a mock function with given fields: teamID
func (_m *API) GetTeamIcon(teamID string) ([]byte, *model.AppError) {
	ret := _m.Called(teamID)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamMember provides a mock function with given fields: teamID, userID
func (_m *API) GetTeamMember(teamID string, userID string) (*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userID)

	var r0 *model.TeamMember
	if rf, ok := ret.Get(0).(func(string, string) *model.TeamMember); ok {
		r0 = rf(teamID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(teamID, userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamMembers provides a mock function with given fields: teamID, page, perPage
func (_m *API) GetTeamMembers(teamID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, page, perPage)

	var r0 []*model.TeamMember
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.TeamMember); ok {
		r0 = rf(teamID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(teamID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamMembersForUser provides a mock function with given fields: userID, page, perPage
func (_m *API) GetTeamMembersForUser(userID string, page int, perPage int) ([]*model.TeamMember, *model.AppError) {
	ret := _m.Called(userID, page, perPage)

	var r0 []*model.TeamMember
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.TeamMember); ok {
		r0 = rf(userID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(userID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamStats provides a mock function with given fields: teamID
func (_m *API) GetTeamStats(teamID string) (*model.TeamStats, *model.AppError) {
	ret := _m.Called(teamID)

	var r0 *model.TeamStats
	if rf, ok := ret.Get(0).(func(string) *model.TeamStats); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamStats)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(teamID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeams provides a mock function with given fields:
func (_m *API) GetTeams() ([]*model.Team, *model.AppError) {
	ret := _m.Called()

	var r0 []*model.Team
	if rf, ok := ret.Get(0).(func() []*model.Team); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func() *model.AppError); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamsForUser provides a mock function with given fields: userID
func (_m *API) GetTeamsForUser(userID string) ([]*model.Team, *model.AppError) {
	ret := _m.Called(userID)

	var r0 []*model.Team
	if rf, ok := ret.Get(0).(func(string) []*model.Team); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTeamsUnreadForUser provides a mock function with given fields: userID
func (_m *API) GetTeamsUnreadForUser(userID string) ([]*model.TeamUnread, *model.AppError) {
	ret := _m.Called(userID)

	var r0 []*model.TeamUnread
	if rf, ok := ret.Get(0).(func(string) []*model.TeamUnread); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.TeamUnread)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetTelemetryId provides a mock function with given fields:
func (_m *API) GetTelemetryId() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// GetUnsanitizedConfig provides a mock function with given fields:
func (_m *API) GetUnsanitizedConfig() *model.Config {
	ret := _m.Called()

	var r0 *model.Config
	if rf, ok := ret.Get(0).(func() *model.Config); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Config)
		}
	}

	return r0
}

// GetUser provides a mock function with given fields: userID
func (_m *API) GetUser(userID string) (*model.User, *model.AppError) {
	ret := _m.Called(userID)

	var r0 *model.User
	if rf, ok := ret.Get(0).(func(string) *model.User); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserByEmail provides a mock function with given fields: email
func (_m *API) GetUserByEmail(email string) (*model.User, *model.AppError) {
	ret := _m.Called(email)

	var r0 *model.User
	if rf, ok := ret.Get(0).(func(string) *model.User); ok {
		r0 = rf(email)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(email)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserByUsername provides a mock function with given fields: name
func (_m *API) GetUserByUsername(name string) (*model.User, *model.AppError) {
	ret := _m.Called(name)

	var r0 *model.User
	if rf, ok := ret.Get(0).(func(string) *model.User); ok {
		r0 = rf(name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(name)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserStatus provides a mock function with given fields: userID
func (_m *API) GetUserStatus(userID string) (*model.Status, *model.AppError) {
	ret := _m.Called(userID)

	var r0 *model.Status
	if rf, ok := ret.Get(0).(func(string) *model.Status); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Status)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(userID)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUserStatusesByIds provides a mock function with given fields: userIds
func (_m *API) GetUserStatusesByIds(userIds []string) ([]*model.Status, *model.AppError) {
	ret := _m.Called(userIds)

	var r0 []*model.Status
	if rf, ok := ret.Get(0).(func([]string) []*model.Status); ok {
		r0 = rf(userIds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Status)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(userIds)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsers provides a mock function with given fields: options
func (_m *API) GetUsers(options *model.UserGetOptions) ([]*model.User, *model.AppError) {
	ret := _m.Called(options)

	var r0 []*model.User
	if rf, ok := ret.Get(0).(func(*model.UserGetOptions) []*model.User); ok {
		r0 = rf(options)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.UserGetOptions) *model.AppError); ok {
		r1 = rf(options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersByUsernames provides a mock function with given fields: usernames
func (_m *API) GetUsersByUsernames(usernames []string) ([]*model.User, *model.AppError) {
	ret := _m.Called(usernames)

	var r0 []*model.User
	if rf, ok := ret.Get(0).(func([]string) []*model.User); ok {
		r0 = rf(usernames)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func([]string) *model.AppError); ok {
		r1 = rf(usernames)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersInChannel provides a mock function with given fields: channelID, sortBy, page, perPage
func (_m *API) GetUsersInChannel(channelID string, sortBy string, page int, perPage int) ([]*model.User, *model.AppError) {
	ret := _m.Called(channelID, sortBy, page, perPage)

	var r0 []*model.User
	if rf, ok := ret.Get(0).(func(string, string, int, int) []*model.User); ok {
		r0 = rf(channelID, sortBy, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, int, int) *model.AppError); ok {
		r1 = rf(channelID, sortBy, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// GetUsersInTeam provides a mock function with given fields: teamID, page, perPage
func (_m *API) GetUsersInTeam(teamID string, page int, perPage int) ([]*model.User, *model.AppError) {
	ret := _m.Called(teamID, page, perPage)

	var r0 []*model.User
	if rf, ok := ret.Get(0).(func(string, int, int) []*model.User); ok {
		r0 = rf(teamID, page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int, int) *model.AppError); ok {
		r1 = rf(teamID, page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// HasPermissionTo provides a mock function with given fields: userID, permission
func (_m *API) HasPermissionTo(userID string, permission *model.Permission) bool {
	ret := _m.Called(userID, permission)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, *model.Permission) bool); ok {
		r0 = rf(userID, permission)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasPermissionToChannel provides a mock function with given fields: userID, channelId, permission
func (_m *API) HasPermissionToChannel(userID string, channelId string, permission *model.Permission) bool {
	ret := _m.Called(userID, channelId, permission)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, string, *model.Permission) bool); ok {
		r0 = rf(userID, channelId, permission)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// HasPermissionToTeam provides a mock function with given fields: userID, teamID, permission
func (_m *API) HasPermissionToTeam(userID string, teamID string, permission *model.Permission) bool {
	ret := _m.Called(userID, teamID, permission)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, string, *model.Permission) bool); ok {
		r0 = rf(userID, teamID, permission)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// InstallPlugin provides a mock function with given fields: file, replace
func (_m *API) InstallPlugin(file io.Reader, replace bool) (*model.Manifest, *model.AppError) {
	ret := _m.Called(file, replace)

	var r0 *model.Manifest
	if rf, ok := ret.Get(0).(func(io.Reader, bool) *model.Manifest); ok {
		r0 = rf(file, replace)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Manifest)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(io.Reader, bool) *model.AppError); ok {
		r1 = rf(file, replace)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// IsEnterpriseReady provides a mock function with given fields:
func (_m *API) IsEnterpriseReady() bool {
	ret := _m.Called()

	var r0 bool
	if rf, ok := ret.Get(0).(func() bool); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// KVCompareAndDelete provides a mock function with given fields: key, oldValue
func (_m *API) KVCompareAndDelete(key string, oldValue []byte) (bool, *model.AppError) {
	ret := _m.Called(key, oldValue)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, []byte) bool); ok {
		r0 = rf(key, oldValue)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []byte) *model.AppError); ok {
		r1 = rf(key, oldValue)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVCompareAndSet provides a mock function with given fields: key, oldValue, newValue
func (_m *API) KVCompareAndSet(key string, oldValue []byte, newValue []byte) (bool, *model.AppError) {
	ret := _m.Called(key, oldValue, newValue)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, []byte, []byte) bool); ok {
		r0 = rf(key, oldValue, newValue)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []byte, []byte) *model.AppError); ok {
		r1 = rf(key, oldValue, newValue)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVDelete provides a mock function with given fields: key
func (_m *API) KVDelete(key string) *model.AppError {
	ret := _m.Called(key)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVDeleteAll provides a mock function with given fields:
func (_m *API) KVDeleteAll() *model.AppError {
	ret := _m.Called()

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func() *model.AppError); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVGet provides a mock function with given fields: key
func (_m *API) KVGet(key string) ([]byte, *model.AppError) {
	ret := _m.Called(key)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(key)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVList provides a mock function with given fields: page, perPage
func (_m *API) KVList(page int, perPage int) ([]string, *model.AppError) {
	ret := _m.Called(page, perPage)

	var r0 []string
	if rf, ok := ret.Get(0).(func(int, int) []string); ok {
		r0 = rf(page, perPage)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(int, int) *model.AppError); ok {
		r1 = rf(page, perPage)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// KVSet provides a mock function with given fields: key, value
func (_m *API) KVSet(key string, value []byte) *model.AppError {
	ret := _m.Called(key, value)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) *model.AppError); ok {
		r0 = rf(key, value)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVSetWithExpiry provides a mock function with given fields: key, value, expireInSeconds
func (_m *API) KVSetWithExpiry(key string, value []byte, expireInSeconds int64) *model.AppError {
	ret := _m.Called(key, value, expireInSeconds)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte, int64) *model.AppError); ok {
		r0 = rf(key, value, expireInSeconds)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// KVSetWithOptions provides a mock function with given fields: key, value, options
func (_m *API) KVSetWithOptions(key string, value []byte, options model.PluginKVSetOptions) (bool, *model.AppError) {
	ret := _m.Called(key, value, options)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string, []byte, model.PluginKVSetOptions) bool); ok {
		r0 = rf(key, value, options)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []byte, model.PluginKVSetOptions) *model.AppError); ok {
		r1 = rf(key, value, options)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// ListBuiltInCommands provides a mock function with given fields:
func (_m *API) ListBuiltInCommands() ([]*model.Command, error) {
	ret := _m.Called()

	var r0 []*model.Command
	if rf, ok := ret.Get(0).(func() []*model.Command); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommands provides a mock function with given fields: teamID
func (_m *API) ListCommands(teamID string) ([]*model.Command, error) {
	ret := _m.Called(teamID)

	var r0 []*model.Command
	if rf, ok := ret.Get(0).(func(string) []*model.Command); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCustomCommands provides a mock function with given fields: teamID
func (_m *API) ListCustomCommands(teamID string) ([]*model.Command, error) {
	ret := _m.Called(teamID)

	var r0 []*model.Command
	if rf, ok := ret.Get(0).(func(string) []*model.Command); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListPluginCommands provides a mock function with given fields: teamID
func (_m *API) ListPluginCommands(teamID string) ([]*model.Command, error) {
	ret := _m.Called(teamID)

	var r0 []*model.Command
	if rf, ok := ret.Get(0).(func(string) []*model.Command); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// LoadPluginConfiguration provides a mock function with given fields: dest
func (_m *API) LoadPluginConfiguration(dest interface{}) error {
	ret := _m.Called(dest)

	var r0 error
	if rf, ok := ret.Get(0).(func(interface{}) error); ok {
		r0 = rf(dest)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// LogDebug provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogDebug(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// LogError provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogError(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// LogInfo provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogInfo(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// LogWarn provides a mock function with given fields: msg, keyValuePairs
func (_m *API) LogWarn(msg string, keyValuePairs ...interface{}) {
	var _ca []interface{}
	_ca = append(_ca, msg)
	_ca = append(_ca, keyValuePairs...)
	_m.Called(_ca...)
}

// OpenInteractiveDialog provides a mock function with given fields: dialog
func (_m *API) OpenInteractiveDialog(dialog model.OpenDialogRequest) *model.AppError {
	ret := _m.Called(dialog)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(model.OpenDialogRequest) *model.AppError); ok {
		r0 = rf(dialog)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PatchBot provides a mock function with given fields: botUserId, botPatch
func (_m *API) PatchBot(botUserId string, botPatch *model.BotPatch) (*model.Bot, *model.AppError) {
	ret := _m.Called(botUserId, botPatch)

	var r0 *model.Bot
	if rf, ok := ret.Get(0).(func(string, *model.BotPatch) *model.Bot); ok {
		r0 = rf(botUserId, botPatch)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, *model.BotPatch) *model.AppError); ok {
		r1 = rf(botUserId, botPatch)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// PermanentDeleteBot provides a mock function with given fields: botUserId
func (_m *API) PermanentDeleteBot(botUserId string) *model.AppError {
	ret := _m.Called(botUserId)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(botUserId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PluginHTTP provides a mock function with given fields: request
func (_m *API) PluginHTTP(request *http.Request) *http.Response {
	ret := _m.Called(request)

	var r0 *http.Response
	if rf, ok := ret.Get(0).(func(*http.Request) *http.Response); ok {
		r0 = rf(request)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*http.Response)
		}
	}

	return r0
}

// PublishPluginClusterEvent provides a mock function with given fields: ev, opts
func (_m *API) PublishPluginClusterEvent(ev model.PluginClusterEvent, opts model.PluginClusterEventSendOptions) error {
	ret := _m.Called(ev, opts)

	var r0 error
	if rf, ok := ret.Get(0).(func(model.PluginClusterEvent, model.PluginClusterEventSendOptions) error); ok {
		r0 = rf(ev, opts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PublishUserTyping provides a mock function with given fields: userID, channelId, parentId
func (_m *API) PublishUserTyping(userID string, channelId string, parentId string) *model.AppError {
	ret := _m.Called(userID, channelId, parentId)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) *model.AppError); ok {
		r0 = rf(userID, channelId, parentId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// PublishWebSocketEvent provides a mock function with given fields: event, payload, broadcast
func (_m *API) PublishWebSocketEvent(event string, payload map[string]interface{}, broadcast *model.WebsocketBroadcast) {
	_m.Called(event, payload, broadcast)
}

// ReadFile provides a mock function with given fields: path
func (_m *API) ReadFile(path string) ([]byte, *model.AppError) {
	ret := _m.Called(path)

	var r0 []byte
	if rf, ok := ret.Get(0).(func(string) []byte); ok {
		r0 = rf(path)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(path)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// RegisterCommand provides a mock function with given fields: command
func (_m *API) RegisterCommand(command *model.Command) error {
	ret := _m.Called(command)

	var r0 error
	if rf, ok := ret.Get(0).(func(*model.Command) error); ok {
		r0 = rf(command)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemovePlugin provides a mock function with given fields: id
func (_m *API) RemovePlugin(id string) *model.AppError {
	ret := _m.Called(id)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RemoveReaction provides a mock function with given fields: reaction
func (_m *API) RemoveReaction(reaction *model.Reaction) *model.AppError {
	ret := _m.Called(reaction)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Reaction) *model.AppError); ok {
		r0 = rf(reaction)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RemoveTeamIcon provides a mock function with given fields: teamID
func (_m *API) RemoveTeamIcon(teamID string) *model.AppError {
	ret := _m.Called(teamID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RemoveUserCustomStatus provides a mock function with given fields: userID
func (_m *API) RemoveUserCustomStatus(userID string) *model.AppError {
	ret := _m.Called(userID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RequestTrialLicense provides a mock function with given fields: requesterID, users, termsAccepted, receiveEmailsAccepted
func (_m *API) RequestTrialLicense(requesterID string, users int, termsAccepted bool, receiveEmailsAccepted bool) *model.AppError {
	ret := _m.Called(requesterID, users, termsAccepted, receiveEmailsAccepted)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, int, bool, bool) *model.AppError); ok {
		r0 = rf(requesterID, users, termsAccepted, receiveEmailsAccepted)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RevokeSession provides a mock function with given fields: sessionID
func (_m *API) RevokeSession(sessionID string) *model.AppError {
	ret := _m.Called(sessionID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(sessionID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RevokeUserAccessToken provides a mock function with given fields: tokenID
func (_m *API) RevokeUserAccessToken(tokenID string) *model.AppError {
	ret := _m.Called(tokenID)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string) *model.AppError); ok {
		r0 = rf(tokenID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// RolesGrantPermission provides a mock function with given fields: roleNames, permissionId
func (_m *API) RolesGrantPermission(roleNames []string, permissionId string) bool {
	ret := _m.Called(roleNames, permissionId)

	var r0 bool
	if rf, ok := ret.Get(0).(func([]string, string) bool); ok {
		r0 = rf(roleNames, permissionId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// SaveConfig provides a mock function with given fields: config
func (_m *API) SaveConfig(config *model.Config) *model.AppError {
	ret := _m.Called(config)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(*model.Config) *model.AppError); ok {
		r0 = rf(config)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SavePluginConfig provides a mock function with given fields: config
func (_m *API) SavePluginConfig(config map[string]interface{}) *model.AppError {
	ret := _m.Called(config)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(map[string]interface{}) *model.AppError); ok {
		r0 = rf(config)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SearchChannels provides a mock function with given fields: teamID, term
func (_m *API) SearchChannels(teamID string, term string) ([]*model.Channel, *model.AppError) {
	ret := _m.Called(teamID, term)

	var r0 []*model.Channel
	if rf, ok := ret.Get(0).(func(string, string) []*model.Channel); ok {
		r0 = rf(teamID, term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(teamID, term)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchPostsInTeam provides a mock function with given fields: teamID, paramsList
func (_m *API) SearchPostsInTeam(teamID string, paramsList []*model.SearchParams) ([]*model.Post, *model.AppError) {
	ret := _m.Called(teamID, paramsList)

	var r0 []*model.Post
	if rf, ok := ret.Get(0).(func(string, []*model.SearchParams) []*model.Post); ok {
		r0 = rf(teamID, paramsList)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Post)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, []*model.SearchParams) *model.AppError); ok {
		r1 = rf(teamID, paramsList)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchPostsInTeamForUser provides a mock function with given fields: teamID, userID, searchParams
func (_m *API) SearchPostsInTeamForUser(teamID string, userID string, searchParams model.SearchParameter) (*model.PostSearchResults, *model.AppError) {
	ret := _m.Called(teamID, userID, searchParams)

	var r0 *model.PostSearchResults
	if rf, ok := ret.Get(0).(func(string, string, model.SearchParameter) *model.PostSearchResults); ok {
		r0 = rf(teamID, userID, searchParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.PostSearchResults)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, model.SearchParameter) *model.AppError); ok {
		r1 = rf(teamID, userID, searchParams)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchTeams provides a mock function with given fields: term
func (_m *API) SearchTeams(term string) ([]*model.Team, *model.AppError) {
	ret := _m.Called(term)

	var r0 []*model.Team
	if rf, ok := ret.Get(0).(func(string) []*model.Team); ok {
		r0 = rf(term)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string) *model.AppError); ok {
		r1 = rf(term)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SearchUsers provides a mock function with given fields: search
func (_m *API) SearchUsers(search *model.UserSearch) ([]*model.User, *model.AppError) {
	ret := _m.Called(search)

	var r0 []*model.User
	if rf, ok := ret.Get(0).(func(*model.UserSearch) []*model.User); ok {
		r0 = rf(search)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.UserSearch) *model.AppError); ok {
		r1 = rf(search)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// SendEphemeralPost provides a mock function with given fields: userID, post
func (_m *API) SendEphemeralPost(userID string, post *model.Post) *model.Post {
	ret := _m.Called(userID, post)

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(string, *model.Post) *model.Post); ok {
		r0 = rf(userID, post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	return r0
}

// SendMail provides a mock function with given fields: to, subject, htmlBody
func (_m *API) SendMail(to string, subject string, htmlBody string) *model.AppError {
	ret := _m.Called(to, subject, htmlBody)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, string, string) *model.AppError); ok {
		r0 = rf(to, subject, htmlBody)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetProfileImage provides a mock function with given fields: userID, data
func (_m *API) SetProfileImage(userID string, data []byte) *model.AppError {
	ret := _m.Called(userID, data)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) *model.AppError); ok {
		r0 = rf(userID, data)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetTeamIcon provides a mock function with given fields: teamID, data
func (_m *API) SetTeamIcon(teamID string, data []byte) *model.AppError {
	ret := _m.Called(teamID, data)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []byte) *model.AppError); ok {
		r0 = rf(teamID, data)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// SetUserStatusTimedDND provides a mock function with given fields: userId, endtime
func (_m *API) SetUserStatusTimedDND(userId string, endtime int64) (*model.Status, *model.AppError) {
	ret := _m.Called(userId, endtime)

	var r0 *model.Status
	if rf, ok := ret.Get(0).(func(string, int64) *model.Status); ok {
		r0 = rf(userId, endtime)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Status)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, int64) *model.AppError); ok {
		r1 = rf(userId, endtime)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UnregisterCommand provides a mock function with given fields: teamID, trigger
func (_m *API) UnregisterCommand(teamID string, trigger string) error {
	ret := _m.Called(teamID, trigger)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(teamID, trigger)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateBotActive provides a mock function with given fields: botUserId, active
func (_m *API) UpdateBotActive(botUserId string, active bool) (*model.Bot, *model.AppError) {
	ret := _m.Called(botUserId, active)

	var r0 *model.Bot
	if rf, ok := ret.Get(0).(func(string, bool) *model.Bot); ok {
		r0 = rf(botUserId, active)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Bot)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, bool) *model.AppError); ok {
		r1 = rf(botUserId, active)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannel provides a mock function with given fields: channel
func (_m *API) UpdateChannel(channel *model.Channel) (*model.Channel, *model.AppError) {
	ret := _m.Called(channel)

	var r0 *model.Channel
	if rf, ok := ret.Get(0).(func(*model.Channel) *model.Channel); ok {
		r0 = rf(channel)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Channel)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Channel) *model.AppError); ok {
		r1 = rf(channel)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannelMemberNotifications provides a mock function with given fields: channelId, userID, notifications
func (_m *API) UpdateChannelMemberNotifications(channelId string, userID string, notifications map[string]string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID, notifications)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string, map[string]string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID, notifications)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, map[string]string) *model.AppError); ok {
		r1 = rf(channelId, userID, notifications)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannelMemberRoles provides a mock function with given fields: channelId, userID, newRoles
func (_m *API) UpdateChannelMemberRoles(channelId string, userID string, newRoles string) (*model.ChannelMember, *model.AppError) {
	ret := _m.Called(channelId, userID, newRoles)

	var r0 *model.ChannelMember
	if rf, ok := ret.Get(0).(func(string, string, string) *model.ChannelMember); ok {
		r0 = rf(channelId, userID, newRoles)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.ChannelMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(channelId, userID, newRoles)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateChannelSidebarCategories provides a mock function with given fields: userID, teamID, categories
func (_m *API) UpdateChannelSidebarCategories(userID string, teamID string, categories []*model.SidebarCategoryWithChannels) ([]*model.SidebarCategoryWithChannels, *model.AppError) {
	ret := _m.Called(userID, teamID, categories)

	var r0 []*model.SidebarCategoryWithChannels
	if rf, ok := ret.Get(0).(func(string, string, []*model.SidebarCategoryWithChannels) []*model.SidebarCategoryWithChannels); ok {
		r0 = rf(userID, teamID, categories)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.SidebarCategoryWithChannels)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, []*model.SidebarCategoryWithChannels) *model.AppError); ok {
		r1 = rf(userID, teamID, categories)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateCommand provides a mock function with given fields: commandID, updatedCmd
func (_m *API) UpdateCommand(commandID string, updatedCmd *model.Command) (*model.Command, error) {
	ret := _m.Called(commandID, updatedCmd)

	var r0 *model.Command
	if rf, ok := ret.Get(0).(func(string, *model.Command) *model.Command); ok {
		r0 = rf(commandID, updatedCmd)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Command)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, *model.Command) error); ok {
		r1 = rf(commandID, updatedCmd)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateEphemeralPost provides a mock function with given fields: userID, post
func (_m *API) UpdateEphemeralPost(userID string, post *model.Post) *model.Post {
	ret := _m.Called(userID, post)

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(string, *model.Post) *model.Post); ok {
		r0 = rf(userID, post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	return r0
}

// UpdateOAuthApp provides a mock function with given fields: app
func (_m *API) UpdateOAuthApp(app *model.OAuthApp) (*model.OAuthApp, *model.AppError) {
	ret := _m.Called(app)

	var r0 *model.OAuthApp
	if rf, ok := ret.Get(0).(func(*model.OAuthApp) *model.OAuthApp); ok {
		r0 = rf(app)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.OAuthApp)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.OAuthApp) *model.AppError); ok {
		r1 = rf(app)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdatePost provides a mock function with given fields: post
func (_m *API) UpdatePost(post *model.Post) (*model.Post, *model.AppError) {
	ret := _m.Called(post)

	var r0 *model.Post
	if rf, ok := ret.Get(0).(func(*model.Post) *model.Post); ok {
		r0 = rf(post)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Post)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Post) *model.AppError); ok {
		r1 = rf(post)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdatePreferencesForUser provides a mock function with given fields: userID, preferences
func (_m *API) UpdatePreferencesForUser(userID string, preferences []model.Preference) *model.AppError {
	ret := _m.Called(userID, preferences)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, []model.Preference) *model.AppError); ok {
		r0 = rf(userID, preferences)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// UpdateTeam provides a mock function with given fields: team
func (_m *API) UpdateTeam(team *model.Team) (*model.Team, *model.AppError) {
	ret := _m.Called(team)

	var r0 *model.Team
	if rf, ok := ret.Get(0).(func(*model.Team) *model.Team); ok {
		r0 = rf(team)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Team)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.Team) *model.AppError); ok {
		r1 = rf(team)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateTeamMemberRoles provides a mock function with given fields: teamID, userID, newRoles
func (_m *API) UpdateTeamMemberRoles(teamID string, userID string, newRoles string) (*model.TeamMember, *model.AppError) {
	ret := _m.Called(teamID, userID, newRoles)

	var r0 *model.TeamMember
	if rf, ok := ret.Get(0).(func(string, string, string) *model.TeamMember); ok {
		r0 = rf(teamID, userID, newRoles)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.TeamMember)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string, string) *model.AppError); ok {
		r1 = rf(teamID, userID, newRoles)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateUser provides a mock function with given fields: user
func (_m *API) UpdateUser(user *model.User) (*model.User, *model.AppError) {
	ret := _m.Called(user)

	var r0 *model.User
	if rf, ok := ret.Get(0).(func(*model.User) *model.User); ok {
		r0 = rf(user)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(*model.User) *model.AppError); ok {
		r1 = rf(user)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UpdateUserActive provides a mock function with given fields: userID, active
func (_m *API) UpdateUserActive(userID string, active bool) *model.AppError {
	ret := _m.Called(userID, active)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, bool) *model.AppError); ok {
		r0 = rf(userID, active)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// UpdateUserCustomStatus provides a mock function with given fields: userID, customStatus
func (_m *API) UpdateUserCustomStatus(userID string, customStatus *model.CustomStatus) *model.AppError {
	ret := _m.Called(userID, customStatus)

	var r0 *model.AppError
	if rf, ok := ret.Get(0).(func(string, *model.CustomStatus) *model.AppError); ok {
		r0 = rf(userID, customStatus)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.AppError)
		}
	}

	return r0
}

// UpdateUserStatus provides a mock function with given fields: userID, status
func (_m *API) UpdateUserStatus(userID string, status string) (*model.Status, *model.AppError) {
	ret := _m.Called(userID, status)

	var r0 *model.Status
	if rf, ok := ret.Get(0).(func(string, string) *model.Status); ok {
		r0 = rf(userID, status)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Status)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func(string, string) *model.AppError); ok {
		r1 = rf(userID, status)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}

// UploadFile provides a mock function with given fields: data, channelId, filename
func (_m *API) UploadFile(data []byte, channelId string, filename string) (*model.FileInfo, *model.AppError) {
	ret := _m.Called(data, channelId, filename)

	var r0 *model.FileInfo
	if rf, ok := ret.Get(0).(func([]byte, string, string) *model.FileInfo); ok {
		r0 = rf(data, channelId, filename)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.FileInfo)
		}
	}

	var r1 *model.AppError
	if rf, ok := ret.Get(1).(func([]byte, string, string) *model.AppError); ok {
		r1 = rf(data, channelId, filename)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*model.AppError)
		}
	}

	return r0, r1
}
