// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVault20201125ClusterState State is the state of the Vault cluster. Note that this state
// represents the abstract Vault cluster itself, not necessarily whether
// Vault cluster is currently available or not.
//
//   - CLUSTER_STATE_INVALID: CLUSTER_STATE_INVALID is a sentinel zero value so that an uninitialized value can be
//
// detected.
//   - PENDING: PENDING is the state the cluster is in while it is waiting to be created.
//   - CREATING: CREATING is the state the cluster is in while it is being provisioned for
//
// the first time.
//   - RUNNING: RUNNING is the steady state while the cluster is running.
//   - FAILED: FAILED is a failure state in which the cluster is unavailable and may
//
// required an operator restore action to recover.
//   - UPDATING: UPDATING is the state the cluster is in while undergoing a version
//
// update.
//   - RESTORING: RESTORING is the state the cluster is in while restoring from a snapshot.
//   - DELETING: DELETING is the state the cluster is in while it is being de-provisioned.
//   - DELETED: DELETED is the state the cluster is in when it has been de-provisioned. At
//
// this point, the cluster is eligible for garbage collection.
//   - SEALING: SEALING is the state the cluster is in when it is about to get sealed.
//   - SEALED: SEALED is the state the cluster is in while a cluster is sealed.
//   - UNSEALING: UNSEALING is the state the cluster is in when it is about to get unsealed.
//   - CLUSTER_SCALING: CLUSTER_SCALING is the state the cluster is in when it is under an up or down scaling operation to a new tier_size state.
//
// swagger:model hashicorp.cloud.vault_20201125.Cluster.State
type HashicorpCloudVault20201125ClusterState string

func NewHashicorpCloudVault20201125ClusterState(value HashicorpCloudVault20201125ClusterState) *HashicorpCloudVault20201125ClusterState {
	return &value
}

// Pointer returns a pointer to a freshly-allocated HashicorpCloudVault20201125ClusterState.
func (m HashicorpCloudVault20201125ClusterState) Pointer() *HashicorpCloudVault20201125ClusterState {
	return &m
}

const (

	// HashicorpCloudVault20201125ClusterStateCLUSTERSTATEINVALID captures enum value "CLUSTER_STATE_INVALID"
	HashicorpCloudVault20201125ClusterStateCLUSTERSTATEINVALID HashicorpCloudVault20201125ClusterState = "CLUSTER_STATE_INVALID"

	// HashicorpCloudVault20201125ClusterStatePENDING captures enum value "PENDING"
	HashicorpCloudVault20201125ClusterStatePENDING HashicorpCloudVault20201125ClusterState = "PENDING"

	// HashicorpCloudVault20201125ClusterStateCREATING captures enum value "CREATING"
	HashicorpCloudVault20201125ClusterStateCREATING HashicorpCloudVault20201125ClusterState = "CREATING"

	// HashicorpCloudVault20201125ClusterStateRUNNING captures enum value "RUNNING"
	HashicorpCloudVault20201125ClusterStateRUNNING HashicorpCloudVault20201125ClusterState = "RUNNING"

	// HashicorpCloudVault20201125ClusterStateFAILED captures enum value "FAILED"
	HashicorpCloudVault20201125ClusterStateFAILED HashicorpCloudVault20201125ClusterState = "FAILED"

	// HashicorpCloudVault20201125ClusterStateUPDATING captures enum value "UPDATING"
	HashicorpCloudVault20201125ClusterStateUPDATING HashicorpCloudVault20201125ClusterState = "UPDATING"

	// HashicorpCloudVault20201125ClusterStateRESTORING captures enum value "RESTORING"
	HashicorpCloudVault20201125ClusterStateRESTORING HashicorpCloudVault20201125ClusterState = "RESTORING"

	// HashicorpCloudVault20201125ClusterStateDELETING captures enum value "DELETING"
	HashicorpCloudVault20201125ClusterStateDELETING HashicorpCloudVault20201125ClusterState = "DELETING"

	// HashicorpCloudVault20201125ClusterStateDELETED captures enum value "DELETED"
	HashicorpCloudVault20201125ClusterStateDELETED HashicorpCloudVault20201125ClusterState = "DELETED"

	// HashicorpCloudVault20201125ClusterStateSEALING captures enum value "SEALING"
	HashicorpCloudVault20201125ClusterStateSEALING HashicorpCloudVault20201125ClusterState = "SEALING"

	// HashicorpCloudVault20201125ClusterStateSEALED captures enum value "SEALED"
	HashicorpCloudVault20201125ClusterStateSEALED HashicorpCloudVault20201125ClusterState = "SEALED"

	// HashicorpCloudVault20201125ClusterStateUNSEALING captures enum value "UNSEALING"
	HashicorpCloudVault20201125ClusterStateUNSEALING HashicorpCloudVault20201125ClusterState = "UNSEALING"

	// HashicorpCloudVault20201125ClusterStateCLUSTERSCALING captures enum value "CLUSTER_SCALING"
	HashicorpCloudVault20201125ClusterStateCLUSTERSCALING HashicorpCloudVault20201125ClusterState = "CLUSTER_SCALING"
)

// for schema
var hashicorpCloudVault20201125ClusterStateEnum []interface{}

func init() {
	var res []HashicorpCloudVault20201125ClusterState
	if err := json.Unmarshal([]byte(`["CLUSTER_STATE_INVALID","PENDING","CREATING","RUNNING","FAILED","UPDATING","RESTORING","DELETING","DELETED","SEALING","SEALED","UNSEALING","CLUSTER_SCALING"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashicorpCloudVault20201125ClusterStateEnum = append(hashicorpCloudVault20201125ClusterStateEnum, v)
	}
}

func (m HashicorpCloudVault20201125ClusterState) validateHashicorpCloudVault20201125ClusterStateEnum(path, location string, value HashicorpCloudVault20201125ClusterState) error {
	if err := validate.EnumCase(path, location, value, hashicorpCloudVault20201125ClusterStateEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this hashicorp cloud vault 20201125 cluster state
func (m HashicorpCloudVault20201125ClusterState) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateHashicorpCloudVault20201125ClusterStateEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this hashicorp cloud vault 20201125 cluster state based on context it is used
func (m HashicorpCloudVault20201125ClusterState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
