// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// GetAvailableProvidersReader is a Reader for the GetAvailableProviders structure.
type GetAvailableProvidersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAvailableProvidersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAvailableProvidersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAvailableProvidersDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAvailableProvidersOK creates a GetAvailableProvidersOK with default headers values
func NewGetAvailableProvidersOK() *GetAvailableProvidersOK {
	return &GetAvailableProvidersOK{}
}

/*
GetAvailableProvidersOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAvailableProvidersOK struct {
	Payload *models.HashicorpCloudVault20201125GetAvailableProvidersResponse
}

// IsSuccess returns true when this get available providers o k response has a 2xx status code
func (o *GetAvailableProvidersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get available providers o k response has a 3xx status code
func (o *GetAvailableProvidersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get available providers o k response has a 4xx status code
func (o *GetAvailableProvidersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get available providers o k response has a 5xx status code
func (o *GetAvailableProvidersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get available providers o k response a status code equal to that given
func (o *GetAvailableProvidersOK) IsCode(code int) bool {
	return code == 200
}

func (o *GetAvailableProvidersOK) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/providers][%d] getAvailableProvidersOK  %+v", 200, o.Payload)
}

func (o *GetAvailableProvidersOK) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/providers][%d] getAvailableProvidersOK  %+v", 200, o.Payload)
}

func (o *GetAvailableProvidersOK) GetPayload() *models.HashicorpCloudVault20201125GetAvailableProvidersResponse {
	return o.Payload
}

func (o *GetAvailableProvidersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125GetAvailableProvidersResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAvailableProvidersDefault creates a GetAvailableProvidersDefault with default headers values
func NewGetAvailableProvidersDefault(code int) *GetAvailableProvidersDefault {
	return &GetAvailableProvidersDefault{
		_statusCode: code,
	}
}

/*
GetAvailableProvidersDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAvailableProvidersDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the get available providers default response
func (o *GetAvailableProvidersDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this get available providers default response has a 2xx status code
func (o *GetAvailableProvidersDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get available providers default response has a 3xx status code
func (o *GetAvailableProvidersDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get available providers default response has a 4xx status code
func (o *GetAvailableProvidersDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get available providers default response has a 5xx status code
func (o *GetAvailableProvidersDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get available providers default response a status code equal to that given
func (o *GetAvailableProvidersDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *GetAvailableProvidersDefault) Error() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/providers][%d] GetAvailableProviders default  %+v", o._statusCode, o.Payload)
}

func (o *GetAvailableProvidersDefault) String() string {
	return fmt.Sprintf("[GET /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/providers][%d] GetAvailableProviders default  %+v", o._statusCode, o.Payload)
}

func (o *GetAvailableProvidersDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *GetAvailableProvidersDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
