// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudResourcemanagerPolicy Policy binds many instances of roles to member lists in the resource hierarchy.
// For example:
//
// An organization policy which has a single owner and many contributors.
//
//	"policy": {
//	  "bindings": [{
//	    "role_id": "roles/owner",
//	    "members": [
//	      {
//	        "member_type": "USER",
//	        "member_id": "f0b6f14c-ff6d-481a-8bd6-f4f0d356bc93"
//	      }
//	    ]
//	  }, {
//	    "role_id": "roles/contributor",
//	    "members": [
//	      {
//	        "member_type": "USER",
//	        "member_id": "b24c10e6-7f2d-4660-a163-f54f52439080"
//	      },
//	      {
//	        "member_type": "USER",
//	        "member_id": "b2becb8c-4947-4a29-94bb-c952b1b67f1e"
//	      },
//	      {
//	        "member_type": "GROUP",
//	        "member_id": "356120ef-3014-404c-b574-c1c9e804663a"
//	      }
//	    ]
//	  }],
//	  "etag": "afd123"
//	}
//
// swagger:model hashicorp.cloud.resourcemanager.Policy
type HashicorpCloudResourcemanagerPolicy struct {

	// Bindings is a list of role to members for this policy.
	Bindings []*HashicorpCloudResourcemanagerPolicyBinding `json:"bindings"`

	// Etag identifies this version of the policy.
	Etag string `json:"etag,omitempty"`
}

// Validate validates this hashicorp cloud resourcemanager policy
func (m *HashicorpCloudResourcemanagerPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBindings(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudResourcemanagerPolicy) validateBindings(formats strfmt.Registry) error {
	if swag.IsZero(m.Bindings) { // not required
		return nil
	}

	for i := 0; i < len(m.Bindings); i++ {
		if swag.IsZero(m.Bindings[i]) { // not required
			continue
		}

		if m.Bindings[i] != nil {
			if err := m.Bindings[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("bindings" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("bindings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud resourcemanager policy based on the context it is used
func (m *HashicorpCloudResourcemanagerPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBindings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudResourcemanagerPolicy) contextValidateBindings(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Bindings); i++ {

		if m.Bindings[i] != nil {
			if err := m.Bindings[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("bindings" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("bindings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudResourcemanagerPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudResourcemanagerPolicy) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudResourcemanagerPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
