// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudPacker20220411Image Represents the actual region:image_id mapping for a single image, in a
// single build.
//
// swagger:model hashicorp.cloud.packer_20220411.Image
type HashicorpCloudPacker20220411Image struct {

	// Timestamp at which this image was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// Universally Unique Lexicographically Sortable Identifier (ULID) for the image.
	ID string `json:"id,omitempty"`

	// ID or URL of the remote cloud image as given by a build. For example, ami-12345.
	ImageID string `json:"image_id,omitempty"`

	// Cloud-specific region as provided by `packer build`. For example, "ap-east-1".
	Region string `json:"region,omitempty"`
}

// Validate validates this hashicorp cloud packer 20220411 image
func (m *HashicorpCloudPacker20220411Image) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411Image) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this hashicorp cloud packer 20220411 image based on context it is used
func (m *HashicorpCloudPacker20220411Image) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411Image) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411Image) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20220411Image
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
