// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudPacker20220411Bucket hashicorp cloud packer 20220411 bucket
//
// swagger:model hashicorp.cloud.packer_20220411.Bucket
type HashicorpCloudPacker20220411Bucket struct {

	// Information about this image bucket's children. Children are image buckets that used any iteration of this bucket
	// as the base image for their latest complete iteration.
	Children *HashicorpCloudPacker20220411BucketChildren `json:"children,omitempty"`

	// When the bucket was created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// A short description of what this bucket's images are for.
	Description string `json:"description,omitempty"`

	// Universally Unique Lexicographically Sortable Identifier (ULID) of the bucket.
	ID string `json:"id,omitempty"`

	// The total number of iterations in this bucket.
	IterationCount string `json:"iteration_count,omitempty"`

	// A key:value map for custom, user-settable metadata about your bucket.
	Labels map[string]string `json:"labels,omitempty"`

	// The bucket's most recent iteration. This iteration may be complete or not.
	LatestIteration *HashicorpCloudPacker20220411BucketLatestIteration `json:"latest_iteration,omitempty"`

	// The human-readable version of the most recent completed iteration in this bucket.
	LatestVersion int32 `json:"latest_version,omitempty"`

	// location
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// Information about this image bucket's parents. Parents are the base images Packer used to build the latest complete iteration
	// in this image bucket.
	Parents *HashicorpCloudPacker20220411BucketParents `json:"parents,omitempty"`

	// A list of the cloud providers or other platforms that are included in the latest complete iteration. e.g aws, gcp, or azure.
	Platforms []string `json:"platforms"`

	// Human-readable name for the bucket.
	Slug string `json:"slug,omitempty"`

	// When the bucket was last updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud packer 20220411 bucket
func (m *HashicorpCloudPacker20220411Bucket) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChildren(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatestIteration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) validateChildren(formats strfmt.Registry) error {
	if swag.IsZero(m.Children) { // not required
		return nil
	}

	if m.Children != nil {
		if err := m.Children.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("children")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("children")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) validateLatestIteration(formats strfmt.Registry) error {
	if swag.IsZero(m.LatestIteration) { // not required
		return nil
	}

	if m.LatestIteration != nil {
		if err := m.LatestIteration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latest_iteration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("latest_iteration")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) validateParents(formats strfmt.Registry) error {
	if swag.IsZero(m.Parents) { // not required
		return nil
	}

	if m.Parents != nil {
		if err := m.Parents.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parents")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parents")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer 20220411 bucket based on the context it is used
func (m *HashicorpCloudPacker20220411Bucket) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChildren(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatestIteration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) contextValidateChildren(ctx context.Context, formats strfmt.Registry) error {

	if m.Children != nil {
		if err := m.Children.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("children")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("children")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) contextValidateLatestIteration(ctx context.Context, formats strfmt.Registry) error {

	if m.LatestIteration != nil {
		if err := m.LatestIteration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latest_iteration")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("latest_iteration")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {
		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20220411Bucket) contextValidateParents(ctx context.Context, formats strfmt.Registry) error {

	if m.Parents != nil {
		if err := m.Parents.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parents")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parents")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411Bucket) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20220411Bucket) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20220411Bucket
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
