// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPackerServiceTFCImageValidationRunTaskParams creates a new PackerServiceTFCImageValidationRunTaskParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceTFCImageValidationRunTaskParams() *PackerServiceTFCImageValidationRunTaskParams {
	return &PackerServiceTFCImageValidationRunTaskParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceTFCImageValidationRunTaskParamsWithTimeout creates a new PackerServiceTFCImageValidationRunTaskParams object
// with the ability to set a timeout on a request.
func NewPackerServiceTFCImageValidationRunTaskParamsWithTimeout(timeout time.Duration) *PackerServiceTFCImageValidationRunTaskParams {
	return &PackerServiceTFCImageValidationRunTaskParams{
		timeout: timeout,
	}
}

// NewPackerServiceTFCImageValidationRunTaskParamsWithContext creates a new PackerServiceTFCImageValidationRunTaskParams object
// with the ability to set a context for a request.
func NewPackerServiceTFCImageValidationRunTaskParamsWithContext(ctx context.Context) *PackerServiceTFCImageValidationRunTaskParams {
	return &PackerServiceTFCImageValidationRunTaskParams{
		Context: ctx,
	}
}

// NewPackerServiceTFCImageValidationRunTaskParamsWithHTTPClient creates a new PackerServiceTFCImageValidationRunTaskParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceTFCImageValidationRunTaskParamsWithHTTPClient(client *http.Client) *PackerServiceTFCImageValidationRunTaskParams {
	return &PackerServiceTFCImageValidationRunTaskParams{
		HTTPClient: client,
	}
}

/*
PackerServiceTFCImageValidationRunTaskParams contains all the parameters to send to the API endpoint

	for the packer service t f c image validation run task operation.

	Typically these are written to a http.Request.
*/
type PackerServiceTFCImageValidationRunTaskParams struct {

	/* APIID.

	   UUID of the HCP Packer registry run task API.
	*/
	APIID string

	/* Body.

	   The bytes for the JSON payload sent by Terraform Cloud when calling this run task.

	   Format: byte
	*/
	Body strfmt.Base64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service t f c image validation run task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceTFCImageValidationRunTaskParams) WithDefaults() *PackerServiceTFCImageValidationRunTaskParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service t f c image validation run task params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceTFCImageValidationRunTaskParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) WithTimeout(timeout time.Duration) *PackerServiceTFCImageValidationRunTaskParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) WithContext(ctx context.Context) *PackerServiceTFCImageValidationRunTaskParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) WithHTTPClient(client *http.Client) *PackerServiceTFCImageValidationRunTaskParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAPIID adds the aPIID to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) WithAPIID(aPIID string) *PackerServiceTFCImageValidationRunTaskParams {
	o.SetAPIID(aPIID)
	return o
}

// SetAPIID adds the apiId to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) SetAPIID(aPIID string) {
	o.APIID = aPIID
}

// WithBody adds the body to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) WithBody(body strfmt.Base64) *PackerServiceTFCImageValidationRunTaskParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the packer service t f c image validation run task params
func (o *PackerServiceTFCImageValidationRunTaskParams) SetBody(body strfmt.Base64) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceTFCImageValidationRunTaskParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param api_id
	if err := r.SetPathParam("api_id", o.APIID); err != nil {
		return err
	}
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
