// Code generated by go-swagger; DO NOT EDIT.

package todos

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFindParams creates a new FindParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFindParams() *FindParams {
	return &FindParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFindParamsWithTimeout creates a new FindParams object
// with the ability to set a timeout on a request.
func NewFindParamsWithTimeout(timeout time.Duration) *FindParams {
	return &FindParams{
		timeout: timeout,
	}
}

// NewFindParamsWithContext creates a new FindParams object
// with the ability to set a context for a request.
func NewFindParamsWithContext(ctx context.Context) *FindParams {
	return &FindParams{
		Context: ctx,
	}
}

// NewFindParamsWithHTTPClient creates a new FindParams object
// with the ability to set a custom HTTPClient for a request.
func NewFindParamsWithHTTPClient(client *http.Client) *FindParams {
	return &FindParams{
		HTTPClient: client,
	}
}

/*
FindParams contains all the parameters to send to the API endpoint

	for the find operation.

	Typically these are written to a http.Request.
*/
type FindParams struct {

	// XRateLimit.
	//
	// Format: int32
	XRateLimit int32

	// Limit.
	//
	// Format: int32
	Limit int32

	// Tags.
	Tags []int32

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the find params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FindParams) WithDefaults() *FindParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the find params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FindParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the find params
func (o *FindParams) WithTimeout(timeout time.Duration) *FindParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the find params
func (o *FindParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the find params
func (o *FindParams) WithContext(ctx context.Context) *FindParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the find params
func (o *FindParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the find params
func (o *FindParams) WithHTTPClient(client *http.Client) *FindParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the find params
func (o *FindParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXRateLimit adds the xRateLimit to the find params
func (o *FindParams) WithXRateLimit(xRateLimit int32) *FindParams {
	o.SetXRateLimit(xRateLimit)
	return o
}

// SetXRateLimit adds the xRateLimit to the find params
func (o *FindParams) SetXRateLimit(xRateLimit int32) {
	o.XRateLimit = xRateLimit
}

// WithLimit adds the limit to the find params
func (o *FindParams) WithLimit(limit int32) *FindParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the find params
func (o *FindParams) SetLimit(limit int32) {
	o.Limit = limit
}

// WithTags adds the tags to the find params
func (o *FindParams) WithTags(tags []int32) *FindParams {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the find params
func (o *FindParams) SetTags(tags []int32) {
	o.Tags = tags
}

// WriteToRequest writes these params to a swagger request
func (o *FindParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// header param X-Rate-Limit
	if err := r.SetHeaderParam("X-Rate-Limit", swag.FormatInt32(o.XRateLimit)); err != nil {
		return err
	}

	// form param limit
	frLimit := o.Limit
	fLimit := swag.FormatInt32(frLimit)
	if err := r.SetFormParam("limit", fLimit); err != nil {
		return err
	}

	if o.Tags != nil {

		// binding items for tags
		joinedTags := o.bindParamTags(reg)

		// form array param tags
		if err := r.SetFormParam("tags", joinedTags...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFind binds the parameter tags
func (o *FindParams) bindParamTags(formats strfmt.Registry) []string {
	tagsIR := o.Tags

	var tagsIC []string
	for _, tagsIIR := range tagsIR { // explode []int32

		tagsIIV := swag.FormatInt32(tagsIIR) // int32 as string
		tagsIC = append(tagsIC, tagsIIV)
	}

	// items.CollectionFormat: "multi"
	tagsIS := swag.JoinByFormat(tagsIC, "multi")

	return tagsIS
}
