#!/bin/sh

# This test ensures that the `-t` / `--template` flag works correctly in query
# mode.

set -e
set -u
set -x

OUT="$(printf '{"foo": 10, "bar": 5}' | "$RQ" -t 'foo is: {{.foo}}, bar is: {{.bar}}')"

EXPECT="foo is: 10, bar is: 5"

if [ "$OUT" != "$EXPECT" ] ; then
	printf "expected output '$EXPECT' but got:\n%s\n" "$OUT"
	exit 1
fi
