#!/bin/sh

# This test verifies that rq -i csv correctly strips the UTF-8 byte order
# marker.
#
# Special thanks to Cody for reporting this issue and for providing this
# minimal test case to reproduce it!

set -e
set -u
set -x

if [ ! -x "$(which base64)" ] ; then
	echo "base64 not in PATH"
	exit 1
fi

# We ASCII-armor this to make sure it doesn't get helpfully converted to some
# other encoding along the way. An ASCII rendition of this file is:
#
# ---
# Username*,Email*
# youcantseeme,butyoucanseeme
# ---
#
# However, the real file does not have a trailing space, has CLRF line endings,
# and has a UTF-8 byte order marker.
TESTDATA='77u/VXNlcm5hbWUqLEVtYWlsKg0KeW91Y2FudHNlZW1lLGJ1dHlvdWNhbnNlZW1l'

OUT="$(echo "$TESTDATA" | base64 -d | "$RQ" -i csv -H --raw 'input[_]["Username*"]')"

if [ "$OUT" != "youcantseeme" ] ; then
	printf "Expected output 'youcantseeme' but got:\n%s\n" "$OUT"
	exit 1
fi
unset OUT
