#include "str.h"
#include "stralloc.h"

/**
  * @file str.c
  * @authors djb, feh
  * @ref qmail
  * @brief string handling functions
  */

unsigned int str_copy(char *s,const char *t)
{
  int len;

  len = 0;
  for (;;) {
    if (!(*s = *t)) { return len; } ++s; ++t; ++len; 
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
  }
}

unsigned int str_copyb(char *s,const char *t,unsigned int max)
{
  int len;

  len = 0;

  while (max-- > 0) {
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
    if (!(*s = *t)) { return len; } ++s; ++t; ++len;
  }

  return len;
}

int str_diff(const char *s,const char *t)
{
  char x;

  for (;;) {
    x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
    x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
    x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
    x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
  }
  return ((int)(unsigned int)(unsigned char) x)
       - ((int)(unsigned int)(unsigned char) *t);
}

int str_diffn(const char *s,const char *t,unsigned int len)
{
  char x;

  for (;;) {
    if (!len--) { return 0; } x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
    if (!len--) { return 0; } x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
    if (!len--) { return 0; } x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
    if (!len--) { return 0; } x = *s; if (x != *t) { break; } if (!x) { break; } ++s; ++t;
  }
  return ((int)(unsigned int)(unsigned char) x)
       - ((int)(unsigned int)(unsigned char) *t);
}

unsigned int str_len(const char *s)
{
  const char *t;

  t = s;
  for (;;) {
    if (!*t) { return t - s; } ++t;
    if (!*t) { return t - s; } ++t;
    if (!*t) { return t - s; } ++t;
    if (!*t) { return t - s; } ++t;
  }
}

unsigned int str_chr(const char *s,int c)
{
  char ch;
  const char *t;

  ch = c;
  t = s;
  for (;;) {
    if (!*t) { break; } if (*t == ch) { break; } ++t;
    if (!*t) { break; } if (*t == ch) { break; } ++t;
    if (!*t) { break; } if (*t == ch) { break; } ++t;
    if (!*t) { break; } if (*t == ch) { break; } ++t;
  }
  return t - s;
}

unsigned int str_rchr(const char *s,int c)
{
  char ch;
  const char *t;
  const char *u;

  ch = c;
  t = s;
  u = 0;
  for (;;) {
    if (!*t) { break; } if (*t == ch) { u = t; } ++t;
    if (!*t) { break; } if (*t == ch) { u = t; } ++t;
    if (!*t) { break; } if (*t == ch) { u = t; } ++t;
    if (!*t) { break; } if (*t == ch) { u = t; } ++t;
  }
  if (!u) u = t;
  return u - s;
}

int str_start(const char *s,const char *t)
{
  char x;

  for (;;) {
    x = *t++; if (!x) return 1; if (x != *s++) return 0;
    x = *t++; if (!x) return 1; if (x != *s++) return 0;
    x = *t++; if (!x) return 1; if (x != *s++) return 0;
    x = *t++; if (!x) return 1; if (x != *s++) return 0;
  }
}

char *str_append(char *dest, char const *s)
{
  static stralloc sa = {0};

  stralloc_copys(&sa,dest);
  stralloc_catb(&sa,s,sizeof(s));
  return sa.s;
}
