#include "case.h"
#include "str.h"

/**
  * @file case.c
  * @author djb
  * @brief string comparison and helper functions; case insensitive
  */

int case_diffb(char *s,unsigned int len,char *t)
{
  unsigned char x;
  unsigned char y;

  while (len > 0) {
    --len;
    x = *s++ - 'A';
    if (x <= 'Z' - 'A') x += 'a'; else x += 'A';
    y = *t++ - 'A';
    if (y <= 'Z' - 'A') y += 'a'; else y += 'A';
    if (x != y)
      return ((int)(unsigned int) x) - ((int)(unsigned int) y);
  }
  return 0;
}

int case_diffs(char *s,char *t)
{
  unsigned char x;
  unsigned char y;

  for (;;) {
    x = *s++ - 'A';
    if (x <= 'Z' - 'A') x += 'a'; else x += 'A';
    y = *t++ - 'A';
    if (y <= 'Z' - 'A') y += 'a'; else y += 'A';
    if (x != y) break;
    if (!x) break;
  }
  return ((int)(unsigned int) x) - ((int)(unsigned int) y);
}

int case_diffrs(char *s,char *t)
{
  unsigned char x = 0;
  unsigned char y = 0;
  unsigned int lens = str_len(s);
  unsigned int lent = str_len(t);

  while (lens > 0 && lent > 0) {
    x = s[--lens] - 'A';
    if (x <= 'Z' - 'A') x += 'a'; else x += 'A';
    y = t[--lent] - 'A';
    if (y <= 'Z' - 'A') y += 'a'; else y += 'A';
    if (x != y) break;
    if (!x) break;
    if (!y) break;
  }
  return ((int)(unsigned int) x) - ((int)(unsigned int) y);
}

void case_lowerb(char *s,unsigned int len)
{
  unsigned char x;
  while (len > 0) {
    --len;
    x = *s - 'A';
    if (x <= 'Z' - 'A') *s = x + 'a';
    ++s;
  }
}

void case_lowers(char *s)
{
  unsigned char x;
  while ((x = *s)) {
    x -= 'A';
    if (x <= 'Z' - 'A') *s = x + 'a';
    ++s;
  }
}

void case_upperb(char *s,unsigned int len)
{
  unsigned char x;
  while (len > 0) {
    --len;
    x = *s - 'a';
    if (x <= 'z' - 'a') *s = x + 'A';
    ++s;
  }
}

void case_uppers(char *s)
{
  unsigned char x;
  while ((x = *s)) {
    x -= 'a';
    if (x <= 'z' - 'a') *s = x + 'A';
    ++s;
  }
}

int case_startb(char *s,unsigned int len,char *t)
{
  unsigned char x;
  unsigned char y;

  for (;;) {
    y = *t++ - 'A';
    if (y <= 'Z' - 'A') y += 'a'; else y += 'A';
    if (!y) return 1;
    if (!len) return 0;
    --len;
    x = *s++ - 'A';
    if (x <= 'Z' - 'A') x += 'a'; else x += 'A';
    if (x != y) return 0;
  }
}

int case_starts(char *s,char *t)
{
  unsigned char x;
  unsigned char y;

  for (;;) {
    x = *s++ - 'A';
    if (x <= 'Z' - 'A') x += 'a'; else x += 'A';
    y = *t++ - 'A';
    if (y <= 'Z' - 'A') y += 'a'; else y += 'A';
    if (!y) return 1;
    if (x != y) return 0;
  }
}
