fehQlibs installation
=====================

Configuration
-------------

Some build options can be configured through 'conf-build'.  
Read the comments in this file for more information. 


Building
--------

a) Static libs:

Execute

     $ make -C src

which does the steps of './configure && make'. 
Don't forget to make sure that libs and headers will be found by the compiler/linker.

In fehQlibs main directory you will find now

- libdnsresolv.a
- libqlibs.a

ready for use.

b) Shared objects libs:

You can also build dynamic libaries for qlibs and dnsresolv. After

     $ make -C src 

call 

     $ make -C src shared

Additionally, the files

- libdnsresolv.so
- libqlibs.so

are created.


Deployment
----------

In case 'conf-build' has been customized to include the location of

- HDRDIR
- LIBDIR

issue 

     $ make -C src install

to deploy the include files and libs at the given location.
By default, for the libs the parent directory is used.


Cleaning
--------

Calling

     $ make -C src clean

will remove the object files in the src directories, but will 
leave the generated libraries as they are in the main directory. 
They will be overwritten on the next call of make.


Verification
------------

Check the ELFCLASS of the generated binaries in the src directory while calling

     $ file open.o

They need to comply with your OS. See 'conf-build' for options.

* Resulting libraries:

The following libraries are generated:

- qlibs.a - static basic [w/o DNS] lib (linked to libqlibs.a)
- dnsresolv.a - static DNS resolver lib (linked to libdnsresolv.a)

and perhaps

- libqlibs.so - dynamic, position independent (PIC) 'shared object' lib
- libdnsresolv.so - dynamic, position independent (PIC) 'shared object' lib

These libs are of type ELF64 or ELF32 depending on the system.

Use 'ar -t' to get the included members of the static libs.
Use 'nm' to view the members and symbols of the libs.

The shared object libs are known NOT not work on MacOS.
You might need additional parameters in 'conf-build'.


Man pages
---------

In the ./man directory the current man pages for the basic qlibs routines are included.
Determine the current $mandir and (as root) install the man pages:

     $ cp *.3 $mandir/man3/

-----

Updated: 20240920, Erwin Hoffmann
