type Icon = 'update' | 'alert';

type Props = {
  variant: Icon;
};

export const UpdateNotificationModalIcons = ({ variant }: Props) => {
  switch (variant) {
    case 'alert':
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="12"
          height="12"
          viewBox="0 0 12 12"
          fill="none"
        >
          <path
            d="M6 12C9.31371 12 12 9.31371 12 6C12 2.68629 9.31371 0 6 0C2.68629 0 0 2.68629 0 6C0 9.31371 2.68629 12 6 12Z"
            style={{
              fill: 'var(--surface-alert-primary)',
            }}
          />
          <path
            d="M6.72213 7.253H5.28013L5.05313 2H6.95313L6.72213 7.253ZM4.99613 8.892C4.99499 8.77035 5.01917 8.6498 5.06713 8.538C5.11266 8.43037 5.18088 8.33384 5.26713 8.255C5.35866 8.17389 5.46446 8.11049 5.57913 8.068C5.70713 8.02074 5.8427 7.99735 5.97913 7.999C6.11556 7.99735 6.25114 8.02074 6.37913 8.068C6.49543 8.10933 6.60295 8.17208 6.69613 8.253C6.78239 8.33184 6.85061 8.42837 6.89613 8.536C6.9441 8.6478 6.96827 8.76835 6.96713 8.89C6.96827 9.01165 6.9441 9.1322 6.89613 9.244C6.85061 9.35163 6.78239 9.44816 6.69613 9.527C6.6046 9.60811 6.49881 9.67151 6.38413 9.714C6.25614 9.76126 6.12056 9.78465 5.98413 9.783C5.8477 9.78465 5.71213 9.76126 5.58413 9.714C5.46946 9.67151 5.36366 9.60811 5.27213 9.527C5.18588 9.44816 5.11766 9.35163 5.07213 9.244C5.02272 9.13319 4.99684 9.01333 4.99613 8.892Z"
            fill="#fff"
          />
        </svg>
      );
    case 'update':
      return (
        <svg
          xmlns="http://www.w3.org/2000/svg"
          width="50"
          height="51"
          viewBox="0 0 50 51"
          fill="none"
        >
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M26.0284 6.75001C15.6731 6.75001 7.27844 15.1447 7.27844 25.5C7.27844 29.7234 8.67232 33.6153 11.026 36.7488C11.717 37.6688 11.5314 38.9748 10.6114 39.6658C9.69147 40.3568 8.3855 40.1712 7.69448 39.2512C4.81743 35.4209 3.11177 30.6566 3.11177 25.5C3.11177 12.8435 13.3719 2.58334 26.0284 2.58334C27.179 2.58334 28.1118 3.51608 28.1118 4.66668C28.1118 5.81727 27.179 6.75001 26.0284 6.75001ZM40.8982 10.7612C41.7915 10.036 43.1036 10.1723 43.8287 11.0655C47.027 15.0052 48.9451 20.0314 48.9451 25.5C48.9451 38.1565 38.685 48.4167 26.0284 48.4167C24.8778 48.4167 23.9451 47.4839 23.9451 46.3333C23.9451 45.1828 24.8778 44.25 26.0284 44.25C36.3838 44.25 44.7784 35.8554 44.7784 25.5C44.7784 21.0222 43.2114 16.9159 40.5939 13.6917C39.8687 12.7984 40.0049 11.4864 40.8982 10.7612Z"
            style={{
              fill: 'var(--surface-icon-secondary)',
            }}
          />
          <path
            d="M36.0151 6.6016L36.7836 16.2133C36.9101 17.7947 38.6872 18.6601 40.0101 17.7845L48.0355 12.473C49.3788 11.5839 49.248 9.57181 47.8009 8.86415L39.0069 4.56399C37.5571 3.855 35.8864 4.99278 36.0151 6.6016Z"
            style={{
              fill: 'var(--surface-icon-secondary)',
            }}
          />
          <path
            d="M15.3307 42.6744L13.804 33.1537C13.5528 31.5873 11.7127 30.8652 10.4632 31.8427L2.88334 37.7726C1.61455 38.7652 1.90418 40.7606 3.40282 41.3516L12.5094 44.9424C14.0109 45.5344 15.5862 44.268 15.3307 42.6744Z"
            style={{
              fill: 'var(--surface-icon-secondary)',
            }}
          />
        </svg>
      );
  }
};
