import { useMutation, useQueryClient } from '@tanstack/react-query';
import type { AxiosError } from 'axios';
import { shallow } from 'zustand/shallow';

import { useI18nContext } from '../../../../../../i18n/i18n-react';
import { ConfirmModal } from '../../../../../../shared/defguard-ui/components/Layout/modals/ConfirmModal/ConfirmModal';
import { ConfirmModalType } from '../../../../../../shared/defguard-ui/components/Layout/modals/ConfirmModal/types';
import useApi from '../../../../../../shared/hooks/useApi';
import { useToaster } from '../../../../../../shared/hooks/useToaster';
import { MutationKeys } from '../../../../../../shared/mutations';
import { QueryKeys } from '../../../../../../shared/queries';
import { useDeleteDeviceModal } from '../../hooks/useDeleteDeviceModal';

export const DeleteUserDeviceModal = () => {
  const { LL } = useI18nContext();
  const toaster = useToaster();
  const [device, visible] = useDeleteDeviceModal(
    (state) => [state.device, state.visible],
    shallow,
  );
  const [setModalState, closeModal] = useDeleteDeviceModal(
    (state) => [state.setState, state.close],
    shallow,
  );
  const {
    device: { deleteDevice },
  } = useApi();
  const queryClient = useQueryClient();

  const { mutate, isPending } = useMutation({
    mutationKey: [MutationKeys.DELETE_USER_DEVICE],
    mutationFn: deleteDevice,
    onSuccess: () => {
      void queryClient.invalidateQueries({
        queryKey: [QueryKeys.FETCH_USER_PROFILE],
      });
      toaster.success(LL.modals.deleteDevice.messages.success());
      closeModal();
    },
    onError: (err: AxiosError) => {
      toaster.error(LL.messages.error());
      console.error(err);
    },
  });

  return (
    <ConfirmModal
      title={LL.modals.deleteDevice.title()}
      type={ConfirmModalType.WARNING}
      subTitle={LL.modals.deleteDevice.message({
        deviceName: device?.name || '',
      })}
      cancelText={LL.form.cancel()}
      submitText={LL.modals.deleteDevice.submit()}
      loading={isPending || device === undefined}
      isOpen={visible}
      setIsOpen={(visibility) => setModalState({ visible: visibility })}
      onSubmit={() => {
        if (device) {
          mutate(device);
        }
      }}
    />
  );
};
