pub mod create;
pub mod list;

use clap::Subcommand;

use super::GeneralArgs;

/// Release subcommands
#[derive(Subcommand, Debug)]
pub enum ReleaseArgs {
    Create(create::CreateReleaseArgs),
    List(list::ListReleaseArgs),
}

impl ReleaseArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            ReleaseArgs::Create(args) => args.run(general_args).await,
            ReleaseArgs::List(args) => args.run(general_args).await,
        }
    }
}
