## v0.5 (08a2c0c..723fef4)
#### Documentation
- Add Fedora installation instructions (#176) - (6d79e47) - lih
- Added homebrew install instructions. (#228) - (08a2c0c) - Anthony Lee
#### Features
- make token actually more secret (#236) - (723fef4) - aviac
- Add a way to list the users' repos #160 (#235) - (8eb1ffa) - aviac
- add commands for release actions (#234) - (00fdd4c) - aviac
- add repo migrate command (#233) - (97c8a95) - aviac
- Add robust tests in NixOS for all non-interactive workflows (#232) - (77e688f) - aviac
- implement json output (#231) - (04e6128) - aviac
#### Miscellaneous Chores
- add liberapay link to README - (7f3fb06) - aviac
- use only actually used features, 285 -> 235 deps (#230) - (76d0d22) - aviac
- maintenance (#229) - (6d2dac6) - aviac

## v0.4.11 (40ebb33..40ebb33)
#### Bug Fixes
- revert "build(rust): bump edition to 2024 (#198)" - (40ebb33) - aviac

## v0.4.10 (888b2d2..b3cd528)
#### Bug Fixes
- revert rust 2024 edition - (888b2d2) - aviac
#### Build system
- **(nix)** shell completion and generally enhanced package (#197) - (898a9c7) - aviac
- **(rust)** bump edition to 2024 (#198) - (b3cd528) - aviac

## v0.4.9 (d71b474..f734cc9)
#### Features
- allow ssh cloning again - (1f3ef07) - aviac
#### Miscellaneous Chores
- **(cleanup)** fix rustc and clippy warnings - (6593e9f) - aviac
- **(deps)** bump edition to 2024 and update Cargo.lock - (a23fbe3) - aviac
- **(nix)** replace LD_LIBRARY_PATH with RUSTFLAGS - (372ae92) - aviac
- Release codeberg-cli version 0.4.9 - (f734cc9) - aviac
- update changelog - (793fac5) - aviac
- Release codeberg-cli version 0.4.8 - (656cd6a) - aviac
- update `fenix` for 1.85 rust toolchain - (d71b474) - aviac

## v0.4.8 (8345675..ed37c08)
#### Bug Fixes
- fix crate vulnerabilities (#172) - (368f382) - Dimitris Apostolou
- render nested tables correctly (at least 1 level) (#164) (#168) - (c744441) - aviac
- use the editor from the config file (#165) (#167) - (8345675) - aviac
#### Miscellaneous Chores
- **(cleanup)** fix rustc and clippy warnings - (6e5ed72) - aviac
- **(deps)** bump edition to 2024 and update Cargo.lock - (783ccae) - aviac
- **(nix)** replace LD_LIBRARY_PATH with RUSTFLAGS - (5608a96) - aviac
- Release codeberg-cli version 0.4.8 - (ed37c08) - aviac
- update `fenix` for 1.85 rust toolchain - (a89f3f2) - aviac
- Fix typos (#171) - (617cee8) - Efraim Flashner

## v0.4.7 (f3d63a6..baec590)
#### Features
- options to adapt stdout width (#158) - (baec590) - aviac
- Add an option to change default editor (#156) - (228635c) - Gordon Onayo
- Add options to filter pull requests result (#157) - (4f49078) - Gordon Onayo
- use `Repository::discover` instead of `open` (#149) - (f3d63a6) - Cyborus
#### Miscellaneous Chores
- update nix (#155) - (79a2c84) - aviac

## v0.4.6 (bbb8b1d..07e5814)
#### Bug Fixes
- **(pull-create)** correct assignment of base and target branches (#145) - (bbb8b1d) - Auguste Baum
#### Miscellaneous Chores
- Release codeberg-cli version 0.4.6 - (07e5814) - aviac

## v0.4.5 (8457fa9..8457fa9)
#### Miscellaneous Chores
- improve error and bump dependencies (#146) - (8457fa9) - aviac

## v0.4.4 (6a9b48a..ee74b8b)
#### Bug Fixes
- typo (#143) - (6a9b48a) - mimikun
#### Miscellaneous Chores
- Release codeberg-cli version 0.4.4 - (ee74b8b) - aviac

## v0.4.3 (c98fe42..d185f82)
#### Documentation
- non-codeberg docs in README (#137) - (c98fe42) - aviac
#### Miscellaneous Chores
- Release codeberg-cli version 0.4.3 - (d185f82) - aviac
- update flake.lock and Cargo.lock (#142) - (9344beb) - aviac
- update repo infos everywhere (#139) - (3c4232d) - aviac
- directory-rename (#138) - (0f05a14) - aviac
#### Tests
- sketch nixos test vm setup (#140) - (e33d45a) - aviac

## v0.4.2 (69b2311..d0798db)
#### Bug Fixes
- getting owner from https remotes (#134) - (69b2311) - aviac
#### Miscellaneous Chores
- Release codeberg-cli version 0.4.2 - (d0798db) - aviac

## v0.4.1 (3d62097..87a7d9e)
#### Bug Fixes
- properly deduce owner from ssh urls (#133) - (8f8fd01) - aviac
#### Documentation
- add dependency info (#131) - (0e9410e) - aviac
#### Features
- allows creating a repo for an organization (#128) - (678560f) - Robin Vobruba
- clone directory options (#127) - (237551d) - aviac
- add git2 integration for more robust git support (#123) - (8fbcd4c) - aviac
#### Miscellaneous Chores
- Release codeberg-cli version 0.4.1 - (87a7d9e) - aviac
- nix fmt - (ad74550) - aviac
- update changelog - (3d62097) - aviac
#### Refactoring
- simplify remote url parsing - (3281f64) - aviac
- program control flow refactor (#122) - (a8ec896) - aviac

## [v0.4.0](https://codeberg.org/Aviac/codeberg-cli/compare/a7b8a344acf07f2c423f98f272005a71682feb91..v0.4.0) - 2024-05-02

#### Bug Fixes

- use `url` crate for URL handling - ([6c38b37](https://codeberg.org/Aviac/codeberg-cli/commit/6c38b37342c7c1ddc380b7901ceb496760c8bd54)) - aviac
- use BROWSERS environment variable from error message as expected (#104) - ([7cb2aa0](https://codeberg.org/Aviac/codeberg-cli/commit/7cb2aa064b324c892903e2e6990ac6f7d5e2c964)) - aviac
- failing ci because of woodpecker update (#102) - ([46c05df](https://codeberg.org/Aviac/codeberg-cli/commit/46c05df79687ca4a0c2c45a75ad1faf6d53afded)) - aviac

#### Build system

- Increase cocogitto utilization for release purposes (#87) - ([a7b8a34](https://codeberg.org/Aviac/codeberg-cli/commit/a7b8a344acf07f2c423f98f272005a71682feb91)) - Aviac

#### Continuous Integration

- basic CI via woodpecker - ([551d334](https://codeberg.org/Aviac/codeberg-cli/commit/551d334cefb6a93c62bc0a0adcc574de913822d8)) - aviac
- add some nix based ci script - ([1b405d8](https://codeberg.org/Aviac/codeberg-cli/commit/1b405d85f1d0f506b5499ed7423b72e6cc9ea1cd)) - aviac
- remove the CI for now - ([c4637d8](https://codeberg.org/Aviac/codeberg-cli/commit/c4637d8bd8d29369389ecdcc665db805495a2e6b)) - aviac
- random flake update - ([d19a672](https://codeberg.org/Aviac/codeberg-cli/commit/d19a6720ca2e98240b8fae1ab56cda9b1fa560da)) - aviac
- update nix stuff - ([9447304](https://codeberg.org/Aviac/codeberg-cli/commit/94473046ae8179f2b9d40cfc169830fb2a08a8d0)) - aviac
- update woodpecker config (#92) - ([9652b58](https://codeberg.org/Aviac/codeberg-cli/commit/9652b5826c931ae20a814da61e00c6feb595c641)) - Marcin Puc

#### Documentation

- **(readme)** improve README.md readability (#91) - ([8b4c19c](https://codeberg.org/Aviac/codeberg-cli/commit/8b4c19caaa44bfc4bf4a8113ed1f265cf3d3cc2e)) - Marcin Puc
- add doc comments to all CLI args - ([f0384d3](https://codeberg.org/Aviac/codeberg-cli/commit/f0384d340bb0e980514a327219cb0b6465a34ab4)) - aviac
- update authors - ([9f4e829](https://codeberg.org/Aviac/codeberg-cli/commit/9f4e8298870c86ed4937e02cebd417e7f26963b1)) - aviac
- Mention related projects - ([5b53540](https://codeberg.org/Aviac/codeberg-cli/commit/5b535407360fcd0fd8f3254b86e11f547dd8cb01)) - aviac
- Readme updates - ([a6c9a3f](https://codeberg.org/Aviac/codeberg-cli/commit/a6c9a3f500729ebf0cf0b9edf506bc3b93916e5d)) - aviac

#### Features

- table rework `comfy-table` (#120) - ([1aebf23](https://codeberg.org/Aviac/codeberg-cli/commit/1aebf230c4c2316416ca4b58b775f0279ed068f1)) - aviac
- forgejo-api (#118) - ([db0775c](https://codeberg.org/Aviac/codeberg-cli/commit/db0775cfc5ba7fb8ed67fb5f5f8ddb32457658b6)) - aviac
- add repo delete subcommand (#117) - ([8c46b79](https://codeberg.org/Aviac/codeberg-cli/commit/8c46b79e08f55bd6c498fb488abfc4e69d45a06d)) - JxBP
- add-config-to-support-different-base-url (#111) - ([9a203bf](https://codeberg.org/Aviac/codeberg-cli/commit/9a203bff2bd4773c6e705d7c09677c08101ad234)) - aviac
- print token generation URL for environments without graphical interfaces (#110) - ([7344f03](https://codeberg.org/Aviac/codeberg-cli/commit/7344f03368b9d66d080d59f2dfd1ce569f8e5ada)) - aviac
- add missing confirmation help texts (#101) - ([7abc591](https://codeberg.org/Aviac/codeberg-cli/commit/7abc5913cc966d71be0cc890d4ccb1dca93368b5)) - aviac
- Improve git cloning commands (#100) - ([141eaa6](https://codeberg.org/Aviac/codeberg-cli/commit/141eaa667dc925d0521949cc6077d6becd8725e4)) - Aviac
- add nix flake for development (#95) - ([efe10c8](https://codeberg.org/Aviac/codeberg-cli/commit/efe10c864c62ffef1dfb78e241dc8b0695e2756d)) - Aviac

#### Miscellaneous Chores

- bump version for new release - ([64aa4a5](https://codeberg.org/Aviac/codeberg-cli/commit/64aa4a5e147a83e7765fcc07f57fdff14e90e74e)) - aviac
- remove old workaround code that's merged upstream - ([30b9e42](https://codeberg.org/Aviac/codeberg-cli/commit/30b9e423ecdcdcc7a8dff03af2d49895a0ffe301)) - aviac
- cli-cleanup (#119) - ([ba4da16](https://codeberg.org/Aviac/codeberg-cli/commit/ba4da161ea20458495b3c16e85444e8328c3db07)) - aviac
- make clippy happy - ([1c03b75](https://codeberg.org/Aviac/codeberg-cli/commit/1c03b753fae0caab3565c8cb167a72a04d60e7f8)) - Aviac
- fix/update nix shell - ([581c9c9](https://codeberg.org/Aviac/codeberg-cli/commit/581c9c95d9be6f1fb1e97a057bdd9ffda9a4c0c9)) - Aviac
- more devshell improvements - ([66d8ae6](https://codeberg.org/Aviac/codeberg-cli/commit/66d8ae665f2c4b2b1e214d7b53a95097e94321a6)) - aviac
- add clippy to dev shell - ([2af3f80](https://codeberg.org/Aviac/codeberg-cli/commit/2af3f80da98c10d328ec112fa5bf46b46170ae22)) - aviac
- update Cargo.lock - ([e589a15](https://codeberg.org/Aviac/codeberg-cli/commit/e589a157a1b8a1766ea782e179d391d1cf6c6165)) - aviac
- add dev shell - ([d7f0c75](https://codeberg.org/Aviac/codeberg-cli/commit/d7f0c755d66d019652019302153d6c056b1a29c6)) - aviac
- bump dependencies - ([d6f313d](https://codeberg.org/Aviac/codeberg-cli/commit/d6f313d713e583fc6d901f13b55376e76557c6f4)) - aviac
- f\*\*\* docker, yeet 🚫🐋🚫 - ([837b3dc](https://codeberg.org/Aviac/codeberg-cli/commit/837b3dccfb40a35527387514f74c9df86322a3e4)) - aviac
- cleanup 🧹 - ([073f6d4](https://codeberg.org/Aviac/codeberg-cli/commit/073f6d48af25b8c48a4237cef1672c72de33830b)) - aviac
- add update about fork to readme (#113) - ([9e2c0f8](https://codeberg.org/Aviac/codeberg-cli/commit/9e2c0f827d34a1329b10a509cb055a26d270cb96)) - Aviac
- Update README with nix/nixos installation (#106) - ([3da181c](https://codeberg.org/Aviac/codeberg-cli/commit/3da181c7952d0a6fc712abd804b9fe3908a6b70f)) - aviac
- update Cargo.lock file (#103) - ([a547384](https://codeberg.org/Aviac/codeberg-cli/commit/a54738482b386c4f4ff099665fa811d2584e18ab)) - aviac

______________________________________________________________________

## [v0.3.5](https://codeberg.org/Aviac/codeberg-cli/compare/v0.3.4..v0.3.5) - 2023-05-22

#### Miscellaneous Chores

- Update dependencies and Cargo.lock file (#86) - ([b185044](https://codeberg.org/Aviac/codeberg-cli/commit/b1850444bef36a16bb9512e73802d7ca2151a0bf)) - Aviac

______________________________________________________________________

## [v0.3.4](https://codeberg.org/Aviac/codeberg-cli/compare/v0.3.1..v0.3.4) - 2023-05-22

#### Bug Fixes

- Remove redundant command line argument requirement (#81) - ([cae75b8](https://codeberg.org/Aviac/codeberg-cli/commit/cae75b8c0fe15cc1c177e803c2ec66e6c2140024)) - Aviac
- `pull create` command line argument bug (#80) - ([b1b3117](https://codeberg.org/Aviac/codeberg-cli/commit/b1b311787e38f8051cf221b9016a9a30acf57c4b)) - Aviac

#### Documentation

- add install instructions for Void Linux (#78) - ([8529d98](https://codeberg.org/Aviac/codeberg-cli/commit/8529d985342d1525374a190c7aec9b6295268242)) - Marcin Puc

#### Features

- Implement Interactive Mode (#82) (for `pull create`) - ([459ef56](https://codeberg.org/Aviac/codeberg-cli/commit/459ef56c795506aadbc613784949704f9f80b96d)) - Aviac

#### Miscellaneous Chores

- March Release (#83) - ([0a15b5e](https://codeberg.org/Aviac/codeberg-cli/commit/0a15b5e22f06c6a9e95236bad361675f87465e7b)) - Aviac

______________________________________________________________________

## [v0.3.1](https://codeberg.org/Aviac/codeberg-cli/compare/244e05f5e013e5a6d620257719924cb93694bc0d..v0.3.1) - 2023-05-22

#### Bug Fixes

- **(README)** fix aspect ratio of logo on mobile page - ([745d1de](https://codeberg.org/Aviac/codeberg-cli/commit/745d1de6588923a23c383220f5a4e435e7ea53e2)) - Aviac
- **(clone/fork)** make actions work with origanizations - ([d1497e5](https://codeberg.org/Aviac/codeberg-cli/commit/d1497e567c76d30a2b18e8a297b0a0a39bf4c316)) - Aviac
- **(fork)** fix clone after fork action - ([448c759](https://codeberg.org/Aviac/codeberg-cli/commit/448c759f1a320db3018711c2c7ca8170e418d3ef)) - Aviac
- **(logo)** logo in cli now displayed properly on errors - ([23d849b](https://codeberg.org/Aviac/codeberg-cli/commit/23d849bd496d8357bc6c3470dcb1ed74b5035247)) - Aviac
- **(milestone)** Remove duplicate issues from milestone view action (#53) - ([83a1a2b](https://codeberg.org/Aviac/codeberg-cli/commit/83a1a2bbd4aac14d04cab5ab435d6c4fbbb31883)) - Aviac
- **(render)** fix table rendering bug in own fork and use it - ([8eda4e3](https://codeberg.org/Aviac/codeberg-cli/commit/8eda4e376b7b43a3b9b76bef6799be8d543f401c)) - Aviac
- **(tests)** delete failing test (#76) - ([c5c9531](https://codeberg.org/Aviac/codeberg-cli/commit/c5c9531a62d3acb9c11382e83d278b8352b53737)) - Aviac
- **(upstream-bug)** Implement `term-table` fix in this crate (#58) - ([9safe65e](https://codeberg.org/Aviac/codeberg-cli/commit/9afe65e68a2e5356b7c31b9528829d0f028293cf)) - Aviac
- undo 1.0.0 release and do 0.3.0 release instead - ([94a2950](https://codeberg.org/Aviac/codeberg-cli/commit/94a2950b068ff47a4d7a19927b9098da2ae92f39)) - Aviac

#### Build system

- **(CI)** format to make CI pass - ([fcda678](https://codeberg.org/Aviac/codeberg-cli/commit/fcda6785cda6953928439c65fa31e7ac971a11a4)) - Aviac
- **(CI)** add initial CI config (#33) - ([6acf363](https://codeberg.org/Aviac/codeberg-cli/commit/6acf3631b946545f847bacc48948194ba13a4c81)) - Marcin Puc
- **(release)** hotfix for packaging - ([9691e02](https://codeberg.org/Aviac/codeberg-cli/commit/9691e02e53346eb29117b233ad2002a6e11a52ad)) - Aviac
- update Cargo.lock - ([e7a3294](https://codeberg.org/Aviac/codeberg-cli/commit/e7a3294fc1c65342cb123424a5cf1d92a6ac1dca)) - Aviac

#### Continuous Integration

- make cocogitto install locked and versioned (#69) - ([1891984](https://codeberg.org/Aviac/codeberg-cli/commit/18919847cef1c0436fff0cbc78aaca9c50ac5dad)) - Marcin Puc
- fix ci for forks - ([e48ae80](https://codeberg.org/Aviac/codeberg-cli/commit/e48ae804804d3217c2f92382881142f7d01b757e)) - Aviac
- adapt CI to also work on main branch - ([79b4c5a](https://codeberg.org/Aviac/codeberg-cli/commit/79b4c5a7cd4b03ad6900f95069c40d72410e54e5)) - Aviac

#### Documentation

- **(CHANGELOG)** init changelog at v0.2.0 - ([0d9a36b](https://codeberg.org/Aviac/codeberg-cli/commit/0d9a36be7189196827c918645503a4c080c9220e)) - Aviac
- **(README)** update README gifs, now created with vhs - ([4faf8ab](https://codeberg.org/Aviac/codeberg-cli/commit/4faf8abc71568b60cabefdb0a0c5057fe49533a1)) - Aviac
- **(README)** Update Readme with CI (#61) - ([9890f68](https://codeberg.org/Aviac/codeberg-cli/commit/9890f68bd06dc0497fca0cf8befbb9db744f30ae)) - Aviac
- **(README)** add README for sub-crates - ([6e1e545](https://codeberg.org/Aviac/codeberg-cli/commit/6e1e545cc8d0de4dcdc936597fb55dc2ca6ab472)) - Aviac
- **(README)** Update Readme with `cod -h` changes (#45) - ([2f2092d](https://codeberg.org/Aviac/codeberg-cli/commit/2f2092dbbea1be5aca9b1443b1b173f4dfce64e9)) - Aviac
- **(README)** extend installation section - ([e7820de](https://codeberg.org/Aviac/codeberg-cli/commit/e7820defba671df5a6ceed11387eab9ad2a63cba)) - Aviac
- **(README)** get the gif right this time - ([b46cecc](https://codeberg.org/Aviac/codeberg-cli/commit/b46cecc4e6fa15c894f9d71a7a9a2aff9cb695bd)) - Aviac
- **(README)** improve gif - ([ddacbe2](https://codeberg.org/Aviac/codeberg-cli/commit/ddacbe292e1b0a70f0e8ee6852816f464353b52f)) - Aviac
- **(README)** fix gif link - ([9305906](https://codeberg.org/Aviac/codeberg-cli/commit/9305906019331741e810d45de6cce7cffa03c76e)) - Aviac
- **(README)** add showcase to README - ([d9c3f81](https://codeberg.org/Aviac/codeberg-cli/commit/d9c3f811096ce6e9ed2ac95978fd28784df3bcdb)) - Aviac
- **(README)** update `README.md` - ([2cf587e](https://codeberg.org/Aviac/codeberg-cli/commit/2cf587e93290384fd880c697aad9ff7856ffb2b2)) - Aviac
- **(cli)** document all CLI actions and argsCloses #16 - ([d0e22de](https://codeberg.org/Aviac/codeberg-cli/commit/d0e22defdb56f800532fabf2c7c9c6ba9fe3c328)) - Aviac
- **(logo)** create simplistic logo - ([e0c006f](https://codeberg.org/Aviac/codeberg-cli/commit/e0c006f92f7de257d98c398cbc80e6cfa56b9824)) - Aviac
- **(sources)** update api reference link + description - ([e3075c1](https://codeberg.org/Aviac/codeberg-cli/commit/e3075c183bbc50a337799d3fa7cc7ab9ea983f1c)) - Aviac
- **(sources)** sources for api docs in README - ([6493580](https://codeberg.org/Aviac/codeberg-cli/commit/6493580d9355aaa9086d8d18d0b78e54a483c0b0)) - Aviac
- Establish conventional commit format (#67) - ([61c9377](https://codeberg.org/Aviac/codeberg-cli/commit/61c9377951527355385630fda6c750f7f91fb190)) - Aviac

#### Features

- **(actions)** Implement notification actions (#63) - ([71c7abf](https://codeberg.org/Aviac/codeberg-cli/commit/71c7abf9ff316f1513749319d24d70fdc091815c)) - Aviac
- **(actions)** Implement CLI edit labels of issues/pulls (#59) - ([a3f4b4e](https://codeberg.org/Aviac/codeberg-cli/commit/a3f4b4e95d0dd96e56a65e4a425a9f86568558b7)) - Aviac
- **(actions)** Implement `milestone edit` action (#55) - ([46164c4](https://codeberg.org/Aviac/codeberg-cli/commit/46164c40a5b4e293a405fa500fe37017f6612d88)) - Aviac
- **(actions)** Implement `milestone create` action (#54) - ([10272ba](https://codeberg.org/Aviac/codeberg-cli/commit/10272bae57fc9bc3ef94cc6951ca298a6ddfc21f)) - Aviac
- **(actions)** Implement Milestone View Action (#51) - ([3480693](https://codeberg.org/Aviac/codeberg-cli/commit/3480693dbe72151222e8b92ef5c1cd11935bb815)) - Aviac
- **(actions)** Implement default branch selection for `pull create` action (#48) - ([7277056](https://codeberg.org/Aviac/codeberg-cli/commit/7277056dad5e733d8acc61cc1ffe26773188267b)) - Aviac
- **(actions)** Improve Pull Request Action (#41) - ([0b04389](https://codeberg.org/Aviac/codeberg-cli/commit/0b043891621254245d883932042b535e5cbb7382)) - Aviac
- **(actions)** Implement edit label action (#31) - ([f6356b0](https://codeberg.org/Aviac/codeberg-cli/commit/f6356b0658ea1eab42f3e66c9da73ed8b0b09e90)) - Aviac
- **(actions+refactor)** see details - ([f75269a](https://codeberg.org/Aviac/codeberg-cli/commit/f75269a742cf106f75519b07ee7d241becd857a8)) - Aviac
- **(api-types)** add real types for deserialization - ([29f37ac](https://codeberg.org/Aviac/codeberg-cli/commit/29f37ac0ff3f7443fdacf598216b8b4afe9473d2)) - Aviac
- **(auth)** implement login workflow - ([c7d44cf](https://codeberg.org/Aviac/codeberg-cli/commit/c7d44cfacada76141f614ca307651335dfc43d91)) - Aviac
- **(bin)** update bin (see details) - ([e47947b](https://codeberg.org/Aviac/codeberg-cli/commit/e47947bfdb543bafe48de79a53b1014cfd23fbf3)) - Aviac
- **(cli)** Implement CLI milestone options (#46) - ([77f017b](https://codeberg.org/Aviac/codeberg-cli/commit/77f017b8d91667984ae99a52b548061f04ea5d65)) - Aviac
- **(cli)** label names instead of ids in create issue - ([152774d](https://codeberg.org/Aviac/codeberg-cli/commit/152774da54f67de267b1afc8fa3d7b54858843ce)) - Aviac
- **(cli)** use `ValueEnum` for visibility arguments - ([fd7c8a5](https://codeberg.org/Aviac/codeberg-cli/commit/fd7c8a579047359fa89fa3e28ad5f2ad2b678f06)) - Aviac
- **(cli)** add logo when displaying long help - ([cc69a2f](https://codeberg.org/Aviac/codeberg-cli/commit/cc69a2f1ad33b22478a50aedd4030aeb107ff710)) - Aviac
- **(completion)** add shell autocompletion generation action - ([dbe649d](https://codeberg.org/Aviac/codeberg-cli/commit/dbe649dc67cc4cbe2c7a5cc137f2782eaa4de6e7)) - Marcin Puc
- **(deps)** add `tracing` crate for logging - ([a9a550c](https://codeberg.org/Aviac/codeberg-cli/commit/a9a550cba70eaeaea8de5b7b055f3bf870a94222)) - Aviac
- **(endpoints)** implement endpoint generator - ([4b1a392](https://codeberg.org/Aviac/codeberg-cli/commit/4b1a3924423e065428daac23196abd5c8aa4c0f9)) - Aviac
- **(endpoints)** add new endpoint for user info - ([51a6956](https://codeberg.org/Aviac/codeberg-cli/commit/51a69566e3cded1b5f1c1f322bb7b7cf88358509)) - Aviac
- **(git-info)** add module to get git-info - ([d74a8a2](https://codeberg.org/Aviac/codeberg-cli/commit/d74a8a268e1c2bde39a74acbbf50ab3e230d88b2)) - Aviac
- **(info)** polish user info action - ([4486029](https://codeberg.org/Aviac/codeberg-cli/commit/448602922ebf64b52d1982ada42e14cea07b9789)) - Aviac
- **(init)** some initial modelling - ([dfc23b3](https://codeberg.org/Aviac/codeberg-cli/commit/dfc23b310d48c8423e18c2aa4bf68bd3b5cbe020)) - Aviac
- **(issue)** implement issue comment action - ([ca35599](https://codeberg.org/Aviac/codeberg-cli/commit/ca355991a340c154cfd556c65c098c53dfd0f301)) - Aviac
- **(issue)** implement issue view comments action - ([da45e61](https://codeberg.org/Aviac/codeberg-cli/commit/da45e612307852f90dbefd6dc3187a2c96507dc4)) - Aviac
- **(issue)** implement issue edit action - ([ced2060](https://codeberg.org/Aviac/codeberg-cli/commit/ced2060f0ecab56f88990d342b75ccb56101d3d8)) - Aviac
- **(issue)** finish view issue action - ([f8ea3dd](https://codeberg.org/Aviac/codeberg-cli/commit/f8ea3ddca6721a3399d2109b689b07d04d4388ed)) - Aviac
- **(issue+api-types+refactor)** see details- added new issue list action- renamed `frontend` -> `cli`- client uses api-types to parse response - ([014337e](https://codeberg.org/Aviac/codeberg-cli/commit/014337e7446e6ba226b92eae1dd0a5b29e5d2fd1)) - Aviac
- **(label)** add more cli args - ([b7c3ab4](https://codeberg.org/Aviac/codeberg-cli/commit/b7c3ab453b6fb3418f90ea4390668508520cd53d)) - Aviac
- **(label)** implement label delete action - ([ba61892](https://codeberg.org/Aviac/codeberg-cli/commit/ba618925c10347d8351abf07042a84d759b11b01)) - Aviac
- **(label)** implement create label action - ([1a87567](https://codeberg.org/Aviac/codeberg-cli/commit/1a87567a6f24ffcaac14a022a31c90612ec01d36)) - Aviac
- **(label)** implement list labels action - ([ad79cd9](https://codeberg.org/Aviac/codeberg-cli/commit/ad79cd924cb482493f7906a75dbee3970708897a)) - Aviac
- **(line-wrap)** implement line wrap + restructure table module - ([76e95b1](https://codeberg.org/Aviac/codeberg-cli/commit/76e95b11d7b5f47beaf3c8f7b320d8237f98ce8e)) - Aviac
- **(login)** utilize new modules for login action - ([ad32ef8](https://codeberg.org/Aviac/codeberg-cli/commit/ad32ef8fed4076c103098add959c6b0829580c19)) - Aviac
- **(logout)** add new logout action - ([e931f1e](https://codeberg.org/Aviac/codeberg-cli/commit/e931f1ee012755f33db3f6058dc03d71402be543)) - Aviac
- **(milestone)** Initial implementation of `Milestone` and its list action (#43) - ([8cfe54c](https://codeberg.org/Aviac/codeberg-cli/commit/8cfe54cae1534706f0bbd7dd7770d7ecc4773051)) - Aviac
- **(parse)** `serde_json::Value` instead of `JSONResponse` - ([a127cd9](https://codeberg.org/Aviac/codeberg-cli/commit/a127cd97c29e635d5cd71b4ba96c8c18b4c400de)) - Aviac
- **(parsing)** Implement proper Datetime parsing (#60) - ([9adebb6](https://codeberg.org/Aviac/codeberg-cli/commit/9adebb6a66917360b7fc497717bb7a5c15b809b2)) - Aviac
- **(paths)** add module for important paths - ([211fd41](https://codeberg.org/Aviac/codeberg-cli/commit/211fd413133d82fef382d57cd4fc983e4c5a07f5)) - Aviac
- **(pull)** implement pull view and pull comment action - ([60775a5](https://codeberg.org/Aviac/codeberg-cli/commit/60775a5382193bd3873ee4b3d2bc2f26f156c1ee)) - Aviac
- **(pull)** implement pull edit action - ([fae7395](https://codeberg.org/Aviac/codeberg-cli/commit/fae739517b98e5a6774d868b8834509aa6b38d56)) - Aviac
- **(pull)** implement pull create action - ([abd8857](https://codeberg.org/Aviac/codeberg-cli/commit/abd885783dbf45ca1f114a3fa8431115510c3bcc)) - Aviac
- **(pulls)** implement list pulls/issues correctly - ([65c607d](https://codeberg.org/Aviac/codeberg-cli/commit/65c607d5d46bf0c252567e16438867b85ae60806)) - Aviac
- **(render)** create crate for rendering output - ([a716c26](https://codeberg.org/Aviac/codeberg-cli/commit/a716c266032b7edddbd7e1679ff333c1e6eeb0d7)) - Aviac
- **(repo)** implement repo fork action - ([21896ab](https://codeberg.org/Aviac/codeberg-cli/commit/21896ab4efb0564256517d8142d5c77ad57bdbc9)) - Aviac
- **(repo)** implement repo clone action - ([b28c5d1](https://codeberg.org/Aviac/codeberg-cli/commit/b28c5d10cbe0665a51960b54653f9b51cc8ee016)) - Aviac
- **(repo)** implement repo create action - ([ff079bc](https://codeberg.org/Aviac/codeberg-cli/commit/ff079bce9394bf0a49674a8546224cb20a1071c4)) - Aviac
- **(scaffolding)** starting new with `clap` instead of `structopt` - ([0762b54](https://codeberg.org/Aviac/codeberg-cli/commit/0762b54167a07193d04e578671e42829289d8892)) - Aviac
- **(types)** add module for important types - ([d9c089c](https://codeberg.org/Aviac/codeberg-cli/commit/d9c089cd9a252afc7e63d7c6f96150a7a3839d08)) - Aviac
- **(ui)** add texts for all selection promptsCloses #25 - ([61ec354](https://codeberg.org/Aviac/codeberg-cli/commit/61ec3548fe40bb600a2041004db4747be2e750fe)) - Aviac
- **(userinfo)** add new user info action - ([109fbcd](https://codeberg.org/Aviac/codeberg-cli/commit/109fbcdb2140bf69ad710afad10b3c2dfa85c1c4)) - Aviac

#### Miscellaneous Chores

- **(README)** fix broken gifs #4 - ([fae85ca](https://codeberg.org/Aviac/codeberg-cli/commit/fae85ca96b8d326f2bab973e3be10d4a14c6e117)) - Aviac
- **(README)** fix broken gifs #3 - ([44d4b9f](https://codeberg.org/Aviac/codeberg-cli/commit/44d4b9fb71d0f11017dc05242ba71d7d3649cd66)) - Aviac
- **(README)** fix broken gifs #2 - ([46fd4e3](https://codeberg.org/Aviac/codeberg-cli/commit/46fd4e3374f1e04b3f12db3f204d40a7283b766e)) - Aviac
- **(README)** fix broken gifs - ([68e1a7e](https://codeberg.org/Aviac/codeberg-cli/commit/68e1a7ec67d2af9eed69c2993e7b9df0e09cc0b3)) - Aviac
- **(README)** center logo and showcase gif - ([7662481](https://codeberg.org/Aviac/codeberg-cli/commit/76624812a05e647cebd6c147b835cc26e24557b3)) - Aviac
- **(README)** update README for release - ([058523b](https://codeberg.org/Aviac/codeberg-cli/commit/058523b8131e7df8ea01ea401321272149b71c79)) - Aviac
- **(cleanup)** Cleanup before february release (#66) - ([6bcdabb](https://codeberg.org/Aviac/codeberg-cli/commit/6bcdabb24cf14ff388c1e030b6943e7eca930f40)) - Aviac
- **(cleanup)** enable missing tokio features - ([6602d20](https://codeberg.org/Aviac/codeberg-cli/commit/6602d20d72eb38db6a2a2733b4bd934031cd0c6d)) - Aviac
- **(cleanup)** Periodical Cleanup PR (#56) - ([28ecc94](https://codeberg.org/Aviac/codeberg-cli/commit/28ecc94b9719738249a1eb52761af780180a580e)) - Aviac
- **(cleanup)** Cleanup `pull create` action (#49) - ([1afd460](https://codeberg.org/Aviac/codeberg-cli/commit/1afd4605f35c01cbaacf10992b4befd7c0c7dec9)) - Aviac
- **(cleanup)** remove unused import - ([247e5ab](https://codeberg.org/Aviac/codeberg-cli/commit/247e5aba0119076434918e76f576d6716d5b0176)) - Aviac
- **(cleanup)** remove all TODO comments - ([70d59fd](https://codeberg.org/Aviac/codeberg-cli/commit/70d59fde3c4b17cfc3854803207e404982988a43)) - Aviac
- **(docs)** update README installation section - ([ca6ae5e](https://codeberg.org/Aviac/codeberg-cli/commit/ca6ae5e6c5af9cbf932c646e8ffa06bd7ebf3319)) - Aviac
- **(license)** update license - ([dd4d03b](https://codeberg.org/Aviac/codeberg-cli/commit/dd4d03bf5f5eb224cc41a5f581297828ff8fd47c)) - Aviac
- **(org)** add basic Makefile.toml for testing publishing - ([0f8b23c](https://codeberg.org/Aviac/codeberg-cli/commit/0f8b23c386f06485f1ec58c346e92cd73da0bb16)) - Aviac
- **(org)** add missing license fix - ([4137809](https://codeberg.org/Aviac/codeberg-cli/commit/41378091b58bdb79a3d8572a7ff3d8acca92dba3)) - Aviac
- **(org)** adjust license names to make cargo and crates.io happy - ([ad9f255](https://codeberg.org/Aviac/codeberg-cli/commit/ad9f255b12c9093ba84128fecdcce26ca5bafe18)) - Aviac
- **(publish)** bump versions to fix dependencies - ([d97c1ce](https://codeberg.org/Aviac/codeberg-cli/commit/d97c1ce19392f6d48bc480fd7c60b048d8e2d232)) - Aviac
- **(publish)** make workspace crates publish ready - ([3e29497](https://codeberg.org/Aviac/codeberg-cli/commit/3e29497c98ed0b82d633020cbbab3d1bf6fcda5e)) - Aviac
- **(publish)** prepare for publishing - ([f6b4d06](https://codeberg.org/Aviac/codeberg-cli/commit/f6b4d068cb12eb149403e47d22f275ececec2827)) - Aviac
- **(release)** bump versions - ([b963a6e](https://codeberg.org/Aviac/codeberg-cli/commit/b963a6e0b6d52153d67a3069b34e9fe574af852f)) - Aviac
- update Cargo.lock - ([2afbeee](https://codeberg.org/Aviac/codeberg-cli/commit/2afbeee00f3357fb289a206a98e9fa2adad1051e)) - Aviac
- unignore Cargo.lock file - ([605af79](https://codeberg.org/Aviac/codeberg-cli/commit/605af7920b87433589ad309ceb752d508dd8d0fc)) - Marcin Puc

#### Refactoring

- **(actions)** unify action naming scheme - ([52c993f](https://codeberg.org/Aviac/codeberg-cli/commit/52c993f7b8a4e822d2efd846edcea981fa0c3ba3)) - Aviac
- **(cli)** Embed logo from file (#50) - ([a34a1b7](https://codeberg.org/Aviac/codeberg-cli/commit/a34a1b7f981030082091017eb03f81c3ea103369)) - Marcin Puc
- **(cli)** use multiple args for list flags - ([1c41804](https://codeberg.org/Aviac/codeberg-cli/commit/1c41804babe834832d0c2d34442bc4435c0384e9)) - Marcin Puc
- **(client)** factor specialized api calls out into client methods - ([ca625e7](https://codeberg.org/Aviac/codeberg-cli/commit/ca625e7f68a89bb3ea902fae7b96cac6617c64b2)) - Aviac
- **(client)** factor out client in own crate - ([2f6fc46](https://codeberg.org/Aviac/codeberg-cli/commit/2f6fc4693934c3b7f5cb63b4d7e05ce749185678)) - Aviac
- **(crate-layout)** Refactor to non-workspace architecture (#72) - ([bf01628](https://codeberg.org/Aviac/codeberg-cli/commit/bf016282f12fd850b02e7d5bcc8eb68aa7f76f0a)) - Aviac
- **(docs)** switch from help attribute to doc comments - ([55ceb2d](https://codeberg.org/Aviac/codeberg-cli/commit/55ceb2d2f005e15ab307771cb02b7aa0647cef07)) - Marcin Puc
- **(endpoints)** make endpoints ready for reuse - ([3c4afcc](https://codeberg.org/Aviac/codeberg-cli/commit/3c4afcc610fc15795fcd35baae72984f2af8d936)) - Aviac
- **(fuzzy-select)** factoring out specialized multi-fuzzy-select - ([7510059](https://codeberg.org/Aviac/codeberg-cli/commit/7510059c96d59169d51f72b4c29127592c546209)) - Aviac
- **(git-info)** modularize - ([39244f3](https://codeberg.org/Aviac/codeberg-cli/commit/39244f3ea8b3442ea1554116a2ee0f665aa1f7ac)) - Aviac
- **(logging)** use debug! instead of info! - ([79e02f5](https://codeberg.org/Aviac/codeberg-cli/commit/79e02f579839ea1840cd261337f7c844c3024a30)) - Aviac
- **(main)** reduce code repetition - ([b0c163b](https://codeberg.org/Aviac/codeberg-cli/commit/b0c163b190693f6dece94d93b717773b26590e3f)) - Aviac
- **(prompt-ui)** Swap `dialoguer` out for `inquire` (#57) - ([6b5b0ea](https://codeberg.org/Aviac/codeberg-cli/commit/6b5b0ea4e11b5faf9a3e8891605583595bdaf54f)) - Aviac
- **(spinner)** spinner now has its own module - ([1610151](https://codeberg.org/Aviac/codeberg-cli/commit/16101515040bcf318a60cb37b646cd3fd155b4a5)) - Aviac
- **(ux)** Improve Error Messages and Display (#47) - ([a0ee68b](https://codeberg.org/Aviac/codeberg-cli/commit/a0ee68b08925552994ffc17d7378e60b5b2a93de)) - Aviac
- **(workspace)** refactor to use workspaces - ([4d304d7](https://codeberg.org/Aviac/codeberg-cli/commit/4d304d76f2cb2ac6a23db8534d45245ac3b0157e)) - Aviac
