// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package iam

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	iampb "cloud.google.com/go/policytroubleshooter/iam/apiv3/iampb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
)

var newPolicyTroubleshooterClientHook clientHook

// PolicyTroubleshooterCallOptions contains the retry settings for each method of PolicyTroubleshooterClient.
type PolicyTroubleshooterCallOptions struct {
	TroubleshootIamPolicy []gax.CallOption
}

func defaultPolicyTroubleshooterGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("policytroubleshooter.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("policytroubleshooter.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://policytroubleshooter.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultPolicyTroubleshooterCallOptions() *PolicyTroubleshooterCallOptions {
	return &PolicyTroubleshooterCallOptions{
		TroubleshootIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultPolicyTroubleshooterRESTCallOptions() *PolicyTroubleshooterCallOptions {
	return &PolicyTroubleshooterCallOptions{
		TroubleshootIamPolicy: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalPolicyTroubleshooterClient is an interface that defines the methods available from Policy Troubleshooter API.
type internalPolicyTroubleshooterClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	TroubleshootIamPolicy(context.Context, *iampb.TroubleshootIamPolicyRequest, ...gax.CallOption) (*iampb.TroubleshootIamPolicyResponse, error)
}

// PolicyTroubleshooterClient is a client for interacting with Policy Troubleshooter API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// IAM Policy Troubleshooter service.
//
// This service helps you troubleshoot access issues for Google Cloud resources.
type PolicyTroubleshooterClient struct {
	// The internal transport-dependent client.
	internalClient internalPolicyTroubleshooterClient

	// The call options for this service.
	CallOptions *PolicyTroubleshooterCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *PolicyTroubleshooterClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *PolicyTroubleshooterClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *PolicyTroubleshooterClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// TroubleshootIamPolicy checks whether a principal has a specific permission for a specific
// resource, and explains why the principal does or doesn’t have that
// permission.
func (c *PolicyTroubleshooterClient) TroubleshootIamPolicy(ctx context.Context, req *iampb.TroubleshootIamPolicyRequest, opts ...gax.CallOption) (*iampb.TroubleshootIamPolicyResponse, error) {
	return c.internalClient.TroubleshootIamPolicy(ctx, req, opts...)
}

// policyTroubleshooterGRPCClient is a client for interacting with Policy Troubleshooter API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type policyTroubleshooterGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing PolicyTroubleshooterClient
	CallOptions **PolicyTroubleshooterCallOptions

	// The gRPC API client.
	policyTroubleshooterClient iampb.PolicyTroubleshooterClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewPolicyTroubleshooterClient creates a new policy troubleshooter client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// IAM Policy Troubleshooter service.
//
// This service helps you troubleshoot access issues for Google Cloud resources.
func NewPolicyTroubleshooterClient(ctx context.Context, opts ...option.ClientOption) (*PolicyTroubleshooterClient, error) {
	clientOpts := defaultPolicyTroubleshooterGRPCClientOptions()
	if newPolicyTroubleshooterClientHook != nil {
		hookOpts, err := newPolicyTroubleshooterClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := PolicyTroubleshooterClient{CallOptions: defaultPolicyTroubleshooterCallOptions()}

	c := &policyTroubleshooterGRPCClient{
		connPool:                   connPool,
		policyTroubleshooterClient: iampb.NewPolicyTroubleshooterClient(connPool),
		CallOptions:                &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *policyTroubleshooterGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *policyTroubleshooterGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *policyTroubleshooterGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type policyTroubleshooterRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing PolicyTroubleshooterClient
	CallOptions **PolicyTroubleshooterCallOptions
}

// NewPolicyTroubleshooterRESTClient creates a new policy troubleshooter rest client.
//
// IAM Policy Troubleshooter service.
//
// This service helps you troubleshoot access issues for Google Cloud resources.
func NewPolicyTroubleshooterRESTClient(ctx context.Context, opts ...option.ClientOption) (*PolicyTroubleshooterClient, error) {
	clientOpts := append(defaultPolicyTroubleshooterRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultPolicyTroubleshooterRESTCallOptions()
	c := &policyTroubleshooterRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &PolicyTroubleshooterClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultPolicyTroubleshooterRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://policytroubleshooter.googleapis.com"),
		internaloption.WithDefaultMTLSEndpoint("https://policytroubleshooter.mtls.googleapis.com"),
		internaloption.WithDefaultAudience("https://policytroubleshooter.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *policyTroubleshooterRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *policyTroubleshooterRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *policyTroubleshooterRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *policyTroubleshooterGRPCClient) TroubleshootIamPolicy(ctx context.Context, req *iampb.TroubleshootIamPolicyRequest, opts ...gax.CallOption) (*iampb.TroubleshootIamPolicyResponse, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).TroubleshootIamPolicy[0:len((*c.CallOptions).TroubleshootIamPolicy):len((*c.CallOptions).TroubleshootIamPolicy)], opts...)
	var resp *iampb.TroubleshootIamPolicyResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.policyTroubleshooterClient.TroubleshootIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// TroubleshootIamPolicy checks whether a principal has a specific permission for a specific
// resource, and explains why the principal does or doesn’t have that
// permission.
func (c *policyTroubleshooterRESTClient) TroubleshootIamPolicy(ctx context.Context, req *iampb.TroubleshootIamPolicyRequest, opts ...gax.CallOption) (*iampb.TroubleshootIamPolicyResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v3/iam:troubleshoot")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).TroubleshootIamPolicy[0:len((*c.CallOptions).TroubleshootIamPolicy):len((*c.CallOptions).TroubleshootIamPolicy)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &iampb.TroubleshootIamPolicyResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
