#include <unistd.h>
#include <string.h>
#include "outbuf.h"
#include "strerr.h"
#include "cdb.h"

#ifdef CDB64
#define FATAL "cdb64get: fatal: "
#else
#define FATAL "cdbget: fatal: "
#endif

static void die_read(void)
{
  strerr_die2sys(111,FATAL,"unable to read input: ");
}
static void die_write(void)
{
  strerr_die2sys(111,FATAL,"unable to write output: ");
}
static void die_usage(void)
{
  strerr_die1x(111,"cdbget: usage: cdbget key [skip]");
}

static struct cdb c;
static char buf[1024];

int main(int argc,char **argv)
{
  char *key;
  num r;
  num pos;
  num len;
  num u = 0;

  if (!*argv) die_usage();
  
  if (!*++argv) die_usage();
  key = *argv;

  if (*++argv)
    u = num_fromstring_allowoverflow(*argv);

  cdb_init(&c,0);
  cdb_findstart(&c);

  for (;;) {
    r = cdb_findnext(&c,key,strlen(key));
    if (r == -1) die_read();
    if (!r) _exit(100);
    if (!u) break;
    --u;
  }

  pos = cdb_datapos(&c);
  len = cdb_datalen(&c);

  while (len > 0) {
    r = sizeof buf;
    if (r > len) r = len;
    if (cdb_read(&c,buf,r,pos) == -1) die_read();
    if (outbuf_put(outbuf_1small,buf,r) == -1) die_write();
    pos += r;
    len -= r;
  }
  if (outbuf_flush(outbuf_1small) == -1) die_write();
  _exit(0);
  return 0;
}
