// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2-devel
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/plugin_curation.proto

package registryv1alpha1

import (
	v1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/image/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	pluginpb "google.golang.org/protobuf/types/pluginpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// CuratedPluginVisibility defines the visibility options available
// for Curated Plugins.
type CuratedPluginVisibility int32

const (
	CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_UNSPECIFIED CuratedPluginVisibility = 0
	CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_PUBLIC      CuratedPluginVisibility = 1
	CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_PRIVATE     CuratedPluginVisibility = 2
)

// Enum value maps for CuratedPluginVisibility.
var (
	CuratedPluginVisibility_name = map[int32]string{
		0: "CURATED_PLUGIN_VISIBILITY_UNSPECIFIED",
		1: "CURATED_PLUGIN_VISIBILITY_PUBLIC",
		2: "CURATED_PLUGIN_VISIBILITY_PRIVATE",
	}
	CuratedPluginVisibility_value = map[string]int32{
		"CURATED_PLUGIN_VISIBILITY_UNSPECIFIED": 0,
		"CURATED_PLUGIN_VISIBILITY_PUBLIC":      1,
		"CURATED_PLUGIN_VISIBILITY_PRIVATE":     2,
	}
)

func (x CuratedPluginVisibility) Enum() *CuratedPluginVisibility {
	p := new(CuratedPluginVisibility)
	*p = x
	return p
}

func (x CuratedPluginVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CuratedPluginVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[0].Descriptor()
}

func (CuratedPluginVisibility) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[0]
}

func (x CuratedPluginVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CuratedPluginVisibility.Descriptor instead.
func (CuratedPluginVisibility) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{0}
}

// The supported plugin registries for curated plugins.
type PluginRegistryType int32

const (
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED PluginRegistryType = 0
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_GO          PluginRegistryType = 1
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_NPM         PluginRegistryType = 2
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_MAVEN       PluginRegistryType = 3
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_SWIFT       PluginRegistryType = 4
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_PYTHON      PluginRegistryType = 5
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_CARGO       PluginRegistryType = 7
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_NUGET       PluginRegistryType = 8
	PluginRegistryType_PLUGIN_REGISTRY_TYPE_CMAKE       PluginRegistryType = 9
)

// Enum value maps for PluginRegistryType.
var (
	PluginRegistryType_name = map[int32]string{
		0: "PLUGIN_REGISTRY_TYPE_UNSPECIFIED",
		1: "PLUGIN_REGISTRY_TYPE_GO",
		2: "PLUGIN_REGISTRY_TYPE_NPM",
		3: "PLUGIN_REGISTRY_TYPE_MAVEN",
		4: "PLUGIN_REGISTRY_TYPE_SWIFT",
		5: "PLUGIN_REGISTRY_TYPE_PYTHON",
		7: "PLUGIN_REGISTRY_TYPE_CARGO",
		8: "PLUGIN_REGISTRY_TYPE_NUGET",
		9: "PLUGIN_REGISTRY_TYPE_CMAKE",
	}
	PluginRegistryType_value = map[string]int32{
		"PLUGIN_REGISTRY_TYPE_UNSPECIFIED": 0,
		"PLUGIN_REGISTRY_TYPE_GO":          1,
		"PLUGIN_REGISTRY_TYPE_NPM":         2,
		"PLUGIN_REGISTRY_TYPE_MAVEN":       3,
		"PLUGIN_REGISTRY_TYPE_SWIFT":       4,
		"PLUGIN_REGISTRY_TYPE_PYTHON":      5,
		"PLUGIN_REGISTRY_TYPE_CARGO":       7,
		"PLUGIN_REGISTRY_TYPE_NUGET":       8,
		"PLUGIN_REGISTRY_TYPE_CMAKE":       9,
	}
)

func (x PluginRegistryType) Enum() *PluginRegistryType {
	p := new(PluginRegistryType)
	*p = x
	return p
}

func (x PluginRegistryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginRegistryType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[1].Descriptor()
}

func (PluginRegistryType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[1]
}

func (x PluginRegistryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginRegistryType.Descriptor instead.
func (PluginRegistryType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{1}
}

// PluginLanguage is used to specify the output languages a plugin supports.
type PluginLanguage int32

const (
	PluginLanguage_PLUGIN_LANGUAGE_UNSPECIFIED PluginLanguage = 0
	PluginLanguage_PLUGIN_LANGUAGE_GO          PluginLanguage = 1
	PluginLanguage_PLUGIN_LANGUAGE_JAVASCRIPT  PluginLanguage = 2
	PluginLanguage_PLUGIN_LANGUAGE_TYPESCRIPT  PluginLanguage = 3
	PluginLanguage_PLUGIN_LANGUAGE_SWIFT       PluginLanguage = 4
	PluginLanguage_PLUGIN_LANGUAGE_CPP         PluginLanguage = 5
	PluginLanguage_PLUGIN_LANGUAGE_JAVA        PluginLanguage = 6
	PluginLanguage_PLUGIN_LANGUAGE_DART        PluginLanguage = 7
	PluginLanguage_PLUGIN_LANGUAGE_RUST        PluginLanguage = 8
	PluginLanguage_PLUGIN_LANGUAGE_PYTHON      PluginLanguage = 9
	PluginLanguage_PLUGIN_LANGUAGE_RUBY        PluginLanguage = 10
	PluginLanguage_PLUGIN_LANGUAGE_KOTLIN      PluginLanguage = 11
	PluginLanguage_PLUGIN_LANGUAGE_OBJECTIVE_C PluginLanguage = 12
	PluginLanguage_PLUGIN_LANGUAGE_PHP         PluginLanguage = 13
	PluginLanguage_PLUGIN_LANGUAGE_CSHARP      PluginLanguage = 14
	PluginLanguage_PLUGIN_LANGUAGE_SCALA       PluginLanguage = 15
	PluginLanguage_PLUGIN_LANGUAGE_C           PluginLanguage = 16
)

// Enum value maps for PluginLanguage.
var (
	PluginLanguage_name = map[int32]string{
		0:  "PLUGIN_LANGUAGE_UNSPECIFIED",
		1:  "PLUGIN_LANGUAGE_GO",
		2:  "PLUGIN_LANGUAGE_JAVASCRIPT",
		3:  "PLUGIN_LANGUAGE_TYPESCRIPT",
		4:  "PLUGIN_LANGUAGE_SWIFT",
		5:  "PLUGIN_LANGUAGE_CPP",
		6:  "PLUGIN_LANGUAGE_JAVA",
		7:  "PLUGIN_LANGUAGE_DART",
		8:  "PLUGIN_LANGUAGE_RUST",
		9:  "PLUGIN_LANGUAGE_PYTHON",
		10: "PLUGIN_LANGUAGE_RUBY",
		11: "PLUGIN_LANGUAGE_KOTLIN",
		12: "PLUGIN_LANGUAGE_OBJECTIVE_C",
		13: "PLUGIN_LANGUAGE_PHP",
		14: "PLUGIN_LANGUAGE_CSHARP",
		15: "PLUGIN_LANGUAGE_SCALA",
		16: "PLUGIN_LANGUAGE_C",
	}
	PluginLanguage_value = map[string]int32{
		"PLUGIN_LANGUAGE_UNSPECIFIED": 0,
		"PLUGIN_LANGUAGE_GO":          1,
		"PLUGIN_LANGUAGE_JAVASCRIPT":  2,
		"PLUGIN_LANGUAGE_TYPESCRIPT":  3,
		"PLUGIN_LANGUAGE_SWIFT":       4,
		"PLUGIN_LANGUAGE_CPP":         5,
		"PLUGIN_LANGUAGE_JAVA":        6,
		"PLUGIN_LANGUAGE_DART":        7,
		"PLUGIN_LANGUAGE_RUST":        8,
		"PLUGIN_LANGUAGE_PYTHON":      9,
		"PLUGIN_LANGUAGE_RUBY":        10,
		"PLUGIN_LANGUAGE_KOTLIN":      11,
		"PLUGIN_LANGUAGE_OBJECTIVE_C": 12,
		"PLUGIN_LANGUAGE_PHP":         13,
		"PLUGIN_LANGUAGE_CSHARP":      14,
		"PLUGIN_LANGUAGE_SCALA":       15,
		"PLUGIN_LANGUAGE_C":           16,
	}
)

func (x PluginLanguage) Enum() *PluginLanguage {
	p := new(PluginLanguage)
	*p = x
	return p
}

func (x PluginLanguage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginLanguage) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[2].Descriptor()
}

func (PluginLanguage) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[2]
}

func (x PluginLanguage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PluginLanguage.Descriptor instead.
func (PluginLanguage) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2}
}

// NPMImportStyle is used to specify the import style the plugin supports.
type NPMImportStyle int32

const (
	NPMImportStyle_NPM_IMPORT_STYLE_UNSPECIFIED NPMImportStyle = 0
	NPMImportStyle_NPM_IMPORT_STYLE_MODULE      NPMImportStyle = 1
	NPMImportStyle_NPM_IMPORT_STYLE_COMMONJS    NPMImportStyle = 2
)

// Enum value maps for NPMImportStyle.
var (
	NPMImportStyle_name = map[int32]string{
		0: "NPM_IMPORT_STYLE_UNSPECIFIED",
		1: "NPM_IMPORT_STYLE_MODULE",
		2: "NPM_IMPORT_STYLE_COMMONJS",
	}
	NPMImportStyle_value = map[string]int32{
		"NPM_IMPORT_STYLE_UNSPECIFIED": 0,
		"NPM_IMPORT_STYLE_MODULE":      1,
		"NPM_IMPORT_STYLE_COMMONJS":    2,
	}
)

func (x NPMImportStyle) Enum() *NPMImportStyle {
	p := new(NPMImportStyle)
	*p = x
	return p
}

func (x NPMImportStyle) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NPMImportStyle) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[3].Descriptor()
}

func (NPMImportStyle) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[3]
}

func (x NPMImportStyle) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NPMImportStyle.Descriptor instead.
func (NPMImportStyle) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{3}
}

// SwiftPlatformType is used to specify the platform type for a Swift plugins minimum compatible version.
type SwiftPlatformType int32

const (
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_UNSPECIFIED SwiftPlatformType = 0
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_MACOS       SwiftPlatformType = 1
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_IOS         SwiftPlatformType = 2
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_WATCHOS     SwiftPlatformType = 3
	SwiftPlatformType_SWIFT_PLATFORM_TYPE_TVOS        SwiftPlatformType = 4
)

// Enum value maps for SwiftPlatformType.
var (
	SwiftPlatformType_name = map[int32]string{
		0: "SWIFT_PLATFORM_TYPE_UNSPECIFIED",
		1: "SWIFT_PLATFORM_TYPE_MACOS",
		2: "SWIFT_PLATFORM_TYPE_IOS",
		3: "SWIFT_PLATFORM_TYPE_WATCHOS",
		4: "SWIFT_PLATFORM_TYPE_TVOS",
	}
	SwiftPlatformType_value = map[string]int32{
		"SWIFT_PLATFORM_TYPE_UNSPECIFIED": 0,
		"SWIFT_PLATFORM_TYPE_MACOS":       1,
		"SWIFT_PLATFORM_TYPE_IOS":         2,
		"SWIFT_PLATFORM_TYPE_WATCHOS":     3,
		"SWIFT_PLATFORM_TYPE_TVOS":        4,
	}
)

func (x SwiftPlatformType) Enum() *SwiftPlatformType {
	p := new(SwiftPlatformType)
	*p = x
	return p
}

func (x SwiftPlatformType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SwiftPlatformType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[4].Descriptor()
}

func (SwiftPlatformType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[4]
}

func (x SwiftPlatformType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SwiftPlatformType.Descriptor instead.
func (SwiftPlatformType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{4}
}

// PythonPackageType is used to specify the package type for a Python Generated SDK.
type PythonPackageType int32

const (
	PythonPackageType_PYTHON_PACKAGE_TYPE_UNSPECIFIED PythonPackageType = 0
	// Regular Python package, containing Python runtime code (`.py` files).
	PythonPackageType_PYTHON_PACKAGE_TYPE_RUNTIME PythonPackageType = 1
	// Stub-only package, containing only `.pyi` files.
	// Ref: https://peps.python.org/pep-0561/#stub-only-packages
	PythonPackageType_PYTHON_PACKAGE_TYPE_STUB_ONLY PythonPackageType = 2
)

// Enum value maps for PythonPackageType.
var (
	PythonPackageType_name = map[int32]string{
		0: "PYTHON_PACKAGE_TYPE_UNSPECIFIED",
		1: "PYTHON_PACKAGE_TYPE_RUNTIME",
		2: "PYTHON_PACKAGE_TYPE_STUB_ONLY",
	}
	PythonPackageType_value = map[string]int32{
		"PYTHON_PACKAGE_TYPE_UNSPECIFIED": 0,
		"PYTHON_PACKAGE_TYPE_RUNTIME":     1,
		"PYTHON_PACKAGE_TYPE_STUB_ONLY":   2,
	}
)

func (x PythonPackageType) Enum() *PythonPackageType {
	p := new(PythonPackageType)
	*p = x
	return p
}

func (x PythonPackageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PythonPackageType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[5].Descriptor()
}

func (PythonPackageType) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[5]
}

func (x PythonPackageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PythonPackageType.Descriptor instead.
func (PythonPackageType) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{5}
}

// DotnetTargetFramework specifies the target framework for dotnet plugins.
// This is not meant to be an exhaustive list - most plugins should target a
// netstandard version.
// Reference: https://learn.microsoft.com/en-us/dotnet/standard/frameworks
type DotnetTargetFramework int32

const (
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_UNSPECIFIED     DotnetTargetFramework = 0
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0 DotnetTargetFramework = 1
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1 DotnetTargetFramework = 2
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2 DotnetTargetFramework = 3
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3 DotnetTargetFramework = 4
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4 DotnetTargetFramework = 5
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5 DotnetTargetFramework = 6
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6 DotnetTargetFramework = 7
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0 DotnetTargetFramework = 8
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1 DotnetTargetFramework = 9
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_5_0         DotnetTargetFramework = 10
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_6_0         DotnetTargetFramework = 11
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_7_0         DotnetTargetFramework = 12
	DotnetTargetFramework_DOTNET_TARGET_FRAMEWORK_NET_8_0         DotnetTargetFramework = 13
)

// Enum value maps for DotnetTargetFramework.
var (
	DotnetTargetFramework_name = map[int32]string{
		0:  "DOTNET_TARGET_FRAMEWORK_UNSPECIFIED",
		1:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0",
		2:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1",
		3:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2",
		4:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3",
		5:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4",
		6:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5",
		7:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6",
		8:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0",
		9:  "DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1",
		10: "DOTNET_TARGET_FRAMEWORK_NET_5_0",
		11: "DOTNET_TARGET_FRAMEWORK_NET_6_0",
		12: "DOTNET_TARGET_FRAMEWORK_NET_7_0",
		13: "DOTNET_TARGET_FRAMEWORK_NET_8_0",
	}
	DotnetTargetFramework_value = map[string]int32{
		"DOTNET_TARGET_FRAMEWORK_UNSPECIFIED":     0,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_0": 1,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_1": 2,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_2": 3,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_3": 4,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_4": 5,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_5": 6,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_1_6": 7,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_0": 8,
		"DOTNET_TARGET_FRAMEWORK_NETSTANDARD_2_1": 9,
		"DOTNET_TARGET_FRAMEWORK_NET_5_0":         10,
		"DOTNET_TARGET_FRAMEWORK_NET_6_0":         11,
		"DOTNET_TARGET_FRAMEWORK_NET_7_0":         12,
		"DOTNET_TARGET_FRAMEWORK_NET_8_0":         13,
	}
)

func (x DotnetTargetFramework) Enum() *DotnetTargetFramework {
	p := new(DotnetTargetFramework)
	*p = x
	return p
}

func (x DotnetTargetFramework) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DotnetTargetFramework) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[6].Descriptor()
}

func (DotnetTargetFramework) Type() protoreflect.EnumType {
	return &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes[6]
}

func (x DotnetTargetFramework) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DotnetTargetFramework.Descriptor instead.
func (DotnetTargetFramework) EnumDescriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{6}
}

// GoConfig is the configuration for a Go plugin.
type GoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*GoConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// The minimum Go version required by the plugin.
	MinimumVersion string `protobuf:"bytes,2,opt,name=minimum_version,json=minimumVersion,proto3" json:"minimum_version,omitempty"`
}

func (x *GoConfig) Reset() {
	*x = GoConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoConfig) ProtoMessage() {}

func (x *GoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoConfig.ProtoReflect.Descriptor instead.
func (*GoConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{0}
}

func (x *GoConfig) GetRuntimeLibraries() []*GoConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *GoConfig) GetMinimumVersion() string {
	if x != nil {
		return x.MinimumVersion
	}
	return ""
}

// NPMConfig is the configuration for a JavaScript NPM plugin.
type NPMConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*NPMConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// Optionally define a configuration for rewriting import paths, a feature mainly
	// used for remote code generation in the BSR npm registry, which makes it possible
	// to serve the output of a BSR module and a plugin in an individual package.
	//
	// All plugins based on @bufbuild/protoplugin support the option "rewrite_imports".
	// Setting this value, i.e. "connectweb.js" or "pb.js", informs the BSR npm registry
	// that the plugin supports import rewrites with the given import suffix.
	RewriteImportPathSuffix string `protobuf:"bytes,2,opt,name=rewrite_import_path_suffix,json=rewriteImportPathSuffix,proto3" json:"rewrite_import_path_suffix,omitempty"`
	// The import style used for the "type" field in the package.json file.
	// This exists to support legacy plugins that require "commonjs" support.
	ImportStyle NPMImportStyle `protobuf:"varint,3,opt,name=import_style,json=importStyle,proto3,enum=buf.alpha.registry.v1alpha1.NPMImportStyle" json:"import_style,omitempty"`
}

func (x *NPMConfig) Reset() {
	*x = NPMConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NPMConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NPMConfig) ProtoMessage() {}

func (x *NPMConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NPMConfig.ProtoReflect.Descriptor instead.
func (*NPMConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{1}
}

func (x *NPMConfig) GetRuntimeLibraries() []*NPMConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *NPMConfig) GetRewriteImportPathSuffix() string {
	if x != nil {
		return x.RewriteImportPathSuffix
	}
	return ""
}

func (x *NPMConfig) GetImportStyle() NPMImportStyle {
	if x != nil {
		return x.ImportStyle
	}
	return NPMImportStyle_NPM_IMPORT_STYLE_UNSPECIFIED
}

// MavenConfig is the configuration for a Maven plugin.
type MavenConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*MavenConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// Settings for the Java/Kotlin compiler used to compile the generated code.
	Compiler *MavenConfig_CompilerConfig `protobuf:"bytes,2,opt,name=compiler,proto3" json:"compiler,omitempty"`
	// Optional additional runtimes supported by the plugin.
	AdditionalRuntimes []*MavenConfig_RuntimeConfig `protobuf:"bytes,3,rep,name=additional_runtimes,json=additionalRuntimes,proto3" json:"additional_runtimes,omitempty"`
}

func (x *MavenConfig) Reset() {
	*x = MavenConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig) ProtoMessage() {}

func (x *MavenConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenConfig.ProtoReflect.Descriptor instead.
func (*MavenConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2}
}

func (x *MavenConfig) GetRuntimeLibraries() []*MavenConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *MavenConfig) GetCompiler() *MavenConfig_CompilerConfig {
	if x != nil {
		return x.Compiler
	}
	return nil
}

func (x *MavenConfig) GetAdditionalRuntimes() []*MavenConfig_RuntimeConfig {
	if x != nil {
		return x.AdditionalRuntimes
	}
	return nil
}

// NugetConfig is the configuration for a NuGet C# plugin.
type NugetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target frameworks to build. At least one target framework is required.
	TargetFrameworks []DotnetTargetFramework `protobuf:"varint,1,rep,packed,name=target_frameworks,json=targetFrameworks,proto3,enum=buf.alpha.registry.v1alpha1.DotnetTargetFramework" json:"target_frameworks,omitempty"`
	// Optional runtime libraries required by the plugin's generated code.
	RuntimeLibraries []*NugetConfig_RuntimeLibrary `protobuf:"bytes,2,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
}

func (x *NugetConfig) Reset() {
	*x = NugetConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NugetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NugetConfig) ProtoMessage() {}

func (x *NugetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NugetConfig.ProtoReflect.Descriptor instead.
func (*NugetConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{3}
}

func (x *NugetConfig) GetTargetFrameworks() []DotnetTargetFramework {
	if x != nil {
		return x.TargetFrameworks
	}
	return nil
}

func (x *NugetConfig) GetRuntimeLibraries() []*NugetConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

// CmakeConfig is the configuration for a Cmake C++ plugin.
type CmakeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CmakeConfig) Reset() {
	*x = CmakeConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CmakeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CmakeConfig) ProtoMessage() {}

func (x *CmakeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CmakeConfig.ProtoReflect.Descriptor instead.
func (*CmakeConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{4}
}

type SwiftConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optionally define the runtime libraries for the plugin.
	RuntimeLibraries []*SwiftConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
}

func (x *SwiftConfig) Reset() {
	*x = SwiftConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwiftConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwiftConfig) ProtoMessage() {}

func (x *SwiftConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SwiftConfig.ProtoReflect.Descriptor instead.
func (*SwiftConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{5}
}

func (x *SwiftConfig) GetRuntimeLibraries() []*SwiftConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

type PythonConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RuntimeLibraries []*PythonConfig_RuntimeLibrary `protobuf:"bytes,1,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// requires_python is a PEP 440 Version Specifier that specifies the value of
	// the `Requires-Python` field in a metadata file.
	//
	// Ref:
	// - https://packaging.python.org/en/latest/specifications/core-metadata/#requires-python
	// - https://peps.python.org/pep-0440/
	RequiresPython string `protobuf:"bytes,2,opt,name=requires_python,json=requiresPython,proto3" json:"requires_python,omitempty"`
	// package_type is the PythonPackageType that this plugin generates.
	PackageType PythonPackageType `protobuf:"varint,3,opt,name=package_type,json=packageType,proto3,enum=buf.alpha.registry.v1alpha1.PythonPackageType" json:"package_type,omitempty"`
}

func (x *PythonConfig) Reset() {
	*x = PythonConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonConfig) ProtoMessage() {}

func (x *PythonConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PythonConfig.ProtoReflect.Descriptor instead.
func (*PythonConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{6}
}

func (x *PythonConfig) GetRuntimeLibraries() []*PythonConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *PythonConfig) GetRequiresPython() string {
	if x != nil {
		return x.RequiresPython
	}
	return ""
}

func (x *PythonConfig) GetPackageType() PythonPackageType {
	if x != nil {
		return x.PackageType
	}
	return PythonPackageType_PYTHON_PACKAGE_TYPE_UNSPECIFIED
}

// CargoConfig specifies the Cargo Registry configuration for a Rust plugin.
type CargoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// rust_version specifies the minimum supported Rust version (MSRV) for the generated crate.
	// Ref: https://doc.rust-lang.org/cargo/reference/manifest.html#the-rust-version-field
	RustVersion string `protobuf:"bytes,1,opt,name=rust_version,json=rustVersion,proto3" json:"rust_version,omitempty"`
	// runtime_libraries specifies the runtime dependencies for the generated crate. Optional.
	RuntimeLibraries []*CargoConfig_RuntimeLibrary `protobuf:"bytes,2,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
}

func (x *CargoConfig) Reset() {
	*x = CargoConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CargoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CargoConfig) ProtoMessage() {}

func (x *CargoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CargoConfig.ProtoReflect.Descriptor instead.
func (*CargoConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{7}
}

func (x *CargoConfig) GetRustVersion() string {
	if x != nil {
		return x.RustVersion
	}
	return ""
}

func (x *CargoConfig) GetRuntimeLibraries() []*CargoConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

// RegistryConfig is the configuration for the remote registry of a plugin.
type RegistryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RegistryConfig:
	//
	//	*RegistryConfig_GoConfig
	//	*RegistryConfig_NpmConfig
	//	*RegistryConfig_MavenConfig
	//	*RegistryConfig_SwiftConfig
	//	*RegistryConfig_PythonConfig
	//	*RegistryConfig_CargoConfig
	//	*RegistryConfig_NugetConfig
	//	*RegistryConfig_CmakeConfig
	RegistryConfig isRegistryConfig_RegistryConfig `protobuf_oneof:"registry_config"`
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string `protobuf:"bytes,10,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *RegistryConfig) Reset() {
	*x = RegistryConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegistryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistryConfig) ProtoMessage() {}

func (x *RegistryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegistryConfig.ProtoReflect.Descriptor instead.
func (*RegistryConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{8}
}

func (m *RegistryConfig) GetRegistryConfig() isRegistryConfig_RegistryConfig {
	if m != nil {
		return m.RegistryConfig
	}
	return nil
}

func (x *RegistryConfig) GetGoConfig() *GoConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_GoConfig); ok {
		return x.GoConfig
	}
	return nil
}

func (x *RegistryConfig) GetNpmConfig() *NPMConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_NpmConfig); ok {
		return x.NpmConfig
	}
	return nil
}

func (x *RegistryConfig) GetMavenConfig() *MavenConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_MavenConfig); ok {
		return x.MavenConfig
	}
	return nil
}

func (x *RegistryConfig) GetSwiftConfig() *SwiftConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_SwiftConfig); ok {
		return x.SwiftConfig
	}
	return nil
}

func (x *RegistryConfig) GetPythonConfig() *PythonConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_PythonConfig); ok {
		return x.PythonConfig
	}
	return nil
}

func (x *RegistryConfig) GetCargoConfig() *CargoConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_CargoConfig); ok {
		return x.CargoConfig
	}
	return nil
}

func (x *RegistryConfig) GetNugetConfig() *NugetConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_NugetConfig); ok {
		return x.NugetConfig
	}
	return nil
}

func (x *RegistryConfig) GetCmakeConfig() *CmakeConfig {
	if x, ok := x.GetRegistryConfig().(*RegistryConfig_CmakeConfig); ok {
		return x.CmakeConfig
	}
	return nil
}

func (x *RegistryConfig) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

type isRegistryConfig_RegistryConfig interface {
	isRegistryConfig_RegistryConfig()
}

type RegistryConfig_GoConfig struct {
	GoConfig *GoConfig `protobuf:"bytes,1,opt,name=go_config,json=goConfig,proto3,oneof"`
}

type RegistryConfig_NpmConfig struct {
	NpmConfig *NPMConfig `protobuf:"bytes,2,opt,name=npm_config,json=npmConfig,proto3,oneof"`
}

type RegistryConfig_MavenConfig struct {
	MavenConfig *MavenConfig `protobuf:"bytes,3,opt,name=maven_config,json=mavenConfig,proto3,oneof"`
}

type RegistryConfig_SwiftConfig struct {
	SwiftConfig *SwiftConfig `protobuf:"bytes,4,opt,name=swift_config,json=swiftConfig,proto3,oneof"`
}

type RegistryConfig_PythonConfig struct {
	PythonConfig *PythonConfig `protobuf:"bytes,5,opt,name=python_config,json=pythonConfig,proto3,oneof"`
}

type RegistryConfig_CargoConfig struct {
	CargoConfig *CargoConfig `protobuf:"bytes,6,opt,name=cargo_config,json=cargoConfig,proto3,oneof"`
}

type RegistryConfig_NugetConfig struct {
	NugetConfig *NugetConfig `protobuf:"bytes,7,opt,name=nuget_config,json=nugetConfig,proto3,oneof"`
}

type RegistryConfig_CmakeConfig struct {
	CmakeConfig *CmakeConfig `protobuf:"bytes,8,opt,name=cmake_config,json=cmakeConfig,proto3,oneof"`
}

func (*RegistryConfig_GoConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_NpmConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_MavenConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_SwiftConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_PythonConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_CargoConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_NugetConfig) isRegistryConfig_RegistryConfig() {}

func (*RegistryConfig_CmakeConfig) isRegistryConfig_RegistryConfig() {}

type CuratedPluginReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Semver-formatted plugin version.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The revision for this plugin version.
	Revision uint32 `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *CuratedPluginReference) Reset() {
	*x = CuratedPluginReference{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPluginReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginReference) ProtoMessage() {}

func (x *CuratedPluginReference) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPluginReference.ProtoReflect.Descriptor instead.
func (*CuratedPluginReference) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{9}
}

func (x *CuratedPluginReference) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CuratedPluginReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CuratedPluginReference) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CuratedPluginReference) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

// CuratedPlugin represents a protoc plugin curated by Buf, such as protoc-gen-go.
type CuratedPlugin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the plugin, which uniquely identifies the plugin.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The optional registry type of the plugin.
	RegistryType PluginRegistryType `protobuf:"varint,4,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType" json:"registry_type,omitempty"`
	// Semver-formatted plugin version.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// The full container image digest associated with this plugin version including
	// the algorithm.
	// Ref: https://github.com/opencontainers/image-spec/blob/main/descriptor.md#digests
	ContainerImageDigest string `protobuf:"bytes,6,opt,name=container_image_digest,json=containerImageDigest,proto3" json:"container_image_digest,omitempty"`
	// The creation time of the plugin.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// List of plugin dependencies.
	Dependencies []*CuratedPluginReference `protobuf:"bytes,9,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// Optionally specify the URL leading to the source code of the plugin, if available.
	SourceUrl string `protobuf:"bytes,10,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// Optionally specify a brief description of the plugin functionality.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	// The configuration for the remote registry of the plugin.
	RegistryConfig *RegistryConfig `protobuf:"bytes,12,opt,name=registry_config,json=registryConfig,proto3" json:"registry_config,omitempty"`
	// The revision for this plugin version.
	Revision uint32 `protobuf:"varint,13,opt,name=revision,proto3" json:"revision,omitempty"`
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage `protobuf:"varint,14,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage" json:"output_languages,omitempty"`
	// spdx_license_id is the license of the plugin, which should be one of the identifiers
	// defined in https://spdx.org/licenses
	SpdxLicenseId string `protobuf:"bytes,15,opt,name=spdx_license_id,json=spdxLicenseId,proto3" json:"spdx_license_id,omitempty"`
	// license_url specifies an optional URL for the plugin's license (if not using a standard spdx_license_id).
	LicenseUrl string `protobuf:"bytes,16,opt,name=license_url,json=licenseUrl,proto3" json:"license_url,omitempty"`
	// verified indicates the plugin has been verified. Verification is a property
	// of the BSR and cannot be set by end-users.
	Verified bool `protobuf:"varint,17,opt,name=verified,proto3" json:"verified,omitempty"`
	// Visibility indicates whether the plugin is public or private.
	Visibility CuratedPluginVisibility `protobuf:"varint,18,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.CuratedPluginVisibility" json:"visibility,omitempty"`
	// Deprecated indicates whether the plugin is deprecated.
	Deprecated bool `protobuf:"varint,19,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// Optionally specify a message to be displayed when the plugin is deprecated.
	DeprecationMessage string `protobuf:"bytes,20,opt,name=deprecation_message,json=deprecationMessage,proto3" json:"deprecation_message,omitempty"`
	// The URL leading to the integration guide of the plugin, if available.
	IntegrationGuideUrl string `protobuf:"bytes,21,opt,name=integration_guide_url,json=integrationGuideUrl,proto3" json:"integration_guide_url,omitempty"`
	// The configurable documentation of the Plugin.
	Doc string `protobuf:"bytes,22,opt,name=doc,proto3" json:"doc,omitempty"`
	// The collections the Plugin belongs to.
	Collections []*PluginCollection `protobuf:"bytes,23,rep,name=collections,proto3" json:"collections,omitempty"`
}

func (x *CuratedPlugin) Reset() {
	*x = CuratedPlugin{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPlugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPlugin) ProtoMessage() {}

func (x *CuratedPlugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPlugin.ProtoReflect.Descriptor instead.
func (*CuratedPlugin) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{10}
}

func (x *CuratedPlugin) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CuratedPlugin) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CuratedPlugin) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CuratedPlugin) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CuratedPlugin) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CuratedPlugin) GetContainerImageDigest() string {
	if x != nil {
		return x.ContainerImageDigest
	}
	return ""
}

func (x *CuratedPlugin) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CuratedPlugin) GetDependencies() []*CuratedPluginReference {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *CuratedPlugin) GetSourceUrl() string {
	if x != nil {
		return x.SourceUrl
	}
	return ""
}

func (x *CuratedPlugin) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CuratedPlugin) GetRegistryConfig() *RegistryConfig {
	if x != nil {
		return x.RegistryConfig
	}
	return nil
}

func (x *CuratedPlugin) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *CuratedPlugin) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.OutputLanguages
	}
	return nil
}

func (x *CuratedPlugin) GetSpdxLicenseId() string {
	if x != nil {
		return x.SpdxLicenseId
	}
	return ""
}

func (x *CuratedPlugin) GetLicenseUrl() string {
	if x != nil {
		return x.LicenseUrl
	}
	return ""
}

func (x *CuratedPlugin) GetVerified() bool {
	if x != nil {
		return x.Verified
	}
	return false
}

func (x *CuratedPlugin) GetVisibility() CuratedPluginVisibility {
	if x != nil {
		return x.Visibility
	}
	return CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *CuratedPlugin) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *CuratedPlugin) GetDeprecationMessage() string {
	if x != nil {
		return x.DeprecationMessage
	}
	return ""
}

func (x *CuratedPlugin) GetIntegrationGuideUrl() string {
	if x != nil {
		return x.IntegrationGuideUrl
	}
	return ""
}

func (x *CuratedPlugin) GetDoc() string {
	if x != nil {
		return x.Doc
	}
	return ""
}

func (x *CuratedPlugin) GetCollections() []*PluginCollection {
	if x != nil {
		return x.Collections
	}
	return nil
}

// Plugin collections group related plugins, organizing them by functionality or ecosystem.
type PluginCollection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the collection.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PluginCollection) Reset() {
	*x = PluginCollection{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginCollection) ProtoMessage() {}

func (x *PluginCollection) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginCollection.ProtoReflect.Descriptor instead.
func (*PluginCollection) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{11}
}

func (x *PluginCollection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GenerateCodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image to run plugins against to generate the desired file outputs.
	//
	// All image files that are not imports and not well-known types will be generated.
	// If you want to filter what files are generated, modify the image.
	// If you want to include imports, set include_imports.
	Image    *v1.Image                  `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	Requests []*PluginGenerationRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	// Include imports from the Image in generation. If include_imports is also set
	// in one of requests, use the request's value for that plugin.
	IncludeImports bool `protobuf:"varint,3,opt,name=include_imports,json=includeImports,proto3" json:"include_imports,omitempty"`
	// Include Well-Known Types from the Image in generation.
	//
	// include_imports must be set if include_well_known_types is set. If include_well_known_types
	// is also set in one of requests, use the request's value for that plugin.
	IncludeWellKnownTypes bool `protobuf:"varint,4,opt,name=include_well_known_types,json=includeWellKnownTypes,proto3" json:"include_well_known_types,omitempty"`
}

func (x *GenerateCodeRequest) Reset() {
	*x = GenerateCodeRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateCodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCodeRequest) ProtoMessage() {}

func (x *GenerateCodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateCodeRequest.ProtoReflect.Descriptor instead.
func (*GenerateCodeRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{12}
}

func (x *GenerateCodeRequest) GetImage() *v1.Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *GenerateCodeRequest) GetRequests() []*PluginGenerationRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *GenerateCodeRequest) GetIncludeImports() bool {
	if x != nil {
		return x.IncludeImports
	}
	return false
}

func (x *GenerateCodeRequest) GetIncludeWellKnownTypes() bool {
	if x != nil {
		return x.IncludeWellKnownTypes
	}
	return false
}

type GenerateCodeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Responses from each plugin execution.
	// The order of each response matches the order in the GenerateCodeRequest.
	Responses []*PluginGenerationResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *GenerateCodeResponse) Reset() {
	*x = GenerateCodeResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateCodeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCodeResponse) ProtoMessage() {}

func (x *GenerateCodeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateCodeResponse.ProtoReflect.Descriptor instead.
func (*GenerateCodeResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{13}
}

func (x *GenerateCodeResponse) GetResponses() []*PluginGenerationResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// Request for performing code generation using the specified plugin.
type PluginGenerationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The plugin to execute.
	PluginReference *CuratedPluginReference `protobuf:"bytes,1,opt,name=plugin_reference,json=pluginReference,proto3" json:"plugin_reference,omitempty"`
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
	// Include imports from the Image in generation.
	IncludeImports *bool `protobuf:"varint,3,opt,name=include_imports,json=includeImports,proto3,oneof" json:"include_imports,omitempty"`
	// Include Well-Known Types from the Image in generation.
	//
	// include_imports must be set if include_well_known_types is set.
	IncludeWellKnownTypes *bool `protobuf:"varint,4,opt,name=include_well_known_types,json=includeWellKnownTypes,proto3,oneof" json:"include_well_known_types,omitempty"`
}

func (x *PluginGenerationRequest) Reset() {
	*x = PluginGenerationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginGenerationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginGenerationRequest) ProtoMessage() {}

func (x *PluginGenerationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginGenerationRequest.ProtoReflect.Descriptor instead.
func (*PluginGenerationRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{14}
}

func (x *PluginGenerationRequest) GetPluginReference() *CuratedPluginReference {
	if x != nil {
		return x.PluginReference
	}
	return nil
}

func (x *PluginGenerationRequest) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *PluginGenerationRequest) GetIncludeImports() bool {
	if x != nil && x.IncludeImports != nil {
		return *x.IncludeImports
	}
	return false
}

func (x *PluginGenerationRequest) GetIncludeWellKnownTypes() bool {
	if x != nil && x.IncludeWellKnownTypes != nil {
		return *x.IncludeWellKnownTypes
	}
	return false
}

// Response from code generation for a given plugin.
type PluginGenerationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Generated code from the plugin.
	Response *pluginpb.CodeGeneratorResponse `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *PluginGenerationResponse) Reset() {
	*x = PluginGenerationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginGenerationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginGenerationResponse) ProtoMessage() {}

func (x *PluginGenerationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginGenerationResponse.ProtoReflect.Descriptor instead.
func (*PluginGenerationResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{15}
}

func (x *PluginGenerationResponse) GetResponse() *pluginpb.CodeGeneratorResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

type DeleteCuratedPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin to delete.
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin to delete.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Version is the plugin version and is optional. If this field is not set then delete all versions,
	// otherwise delete only the specified version which includes all revisions.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *DeleteCuratedPluginRequest) Reset() {
	*x = DeleteCuratedPluginRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCuratedPluginRequest) ProtoMessage() {}

func (x *DeleteCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCuratedPluginRequest.ProtoReflect.Descriptor instead.
func (*DeleteCuratedPluginRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *DeleteCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type DeleteCuratedPluginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteCuratedPluginResponse) Reset() {
	*x = DeleteCuratedPluginResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCuratedPluginResponse) ProtoMessage() {}

func (x *DeleteCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCuratedPluginResponse.ProtoReflect.Descriptor instead.
func (*DeleteCuratedPluginResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{17}
}

type CreateCuratedPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The optional registry type of the plugin.
	RegistryType PluginRegistryType `protobuf:"varint,3,opt,name=registry_type,json=registryType,proto3,enum=buf.alpha.registry.v1alpha1.PluginRegistryType" json:"registry_type,omitempty"`
	// Semver-formatted plugin version.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// The full container image digest associated with this plugin version including
	// the algorithm.
	// Ref: https://github.com/opencontainers/image-spec/blob/main/descriptor.md#digests
	ContainerImageDigest string `protobuf:"bytes,5,opt,name=container_image_digest,json=containerImageDigest,proto3" json:"container_image_digest,omitempty"`
	// List of plugin dependencies.
	Dependencies []*CuratedPluginReference `protobuf:"bytes,7,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	// The URL leading to the source code of the plugin, if available.
	SourceUrl string `protobuf:"bytes,8,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// A brief description of the plugin functionality.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// The configuration for the remote registry of the plugin.
	RegistryConfig *RegistryConfig `protobuf:"bytes,12,opt,name=registry_config,json=registryConfig,proto3" json:"registry_config,omitempty"`
	// The revision for this plugin version.
	Revision uint32 `protobuf:"varint,13,opt,name=revision,proto3" json:"revision,omitempty"`
	// The output languages supported by the plugin.
	OutputLanguages []PluginLanguage `protobuf:"varint,14,rep,packed,name=output_languages,json=outputLanguages,proto3,enum=buf.alpha.registry.v1alpha1.PluginLanguage" json:"output_languages,omitempty"`
	// spdx_license_id is the license of the plugin, which should be one of the identifiers
	// defined in https://spdx.org/licenses
	SpdxLicenseId string `protobuf:"bytes,15,opt,name=spdx_license_id,json=spdxLicenseId,proto3" json:"spdx_license_id,omitempty"`
	// license_url specifies an optional URL for the plugin's license (if not using a standard spdx_license_id).
	LicenseUrl string `protobuf:"bytes,16,opt,name=license_url,json=licenseUrl,proto3" json:"license_url,omitempty"`
	// Visibility indicates whether the plugin is public or private.
	Visibility CuratedPluginVisibility `protobuf:"varint,17,opt,name=visibility,proto3,enum=buf.alpha.registry.v1alpha1.CuratedPluginVisibility" json:"visibility,omitempty"`
	// The URL leading to the integration guide of the plugin, if available.
	IntegrationGuideUrl string `protobuf:"bytes,18,opt,name=integration_guide_url,json=integrationGuideUrl,proto3" json:"integration_guide_url,omitempty"`
}

func (x *CreateCuratedPluginRequest) Reset() {
	*x = CreateCuratedPluginRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCuratedPluginRequest) ProtoMessage() {}

func (x *CreateCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCuratedPluginRequest.ProtoReflect.Descriptor instead.
func (*CreateCuratedPluginRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{18}
}

func (x *CreateCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetRegistryType() PluginRegistryType {
	if x != nil {
		return x.RegistryType
	}
	return PluginRegistryType_PLUGIN_REGISTRY_TYPE_UNSPECIFIED
}

func (x *CreateCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetContainerImageDigest() string {
	if x != nil {
		return x.ContainerImageDigest
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDependencies() []*CuratedPluginReference {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetSourceUrl() string {
	if x != nil {
		return x.SourceUrl
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetRegistryConfig() *RegistryConfig {
	if x != nil {
		return x.RegistryConfig
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *CreateCuratedPluginRequest) GetOutputLanguages() []PluginLanguage {
	if x != nil {
		return x.OutputLanguages
	}
	return nil
}

func (x *CreateCuratedPluginRequest) GetSpdxLicenseId() string {
	if x != nil {
		return x.SpdxLicenseId
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetLicenseUrl() string {
	if x != nil {
		return x.LicenseUrl
	}
	return ""
}

func (x *CreateCuratedPluginRequest) GetVisibility() CuratedPluginVisibility {
	if x != nil {
		return x.Visibility
	}
	return CuratedPluginVisibility_CURATED_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *CreateCuratedPluginRequest) GetIntegrationGuideUrl() string {
	if x != nil {
		return x.IntegrationGuideUrl
	}
	return ""
}

type CreateCuratedPluginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created plugin.
	Configuration *CuratedPlugin `protobuf:"bytes,1,opt,name=configuration,proto3" json:"configuration,omitempty"`
}

func (x *CreateCuratedPluginResponse) Reset() {
	*x = CreateCuratedPluginResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCuratedPluginResponse) ProtoMessage() {}

func (x *CreateCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCuratedPluginResponse.ProtoReflect.Descriptor instead.
func (*CreateCuratedPluginResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{19}
}

func (x *CreateCuratedPluginResponse) GetConfiguration() *CuratedPlugin {
	if x != nil {
		return x.Configuration
	}
	return nil
}

type ListCuratedPluginsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The first page is returned if this is empty.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	Reverse   bool   `protobuf:"varint,3,opt,name=reverse,proto3" json:"reverse,omitempty"`
	// If true, will only return plugins which support remote packages (registry_type is set).
	SupportsRemotePackages bool `protobuf:"varint,4,opt,name=supports_remote_packages,json=supportsRemotePackages,proto3" json:"supports_remote_packages,omitempty"`
	// If true, will include deprecated plugins.
	IncludeDeprecated bool `protobuf:"varint,5,opt,name=include_deprecated,json=includeDeprecated,proto3" json:"include_deprecated,omitempty"`
}

func (x *ListCuratedPluginsRequest) Reset() {
	*x = ListCuratedPluginsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCuratedPluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCuratedPluginsRequest) ProtoMessage() {}

func (x *ListCuratedPluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCuratedPluginsRequest.ProtoReflect.Descriptor instead.
func (*ListCuratedPluginsRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{20}
}

func (x *ListCuratedPluginsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCuratedPluginsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCuratedPluginsRequest) GetReverse() bool {
	if x != nil {
		return x.Reverse
	}
	return false
}

func (x *ListCuratedPluginsRequest) GetSupportsRemotePackages() bool {
	if x != nil {
		return x.SupportsRemotePackages
	}
	return false
}

func (x *ListCuratedPluginsRequest) GetIncludeDeprecated() bool {
	if x != nil {
		return x.IncludeDeprecated
	}
	return false
}

type ListCuratedPluginsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Plugins []*CuratedPlugin `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"`
	// There are no more pages if this is empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCuratedPluginsResponse) Reset() {
	*x = ListCuratedPluginsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCuratedPluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCuratedPluginsResponse) ProtoMessage() {}

func (x *ListCuratedPluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCuratedPluginsResponse.ProtoReflect.Descriptor instead.
func (*ListCuratedPluginsResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{21}
}

func (x *ListCuratedPluginsResponse) GetPlugins() []*CuratedPlugin {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *ListCuratedPluginsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type GetLatestCuratedPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the plugin, i.e. "library".
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the plugin, i.e. "connect-go".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Both version (semver-formatted) and revision are optional, which means
	// return the latest plugin.
	// If version is set, but revision is omitted, then return the latest
	// revision for that version.
	// If version and revision are both set, return specific plugin.
	// It is an error to set a revision without a corresponding version.
	Version  string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	Revision uint32 `protobuf:"varint,4,opt,name=revision,proto3" json:"revision,omitempty"`
	// If true, will only return versions (and revisions) which support remote packages (registry_type is set).
	SupportsRemotePackages bool `protobuf:"varint,5,opt,name=supports_remote_packages,json=supportsRemotePackages,proto3" json:"supports_remote_packages,omitempty"`
}

func (x *GetLatestCuratedPluginRequest) Reset() {
	*x = GetLatestCuratedPluginRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLatestCuratedPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestCuratedPluginRequest) ProtoMessage() {}

func (x *GetLatestCuratedPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestCuratedPluginRequest.ProtoReflect.Descriptor instead.
func (*GetLatestCuratedPluginRequest) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{22}
}

func (x *GetLatestCuratedPluginRequest) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GetLatestCuratedPluginRequest) GetRevision() uint32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *GetLatestCuratedPluginRequest) GetSupportsRemotePackages() bool {
	if x != nil {
		return x.SupportsRemotePackages
	}
	return false
}

type GetLatestCuratedPluginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Plugin *CuratedPlugin `protobuf:"bytes,1,opt,name=plugin,proto3" json:"plugin,omitempty"`
	// versions is a semver-sorted list in descending order.
	Versions []*CuratedPluginVersionRevisions `protobuf:"bytes,2,rep,name=versions,proto3" json:"versions,omitempty"`
}

func (x *GetLatestCuratedPluginResponse) Reset() {
	*x = GetLatestCuratedPluginResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLatestCuratedPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestCuratedPluginResponse) ProtoMessage() {}

func (x *GetLatestCuratedPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestCuratedPluginResponse.ProtoReflect.Descriptor instead.
func (*GetLatestCuratedPluginResponse) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{23}
}

func (x *GetLatestCuratedPluginResponse) GetPlugin() *CuratedPlugin {
	if x != nil {
		return x.Plugin
	}
	return nil
}

func (x *GetLatestCuratedPluginResponse) GetVersions() []*CuratedPluginVersionRevisions {
	if x != nil {
		return x.Versions
	}
	return nil
}

type CuratedPluginVersionRevisions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// revisions is a sorted list in descending order.
	Revisions []uint32 `protobuf:"varint,2,rep,packed,name=revisions,proto3" json:"revisions,omitempty"`
}

func (x *CuratedPluginVersionRevisions) Reset() {
	*x = CuratedPluginVersionRevisions{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CuratedPluginVersionRevisions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CuratedPluginVersionRevisions) ProtoMessage() {}

func (x *CuratedPluginVersionRevisions) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CuratedPluginVersionRevisions.ProtoReflect.Descriptor instead.
func (*CuratedPluginVersionRevisions) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{24}
}

func (x *CuratedPluginVersionRevisions) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *CuratedPluginVersionRevisions) GetRevisions() []uint32 {
	if x != nil {
		return x.Revisions
	}
	return nil
}

// RuntimeLibrary describes the runtime library dependency of the generated code.
type GoConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the runtime library module, i.e. "google.golang.org/protobuf".
	Module string `protobuf:"bytes,1,opt,name=module,proto3" json:"module,omitempty"`
	// The version of the runtime library, i.e. "v1.27.1".
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GoConfig_RuntimeLibrary) Reset() {
	*x = GoConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GoConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoConfig_RuntimeLibrary) ProtoMessage() {}

func (x *GoConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*GoConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{0, 0}
}

func (x *GoConfig_RuntimeLibrary) GetModule() string {
	if x != nil {
		return x.Module
	}
	return ""
}

func (x *GoConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// RuntimeLibrary describes the runtime library dependency of the generated code.
type NPMConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the runtime library package, i.e. "@grpc/grpc-js".
	Package string `protobuf:"bytes,1,opt,name=package,proto3" json:"package,omitempty"`
	// The version of the runtime library, i.e. "^1.27.1".
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *NPMConfig_RuntimeLibrary) Reset() {
	*x = NPMConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NPMConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NPMConfig_RuntimeLibrary) ProtoMessage() {}

func (x *NPMConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NPMConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*NPMConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{1, 0}
}

func (x *NPMConfig_RuntimeLibrary) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *NPMConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// RuntimeLibrary describes a runtime dependency of the generated code.
type MavenConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GroupId    string `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	ArtifactId string `protobuf:"bytes,2,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	Version    string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	Classifier string `protobuf:"bytes,4,opt,name=classifier,proto3" json:"classifier,omitempty"`
	Extension  string `protobuf:"bytes,5,opt,name=extension,proto3" json:"extension,omitempty"`
}

func (x *MavenConfig_RuntimeLibrary) Reset() {
	*x = MavenConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_RuntimeLibrary) ProtoMessage() {}

func (x *MavenConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*MavenConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2, 0}
}

func (x *MavenConfig_RuntimeLibrary) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetClassifier() string {
	if x != nil {
		return x.Classifier
	}
	return ""
}

func (x *MavenConfig_RuntimeLibrary) GetExtension() string {
	if x != nil {
		return x.Extension
	}
	return ""
}

// CompilerConfig contains configuration for the Java and/or Kotlin compiler used when compiling the generated code.
type MavenConfig_CompilerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Java   *MavenConfig_CompilerJavaConfig   `protobuf:"bytes,1,opt,name=java,proto3" json:"java,omitempty"`
	Kotlin *MavenConfig_CompilerKotlinConfig `protobuf:"bytes,2,opt,name=kotlin,proto3" json:"kotlin,omitempty"`
}

func (x *MavenConfig_CompilerConfig) Reset() {
	*x = MavenConfig_CompilerConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_CompilerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_CompilerConfig) ProtoMessage() {}

func (x *MavenConfig_CompilerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenConfig_CompilerConfig.ProtoReflect.Descriptor instead.
func (*MavenConfig_CompilerConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2, 1}
}

func (x *MavenConfig_CompilerConfig) GetJava() *MavenConfig_CompilerJavaConfig {
	if x != nil {
		return x.Java
	}
	return nil
}

func (x *MavenConfig_CompilerConfig) GetKotlin() *MavenConfig_CompilerKotlinConfig {
	if x != nil {
		return x.Kotlin
	}
	return nil
}

// CompilerJavaConfig contains settings for the Java compiler.
type MavenConfig_CompilerJavaConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File encoding (default: UTF-8).
	Encoding string `protobuf:"bytes,1,opt,name=encoding,proto3" json:"encoding,omitempty"`
	// Release version (default: 8).
	Release int32 `protobuf:"varint,2,opt,name=release,proto3" json:"release,omitempty"`
	// Source version (default: 8).
	Source int32 `protobuf:"varint,3,opt,name=source,proto3" json:"source,omitempty"`
	// Target version (default: 8).
	Target int32 `protobuf:"varint,4,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *MavenConfig_CompilerJavaConfig) Reset() {
	*x = MavenConfig_CompilerJavaConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_CompilerJavaConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_CompilerJavaConfig) ProtoMessage() {}

func (x *MavenConfig_CompilerJavaConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenConfig_CompilerJavaConfig.ProtoReflect.Descriptor instead.
func (*MavenConfig_CompilerJavaConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2, 2}
}

func (x *MavenConfig_CompilerJavaConfig) GetEncoding() string {
	if x != nil {
		return x.Encoding
	}
	return ""
}

func (x *MavenConfig_CompilerJavaConfig) GetRelease() int32 {
	if x != nil {
		return x.Release
	}
	return 0
}

func (x *MavenConfig_CompilerJavaConfig) GetSource() int32 {
	if x != nil {
		return x.Source
	}
	return 0
}

func (x *MavenConfig_CompilerJavaConfig) GetTarget() int32 {
	if x != nil {
		return x.Target
	}
	return 0
}

// CompilerKotlinConfig contains settings for the Kotlin compiler.
type MavenConfig_CompilerKotlinConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the Kotlin compiler used to compile the generated code.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Version of the Kotlin API to target.
	ApiVersion string `protobuf:"bytes,2,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Target version of the JVM bytecode (default: 1.8).
	JvmTarget string `protobuf:"bytes,3,opt,name=jvm_target,json=jvmTarget,proto3" json:"jvm_target,omitempty"`
	// Kotlin language version used for source compatibility.
	LanguageVersion string `protobuf:"bytes,4,opt,name=language_version,json=languageVersion,proto3" json:"language_version,omitempty"`
}

func (x *MavenConfig_CompilerKotlinConfig) Reset() {
	*x = MavenConfig_CompilerKotlinConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_CompilerKotlinConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_CompilerKotlinConfig) ProtoMessage() {}

func (x *MavenConfig_CompilerKotlinConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenConfig_CompilerKotlinConfig.ProtoReflect.Descriptor instead.
func (*MavenConfig_CompilerKotlinConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2, 3}
}

func (x *MavenConfig_CompilerKotlinConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) GetJvmTarget() string {
	if x != nil {
		return x.JvmTarget
	}
	return ""
}

func (x *MavenConfig_CompilerKotlinConfig) GetLanguageVersion() string {
	if x != nil {
		return x.LanguageVersion
	}
	return ""
}

// RuntimeConfig allows configuring additional runtimes (like the 'lite' runtime).
// They can use different runtime dependencies and plugin options.
type MavenConfig_RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name             string                        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	RuntimeLibraries []*MavenConfig_RuntimeLibrary `protobuf:"bytes,2,rep,name=runtime_libraries,json=runtimeLibraries,proto3" json:"runtime_libraries,omitempty"`
	// The options to pass to the plugin. These will
	// be merged into a single, comma-separated string.
	Options []string `protobuf:"bytes,3,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *MavenConfig_RuntimeConfig) Reset() {
	*x = MavenConfig_RuntimeConfig{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MavenConfig_RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MavenConfig_RuntimeConfig) ProtoMessage() {}

func (x *MavenConfig_RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MavenConfig_RuntimeConfig.ProtoReflect.Descriptor instead.
func (*MavenConfig_RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{2, 4}
}

func (x *MavenConfig_RuntimeConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MavenConfig_RuntimeConfig) GetRuntimeLibraries() []*MavenConfig_RuntimeLibrary {
	if x != nil {
		return x.RuntimeLibraries
	}
	return nil
}

func (x *MavenConfig_RuntimeConfig) GetOptions() []string {
	if x != nil {
		return x.Options
	}
	return nil
}

// RuntimeLibrary describes a NuGet package dependency of the generated code.
// Ref: https://learn.microsoft.com/en-us/dotnet/core/tools/dependencies#the-packagereference-element
type NugetConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the NuGet package (also known as the package ID).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the NuGet package (supports ranges).
	// Ref: https://learn.microsoft.com/en-us/nuget/concepts/package-versioning#version-ranges
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Optional target frameworks. If specified, these dependencies will be
	// conditionally added when building for the specified target framework.
	TargetFrameworks []DotnetTargetFramework `protobuf:"varint,3,rep,packed,name=target_frameworks,json=targetFrameworks,proto3,enum=buf.alpha.registry.v1alpha1.DotnetTargetFramework" json:"target_frameworks,omitempty"`
}

func (x *NugetConfig_RuntimeLibrary) Reset() {
	*x = NugetConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NugetConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NugetConfig_RuntimeLibrary) ProtoMessage() {}

func (x *NugetConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NugetConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*NugetConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{3, 0}
}

func (x *NugetConfig_RuntimeLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NugetConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *NugetConfig_RuntimeLibrary) GetTargetFrameworks() []DotnetTargetFramework {
	if x != nil {
		return x.TargetFrameworks
	}
	return nil
}

// RuntimeLibrary describes a runtime library dependency of the generated code.
type SwiftConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the runtime library package, e.g. https://github.com/apple/swift-protobuf.git.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The name of the runtime library package, e.g. "swift-protobuf".
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// The version of the runtime library, e.g. "1.21.0".
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// The products exported by the runtime library, e.g. "SwiftProtobuf".
	Products []string `protobuf:"bytes,4,rep,name=products,proto3" json:"products,omitempty"`
	// The minimum compatible platform versions of the runtime library.
	Platforms []*SwiftConfig_RuntimeLibrary_Platform `protobuf:"bytes,5,rep,name=platforms,proto3" json:"platforms,omitempty"`
	// The supported Swift language versions of the runtime library, e.g. ".v5".
	SwiftVersions []string `protobuf:"bytes,6,rep,name=swift_versions,json=swiftVersions,proto3" json:"swift_versions,omitempty"`
}

func (x *SwiftConfig_RuntimeLibrary) Reset() {
	*x = SwiftConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwiftConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwiftConfig_RuntimeLibrary) ProtoMessage() {}

func (x *SwiftConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SwiftConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*SwiftConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{5, 0}
}

func (x *SwiftConfig_RuntimeLibrary) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SwiftConfig_RuntimeLibrary) GetProducts() []string {
	if x != nil {
		return x.Products
	}
	return nil
}

func (x *SwiftConfig_RuntimeLibrary) GetPlatforms() []*SwiftConfig_RuntimeLibrary_Platform {
	if x != nil {
		return x.Platforms
	}
	return nil
}

func (x *SwiftConfig_RuntimeLibrary) GetSwiftVersions() []string {
	if x != nil {
		return x.SwiftVersions
	}
	return nil
}

// The minimum compatible platform versions of the runtime library.
type SwiftConfig_RuntimeLibrary_Platform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the platform.
	Name SwiftPlatformType `protobuf:"varint,1,opt,name=name,proto3,enum=buf.alpha.registry.v1alpha1.SwiftPlatformType" json:"name,omitempty"`
	// The minimum compatible version of the platform.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SwiftConfig_RuntimeLibrary_Platform) Reset() {
	*x = SwiftConfig_RuntimeLibrary_Platform{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwiftConfig_RuntimeLibrary_Platform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwiftConfig_RuntimeLibrary_Platform) ProtoMessage() {}

func (x *SwiftConfig_RuntimeLibrary_Platform) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SwiftConfig_RuntimeLibrary_Platform.ProtoReflect.Descriptor instead.
func (*SwiftConfig_RuntimeLibrary_Platform) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *SwiftConfig_RuntimeLibrary_Platform) GetName() SwiftPlatformType {
	if x != nil {
		return x.Name
	}
	return SwiftPlatformType_SWIFT_PLATFORM_TYPE_UNSPECIFIED
}

func (x *SwiftConfig_RuntimeLibrary_Platform) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type PythonConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// dependency_specification is a PEP 508 Dependency Specification.
	// Ref: https://peps.python.org/pep-0508/
	DependencySpecification string `protobuf:"bytes,1,opt,name=dependency_specification,json=dependencySpecification,proto3" json:"dependency_specification,omitempty"`
}

func (x *PythonConfig_RuntimeLibrary) Reset() {
	*x = PythonConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PythonConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PythonConfig_RuntimeLibrary) ProtoMessage() {}

func (x *PythonConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PythonConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*PythonConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{6, 0}
}

func (x *PythonConfig_RuntimeLibrary) GetDependencySpecification() string {
	if x != nil {
		return x.DependencySpecification
	}
	return ""
}

// RuntimeLibrary specifies a runtime dependency for a generated crate.
// It is the subset of a full Cargo dependency specification, which contains
// fields that are irrelevant for Generated SDKs.
// Ref: https://doc.rust-lang.org/cargo/reference/specifying-dependencies.html
type CargoConfig_RuntimeLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name specifies the name of the dependency.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// version_requirement specifies the version requirement of the dependency.
	VersionRequirement string `protobuf:"bytes,2,opt,name=version_requirement,json=versionRequirement,proto3" json:"version_requirement,omitempty"`
	// default_features specifies whether or not default features will be enabled for the dependency.
	DefaultFeatures bool `protobuf:"varint,3,opt,name=default_features,json=defaultFeatures,proto3" json:"default_features,omitempty"`
	// features specifies the features enabled for the dependency.
	Features []string `protobuf:"bytes,4,rep,name=features,proto3" json:"features,omitempty"`
}

func (x *CargoConfig_RuntimeLibrary) Reset() {
	*x = CargoConfig_RuntimeLibrary{}
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CargoConfig_RuntimeLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CargoConfig_RuntimeLibrary) ProtoMessage() {}

func (x *CargoConfig_RuntimeLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CargoConfig_RuntimeLibrary.ProtoReflect.Descriptor instead.
func (*CargoConfig_RuntimeLibrary) Descriptor() ([]byte, []int) {
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP(), []int{7, 0}
}

func (x *CargoConfig_RuntimeLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CargoConfig_RuntimeLibrary) GetVersionRequirement() string {
	if x != nil {
		return x.VersionRequirement
	}
	return ""
}

func (x *CargoConfig_RuntimeLibrary) GetDefaultFeatures() bool {
	if x != nil {
		return x.DefaultFeatures
	}
	return false
}

func (x *CargoConfig_RuntimeLibrary) GetFeatures() []string {
	if x != nil {
		return x.Features
	}
	return nil
}

var File_buf_alpha_registry_v1alpha1_plugin_curation_proto protoreflect.FileDescriptor

var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc = []byte{
	0x0a, 0x31, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x70, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x5f, 0x63, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x1a, 0x1e, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xda, 0x01, 0x0a, 0x08, 0x47, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x1a, 0x42, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x02, 0x0a, 0x09, 0x4e, 0x50, 0x4d, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x62, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x50, 0x4d,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x72, 0x65, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x61, 0x74, 0x68, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x12, 0x4e, 0x0a, 0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73,
	0x74, 0x79, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x50, 0x4d, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x1a, 0x44, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd3, 0x08, 0x0a, 0x0b, 0x4d,
	0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x11, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x12, 0x53, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x13, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x1a, 0xa4,
	0x01, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xb8, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x04, 0x6a, 0x61, 0x76, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x4a, 0x61, 0x76, 0x61, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x04, 0x6a, 0x61, 0x76, 0x61, 0x12, 0x55, 0x0a, 0x06, 0x6b, 0x6f, 0x74,
	0x6c, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x4b, 0x6f, 0x74, 0x6c,
	0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x6b, 0x6f, 0x74, 0x6c, 0x69, 0x6e,
	0x1a, 0x7a, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x4a, 0x61, 0x76, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x1a, 0x9b, 0x01, 0x0a,
	0x14, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x4b, 0x6f, 0x74, 0x6c, 0x69, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x6a, 0x76, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6a, 0x76, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x29, 0x0a, 0x10, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xa3, 0x01, 0x0a, 0x0d, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x64, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xf6, 0x02, 0x0a, 0x0b, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5f, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x74, 0x6e, 0x65, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x12, 0x64, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x75, 0x67, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x44, 0x6f, 0x74, 0x6e, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x22, 0x0d, 0x0a, 0x0b, 0x43, 0x6d, 0x61,
	0x6b, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xdf, 0x03, 0x0a, 0x0b, 0x53, 0x77, 0x69,
	0x66, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x53, 0x77, 0x69, 0x66, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xe9,
	0x02, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x12, 0x5e, 0x0a, 0x09, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x77, 0x69, 0x66, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x09,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x77, 0x69,
	0x66, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x73, 0x77, 0x69, 0x66, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x68, 0x0a, 0x08, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x42, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x77, 0x69, 0x66, 0x74, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xbe, 0x02, 0x0a, 0x0c, 0x50,
	0x79, 0x74, 0x68, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x11, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x70,
	0x79, 0x74, 0x68, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x73, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0c, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x4b,
	0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x12, 0x39, 0x0a, 0x18, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x17, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb5, 0x02, 0x0a, 0x0b,
	0x43, 0x61, 0x72, 0x67, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x72,
	0x75, 0x73, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x72, 0x75, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x64,
	0x0a, 0x11, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x72, 0x67, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x52, 0x10, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x1a, 0x9c, 0x01, 0x0a, 0x0e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x22, 0xaf, 0x05, 0x0a, 0x0e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x67, 0x6f, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x08, 0x67, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x0a,
	0x6e, 0x70, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e,
	0x50, 0x4d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x09, 0x6e, 0x70, 0x6d, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0c, 0x6d, 0x61, 0x76, 0x65, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x76, 0x65, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x61, 0x76, 0x65, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x77, 0x69, 0x66, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x77, 0x69, 0x66, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x77, 0x69, 0x66, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x0d, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0c, 0x63, 0x61, 0x72, 0x67, 0x6f, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x72, 0x67, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x61, 0x72, 0x67, 0x6f, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0c, 0x6e, 0x75, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4e, 0x75, 0x67, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x6e, 0x75, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0c, 0x63, 0x6d, 0x61, 0x6b, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6d, 0x61, 0x6b, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6d, 0x61, 0x6b, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x11, 0x0a, 0x0f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4a,
	0x04, 0x08, 0x09, 0x10, 0x0a, 0x22, 0x78, 0x0a, 0x16, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xb3, 0x08, 0x0a, 0x0d, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57,
	0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a,
	0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x10, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x70, 0x64, 0x78, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x70, 0x64,
	0x78, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x1a, 0x0a, 0x08, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a,
	0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x2f, 0x0a,
	0x13, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x70, 0x72,
	0x65, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x32,
	0x0a, 0x15, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x75,
	0x69, 0x64, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x75, 0x69, 0x64, 0x65, 0x55,
	0x72, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x6f, 0x63, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x64, 0x6f, 0x63, 0x12, 0x4f, 0x0a, 0x0b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x26, 0x0a, 0x10, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfa, 0x01,
	0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x50, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x12, 0x37, 0x0a, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x77, 0x65, 0x6c,
	0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x57, 0x65, 0x6c, 0x6c,
	0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x6b, 0x0a, 0x14, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x53, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0xb0, 0x02, 0x0a, 0x17, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x0f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a,
	0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a, 0x18, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b, 0x6e, 0x6f, 0x77,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52,
	0x15, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x57, 0x65, 0x6c, 0x6c, 0x4b, 0x6e, 0x6f, 0x77,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x42, 0x1b, 0x0a,
	0x19, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x77, 0x65, 0x6c, 0x6c, 0x5f, 0x6b,
	0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x22, 0x67, 0x0a, 0x18, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x60, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x1d, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa3, 0x06, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a,
	0x16, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a,
	0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x56, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x70, 0x64, 0x78, 0x5f,
	0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x73, 0x70, 0x64, 0x78, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x55, 0x72, 0x6c,
	0x12, 0x54, 0x0a, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x47, 0x75, 0x69, 0x64, 0x65, 0x55, 0x72, 0x6c, 0x22, 0x6f, 0x0a, 0x1b, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x0d, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xda, 0x01, 0x0a, 0x19,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x12,
	0x38, 0x0a, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x16, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x44, 0x65,
	0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x52, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb9, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x73, 0x22, 0xbc, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x06, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x56, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x57, 0x0a, 0x1d, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x09,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2a, 0x91, 0x01, 0x0a, 0x17, 0x43, 0x75,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x56, 0x69, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a, 0x25, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44,
	0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x24, 0x0a, 0x20, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47,
	0x49, 0x4e, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x55,
	0x42, 0x4c, 0x49, 0x43, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x55, 0x52, 0x41, 0x54, 0x45,
	0x44, 0x5f, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x59, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x02, 0x2a, 0xda, 0x02,
	0x0a, 0x12, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x52,
	0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4c,
	0x55, 0x47, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x47, 0x4f, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x4c, 0x55, 0x47, 0x49,
	0x4e, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x4e, 0x50, 0x4d, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41,
	0x56, 0x45, 0x4e, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x57,
	0x49, 0x46, 0x54, 0x10, 0x04, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f,
	0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x59,
	0x54, 0x48, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43,
	0x41, 0x52, 0x47, 0x4f, 0x10, 0x07, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e,
	0x55, 0x47, 0x45, 0x54, 0x10, 0x08, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43,
	0x4d, 0x41, 0x4b, 0x45, 0x10, 0x09, 0x22, 0x04, 0x08, 0x06, 0x10, 0x06, 0x2a, 0x1c, 0x50, 0x4c,
	0x55, 0x47, 0x49, 0x4e, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x2a, 0xe5, 0x03, 0x0a, 0x0e, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a,
	0x1b, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16,
	0x0a, 0x12, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47,
	0x45, 0x5f, 0x47, 0x4f, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x53, 0x43,
	0x52, 0x49, 0x50, 0x54, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x53, 0x43,
	0x52, 0x49, 0x50, 0x54, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e,
	0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x53, 0x57, 0x49, 0x46, 0x54, 0x10,
	0x04, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47,
	0x55, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x50, 0x50, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c,
	0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4a, 0x41,
	0x56, 0x41, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c,
	0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x41, 0x52, 0x54, 0x10, 0x07, 0x12, 0x18,
	0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47,
	0x45, 0x5f, 0x52, 0x55, 0x53, 0x54, 0x10, 0x08, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x4c, 0x55, 0x47,
	0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x59, 0x54, 0x48,
	0x4f, 0x4e, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c,
	0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x55, 0x42, 0x59, 0x10, 0x0a, 0x12, 0x1a,
	0x0a, 0x16, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47,
	0x45, 0x5f, 0x4b, 0x4f, 0x54, 0x4c, 0x49, 0x4e, 0x10, 0x0b, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x4c,
	0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x4f, 0x42,
	0x4a, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x10, 0x0c, 0x12, 0x17, 0x0a, 0x13, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x50,
	0x48, 0x50, 0x10, 0x0d, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c,
	0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x53, 0x48, 0x41, 0x52, 0x50, 0x10, 0x0e,
	0x12, 0x19, 0x0a, 0x15, 0x50, 0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55,
	0x41, 0x47, 0x45, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x41, 0x10, 0x0f, 0x12, 0x15, 0x0a, 0x11, 0x50,
	0x4c, 0x55, 0x47, 0x49, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f, 0x43,
	0x10, 0x10, 0x2a, 0x6e, 0x0a, 0x0e, 0x4e, 0x50, 0x4d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x74, 0x79, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x4e, 0x50, 0x4d, 0x5f, 0x49, 0x4d, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x4e, 0x50, 0x4d, 0x5f, 0x49, 0x4d,
	0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x50, 0x4d, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52,
	0x54, 0x5f, 0x53, 0x54, 0x59, 0x4c, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x4a, 0x53,
	0x10, 0x02, 0x2a, 0xb3, 0x01, 0x0a, 0x11, 0x53, 0x77, 0x69, 0x66, 0x74, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x57, 0x49, 0x46,
	0x54, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a,
	0x19, 0x53, 0x57, 0x49, 0x46, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x43, 0x4f, 0x53, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17,
	0x53, 0x57, 0x49, 0x46, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x57, 0x49,
	0x46, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x57, 0x41, 0x54, 0x43, 0x48, 0x4f, 0x53, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x57,
	0x49, 0x46, 0x54, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x54, 0x56, 0x4f, 0x53, 0x10, 0x04, 0x2a, 0x7c, 0x0a, 0x11, 0x50, 0x79, 0x74, 0x68,
	0x6f, 0x6e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x1f, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43,
	0x4b, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x5f, 0x50, 0x41,
	0x43, 0x4b, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x55, 0x42, 0x5f,
	0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x2a, 0xe9, 0x04, 0x0a, 0x15, 0x44, 0x6f, 0x74, 0x6e, 0x65,
	0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x27, 0x0a, 0x23, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45,
	0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54,
	0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45,
	0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x5f, 0x31, 0x5f, 0x30, 0x10, 0x01, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54,
	0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52,
	0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x31, 0x5f,
	0x31, 0x10, 0x02, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41,
	0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e,
	0x45, 0x54, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x31, 0x5f, 0x32, 0x10, 0x03,
	0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45,
	0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x53,
	0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x31, 0x5f, 0x33, 0x10, 0x04, 0x12, 0x2b, 0x0a,
	0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46,
	0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x53, 0x54, 0x41, 0x4e,
	0x44, 0x41, 0x52, 0x44, 0x5f, 0x31, 0x5f, 0x34, 0x10, 0x05, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f,
	0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d,
	0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52,
	0x44, 0x5f, 0x31, 0x5f, 0x35, 0x10, 0x06, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45,
	0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f,
	0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x31,
	0x5f, 0x36, 0x10, 0x07, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54,
	0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f,
	0x4e, 0x45, 0x54, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x32, 0x5f, 0x30, 0x10,
	0x08, 0x12, 0x2b, 0x0a, 0x27, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47,
	0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54,
	0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x32, 0x5f, 0x31, 0x10, 0x09, 0x12, 0x23,
	0x0a, 0x1f, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f,
	0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x5f, 0x35, 0x5f,
	0x30, 0x10, 0x0a, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41,
	0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e,
	0x45, 0x54, 0x5f, 0x36, 0x5f, 0x30, 0x10, 0x0b, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x4f, 0x54, 0x4e,
	0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x57,
	0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x5f, 0x37, 0x5f, 0x30, 0x10, 0x0c, 0x12, 0x23, 0x0a,
	0x1f, 0x44, 0x4f, 0x54, 0x4e, 0x45, 0x54, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x46,
	0x52, 0x41, 0x4d, 0x45, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x4e, 0x45, 0x54, 0x5f, 0x38, 0x5f, 0x30,
	0x10, 0x0d, 0x32, 0xdd, 0x04, 0x0a, 0x15, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8a, 0x01, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x73, 0x12, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x96, 0x01, 0x0a, 0x16, 0x47, 0x65,
	0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x12, 0x3a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x37, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x75, 0x72, 0x61, 0x74, 0x65, 0x64, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x02, 0x32, 0x8c, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x64, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x73, 0x0a, 0x0c,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x42, 0xa0, 0x02, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x42, 0x13, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x43, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x59, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x67, 0x65,
	0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x42, 0x41, 0x52, 0xaa, 0x02, 0x1b,
	0x42, 0x75, 0x66, 0x2e, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1b, 0x42, 0x75,
	0x66, 0x5c, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xe2, 0x02, 0x27, 0x42, 0x75, 0x66, 0x5c,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0x5c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5c, 0x56,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xea, 0x02, 0x1e, 0x42, 0x75, 0x66, 0x3a, 0x3a, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0x3a, 0x3a, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescOnce sync.Once
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData = file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc
)

func file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescGZIP() []byte {
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescOnce.Do(func() {
		file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData)
	})
	return file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDescData
}

var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes = []any{
	(CuratedPluginVisibility)(0),                // 0: buf.alpha.registry.v1alpha1.CuratedPluginVisibility
	(PluginRegistryType)(0),                     // 1: buf.alpha.registry.v1alpha1.PluginRegistryType
	(PluginLanguage)(0),                         // 2: buf.alpha.registry.v1alpha1.PluginLanguage
	(NPMImportStyle)(0),                         // 3: buf.alpha.registry.v1alpha1.NPMImportStyle
	(SwiftPlatformType)(0),                      // 4: buf.alpha.registry.v1alpha1.SwiftPlatformType
	(PythonPackageType)(0),                      // 5: buf.alpha.registry.v1alpha1.PythonPackageType
	(DotnetTargetFramework)(0),                  // 6: buf.alpha.registry.v1alpha1.DotnetTargetFramework
	(*GoConfig)(nil),                            // 7: buf.alpha.registry.v1alpha1.GoConfig
	(*NPMConfig)(nil),                           // 8: buf.alpha.registry.v1alpha1.NPMConfig
	(*MavenConfig)(nil),                         // 9: buf.alpha.registry.v1alpha1.MavenConfig
	(*NugetConfig)(nil),                         // 10: buf.alpha.registry.v1alpha1.NugetConfig
	(*CmakeConfig)(nil),                         // 11: buf.alpha.registry.v1alpha1.CmakeConfig
	(*SwiftConfig)(nil),                         // 12: buf.alpha.registry.v1alpha1.SwiftConfig
	(*PythonConfig)(nil),                        // 13: buf.alpha.registry.v1alpha1.PythonConfig
	(*CargoConfig)(nil),                         // 14: buf.alpha.registry.v1alpha1.CargoConfig
	(*RegistryConfig)(nil),                      // 15: buf.alpha.registry.v1alpha1.RegistryConfig
	(*CuratedPluginReference)(nil),              // 16: buf.alpha.registry.v1alpha1.CuratedPluginReference
	(*CuratedPlugin)(nil),                       // 17: buf.alpha.registry.v1alpha1.CuratedPlugin
	(*PluginCollection)(nil),                    // 18: buf.alpha.registry.v1alpha1.PluginCollection
	(*GenerateCodeRequest)(nil),                 // 19: buf.alpha.registry.v1alpha1.GenerateCodeRequest
	(*GenerateCodeResponse)(nil),                // 20: buf.alpha.registry.v1alpha1.GenerateCodeResponse
	(*PluginGenerationRequest)(nil),             // 21: buf.alpha.registry.v1alpha1.PluginGenerationRequest
	(*PluginGenerationResponse)(nil),            // 22: buf.alpha.registry.v1alpha1.PluginGenerationResponse
	(*DeleteCuratedPluginRequest)(nil),          // 23: buf.alpha.registry.v1alpha1.DeleteCuratedPluginRequest
	(*DeleteCuratedPluginResponse)(nil),         // 24: buf.alpha.registry.v1alpha1.DeleteCuratedPluginResponse
	(*CreateCuratedPluginRequest)(nil),          // 25: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest
	(*CreateCuratedPluginResponse)(nil),         // 26: buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse
	(*ListCuratedPluginsRequest)(nil),           // 27: buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest
	(*ListCuratedPluginsResponse)(nil),          // 28: buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse
	(*GetLatestCuratedPluginRequest)(nil),       // 29: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest
	(*GetLatestCuratedPluginResponse)(nil),      // 30: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse
	(*CuratedPluginVersionRevisions)(nil),       // 31: buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisions
	(*GoConfig_RuntimeLibrary)(nil),             // 32: buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibrary
	(*NPMConfig_RuntimeLibrary)(nil),            // 33: buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibrary
	(*MavenConfig_RuntimeLibrary)(nil),          // 34: buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibrary
	(*MavenConfig_CompilerConfig)(nil),          // 35: buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig
	(*MavenConfig_CompilerJavaConfig)(nil),      // 36: buf.alpha.registry.v1alpha1.MavenConfig.CompilerJavaConfig
	(*MavenConfig_CompilerKotlinConfig)(nil),    // 37: buf.alpha.registry.v1alpha1.MavenConfig.CompilerKotlinConfig
	(*MavenConfig_RuntimeConfig)(nil),           // 38: buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfig
	(*NugetConfig_RuntimeLibrary)(nil),          // 39: buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibrary
	(*SwiftConfig_RuntimeLibrary)(nil),          // 40: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary
	(*SwiftConfig_RuntimeLibrary_Platform)(nil), // 41: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.Platform
	(*PythonConfig_RuntimeLibrary)(nil),         // 42: buf.alpha.registry.v1alpha1.PythonConfig.RuntimeLibrary
	(*CargoConfig_RuntimeLibrary)(nil),          // 43: buf.alpha.registry.v1alpha1.CargoConfig.RuntimeLibrary
	(*timestamppb.Timestamp)(nil),               // 44: google.protobuf.Timestamp
	(*v1.Image)(nil),                            // 45: buf.alpha.image.v1.Image
	(*pluginpb.CodeGeneratorResponse)(nil),      // 46: google.protobuf.compiler.CodeGeneratorResponse
}
var file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs = []int32{
	32, // 0: buf.alpha.registry.v1alpha1.GoConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.GoConfig.RuntimeLibrary
	33, // 1: buf.alpha.registry.v1alpha1.NPMConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.NPMConfig.RuntimeLibrary
	3,  // 2: buf.alpha.registry.v1alpha1.NPMConfig.import_style:type_name -> buf.alpha.registry.v1alpha1.NPMImportStyle
	34, // 3: buf.alpha.registry.v1alpha1.MavenConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibrary
	35, // 4: buf.alpha.registry.v1alpha1.MavenConfig.compiler:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig
	38, // 5: buf.alpha.registry.v1alpha1.MavenConfig.additional_runtimes:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfig
	6,  // 6: buf.alpha.registry.v1alpha1.NugetConfig.target_frameworks:type_name -> buf.alpha.registry.v1alpha1.DotnetTargetFramework
	39, // 7: buf.alpha.registry.v1alpha1.NugetConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibrary
	40, // 8: buf.alpha.registry.v1alpha1.SwiftConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary
	42, // 9: buf.alpha.registry.v1alpha1.PythonConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.PythonConfig.RuntimeLibrary
	5,  // 10: buf.alpha.registry.v1alpha1.PythonConfig.package_type:type_name -> buf.alpha.registry.v1alpha1.PythonPackageType
	43, // 11: buf.alpha.registry.v1alpha1.CargoConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.CargoConfig.RuntimeLibrary
	7,  // 12: buf.alpha.registry.v1alpha1.RegistryConfig.go_config:type_name -> buf.alpha.registry.v1alpha1.GoConfig
	8,  // 13: buf.alpha.registry.v1alpha1.RegistryConfig.npm_config:type_name -> buf.alpha.registry.v1alpha1.NPMConfig
	9,  // 14: buf.alpha.registry.v1alpha1.RegistryConfig.maven_config:type_name -> buf.alpha.registry.v1alpha1.MavenConfig
	12, // 15: buf.alpha.registry.v1alpha1.RegistryConfig.swift_config:type_name -> buf.alpha.registry.v1alpha1.SwiftConfig
	13, // 16: buf.alpha.registry.v1alpha1.RegistryConfig.python_config:type_name -> buf.alpha.registry.v1alpha1.PythonConfig
	14, // 17: buf.alpha.registry.v1alpha1.RegistryConfig.cargo_config:type_name -> buf.alpha.registry.v1alpha1.CargoConfig
	10, // 18: buf.alpha.registry.v1alpha1.RegistryConfig.nuget_config:type_name -> buf.alpha.registry.v1alpha1.NugetConfig
	11, // 19: buf.alpha.registry.v1alpha1.RegistryConfig.cmake_config:type_name -> buf.alpha.registry.v1alpha1.CmakeConfig
	1,  // 20: buf.alpha.registry.v1alpha1.CuratedPlugin.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	44, // 21: buf.alpha.registry.v1alpha1.CuratedPlugin.create_time:type_name -> google.protobuf.Timestamp
	16, // 22: buf.alpha.registry.v1alpha1.CuratedPlugin.dependencies:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	15, // 23: buf.alpha.registry.v1alpha1.CuratedPlugin.registry_config:type_name -> buf.alpha.registry.v1alpha1.RegistryConfig
	2,  // 24: buf.alpha.registry.v1alpha1.CuratedPlugin.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	0,  // 25: buf.alpha.registry.v1alpha1.CuratedPlugin.visibility:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVisibility
	18, // 26: buf.alpha.registry.v1alpha1.CuratedPlugin.collections:type_name -> buf.alpha.registry.v1alpha1.PluginCollection
	45, // 27: buf.alpha.registry.v1alpha1.GenerateCodeRequest.image:type_name -> buf.alpha.image.v1.Image
	21, // 28: buf.alpha.registry.v1alpha1.GenerateCodeRequest.requests:type_name -> buf.alpha.registry.v1alpha1.PluginGenerationRequest
	22, // 29: buf.alpha.registry.v1alpha1.GenerateCodeResponse.responses:type_name -> buf.alpha.registry.v1alpha1.PluginGenerationResponse
	16, // 30: buf.alpha.registry.v1alpha1.PluginGenerationRequest.plugin_reference:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	46, // 31: buf.alpha.registry.v1alpha1.PluginGenerationResponse.response:type_name -> google.protobuf.compiler.CodeGeneratorResponse
	1,  // 32: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.registry_type:type_name -> buf.alpha.registry.v1alpha1.PluginRegistryType
	16, // 33: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.dependencies:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginReference
	15, // 34: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.registry_config:type_name -> buf.alpha.registry.v1alpha1.RegistryConfig
	2,  // 35: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.output_languages:type_name -> buf.alpha.registry.v1alpha1.PluginLanguage
	0,  // 36: buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest.visibility:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVisibility
	17, // 37: buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse.configuration:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	17, // 38: buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse.plugins:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	17, // 39: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse.plugin:type_name -> buf.alpha.registry.v1alpha1.CuratedPlugin
	31, // 40: buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse.versions:type_name -> buf.alpha.registry.v1alpha1.CuratedPluginVersionRevisions
	36, // 41: buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig.java:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.CompilerJavaConfig
	37, // 42: buf.alpha.registry.v1alpha1.MavenConfig.CompilerConfig.kotlin:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.CompilerKotlinConfig
	34, // 43: buf.alpha.registry.v1alpha1.MavenConfig.RuntimeConfig.runtime_libraries:type_name -> buf.alpha.registry.v1alpha1.MavenConfig.RuntimeLibrary
	6,  // 44: buf.alpha.registry.v1alpha1.NugetConfig.RuntimeLibrary.target_frameworks:type_name -> buf.alpha.registry.v1alpha1.DotnetTargetFramework
	41, // 45: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.platforms:type_name -> buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.Platform
	4,  // 46: buf.alpha.registry.v1alpha1.SwiftConfig.RuntimeLibrary.Platform.name:type_name -> buf.alpha.registry.v1alpha1.SwiftPlatformType
	27, // 47: buf.alpha.registry.v1alpha1.PluginCurationService.ListCuratedPlugins:input_type -> buf.alpha.registry.v1alpha1.ListCuratedPluginsRequest
	25, // 48: buf.alpha.registry.v1alpha1.PluginCurationService.CreateCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.CreateCuratedPluginRequest
	29, // 49: buf.alpha.registry.v1alpha1.PluginCurationService.GetLatestCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.GetLatestCuratedPluginRequest
	23, // 50: buf.alpha.registry.v1alpha1.PluginCurationService.DeleteCuratedPlugin:input_type -> buf.alpha.registry.v1alpha1.DeleteCuratedPluginRequest
	19, // 51: buf.alpha.registry.v1alpha1.CodeGenerationService.GenerateCode:input_type -> buf.alpha.registry.v1alpha1.GenerateCodeRequest
	28, // 52: buf.alpha.registry.v1alpha1.PluginCurationService.ListCuratedPlugins:output_type -> buf.alpha.registry.v1alpha1.ListCuratedPluginsResponse
	26, // 53: buf.alpha.registry.v1alpha1.PluginCurationService.CreateCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.CreateCuratedPluginResponse
	30, // 54: buf.alpha.registry.v1alpha1.PluginCurationService.GetLatestCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.GetLatestCuratedPluginResponse
	24, // 55: buf.alpha.registry.v1alpha1.PluginCurationService.DeleteCuratedPlugin:output_type -> buf.alpha.registry.v1alpha1.DeleteCuratedPluginResponse
	20, // 56: buf.alpha.registry.v1alpha1.CodeGenerationService.GenerateCode:output_type -> buf.alpha.registry.v1alpha1.GenerateCodeResponse
	52, // [52:57] is the sub-list for method output_type
	47, // [47:52] is the sub-list for method input_type
	47, // [47:47] is the sub-list for extension type_name
	47, // [47:47] is the sub-list for extension extendee
	0,  // [0:47] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init() }
func file_buf_alpha_registry_v1alpha1_plugin_curation_proto_init() {
	if File_buf_alpha_registry_v1alpha1_plugin_curation_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[8].OneofWrappers = []any{
		(*RegistryConfig_GoConfig)(nil),
		(*RegistryConfig_NpmConfig)(nil),
		(*RegistryConfig_MavenConfig)(nil),
		(*RegistryConfig_SwiftConfig)(nil),
		(*RegistryConfig_PythonConfig)(nil),
		(*RegistryConfig_CargoConfig)(nil),
		(*RegistryConfig_NugetConfig)(nil),
		(*RegistryConfig_CmakeConfig)(nil),
	}
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes[14].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs,
		EnumInfos:         file_buf_alpha_registry_v1alpha1_plugin_curation_proto_enumTypes,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_plugin_curation_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_plugin_curation_proto = out.File
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_rawDesc = nil
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_plugin_curation_proto_depIdxs = nil
}
