// Copyright 2020-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/alpha/registry/v1alpha1/download.proto

package registryv1alpha1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// DownloadServiceName is the fully-qualified name of the DownloadService service.
	DownloadServiceName = "buf.alpha.registry.v1alpha1.DownloadService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// DownloadServiceDownloadProcedure is the fully-qualified name of the DownloadService's Download
	// RPC.
	DownloadServiceDownloadProcedure = "/buf.alpha.registry.v1alpha1.DownloadService/Download"
	// DownloadServiceDownloadManifestAndBlobsProcedure is the fully-qualified name of the
	// DownloadService's DownloadManifestAndBlobs RPC.
	DownloadServiceDownloadManifestAndBlobsProcedure = "/buf.alpha.registry.v1alpha1.DownloadService/DownloadManifestAndBlobs"
)

// These variables are the protoreflect.Descriptor objects for the RPCs defined in this package.
var (
	downloadServiceServiceDescriptor                        = v1alpha1.File_buf_alpha_registry_v1alpha1_download_proto.Services().ByName("DownloadService")
	downloadServiceDownloadMethodDescriptor                 = downloadServiceServiceDescriptor.Methods().ByName("Download")
	downloadServiceDownloadManifestAndBlobsMethodDescriptor = downloadServiceServiceDescriptor.Methods().ByName("DownloadManifestAndBlobs")
)

// DownloadServiceClient is a client for the buf.alpha.registry.v1alpha1.DownloadService service.
type DownloadServiceClient interface {
	// Download downloads a BSR module.
	// NOTE: Newer clients should use DownloadManifestAndBlobs instead.
	Download(context.Context, *connect.Request[v1alpha1.DownloadRequest]) (*connect.Response[v1alpha1.DownloadResponse], error)
	// DownloadManifestAndBlobs downloads a module in the manifest+blobs encoding format.
	DownloadManifestAndBlobs(context.Context, *connect.Request[v1alpha1.DownloadManifestAndBlobsRequest]) (*connect.Response[v1alpha1.DownloadManifestAndBlobsResponse], error)
}

// NewDownloadServiceClient constructs a client for the buf.alpha.registry.v1alpha1.DownloadService
// service. By default, it uses the Connect protocol with the binary Protobuf Codec, asks for
// gzipped responses, and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply
// the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewDownloadServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) DownloadServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	return &downloadServiceClient{
		download: connect.NewClient[v1alpha1.DownloadRequest, v1alpha1.DownloadResponse](
			httpClient,
			baseURL+DownloadServiceDownloadProcedure,
			connect.WithSchema(downloadServiceDownloadMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		downloadManifestAndBlobs: connect.NewClient[v1alpha1.DownloadManifestAndBlobsRequest, v1alpha1.DownloadManifestAndBlobsResponse](
			httpClient,
			baseURL+DownloadServiceDownloadManifestAndBlobsProcedure,
			connect.WithSchema(downloadServiceDownloadManifestAndBlobsMethodDescriptor),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
	}
}

// downloadServiceClient implements DownloadServiceClient.
type downloadServiceClient struct {
	download                 *connect.Client[v1alpha1.DownloadRequest, v1alpha1.DownloadResponse]
	downloadManifestAndBlobs *connect.Client[v1alpha1.DownloadManifestAndBlobsRequest, v1alpha1.DownloadManifestAndBlobsResponse]
}

// Download calls buf.alpha.registry.v1alpha1.DownloadService.Download.
func (c *downloadServiceClient) Download(ctx context.Context, req *connect.Request[v1alpha1.DownloadRequest]) (*connect.Response[v1alpha1.DownloadResponse], error) {
	return c.download.CallUnary(ctx, req)
}

// DownloadManifestAndBlobs calls
// buf.alpha.registry.v1alpha1.DownloadService.DownloadManifestAndBlobs.
func (c *downloadServiceClient) DownloadManifestAndBlobs(ctx context.Context, req *connect.Request[v1alpha1.DownloadManifestAndBlobsRequest]) (*connect.Response[v1alpha1.DownloadManifestAndBlobsResponse], error) {
	return c.downloadManifestAndBlobs.CallUnary(ctx, req)
}

// DownloadServiceHandler is an implementation of the buf.alpha.registry.v1alpha1.DownloadService
// service.
type DownloadServiceHandler interface {
	// Download downloads a BSR module.
	// NOTE: Newer clients should use DownloadManifestAndBlobs instead.
	Download(context.Context, *connect.Request[v1alpha1.DownloadRequest]) (*connect.Response[v1alpha1.DownloadResponse], error)
	// DownloadManifestAndBlobs downloads a module in the manifest+blobs encoding format.
	DownloadManifestAndBlobs(context.Context, *connect.Request[v1alpha1.DownloadManifestAndBlobsRequest]) (*connect.Response[v1alpha1.DownloadManifestAndBlobsResponse], error)
}

// NewDownloadServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewDownloadServiceHandler(svc DownloadServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	downloadServiceDownloadHandler := connect.NewUnaryHandler(
		DownloadServiceDownloadProcedure,
		svc.Download,
		connect.WithSchema(downloadServiceDownloadMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	downloadServiceDownloadManifestAndBlobsHandler := connect.NewUnaryHandler(
		DownloadServiceDownloadManifestAndBlobsProcedure,
		svc.DownloadManifestAndBlobs,
		connect.WithSchema(downloadServiceDownloadManifestAndBlobsMethodDescriptor),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.alpha.registry.v1alpha1.DownloadService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case DownloadServiceDownloadProcedure:
			downloadServiceDownloadHandler.ServeHTTP(w, r)
		case DownloadServiceDownloadManifestAndBlobsProcedure:
			downloadServiceDownloadManifestAndBlobsHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedDownloadServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedDownloadServiceHandler struct{}

func (UnimplementedDownloadServiceHandler) Download(context.Context, *connect.Request[v1alpha1.DownloadRequest]) (*connect.Response[v1alpha1.DownloadResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.DownloadService.Download is not implemented"))
}

func (UnimplementedDownloadServiceHandler) DownloadManifestAndBlobs(context.Context, *connect.Request[v1alpha1.DownloadManifestAndBlobsRequest]) (*connect.Response[v1alpha1.DownloadManifestAndBlobsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.alpha.registry.v1alpha1.DownloadService.DownloadManifestAndBlobs is not implemented"))
}
