#!/usr/bin/env perl
use strict;
use Config;

if ($#ARGV ne 2 and $#ARGV ne 3) {
    die "Usage: $0 AppName IncludeRoot SourceRoot [include prefix]";
}
my ($APPNAME,$INCDIR, $SRCDIR, $PREFIX) = @ARGV;
$PREFIX or $PREFIX = '';

my $APPNAME_U = uc $APPNAME;

my @DATE = localtime;
my $DATE = sprintf "%4d%02d%02d%02d%02d%02d", $DATE[5]+1900, $DATE[4]+1, $DATE[3], $DATE[2], $DATE[1], $DATE[0];

my $OSTAG = 'Unknown';
if ($Config{osname} eq 'linux') {
	$OSTAG = 'Linux';
} elsif ($Config{osname} eq 'darwin') {
	$OSTAG = 'MacOSX';
} elsif ($Config{osname} eq 'MSWin32') {
	$OSTAG = 'Win32';
}


my $header = qq{//////////////////////////////////////////////////
// File autogenerated by buildcounter
// Do not hand edit! (preferably)
//////////////////////////////////////////////////

#ifndef BUILDID_${APPNAME_U}_H
#define BUILDID_${APPNAME_U}_H

const char* GetBuildID_${APPNAME}();


#endif //BUILDID_${APPNAME_U}_H
};

my $source = qq{//////////////////////////////////////////////////
// File autogenerated by buildcounter
// Do not hand edit! (preferably)
//////////////////////////////////////////////////
#include "${PREFIX}BuildID_${APPNAME}.h"

static char gsBuildID[16] = "${DATE}";

const char* GetBuildID_${APPNAME}()
{
    return gsBuildID;
}
};

$header =~ s/\n/\r\n/gms;

my $full = $INCDIR.'/'.$PREFIX.'BuildID_'.$APPNAME.'.h';

print 'Writing '.$full."\n";
open DAFILE, ">$full" or die("Unable to open $full");
print DAFILE $header;
close DAFILE;

$full = $SRCDIR.'/BuildID_'.$APPNAME.'_'.$OSTAG.'.cpp';
print 'Writing '.$full."\n";
open DAFILE, ">$full" or die("Unable to open $full");
print DAFILE $source;
close DAFILE;

