% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe_continuation_linter.R
\name{pipe_continuation_linter}
\alias{pipe_continuation_linter}
\title{Pipe continuation linter}
\usage{
pipe_continuation_linter()
}
\description{
Check that each step in a pipeline is on a new line, or the entire pipe fits on one line.
}
\examples{
# will produce lints
code_lines <- "1:3 \%>\%\n mean() \%>\% as.character()"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = pipe_continuation_linter()
)

code_lines <- "1:3 |> mean() |>\n as.character()"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = pipe_continuation_linter()
)

# okay
lint(
  text = "1:3 \%>\% mean() \%>\% as.character()",
  linters = pipe_continuation_linter()
)

code_lines <- "1:3 \%>\%\n mean() \%>\%\n as.character()"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = pipe_continuation_linter()
)

lint(
  text = "1:3 |> mean() |> as.character()",
  linters = pipe_continuation_linter()
)

code_lines <- "1:3 |>\n mean() |>\n as.character()"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = pipe_continuation_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/pipes.html#long-lines-2}
}
}
\section{Tags}{
\link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
