% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate-responses.R
\name{resps_successes}
\alias{resps_successes}
\alias{resps_failures}
\alias{resps_requests}
\alias{resps_data}
\title{Tools for working with lists of responses}
\usage{
resps_successes(resps)

resps_failures(resps)

resps_requests(resps)

resps_data(resps, resp_data)
}
\arguments{
\item{resps}{A list of responses (possibly including errors).}

\item{resp_data}{A function that takes a response (\code{resp}) and
returns the data found inside that response as a vector or data frame.}
}
\description{
These function provide a basic toolkit for operating with lists of
responses and possibly errors, as returned by \code{\link[=req_perform_parallel]{req_perform_parallel()}},
\code{\link[=req_perform_sequential]{req_perform_sequential()}} and \code{\link[=req_perform_iterative]{req_perform_iterative()}}.
\itemize{
\item \code{resps_successes()} returns a list successful responses.
\item \code{resps_failures()} returns a list failed responses (i.e. errors).
\item \code{resps_requests()} returns the list of requests that corresponds to
each request.
\item \code{resps_data()} returns all the data in a single vector or data frame.
It requires the vctrs package to be installed.
}
}
\examples{
reqs <- list(
  request(example_url()) |> req_url_path("/ip"),
  request(example_url()) |> req_url_path("/user-agent"),
  request(example_url()) |> req_template("/status/:status", status = 404),
  request("INVALID")
)
resps <- req_perform_parallel(reqs, on_error = "continue")

# find successful responses
resps |> resps_successes()

# collect all their data
resps |> resps_successes() |> resps_data(\(resp) resp_body_json(resp))

# find requests corresponding to failure responses
resps |> resps_failures() |> resps_requests()
}
