/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    QStringList extensions;
    extensions << QLatin1String("csv") << QLatin1String("cfo") << QLatin1String("gnucash") << QLatin1String("gsb") << QLatin1String("kmy") << QLatin1String("mmb") << QLatin1String("mt940") << QLatin1String("ofx") << QLatin1String("qif") << QLatin1String("skg") << QLatin1String("xhb");

    int nb = extensions.count();
    for (int i = 0; i < nb; ++i) {
        const QString& ext = extensions.at(i);
        QString filename = "https://skrooge.org/skgtestimporturl/test." % ext;
        SKGTRACE << i + 1 << "/" << nb << ": Import " << filename << Qt::endl;

        // Test import
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromUserInput(filename));
            SKGTESTERROR(ext % ".importFile", imp1.importFile(), true)
        }
    }

    {
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGTESTERROR(QLatin1String("document1.load()"), document1.load(QLatin1String("https://skrooge.org/skgtestimporturl/test.skg")), true)
    }

    // End test
    SKGENDTEST()
}
