/***************************************************************************
                               bind_legend.cpp
                               ---------------
    begin                : Nov 08 2005
    copyright            : (C) 2005 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bind_legend.h"

#include <kst.h>
#include <kstviewwindow.h>

#include <kdebug.h>

KstBindLegend::KstBindLegend(KJS::ExecState *exec, KstViewLegendPtr d, const char *name)
: KstBindViewObject(exec, d.data(), name ? name : "Legend") {
  KJS::Object o(this);
  addBindings(exec, o);
}


KstBindLegend::KstBindLegend(KJS::ExecState *exec, KJS::Object *globalObject, const char *name)
: KstBindViewObject(exec, globalObject, name ? name : "Legend") {
  KJS::Object o(this);
  addBindings(exec, o);
  if (globalObject) {
    KstBindViewObject::addFactory("Legend", KstBindLegend::bindFactory);
  }
}


KstBindViewObject *KstBindLegend::bindFactory(KJS::ExecState *exec, KstViewObjectPtr obj) {
  KstViewLegendPtr v = kst_cast<KstViewLegend>(obj);
  if (v) {
    return new KstBindLegend(exec, v);
  }
  return 0L;
}


KstBindLegend::KstBindLegend(int id, const char *name)
: KstBindViewObject(id, name ? name : "Legend Method") {
}


KstBindLegend::~KstBindLegend() {
}


KJS::Object KstBindLegend::construct(KJS::ExecState *exec, const KJS::List& args) {
  if (args.size() == 0 || args.size() > 2) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::SyntaxError);
    exec->setException(eobj);
    return KJS::Object();
  }

  KstViewWindow *w = extractWindow(exec, args[0]);
  if (!w) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::TypeError);
    exec->setException(eobj);
    return KJS::Object();
  }

  QString txt;

  if (args.size() == 2) {
    if (args[1].type() != KJS::StringType) {
      KJS::Object eobj = KJS::Error::create(exec, KJS::TypeError);
      exec->setException(eobj);
      return KJS::Object();
    }
    txt = args[1].toString(exec).qstring();
  }

  KstViewLegendPtr b = new KstViewLegend;
  w->view()->appendChild(b.data());
  w->view()->paint(P_PAINT);
  return KJS::Object(new KstBindLegend(exec, b));
}


struct LegendBindings {
  const char *name;
  KJS::Value (KstBindLegend::*method)(KJS::ExecState*, const KJS::List&);
};


struct LegendProperties {
  const char *name;
  void (KstBindLegend::*set)(KJS::ExecState*, const KJS::Value&);
  KJS::Value (KstBindLegend::*get)(KJS::ExecState*) const;
};


static LegendBindings legendBindings[] = {
  { 0L, 0L }
};


static LegendProperties legendProperties[] = {
  { "font", &KstBindLegend::setFont, &KstBindLegend::font },
  { "fontSize", &KstBindLegend::setFontSize, &KstBindLegend::fontSize },
  { "scalarReplacement", &KstBindLegend::setScalarReplacement, &KstBindLegend::scalarReplacement },
  { 0L, 0L, 0L }
};


int KstBindLegend::methodCount() const {
  return sizeof legendBindings + KstBindViewObject::methodCount();
}


int KstBindLegend::propertyCount() const {
  return sizeof legendProperties + KstBindViewObject::propertyCount();
}


KJS::ReferenceList KstBindLegend::propList(KJS::ExecState *exec, bool recursive) {
  KJS::ReferenceList rc = KstBindViewObject::propList(exec, recursive);

  for (int i = 0; legendProperties[i].name; ++i) {
    rc.append(KJS::Reference(this, KJS::Identifier(legendProperties[i].name)));
  }

  return rc;
}


bool KstBindLegend::hasProperty(KJS::ExecState *exec, const KJS::Identifier& propertyName) const {
  QString prop = propertyName.qstring();
  for (int i = 0; legendProperties[i].name; ++i) {
    if (prop == legendProperties[i].name) {
      return true;
    }
  }

  return KstBindViewObject::hasProperty(exec, propertyName);
}


void KstBindLegend::put(KJS::ExecState *exec, const KJS::Identifier& propertyName, const KJS::Value& value, int attr) {
  if (!_d) {
    KstBindViewObject::put(exec, propertyName, value, attr);
    return;
  }

  QString prop = propertyName.qstring();
  for (int i = 0; legendProperties[i].name; ++i) {
    if (prop == legendProperties[i].name) {
      if (!legendProperties[i].set) {
        break;
      }
      (this->*legendProperties[i].set)(exec, value);
      return;
    }
  }

  KstBindViewObject::put(exec, propertyName, value, attr);
}


KJS::Value KstBindLegend::get(KJS::ExecState *exec, const KJS::Identifier& propertyName) const {
  if (!_d) {
    return KstBindViewObject::get(exec, propertyName);
  }

  QString prop = propertyName.qstring();
  for (int i = 0; legendProperties[i].name; ++i) {
    if (prop == legendProperties[i].name) {
      if (!legendProperties[i].get) {
        break;
      }
      return (this->*legendProperties[i].get)(exec);
    }
  }
  
  return KstBindViewObject::get(exec, propertyName);
}


KJS::Value KstBindLegend::call(KJS::ExecState *exec, KJS::Object& self, const KJS::List& args) {
  int id = this->id();
  if (id <= 0) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::GeneralError);
    exec->setException(eobj);
    return KJS::Undefined();
  }

  int start = KstBindViewObject::methodCount();
  if (id > start) {
    KstBindLegend *imp = dynamic_cast<KstBindLegend*>(self.imp());
    if (!imp) {
      KJS::Object eobj = KJS::Error::create(exec, KJS::GeneralError);
      exec->setException(eobj);
      return KJS::Undefined();
    }

    return (imp->*legendBindings[id - start - 1].method)(exec, args);
  } 

  return KstBindViewObject::call(exec, self, args);
}


void KstBindLegend::addBindings(KJS::ExecState *exec, KJS::Object& obj) {
  int start = KstBindViewObject::methodCount();
  for (int i = 0; legendBindings[i].name != 0L; ++i) {
    KJS::Object o = KJS::Object(new KstBindLegend(i + start + 1));
    obj.put(exec, legendBindings[i].name, o, KJS::Function);
  }
}


#define makeLegend(X) dynamic_cast<KstViewLegend*>(const_cast<KstObject*>(X.data()))

void KstBindLegend::setFont(KJS::ExecState *exec, const KJS::Value& value) {
  if (value.type() != KJS::StringType) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::TypeError);
    exec->setException(eobj);
    return;
  }
  KstViewLegendPtr d = makeLegend(_d);
  if (d) {
    KstWriteLocker wl(d);
    d->setFontName(value.toString(exec).qstring());
    KstApp::inst()->paintAll(P_PAINT);
  }
}


KJS::Value KstBindLegend::font(KJS::ExecState *exec) const {
  Q_UNUSED(exec)
  KstViewLegendPtr d = makeLegend(_d);
  if (d) {
    KstReadLocker rl(d);
    return KJS::String(d->fontName());
  }
  return KJS::String();
}


void KstBindLegend::setFontSize(KJS::ExecState *exec, const KJS::Value& value) {
  unsigned int i = 0;
  if (value.type() != KJS::NumberType || !value.toUInt32(i)) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::TypeError);
    exec->setException(eobj);
    return;
  }
  KstViewLegendPtr d = makeLegend(_d);
  if (d) {
    KstWriteLocker wl(d);
    d->setFontSize(i);
    KstApp::inst()->paintAll(P_PAINT);
  }
}


KJS::Value KstBindLegend::fontSize(KJS::ExecState *exec) const {
  Q_UNUSED(exec)
  KstViewLegendPtr d = makeLegend(_d);
  if (d) {
    KstReadLocker rl(d);
    return KJS::Number(d->fontSize());
  }
  return KJS::Number(0);
}


void KstBindLegend::setScalarReplacement(KJS::ExecState *exec, const KJS::Value& value) {
  if (value.type() != KJS::BooleanType) {
    KJS::Object eobj = KJS::Error::create(exec, KJS::TypeError);
    exec->setException(eobj);
    return;
  }
  KstViewLegendPtr d = makeLegend(_d);
  if (d) {
    KstWriteLocker wl(d);
    d->setDoScalarReplacement(value.toBoolean(exec));
    KstApp::inst()->paintAll(P_PAINT);
  }
}


KJS::Value KstBindLegend::scalarReplacement(KJS::ExecState *exec) const {
  Q_UNUSED(exec)
  KstViewLegendPtr d = makeLegend(_d);
  if (d) {
    KstReadLocker rl(d);
    return KJS::Boolean(d->doScalarReplacement());
  }
  return KJS::Boolean(false);
}


#undef makeLegend

// vim: ts=2 sw=2 et
