/***************************************************************************
                          krelais.cpp  -  description
                             -------------------
    begin                : Wed Feb 12 21:36:24 CET 2003
    copyright            : (C) 2003 by Burkhard Brauer     (* Elektromeister *)
    email                : BurkhardBrauer@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "krelais.h"
#include <stdio.h>
#include <unistd.h>
#include <dirent.h>
#include <qmessagebox.h>


extern QString data_path;

using namespace std;

QString Str,QStr;
//QPoint MausKoordinaten(100,200),altMausKoordinaten(100,200);
QString PfadPlusDateiname;
char DateiKennung[121]={"Schaltungsdaten CAD-Relais Autor:Burkhard Brauer Berliner Strae 80 25421 Pinneberg"};
char DateiKennungsMerker[256];

int PressMausX,PressMausY;
int moveMausX,moveMausY;
int MausButton=0;
char CStr[256];
int DurchlaufNr=0;


KRelais::KRelais()
{ 	int Nr,Zeile,Spalte;
	Hintergrund.setRgb (80,80,80);

// *** Relais ***
	RelaisOFF.resize(55,95);
	RelaisOFF.fill(Hintergrund);
   	paint.begin(&RelaisOFF);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setRasterOp(CopyROP);
		paint.setBrush(gray);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.fillRect(2,35,51,25,gray);
	paint.end();
	RelaisON.resize(55,95);
	RelaisON.fill(Hintergrund);
   paint.begin(&RelaisON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.fillRect(2,35,51,25,red);
	paint.end();
//*** Anzugsverzgertes Zeitrelais ***
   RelaisSeOFF.resize(55,95);
	RelaisSeOFF.fill(Hintergrund);
   paint.begin(&RelaisSeOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.fillRect(2,35,51,25,gray);
		paint.setPen(black);
		paint.moveTo(35,35);
		paint.lineTo(52,59);
		paint.moveTo(35,59);
		paint.lineTo(52,35);
		paint.moveTo(35,35);
		paint.lineTo(35,59);
	paint.end();
	RelaisSeON.resize(55,95);
	RelaisSeON.fill(Hintergrund);
   paint.begin(&RelaisSeON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.fillRect(2,35,51,25,red);
		paint.setPen(black);
		paint.moveTo(35,35);
		paint.lineTo(52,59);
		paint.moveTo(35,59);
		paint.lineTo(52,35);
		paint.moveTo(35,35);
		paint.lineTo(35,59);
	paint.end();
//*** Abfallverzgertes Zeitrelais ***
   RelaisSiOFF.resize(55,95);
	RelaisSiOFF.fill(Hintergrund);
   paint.begin(&RelaisSiOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.fillRect(2,35,51,25,gray);
		paint.fillRect(35,36,17,23,black);
	paint.end();
	RelaisSiON.resize(55,95);
	RelaisSiON.fill(Hintergrund);
   paint.begin(&RelaisSiON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.fillRect(2,35,51,25,red);
		paint.fillRect(35,36,17,23,black);
	paint.end();
//*** Schliesser ***
	SchliesserOFF.resize(55,95);
	SchliesserOFF.fill(Hintergrund);
   paint.begin(&SchliesserOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(15,38);  // Kontakt
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
	SchliesserON.resize(55,95);
	SchliesserON.fill(Hintergrund);
   paint.begin(&SchliesserON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,30);  // Kontakt
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
//*** ffner ***
	OeffnerON.resize(55,95);
	OeffnerON.fill(Hintergrund);
	 paint.begin(&OeffnerON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30); 			//  	|
		paint.lineTo(38,30); 			// 	_
		paint.moveTo(28,65);
		paint.lineTo(35,25);  			//		/
		paint.drawEllipse(26,65,5,5); // *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				// 	|
	paint.end();
	OeffnerOFF.resize(55,95);
	OeffnerOFF.fill(Hintergrund);
   paint.begin(&OeffnerOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);				//	|
		paint.lineTo(38,30); 			// _
		paint.moveTo(28,65);
		paint.lineTo(45,30);  			//	/
		paint.drawEllipse(26,65,5,5);	// *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				//	|
	paint.end();
//*** TasterSchliesser ***
	TasterSchliesserOFF.resize(55,95);
	TasterSchliesserOFF.fill(Hintergrund);
    paint.begin(&TasterSchliesserOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(15,38);  // Kontakt
		paint.moveTo(21,52);
		paint.lineTo(1,52);  //-
		paint.moveTo(1,42);
		paint.lineTo(1,62);	// |
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
	TasterSchliesserON.resize(55,95);
	TasterSchliesserON.fill(Hintergrund);
   paint.begin(&TasterSchliesserON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,30);  // Kontakt
		paint.moveTo(28,52);
		paint.lineTo(8,52);  //-
		paint.moveTo(8,42);
		paint.lineTo(8,62);	// |
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
 // *** SchalterSchliesser ***
	SchalterSchliesserOFF.resize(55,95);
	SchalterSchliesserOFF.fill(Hintergrund);
    paint.begin(&SchalterSchliesserOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(15,38);  // Kontakt
		paint.moveTo(21,52);
		paint.lineTo(1,52);  //-
		paint.moveTo(1,42);
		paint.lineTo(1,62);	// |
		paint.moveTo(8,52);
		paint.lineTo(10,65); // V
		paint.lineTo(12,52); // V
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
	SchalterSchliesserON.resize(55,95);
	SchalterSchliesserON.fill(Hintergrund);
   paint.begin(&SchalterSchliesserON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,30);  // Kontakt
		paint.moveTo(28,52);
		paint.lineTo(8,52);  //-
		paint.moveTo(8,42);
		paint.lineTo(8,62);	// |
		paint.moveTo(15,52);
		paint.lineTo(17,65); // V
		paint.lineTo(19,52); // V
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
// *** Taster ffner ***
	TasterOeffnerON.resize(55,95);
	TasterOeffnerON.fill(Hintergrund);
    paint.begin(&TasterOeffnerON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.moveTo(28,0);
		paint.lineTo(28,30); 			//  	|
		paint.lineTo(38,30); 			// 	_
		paint.moveTo(28,65);
		paint.lineTo(35,25);  			//		/
		paint.moveTo(30,45);
		paint.lineTo(8,45);  //-
		paint.moveTo(8,35);
		paint.lineTo(8,55);	// |
		paint.drawEllipse(26,65,5,5); // *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				// 	|
	paint.end();
	TasterOeffnerOFF.resize(55,95);
	TasterOeffnerOFF.fill(Hintergrund);
    paint.begin(&TasterOeffnerOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);				//	|
		paint.lineTo(38,30); 			// _
		paint.moveTo(28,65);
		paint.lineTo(45,30);  			//	/
		paint.moveTo(37,45);
		paint.lineTo(15,45);  //-
		paint.moveTo(15,35);
		paint.lineTo(15,55);	// |
		paint.drawEllipse(26,65,5,5);	// *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				//	|
	paint.end();
//*** Hintergrundmakse fr Lampe ***
	HintergrundMaske.resize(55,95);
	HintergrundMaske.fill(Hintergrund);
   paint.begin(&HintergrundMaske);
	   paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.setPen(black);
		paint.setBrush(black);
		paint.drawEllipse(8,27,40,40);
	paint.end();
// *** Lampe ***
	LampeOFF.resize(55,95);
	LampeOFF.fill(black);
   paint.begin(&LampeOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.setPen(black);
		paint.setBrush(gray);
		paint.drawEllipse(8,27,40,40);
		/* Kreuz */
		paint.moveTo(8,27);
		paint.lineTo(48,67);
		paint.moveTo(8,67);
		paint.lineTo(48,27);
	   paint.setRasterOp(OrROP);
      paint.drawPixmap(0,0,HintergrundMaske);
	paint.end();
	LampeON.resize(55,95);
	LampeON.fill(black);
    paint.begin(&LampeON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,95);
		paint.setPen(black);
		paint.setBrush(yellow);
		paint.drawEllipse(8,27,40,40);
		/* Kreuz */
	   paint.moveTo(8,27);
		paint.lineTo(48,67);
		paint.moveTo(8,67);
		paint.lineTo(48,27);
	   paint.setRasterOp(OrROP);
      paint.drawPixmap(0,0,HintergrundMaske);
	paint.end();
 //*** Kontakt SE_Relais ***
	SchliesserSeOFF.resize(55,95);
	SchliesserSeOFF.fill(Hintergrund);
   paint.begin(&SchliesserSeOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(15,38);  // Kontakt
		paint.moveTo(21,52);
		paint.lineTo(1,52);  //-
		paint.drawArc(1,43,20,20,100*16,160*16); // (
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
	SchliesserSeON.resize(55,95);
	SchliesserSeON.fill(Hintergrund);
    paint.begin(&SchliesserSeON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,30);  // Kontakt
		paint.moveTo(28,52);
		paint.lineTo(8,52);  //-
		paint.drawArc(8,43,20,20,100*16,160*16); // (
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
	Rechteck.resize(55,95);
	Rechteck.fill(Hintergrund);
    paint.begin(&Rechteck);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.drawArc(1,1,20,20,280*16,160*16); // (
	paint.end();
 //*** Kontakt SI_Relais ***
	SchliesserSiOFF.resize(55,95);
	SchliesserSiOFF.fill(Hintergrund);
    paint.begin(&SchliesserSiOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		bitBlt(&SchliesserSiOFF,1,43,&Rechteck,10,1,20,20,CopyROP);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(15,38);  // Kontakt
		paint.moveTo(21,52);
		paint.lineTo(1,52);  //-
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
	SchliesserSiON.resize(55,95);
	SchliesserSiON.fill(Hintergrund);
    paint.begin(&SchliesserSiON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		bitBlt(&SchliesserSiON,7,43,&Rechteck,10,1,20,20,CopyROP);
		paint.moveTo(28,0);
		paint.lineTo(28,30);
		paint.drawEllipse(26,30,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,30);  // Kontakt
		paint.moveTo(28,52);
		paint.lineTo(8,52);  //-
		paint.drawEllipse(26,65,5,5);
		paint.moveTo(28,65);
		paint.lineTo(28,95);
	paint.end();
 // ***Kontakt SE_Relais ffner ***
	OeffnerSeON.resize(55,95);
	OeffnerSeON.fill(Hintergrund);
    paint.begin(&OeffnerSeON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.moveTo(28,0);
		paint.lineTo(28,30); 			//  	|
		paint.lineTo(38,30); 			// 	_
		paint.moveTo(28,65);
		paint.lineTo(35,25);  			//		/
		paint.moveTo(30,45);
		paint.lineTo(8,45);  //-
		paint.drawArc(8,36,20,20,100*16,160*16); // (
		paint.drawEllipse(26,65,5,5); // *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				// 	|
	paint.end();
	OeffnerSeOFF.resize(55,95);
	OeffnerSeOFF.fill(Hintergrund);
    paint.begin(&OeffnerSeOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);				//	|
		paint.lineTo(38,30); 			// _
		paint.moveTo(28,65);
		paint.lineTo(45,30);  			//	/
		paint.moveTo(37,45);
		paint.lineTo(15,45);  //-
		paint.drawArc(15,36,20,20,100*16,160*16); // (
		paint.drawEllipse(26,65,5,5);	// *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				//	|
	paint.end();
// ***Kontakt SI_Relais ffner ***
	OeffnerSiON.resize(55,95);
	OeffnerSiON.fill(Hintergrund);
    paint.begin(&OeffnerSiON);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		bitBlt(&OeffnerSiON,12,35,&Rechteck,10,1,20,20,CopyROP);
		paint.moveTo(28,0);
		paint.lineTo(28,30); 			//  	|
		paint.lineTo(38,30); 			// 	_
		paint.moveTo(28,65);
		paint.lineTo(35,25);  			//		/
		paint.moveTo(30,45);
		paint.lineTo(8,45);  //-
	//	paint.moveTo(8,35);
	//	paint.lineTo(8,55);	// |
		paint.drawEllipse(26,65,5,5); // *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				// 	|
	paint.end();
	OeffnerSiOFF.resize(55,95);
	OeffnerSiOFF.fill(Hintergrund);
    paint.begin(&OeffnerSiOFF);
		paint.setRasterOp(CopyROP);
		paint.setPen(QPen(green,3,SolidLine));
		bitBlt(&OeffnerSiOFF,19,35,&Rechteck,10,1,20,20,CopyROP);
		paint.setBrush(green);
		paint.moveTo(28,0);
		paint.lineTo(28,30);				//	|
		paint.lineTo(38,30); 			// _
		paint.moveTo(28,65);
		paint.lineTo(45,30);  			//	/
		paint.moveTo(37,45);
		paint.lineTo(15,45);  //-
	//	paint.moveTo(15,35);
	//	paint.lineTo(15,55);	// |
		paint.drawEllipse(26,65,5,5);	// *
		paint.moveTo(28,65);
		paint.lineTo(28,95);				//	|
	paint.end();

  	for(Nr=1;Nr<=10;Nr++)
	  Knoten[Nr].Spannung=true;

	Nr=0;
	for (Zeile=37;Zeile<=640;Zeile+=100)
		for(Spalte=53;Spalte<=956;Spalte+=100)
		{	Nr++;
		 	Knoten[Nr].x=Spalte;
			posXY[Nr].setX(Spalte-26);
			Knoten[Nr].y=Zeile;
		   posXY[Nr].setY(Zeile+5);
		}
	BauteilArt=VERBINDUNG;

	setGeometry(0,0,BILD_BREITE,BILD_HOEHE);
   setMaximumSize(BILD_BREITE,BILD_HOEHE);
   setBackgroundColor(black);
   setBackgroundMode(NoBackground);
 	this->setCaption("KRelais  Simulation");
   for(Nr=1;Nr<=10;Nr++)
	{	Kommentar[Nr] = new QLineEdit(this);
    	Kommentar[Nr]->move(Knoten[Nr].x-43,BILD_HOEHE-55);
  		Kommentar[Nr]->resize(96,20);
  		Kommentar[Nr]->setFont(QFont("courier",10, QFont::Bold));
	}
	Kommentar[1]->setFocus();
   	statusbar=new QStatusBar(this,0);
  	statusbar->setFont(QFont("courier", 12, QFont::Bold));
	statusbar->setGeometry(0,BILD_HOEHE-20,BILD_BREITE,20);
    statusbar->message(i18n("Set connections"));

	KPopupMenu *fileMenu =new KPopupMenu();
	fileMenu->insertItem(i18n("Load"),M_LADEN);
	fileMenu->insertItem(i18n("Save"),M_SPEICHERN);
	fileMenu->insertItem(i18n("Save as"),M_SPEICHERN_ALS);
	fileMenu->insertItem(i18n("Clear all (* New*)"),M_LOESCHEN);
    fileMenu->insertItem(" Quit ",M_QUIT);

	KPopupMenu *installMenu =new KPopupMenu();
	installMenu->insertItem(i18n("Connection "),M_VERBINDUNG);
	installMenu->insertItem(i18n("Key closer"),M_TASTER_SCHLIESSER);
	installMenu->insertItem(i18n("Key opener"),M_TASTER_OEFFNER);
    	installMenu->insertItem(i18n("Switch closer"),M_SCHALTER_SCHLIESSER);
	installMenu->insertItem(i18n("Relay contact closer "),M_SCHLIESSER);
	installMenu->insertItem(i18n("Relay contact opener "),M_OEFFNER);
	installMenu->insertItem(i18n("Relay"),M_RELAIS);
	installMenu->insertItem(i18n("SE_relay"),M_SE_RELAIS);
	installMenu->insertItem(i18n("SI_relay"),M_SI_RELAIS);
	installMenu->insertItem(i18n("Lamp"),M_LAMPE);

	KPopupMenu *simulationMenu =new KPopupMenu();
	simulationMenu->insertItem(i18n("Start"),M_START);
	simulationMenu->insertItem(i18n("Stop "),M_STOP);

   QString aboutText ("KRelais  Author: Burkhard Bauer");
   KPopupMenu *help = helpMenu(QString(i18n("KRelais"))
           + " " + VERSION
           +  i18n("\n\nThis electronic program simulates")
            + i18n( "\nrelay circuits")
  		    + i18n("\n\nWritten by Burkhard Brauer 2003")
             + i18n("\nElectromaster")
   			+ "\n\neMail:BurkhardBrauer@t-online.de");
    help->insertItem(i18n("Fast help circuit simulation"), 	M_FAST_HELP_SIMULATION);
	help->insertItem(i18n("Fast help circuit install"),M_FAST_HELP_INSTALL);

	menu =new KMenuBar(this);
	CHECK_PTR(menu);
	menu->insertItem(i18n("File"),fileMenu);
	menu->insertItem(i18n("Component"),installMenu);
	menu->insertItem(i18n("Simulation"),simulationMenu);
 	menu->insertItem(i18n("Help"),help);
	menu->show();
	connect(menu,SIGNAL(activated(int)),this,SLOT(MenueItem(int)));

   timer = new QTimer(this);
   QObject::connect(timer,SIGNAL(timeout()),this, SLOT(timerSimulation()));
}

KRelais::~KRelais()
{
}




void KRelais::Speichern()
{ FILE *stream;
  QString DateiQStr,QStr;
  char KommentarStr[12][256];
  int pos,Nr;
  if(strcmp(DateiKennungsMerker,DateiKennung)==0 || PfadPlusDateiname.length()!=0)
  {	for (Nr=1;Nr<=10;Nr++)
			strcpy(KommentarStr[Nr],Kommentar[Nr]->text());

		pos=PfadPlusDateiname.find('.',0,true);
		if(pos==-1) // Punkt nicht gefunden
     		DateiQStr=PfadPlusDateiname+".circuit";
  		else
			DateiQStr=PfadPlusDateiname;
		statusbar->message(DateiQStr);
		stream = fopen(DateiQStr,"wb");
		if(stream)
		{ fwrite(DateiKennung,120,1, stream);
			fwrite(Bauteil, sizeof(BauteilStruct),70, stream);
			fwrite(Vertikale, sizeof(VerbindungStruct),70, stream);
			fwrite(Horizontale, sizeof(VerbindungStruct),70, stream);
			for (Nr=1;Nr<=10;Nr++)
				fwrite(KommentarStr[Nr],80,1, stream);
			fclose(stream);
		}
	}
	else
		SpeichernAls();
}// Ende Speichern()

void KRelais::SpeichernAls()
{ FILE *stream;
  QString DateiQStr,QStr;
  char KommentarStr[12][256];
  int pos,Nr;
  PfadPlusDateiname =fileName->getSaveFileName(data_path,"*.circuit",this);
  statusbar->message(PfadPlusDateiname);

  if (PfadPlusDateiname.length()!=0)
  {	for (Nr=1;Nr<=10;Nr++)
			strcpy(KommentarStr[Nr],Kommentar[Nr]->text());

		// Schaltung Speichern
		pos=PfadPlusDateiname.find('.',0,true);
		if(pos==-1) // Punkt nicht gefunden
			DateiQStr=PfadPlusDateiname+".circuit";
		else
				DateiQStr=PfadPlusDateiname;

		stream = fopen(DateiQStr,"wb");
		if(stream)
		{ fwrite(DateiKennung,120,1, stream);
			fwrite(Bauteil, sizeof(BauteilStruct),70, stream);
			fwrite(Vertikale, sizeof(VerbindungStruct),70, stream);
			fwrite(Horizontale, sizeof(VerbindungStruct),70, stream);
			for (Nr=1;Nr<=10;Nr++)
				fwrite(KommentarStr[Nr],80,1, stream);
			fclose(stream);
		}
	}
   else
		statusbar->message(i18n("Data save failed!"));
}// Ende SpeichernAls()

void KRelais::Laden()
{ FILE *stream;
  QString DateiQStr,QStr;
  char KommentarStr[12][256];
  int Nr;
  PfadPlusDateiname = fileName->getOpenFileName(data_path, "*.circuit", this );
 // Bauteile Laden
  if (PfadPlusDateiname.length()!=0)
  { 	DateiQStr=PfadPlusDateiname;//+".Schaltung";
		statusbar->message(DateiQStr);
		stream = fopen(DateiQStr, "rb");
		if(stream)
		{ fread(DateiKennungsMerker,120,1, stream);
			fread (Bauteil,sizeof(BauteilStruct),70, stream);
			fread (Vertikale,sizeof(VerbindungStruct),70, stream);
			fread (Horizontale,sizeof(VerbindungStruct),70, stream);
			for (Nr=1;Nr<=10;Nr++)
				fread(KommentarStr[Nr],80,1, stream);
			fclose(stream);
		}
		for(Nr=1;Nr<=10;Nr++)
		{	Kommentar[Nr]->setText(KommentarStr[Nr]);
				Kommentar[Nr]->setCursorPosition(0);
		}
	}
	else
		statusbar->message(i18n("Load data failed"));
}//ENDE Laden()

void KRelais::ResetStructe()
{ int Nr;
  for(Nr=1;Nr<=70;Nr++)
  {// Knoten[Nr].x=0;
	// Knoten[Nr].y=0;
	 Knoten[Nr]. Spannung=false;

	 Bauteil[Nr].art=KEIN_BAUTEIL;
	 Bauteil[Nr].x=0;
	 Bauteil[Nr].y=0;
	 Bauteil[Nr].status=false;
    Bauteil[Nr].AnzeigeStatus=false;
	 Bauteil[Nr].Spannung=false;
	 Bauteil[Nr].Zuordnung=0;
    Bauteil[Nr].StartTimer=false;
	 Bauteil[Nr].Startzeit=0;
	 Bauteil[Nr].Laufzeit=0;

	 Vertikale[Nr].x=0;
	 Vertikale[Nr].y=0;
  	 Vertikale[Nr].Verbindung=false;
	 Vertikale[Nr].Spannung=false;

    Horizontale[Nr].x=0;
    Horizontale[Nr].y=0;
    Horizontale[Nr].Verbindung=false;
    Horizontale[Nr].Spannung=false;
  }

  for(Nr=1;Nr<=10;Nr++)
   Kommentar[Nr]->clear();
	DateiKennungsMerker[0]=0;
   PfadPlusDateiname="";
  repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
}// Ende ResetStructe()

void KRelais::ResetLogisch()
{	int Nr;
 	for(Nr=1;Nr<=70;Nr++)
	{	if (Nr<=10)
			Knoten[Nr].Spannung=true;
		else
			Knoten[Nr].Spannung=false;

		Bauteil[Nr].status=false;
		Bauteil[Nr].Spannung=false;
		Bauteil[Nr].StartTimer=false;
	   Bauteil[Nr].Startzeit=0;
	   if(Bauteil[Nr].art & (TASTER_OEFFNER | OEFFNER))
			Bauteil[Nr].status=true;
		else
			Bauteil[Nr].status=false;
      Bauteil[Nr].AnzeigeStatus=false;
		Vertikale[Nr].Spannung=false;
		Horizontale[Nr].Spannung=false;
	}
}

void KRelais::SE_Relais()
{ 	int Nr,diffZeit=0;
	for(Nr=51;Nr<=60;Nr++)
	{  if(Bauteil[Nr].art==SE_RELAIS)
	   {	 if(Knoten[Nr].Spannung && Bauteil[Nr].StartTimer==false )
			{  Bauteil[Nr].Startzeit=DurchlaufNr;
				Bauteil[Nr].StartTimer=true;
				Bauteil[Nr].status=false;
			}
			else if(Knoten[Nr].Spannung==false)
			{  Bauteil[Nr].Startzeit=0;
				Bauteil[Nr].StartTimer=false;
				Bauteil[Nr].status=false;
			}

			if(Bauteil[Nr].StartTimer)
			{ diffZeit=DurchlaufNr-Bauteil[Nr].Startzeit;
				if(diffZeit>= Bauteil[Nr].Laufzeit)
					Bauteil[Nr].status=true;
			}
		}
	}
}// Ende SE_Relais()


void KRelais::SI_Relais()
{ 	int Nr,diffZeit=0;
	for(Nr=51;Nr<=60;Nr++)
	{  if(Bauteil[Nr].art==SI_RELAIS)
	   {	 if(Knoten[Nr].Spannung && Bauteil[Nr].StartTimer==false )
			{  Bauteil[Nr].Startzeit=DurchlaufNr;
				Bauteil[Nr].StartTimer=true;
				Bauteil[Nr].status=true;
			}
			else if(Knoten[Nr].Spannung==false)
			{  Bauteil[Nr].Startzeit=0;
				Bauteil[Nr].StartTimer=false;
				Bauteil[Nr].status=false;
			}

			if(Bauteil[Nr].StartTimer)
			{ diffZeit=DurchlaufNr-Bauteil[Nr].Startzeit;
				if(diffZeit>= Bauteil[Nr].Laufzeit)
					Bauteil[Nr].status=false;
			}
		}
	}
}// Ende SI_Relais()



void KRelais::timerSimulation()
{	int Nr,n;
   DurchlaufNr++;

	sprintf(CStr,i18n("Simulation runs!   Count:%d"),DurchlaufNr);
	statusbar->message(CStr);

   for(Nr=11;Nr<=70;Nr++) Knoten[Nr].Spannung=false; // Knoten Spannungen 0 setzen

	WaagerechtDurchrechnen();

	for(Nr=51;Nr<=60;Nr++)
	{  if(Bauteil[Nr].art & (RELAIS | LAMPE))
	     Bauteil[Nr].status=Knoten[Nr].Spannung;
	}
  for(Nr=51;Nr<=60;Nr++)
  { if(Bauteil[Nr].art & AKTIVE_BAUTEILE)
    {  for(n=1;n<=68;n++)
	    {	if(Bauteil[n].Zuordnung==Nr)
			{	if(Bauteil[n].art==SCHLIESSER)
				{	if (Bauteil[Nr].status)
						Bauteil[n].status=ON;
    				else
						Bauteil[n].status=OFF;
				}
				else if(Bauteil[n].art==OEFFNER)
				{	if (Bauteil[Nr].status)
						Bauteil[n].status=OFF;
					else
						Bauteil[n].status=ON;
				}
			}
		 }
	 }//Ende if(Bauteil[Nr].art==RELAIS) for(Nr=51;Nr<=60;Nr++)

	 if(Bauteil[Nr].art==RELAIS)
    {  for(n=1;n<=68;n++)
	    {	if(Bauteil[n].Zuordnung==Nr)
			{	if(Bauteil[n].art==SCHLIESSER)
				{	if (Bauteil[Nr].status)
						Bauteil[n].status=ON;
    				else
						Bauteil[n].status=OFF;
				}
				else if(Bauteil[n].art==OEFFNER)
				{	if (Bauteil[Nr].status)
						Bauteil[n].status=OFF;
					else
						Bauteil[n].status=ON;
				}
			}
		 }
	 }//Ende if(Bauteil[Nr].art==RELAIS)
  }// ende for(Nr=51;Nr<=60;Nr++)

  SE_Relais(); // Zeitrelais Anzugsverzgert
  SI_Relais(); // Zeitrelais Abfallverzgert
  repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
}/* Ende timerSimulation() */





void KRelais::BauteileDurchrechnen(int Nr)
{	if(Bauteil[Nr].art & SCHALTELEMENTE)
		{ 	Knoten[Nr+10].Spannung	= 	Knoten[Nr+10].Spannung || (Knoten[Nr].Spannung && Bauteil[Nr].status);
	  		Knoten[Nr].Spannung		= 	Knoten[Nr].Spannung 	|| (Knoten[Nr+10].Spannung && Bauteil[Nr].status);
   	}
}// ENDE

void KRelais::SenkrechtDurchrechnen(int Spalte)
{ 	int Zeile,Nr;
   for(Zeile=1;Zeile<=6;Zeile++)
	{  Nr=Spalte+(Zeile-1)*10;
		if(Zeile>1)
		{	if (Spalte==1) // Anfang Feld
			{ Knoten[Nr].Spannung	=	Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung	&&  	Vertikale[Nr-10].Verbindung  ||
												Knoten[Nr+1].Spannung  	&& 	Horizontale[Nr].Verbindung)  ||
												Knoten[Nr+10].Spannung  && 	Vertikale[Nr].Verbindung;
			}
			else if (Spalte==10) // Ende Feld
			{	Knoten[Nr].Spannung	= 	Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung  ||
												Knoten[Nr-1].Spannung 	&&  	Horizontale[Nr-1].Verbindung ||
												Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung);
			}
			else  // Mitte Feld
			{  Knoten[Nr].Spannung	=  Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung 	||
												Knoten[Nr+1].Spannung  	&& 	Horizontale[Nr].Verbindung 	||
												Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung		||
												Knoten[Nr-1].Spannung   &&  	Horizontale[Nr-1].Verbindung);
			}
		} /* Ende if(Zeile>1) */
		BauteileDurchrechnen(Nr);
	}/*Ende for Zeile  von oben nach unten--------------------------------------*/
	for(Zeile=6;Zeile>=1;Zeile--) // von unten nach oben
	{  Nr=Spalte+(Zeile-1)*10;

		if(Zeile>1)
		{	if (Spalte==1) // Anfang Feld
			{ Knoten[Nr].Spannung	=	Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung	&&  	Vertikale[Nr-10].Verbindung  ||
												Knoten[Nr+1].Spannung  	&& 	Horizontale[Nr].Verbindung)  ||
												Knoten[Nr+10].Spannung  && 	Vertikale[Nr].Verbindung;
			}
			else if (Spalte==10) // Ende Feld
			{	Knoten[Nr].Spannung	= 	Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung  ||
												Knoten[Nr-1].Spannung 	&&  	Horizontale[Nr-1].Verbindung ||
												Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung);
			}
			else  // Mitte Feld
			{  Knoten[Nr].Spannung	=  Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung 	||
												Knoten[Nr+1].Spannung  	&& 	Horizontale[Nr].Verbindung 	||
												Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung		||
												Knoten[Nr-1].Spannung   &&  	Horizontale[Nr-1].Verbindung);
			}
		} /* Ende if(Zeile>1) */
		BauteileDurchrechnen(Nr);
	}/*Ende for Zeile  von unten nach oben--------------------------------------*/
} /* ENDE VertikalDurchrechnenSpalte() */



void KRelais::WaagerechtDurchrechnen()
{	int Spalte,Zeile,Nr;
	for(Zeile=1;Zeile<=6;Zeile++)
	{	for(Spalte=1;Spalte<=10;Spalte++)// von links nach rechts
		{  Nr=Spalte+(Zeile-1)*10;
			if(Zeile>1)
			{	if (Spalte==1) // Anfang Feld
				{ Knoten[Nr].Spannung	=	Knoten[Nr].Spannung ||
													(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung  ||
													Knoten[Nr+1].Spannung   && 	Horizontale[Nr].Verbindung)  ||
													Knoten[Nr+10].Spannung  && 	Vertikale[Nr].Verbindung;
				}
				else if (Spalte==10) // Ende Feld
				{	Knoten[Nr].Spannung	=	Knoten[Nr].Spannung ||
													(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung  ||
													Knoten[Nr-1].Spannung 	&&  	Horizontale[Nr-1].Verbindung ||
													Knoten[Nr+10].Spannung	&& 	Vertikale[Nr].Verbindung);
				}
				else  // Mitte Feld
				{  Knoten[Nr].Spannung	=  Knoten[Nr].Spannung ||
													(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung 	||
													Knoten[Nr+1].Spannung  	&& 	Horizontale[Nr].Verbindung 	||
													Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung		||
													Knoten[Nr-1].Spannung   &&  	Horizontale[Nr-1].Verbindung);
				}
			} /* Ende if(Zeile>1) */
		BauteileDurchrechnen(Nr);
		SenkrechtDurchrechnen(Spalte);
		}/*Ende for Spalte  von links nach rechts--------------------------------------*/
		for(Spalte=10;Spalte>=1;Spalte--)// von rechts nach links
		{  Nr=Spalte+(Zeile-1)*10;
			if(Zeile>1)
			{	if (Spalte==1) // Anfang Feld
				{ Knoten[Nr].Spannung	=	Knoten[Nr].Spannung ||
													(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung  ||
													Knoten[Nr+1].Spannung   && 	Horizontale[Nr].Verbindung)  ||
													Knoten[Nr+10].Spannung  && 	Vertikale[Nr].Verbindung;


				}
				else if (Spalte==10) // Ende Feld
				{	Knoten[Nr].Spannung	= Knoten[Nr].Spannung ||
												(Knoten[Nr-10].Spannung  	&&  	Vertikale[Nr-10].Verbindung  ||
													Knoten[Nr-1].Spannung 	&&  	Horizontale[Nr-1].Verbindung ||
													Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung);
				}
				else  // Mitte Feld
				{  Knoten[Nr].Spannung	=  Knoten[Nr].Spannung ||
													(Knoten[Nr-10].Spannung &&  	Vertikale[Nr-10].Verbindung 	||
													Knoten[Nr+1].Spannung  	&& 	Horizontale[Nr].Verbindung 	||
													Knoten[Nr+10].Spannung 	&& 	Vertikale[Nr].Verbindung		||
													Knoten[Nr-1].Spannung   &&  	Horizontale[Nr-1].Verbindung);
				}
			} /* Ende if(Zeile>1) */
		BauteileDurchrechnen(Nr);
	   SenkrechtDurchrechnen(Spalte);
		}/*Ende for Spalte  von rechts nach links----------------------------------------------------*/
	} // Ende for Zeile
} /* ENDE vonLinksNachRechts() */


void KRelais::moveEvent(QMoveEvent *)
{ /*PressMausX=MausPosition->x();
  PressMausY=MausPosition->y();
  MausButton=MausPosition->button();

  if(MausButton=MidButton)
		 if(Aktion)
				Bauteil_schalten(PressMausX,PressMausY);*/

}


void KRelais::resizeEvent(QResizeEvent *Veraenderung)
{	ZeichnenPuffer.resize(Veraenderung->size());
	ZeichnenPuffer.fill(black);
	/* ruft den paintEvent automatisch auf */
} // Ende resizeEvent()


void KRelais::mousePressEvent(QMouseEvent *MausPosition)
{ PressMausX=MausPosition->x();
   PressMausY=MausPosition->y();
   MausButton=MausPosition->button();
	if (BauteilArt)
  	{	if(MausButton==LeftButton)  //Plazieren
			Bauteile_plazieren(PressMausX,PressMausY);
		else if(MausButton==RightButton) // Lschen
		  	Bauteil_loeschen(PressMausX,PressMausY);
	}
	else if(Aktion)
		Bauteil_schalten(PressMausX,PressMausY);
}  // Ende mousePressEvent()

void KRelais::mouseMoveEvent(QMouseEvent *)
{/* PressMausX=MausPosition->x();
  PressMausY=MausPosition->y();
 // MausButton=MausPosition->button();

  if(MausButton==MidButton)
		 if(Aktion)
				Bauteil_schalten(PressMausX,PressMausY);*/


}
void KRelais::mouseReleaseEvent(QMouseEvent *)
{  int Nr;
	for(Nr=1;Nr<=60;Nr++)
	{  if (Bauteil[Nr].art==KEIN_BAUTEIL) continue;
		switch (Bauteil[Nr].art)
		{	case	TASTER_SCHLIESSER:
			   	Bauteil[Nr].status=OFF;
			break;
			case	TASTER_OEFFNER:
			   	Bauteil[Nr].status=ON;
			break;
		}
	} /* Ende for */
} // Ende mouseReleaseEvent()

void KRelais::Bauteil_schalten(int MausX,int MausY)
{	int Nr;
	for(Nr=1;Nr<=60;Nr++)
	{  if (Bauteil[Nr].art==KEIN_BAUTEIL) continue;
		switch (Bauteil[Nr].art)
		{	case	TASTER_SCHLIESSER:
				if((Bauteil[Nr].x+30)>=MausX && Bauteil[Nr].x-30<=MausX)
					if(Bauteil[Nr].y+35<=MausY && Bauteil[Nr].y+75>=MausY)
					  Bauteil[Nr].status=ON;
			break;
			case	TASTER_OEFFNER:
				if((Bauteil[Nr].x+30)>=MausX && Bauteil[Nr].x-30<=MausX)
					if(Bauteil[Nr].y+35<=MausY && Bauteil[Nr].y+75>=MausY)
						  Bauteil[Nr].status=OFF;
			break;
		   case	SCHALTER_SCHLIESSER:
				if((Bauteil[Nr].x)+30>=MausX && Bauteil[Nr].x-30<=MausX)
					if(Bauteil[Nr].y+35<=MausY && Bauteil[Nr].y+75>=MausY)
					 if(Bauteil[Nr].status)
						Bauteil[Nr].status=OFF;
					  else
						Bauteil[Nr].status=ON;
			break;





		} /* Ende switch */
	} /* Ende for */
} /* Ende Bauteil_schalten(int MausX,int MausY) */

void KRelais::BauteilReset(int Nr)
{  Bauteil[Nr].art=KEIN_BAUTEIL;
   Bauteil[Nr].x=0;
	Bauteil[Nr].y=0;
	Bauteil[Nr].status=OFF;;
	Bauteil[Nr].Spannung=0;
	Bauteil[Nr].Zuordnung=0;
	Bauteil[Nr].StartTimer=false;
	Bauteil[Nr].Startzeit=0;
	Bauteil[Nr].Laufzeit=0;
   Vertikale[Nr].Verbindung=false; //lschen falls vorhanden
}// ENDE BauteilInit()

void KRelais::Bauteile_plazieren(int MausX,int MausY)
{	int Nr;
	bool ok=false;

	for(Nr=1;Nr<=70;Nr++)
	{	if(BauteilArt==VERBINDUNG)
		{	if((Knoten[Nr].x+50)>=(MausX-20) && (Knoten[Nr].x+50)<=(MausX+20))
			{	if(Knoten[Nr].y>=(MausY-30) && Knoten[Nr].y<=(MausY+30))
				{  if(Nr>10)
					{	Horizontale[Nr].Verbindung=true;
						repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
					}
				}
			}
			else if((Knoten[Nr].x)>=(MausX-20) && (Knoten[Nr].x)<=(MausX+20))
			{	if((Knoten[Nr].y+50)>=(MausY-30) && (Knoten[Nr].y+50)<=(MausY+30))
				{	if(Nr<51)
					{	BauteilReset(Nr);
					   Vertikale[Nr].Verbindung=true;
						repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
					}
				}
			}
			continue;
		}/*Ende if(BauteilArt=VERBINDUNG) */

		if(Knoten[Nr].x>=(MausX-20) && Knoten[Nr].x<=(MausX+20))
			if((Knoten[Nr].y+50)>=(MausY-30) && (Knoten[Nr].y+50)<=(MausY+30))
			{ 	switch(BauteilArt)
				{	case SCHLIESSER:	if(Nr<51)
											{  //void BauteilInit(int art,int Nr,int x,int y)
											   BauteilReset(Nr);
												Bauteil[Nr].art=SCHLIESSER;
												Bauteil[Nr].x=Knoten[Nr].x;
												Bauteil[Nr].y=Knoten[Nr].y;
												Bauteil[Nr].status=OFF;
												repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
												int RNr = QInputDialog::getInteger(i18n( "Set relay number" ),
																							i18n( "Input no. :" ),
																									51, 51, 60, 1, &ok, this );
												if ( ok )
												{	Bauteil[Nr].Zuordnung=RNr;
												}
												else
													statusbar->message(i18n("Error, contact has no relay number"));
												repaint(0,0, BILD_BREITE, BILD_HOEHE,true);

											} break; /* Ende if(Nr<51) */
					case OEFFNER:		if(Nr<51)
											{	BauteilReset(Nr);
											   Bauteil[Nr].art=OEFFNER;
												Bauteil[Nr].x=Knoten[Nr].x;
												Bauteil[Nr].y=Knoten[Nr].y;
												Bauteil[Nr].status=ON;
												repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
												int RNr = QInputDialog::getInteger(i18n( "Set relay number" ),
																							i18n( "Input no. :" ),
																								51, 51, 60, 1, &ok, this );
												if ( ok )
												 Bauteil[Nr].Zuordnung=RNr;
												else
													statusbar->message(i18n("Error, contact has no relay number"));
												repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
											} 	break; /* Ende if(Nr<51) */
					case RELAIS: 			if(Nr>=51 && Nr<=60)
												{	BauteilReset(Nr);
												   Bauteil[Nr].art=RELAIS;
													Bauteil[Nr].x=Knoten[Nr].x;
													Bauteil[Nr].y=Knoten[Nr].y;
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
												}  break;
					case SE_RELAIS: 		if(Nr>=51 && Nr<=60)
												{  BauteilReset(Nr);
												   Bauteil[Nr].art=SE_RELAIS;
													Bauteil[Nr].x=Knoten[Nr].x;
													Bauteil[Nr].y=Knoten[Nr].y;
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
													int Zeit = QInputDialog::getInteger(i18n( "SE_relay time delay"),
																							i18n( "Input time : t * 100 ms:"),
																								1, 1, 1000, 1, &ok, this );
													if ( ok )
												 		Bauteil[Nr].Laufzeit=Zeit;
													else
														statusbar->message(i18n("Error, wrong time input!"));
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
												}  break;
					case SI_RELAIS: 		if(Nr>=51 && Nr<=60)
												{  BauteilReset(Nr);
												   Bauteil[Nr].art=SI_RELAIS;
													Bauteil[Nr].x=Knoten[Nr].x;
													Bauteil[Nr].y=Knoten[Nr].y;
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
													int Zeit = QInputDialog::getInteger(i18n( "SI_relay time delay"),
																							i18n( "Input time: t * 100 ms:"),
																								1, 1, 1000, 1, &ok, this );
													if ( ok )
												 		Bauteil[Nr].Laufzeit=Zeit;
													else
														statusbar->message(i18n("Error, wrong time input!"));
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
												}  break;
					case TASTER_SCHLIESSER: BauteilReset(Nr);
													Bauteil[Nr].art=TASTER_SCHLIESSER;
													Bauteil[Nr].x=Knoten[Nr].x;
													Bauteil[Nr].y=Knoten[Nr].y;
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
													break;
					case TASTER_OEFFNER:		BauteilReset(Nr);
					 								Bauteil[Nr].art=TASTER_OEFFNER;
													Bauteil[Nr].x=Knoten[Nr].x;
													Bauteil[Nr].y=Knoten[Nr].y;
													Bauteil[Nr].status=ON;
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
													break;
				 case SCHALTER_SCHLIESSER: BauteilReset(Nr);
													Bauteil[Nr].art=SCHALTER_SCHLIESSER;
													Bauteil[Nr].x=Knoten[Nr].x;
													Bauteil[Nr].y=Knoten[Nr].y;
													repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
													break;



					case LAMPE:					if(Nr>=51 && Nr<=60)
													{	BauteilReset(Nr);
														Bauteil[Nr].art=LAMPE;
														Bauteil[Nr].x=Knoten[Nr].x;
														Bauteil[Nr].y=Knoten[Nr].y;
														repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
													}
													break;
					default: 					statusbar->message(i18n("Not found!"));
				}
			}
	}
} /*Ende Bauteile_plazieren(void)*/


void KRelais::Bauteil_loeschen(int MausX,int MausY)
{	int Nr;
	for(Nr=1;Nr<=70;Nr++)
	{	if((Knoten[Nr].x+50)>=(MausX-20) && (Knoten[Nr].x+50)<=(MausX+20))
		{	if(Knoten[Nr].y>=(MausY-30) && Knoten[Nr].y<=(MausY+30))
			{	if(Horizontale[Nr].Verbindung)
					Horizontale[Nr].Verbindung=false;
			}
		}
		else if((Knoten[Nr].x)>=(MausX-20) && (Knoten[Nr].x)<=(MausX+20))
		{	if((Knoten[Nr].y+50)>=(MausY-30) && (Knoten[Nr].y+50)<=(MausY+30))
			{	if(Vertikale[Nr].Verbindung)
					Vertikale[Nr].Verbindung=false;
			}
		}
		if(Knoten[Nr].x>=(MausX-20) && Knoten[Nr].x<=(MausX+20))
		{	if((Knoten[Nr].y+50)>=(MausY-30) && (Knoten[Nr].y+50)<=(MausY+30))
				BauteilReset(Nr);
		}
	}/* Ende for Nr */
	repaint(0,0, BILD_BREITE, BILD_HOEHE,true);
}/* Ende Bauteil lschen */

void KRelais::Verbindung_Horizontal_zeichnen(int Nr)
{		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(Knoten[Nr].x+2,Knoten[Nr].y+2);
		paint.lineTo(Knoten[Nr].x+102,Knoten[Nr].y+2);
} // Ende Verbindung_Horizontal_zeichnen()

void KRelais::Verbindung_Vertikal_zeichnen(int Nr)
{		paint.setPen(QPen(green,3,SolidLine));
		paint.setBrush(gray);
		paint.moveTo(Knoten[Nr].x+2,Knoten[Nr].y+3);
		paint.lineTo(Knoten[Nr].x+2,Knoten[Nr].y+100);
} // Ende Verbindung_Vertikal_zeichnen()

void KRelais::Schliesser_zeichnen(int Nr, StatusBauteil Status)
{    switch(Bauteil[Bauteil[Nr].Zuordnung].art)
	  {	case SE_RELAIS:
				switch (Status) //Schliesser
				{	case OFF:
						paint.drawPixmap(posXY[Nr],SchliesserSeOFF);
					break;
					case ON:
						paint.drawPixmap(posXY[Nr],SchliesserSeON);
					break;
				}
			break;
			case SI_RELAIS:
				switch (Status) //Schliesser
				{	case OFF:
						paint.drawPixmap(posXY[Nr],SchliesserSiOFF);
					break;
					case ON:
						paint.drawPixmap(posXY[Nr],SchliesserSiON);
					break;
				}
			break;
			default:
				switch (Status) //Schliesser
				{	case OFF:
						paint.drawPixmap(posXY[Nr],SchliesserOFF);
					break;
					case ON:
						paint.drawPixmap(posXY[Nr],SchliesserON);
					break;
				}
	  }
		paint.setPen(gray);
		QStr.sprintf("K%d",Bauteil[Nr].Zuordnung);
		paint.drawText(Knoten[Nr].x+30,Knoten[Nr].y+58,QStr,12);
} // Ende Schliesser_zeichnen()

void KRelais::Oeffner_zeichnen(int Nr, StatusBauteil Status)
{
	  switch(Bauteil[Bauteil[Nr].Zuordnung].art)
	  {	case SE_RELAIS:
				switch (Status) //ffner
				{	case OFF:
						paint.drawPixmap(posXY[Nr],OeffnerSeOFF);
					break;
					case ON:
						paint.drawPixmap(posXY[Nr],OeffnerSeON);
					break;
				}
			break;
			case SI_RELAIS:
				switch (Status) //ffner
				{	case OFF:
						paint.drawPixmap(posXY[Nr],OeffnerSiOFF);
					break;
					case ON:
						paint.drawPixmap(posXY[Nr],OeffnerSiON);
					break;
				}
			break;
			default:
				switch (Status) // ffner
				{	case OFF:
						paint.drawPixmap(posXY[Nr],OeffnerOFF);
					break;
					case ON:
						paint.drawPixmap(posXY[Nr],OeffnerON);
					break;
				}
	  }
		paint.setPen(gray);
		QStr.sprintf("K%d",Bauteil[Nr].Zuordnung);
		paint.drawText(Knoten[Nr].x+30,Knoten[Nr].y+58,QStr,12);
} // Ende Oeffner_zeichnen()

void KRelais::Schalter_Schliesser_zeichnen(int Nr, StatusBauteil Status)
{		switch (Status)
		{	case OFF:
				paint.drawPixmap(posXY[Nr],SchalterSchliesserOFF);
		   break;
			case ON:
				paint.drawPixmap(posXY[Nr],SchalterSchliesserON);
			break;
		}
} // Ende Taster_Schliesser_zeichnen()


void KRelais::Taster_Schliesser_zeichnen(int Nr, StatusBauteil Status)
{		switch (Status)
		{	case OFF:
				paint.drawPixmap(posXY[Nr],TasterSchliesserOFF);
		   break;
			case ON:
				paint.drawPixmap(posXY[Nr],TasterSchliesserON);
			break;
		}
} // Ende Taster_Schliesser_zeichnen()

void KRelais::Taster_Oeffner_zeichnen(int Nr, StatusBauteil Status)
{		switch (Status)
		{	case ON:
		      paint.drawPixmap(posXY[Nr],TasterOeffnerON);
			break;
			case OFF:
            paint.drawPixmap(posXY[Nr],TasterOeffnerOFF);
			break;
		}
}// Ende Taster_Oeffner_zeichnen

void KRelais::Relais_zeichnen(int Nr,StatusBauteil Status)
{  switch (Status)
	{	case OFF:
	 			paint.drawPixmap(posXY[Nr],RelaisOFF);
	 	break;
		case ON:
		      paint.drawPixmap(posXY[Nr],RelaisON);
	}
	paint.setPen(gray);
	sprintf(CStr,"K%d",Nr);
	paint.drawText(Knoten[Nr].x+30,Knoten[Nr].y+58,CStr,12);
} // Ende Relais_zeichnen()

void KRelais::SE_Relais_zeichnen(int Nr,StatusBauteil Status) // Anzugsverzgertes Relais
{		switch (Status)
		{	case OFF:
				paint.drawPixmap(posXY[Nr],RelaisSeOFF);
			break;
			case ON:
				paint.drawPixmap(posXY[Nr],RelaisSeON);
			break;
		}
		paint.setPen(gray);
		sprintf(CStr,"KT%d",Nr);
		paint.drawText(Knoten[Nr].x+10,Knoten[Nr].y+30,CStr,12);
         sprintf(CStr,"%dms", Bauteil[Nr].Laufzeit*100);
		paint.drawText(Knoten[Nr].x+10,Knoten[Nr].y+80,CStr,12);
} // Ende SE_Relais_zeichnen()


void KRelais::SI_Relais_zeichnen(int Nr,StatusBauteil Status) // Abfallverzgertes Relais
{		switch (Status)
		{	case OFF:
				paint.drawPixmap(posXY[Nr],RelaisSiOFF);
			break;
			case ON:
				paint.drawPixmap(posXY[Nr],RelaisSiON);
			break;
		}
		paint.setPen(gray);
		sprintf(CStr,"KT%d",Nr);
		paint.drawText(Knoten[Nr].x+10,Knoten[Nr].y+30,CStr,12);
		sprintf(CStr,"%dms", Bauteil[Nr].Laufzeit*100);
		paint.drawText(Knoten[Nr].x+10,Knoten[Nr].y+80,CStr,12);
} // Ende SI_Relais_zeichnen()  Abfallverzgertes Relais


void KRelais::Lampe_zeichnen(int Nr,StatusBauteil Status)
{		switch (Status)
		{	case	OFF:
				paint.drawPixmap(posXY[Nr],LampeOFF);
			break;
			case	ON:
				paint.drawPixmap(posXY[Nr],LampeON);
			break;
		}
} // Ende Lampe_zeichnen()



void KRelais::paintEvent(QPaintEvent *)
{ 		int Nr;
		ZeichnenPuffer.fill(Hintergrund);
		paint.begin(&ZeichnenPuffer);
		paint.setRasterOp(CopyROP);

		for(Nr=1;Nr<=50;Nr++)
		{  switch (Bauteil[Nr].art)
			{	case	TASTER_SCHLIESSER:
					if(Bauteil[Nr].status)
						Taster_Schliesser_zeichnen(Nr,ON);
					else
						Taster_Schliesser_zeichnen(Nr,OFF);
			   break;
				case	SCHALTER_SCHLIESSER:
					if(Bauteil[Nr].status)
						Schalter_Schliesser_zeichnen(Nr,ON);
					else
						Schalter_Schliesser_zeichnen(Nr,OFF);
			   break;
				case	TASTER_OEFFNER:
					if(Bauteil[Nr].status)
						Taster_Oeffner_zeichnen(Nr,ON);
					else
						Taster_Oeffner_zeichnen(Nr,OFF);
				break;
				case SCHLIESSER:
					if(Bauteil[Nr].status)
						Schliesser_zeichnen(Nr,ON);
					else
						Schliesser_zeichnen(Nr,OFF);
				break;
				case	OEFFNER:
					if(Bauteil[Nr].status)
						Oeffner_zeichnen(Nr,ON);
					else
						Oeffner_zeichnen(Nr,OFF);
				break;
			}// Ende	switch (Bauteil[Nr].art)
		} // Ende for for(Nr=1;Nr<=50;Nr++)


		for(Nr=1;Nr<=60;Nr++)
		{	if(Horizontale[Nr].Verbindung)
				Verbindung_Horizontal_zeichnen(Nr);
			if(Vertikale[Nr].Verbindung)
				Verbindung_Vertikal_zeichnen(Nr);
		}// Ende for(Nr=1;Nr<=60;Nr++)

		for(Nr=51;Nr<=60;Nr++)
		{  switch(Bauteil[Nr].art)
			{	case LAMPE:
					if(Bauteil[Nr].status)
						Lampe_zeichnen(Nr,ON);
					else
						Lampe_zeichnen(Nr,OFF);
				break;
				case RELAIS:
					if(Bauteil[Nr].status)
						Relais_zeichnen(Nr,ON);
					else
						Relais_zeichnen(Nr,OFF);
					break;
				case SE_RELAIS:
					if(Bauteil[Nr].status)
						SE_Relais_zeichnen(Nr,ON);
					else
						SE_Relais_zeichnen(Nr,OFF);
    				break;
 				case SI_RELAIS:
					if(Bauteil[Nr].status)
						SI_Relais_zeichnen(Nr,ON);
					else
						SI_Relais_zeichnen(Nr,OFF);
    				break;
			}
		}// Ende for(Nr=51;Nr<=60;Nr++)
		paint.setPen(QPen(red,3,SolidLine));
		paint.moveTo(55,39);
		paint.lineTo(955,39);
		paint.setPen(QPen(blue,3,SolidLine));
		paint.moveTo(55,639);
		paint.lineTo(955,639);
		paint.setPen(gray);
		paint.setBrush(gray);
		for(Nr=1;Nr<=70;Nr++)
			paint.drawEllipse(Knoten[Nr].x,Knoten[Nr].y,5,5);

	paint.end();
   bitBlt(this,0,0,&ZeichnenPuffer);
} // EndepaintEvent()


void KRelais::MenueItem(int MenuPunkt)
{ 	timer->stop();
	DurchlaufNr=0;
	BauteilArt=KEIN_BAUTEIL;
	Aktion=KEINE_AKTION;
	ResetLogisch();
	repaint(0,0, BILD_BREITE, BILD_HOEHE,true);

	switch(MenuPunkt)
	{  case M_LADEN:      			  	statusbar->message(i18n("Loading circuit. "),2000);
	   										Laden();
		break;
		case M_SPEICHERN:  				statusbar->message(i18n("Save circuit"),2000);
     										    Speichern();
		break;
		case M_SPEICHERN_ALS:			statusbar->message(i18n("Save circuit as"),2000);
												SpeichernAls();
		break;
		case M_LOESCHEN:   				statusbar->message(i18n("Clear circuit"),3000);
												ResetStructe();
		break;
		case M_QUIT:
												close(0);
		break;
		case M_VERBINDUNG:				statusbar->message(i18n("Install connections"));
												BauteilArt=VERBINDUNG;
		break;
		case M_SCHLIESSER:   			statusbar->message(i18n("Install relay contact closer"));
												BauteilArt=SCHLIESSER;
		break;
		case M_OEFFNER:   				statusbar->message(i18n("Install relay contact opener"));
												BauteilArt=OEFFNER;
		break;
		case M_RELAIS:      				statusbar->message(i18n("Install relay "));
												BauteilArt=RELAIS;
		break;
		case M_SE_RELAIS:      			statusbar->message(i18n("Install SE_relay"));
												BauteilArt=SE_RELAIS;
		break;
		case M_SI_RELAIS:      			statusbar->message(i18n("Install SI_relay"));
												BauteilArt=SI_RELAIS;
		break;
		case M_TASTER_SCHLIESSER:		statusbar->message(i18n("Install key closer"));
												BauteilArt=TASTER_SCHLIESSER;
		break;
		case M_TASTER_OEFFNER:    		statusbar->message(i18n("Install key opener "));
										   	BauteilArt=TASTER_OEFFNER;
		break;
		case M_SCHALTER_SCHLIESSER: 	statusbar->message(i18n("Install switch closer"));
										   	BauteilArt=SCHALTER_SCHLIESSER;
		break;
		case M_LAMPE:						statusbar->message(i18n("Install lamp "));
												BauteilArt=LAMPE;
		break;
		case M_START: 						statusbar->message(i18n("Simulation runs"));
												Aktion=START;
												timer->start(50,false);
		break;
		case M_STOP:  						statusbar->message(i18n("Simulation stops!"));
												BauteilArt=KEIN_BAUTEIL;
		break;
        case  	M_FAST_HELP_SIMULATION:     statusbar->message("");
				QMessageBox::information( this, i18n("Help: Simulation"),
   															 		i18n("1. load a circuit\n"
    																			"2. start the simulation\n"
																			  "3. change key or switch with left mouse button\n"));
		break;
 		case	 M_FAST_HELP_INSTALL:        statusbar->message("");
                  QMessageBox::information( this, i18n("Help: Create circuit"),
   															 		i18n("1. Select circuit from menu\n "
																			"2. Set circuit with left mouse button between 2 nodes\n"
																			"3. Remove circuit with right mouse button.\n"
		  																	"4. Replace circuit with a new circuit with left mouse button\n"));         break;
      	default:
			statusbar->message(i18n("Help menu!"));
	} // Ende switch(MenuPunkt)
} // Ende MenueItem()



