/*
 * KMLOCfg
 *
 * A utility to configure modems of the ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef SETUPDLG_H 
#define SETUPDLG_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qvalidator.h>
#include <qwidget.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qslider.h>
#include <qtimer.h>
#include <qlayout.h>
#include <qgroupbox.h>

#include <kconfig.h>
#include <ktabctl.h>

#include "mloloader.h"




class CommonPageGeneral: public QWidget
{
	Q_OBJECT
public:
	CommonPageGeneral(QWidget *parent = 0, const char *name = 0);
	~CommonPageGeneral();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);

	void resetTime();
	
protected:
	void setTime(const QDateTime &time_);

protected slots:
	void timerSlot();

protected:
	QBoxLayout *vbox;

	QGroupBox *timer_box;

	QLabel *thumb;
	QLabel *model, *firmware;
	QCheckBox *sync_time;

private:
	QLabel *time;
	QTimer *timer;
	QDateTime m_time;
};



class OfficePageGeneral: public CommonPageGeneral
{
	Q_OBJECT
public:
	OfficePageGeneral(QWidget *parent = 0, const char *name = 0);
	~OfficePageGeneral();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);

private:
	QComboBox *line_country;
};



class OfficePageCalls: public QWidget
{
	Q_OBJECT
public:
	OfficePageCalls(QWidget *parent = 0, const char *name = 0);
	~OfficePageCalls();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QCheckBox *general_ring;
	QComboBox *general_rings;
	QCheckBox *general_acceptearly, *general_acceptfull, *general_acceptdtr;
	QCheckBox *general_suppressri;
};



class OfficePageAnswering: public QWidget
{
	Q_OBJECT
public:
	OfficePageAnswering(QWidget *parent = 0, const char *name = 0);
	~OfficePageAnswering();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QCheckBox *answer_enabled, *answer_record;
	QComboBox *answer_outgoing;

	QSlider *rec_playvol, *rec_recvol;
	QComboBox *rec_quality, *rec_maxdur, *rec_mindur;
	QCheckBox *rec_speaker;
};



class OfficePageFax: public QWidget
{
	Q_OBJECT
public:
	OfficePageFax(QWidget *parent = 0, const char *name = 0);
	~OfficePageFax();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QCheckBox *fax_operation, *fax_takeover;
	QLineEdit *fax_id;

	QCheckBox *message_system, *message_number, *message_time;

	QSlider *speaker_volume, *speaker_micro;
	QCheckBox *speaker_monitor;
};



class OfficePageAccess: public QWidget
{
	Q_OBJECT
public:
	OfficePageAccess(QWidget *parent = 0, const char *name = 0);
	~OfficePageAccess();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QCheckBox *access_hook, *access_dtmf;
	QCheckBox *access_playback, *access_config;
	QLineEdit *access_password;
};



class OfficeIIPageGeneral: public CommonPageGeneral
{
	Q_OBJECT
public:
	OfficeIIPageGeneral(QWidget *parent = 0, const char *name = 0);
	~OfficeIIPageGeneral();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);

private:
	QComboBox *line_country;
};



class OfficeIIPageCallerID: public QWidget
{
	Q_OBJECT
public:
	OfficeIIPageCallerID(QWidget *parent = 0, const char *name = 0);
	~OfficeIIPageCallerID();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QLineEdit *in_numbers[3];
};



class OfficeIIPageCallerList: public QWidget
{
	Q_OBJECT
public:
	OfficeIIPageCallerList(QWidget *parent = 0, const char *name = 0);
	~OfficeIIPageCallerList();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QLabel *number_list[10];
	QCheckBox *reset_list;
};



class OfficeIIPageExtras: public QWidget
{
	Q_OBJECT
public:
	OfficeIIPageExtras(QWidget *parent = 0, const char *name = 0);
	~OfficeIIPageExtras();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QCheckBox *no_ring_signal;
	QCheckBox *permit_ri;
	QCheckBox *delete_email;
	QCheckBox *external_signal;
	QSlider *ring_delay;
};



class ISDNPageGeneral: public CommonPageGeneral
{
	Q_OBJECT
public:
	ISDNPageGeneral(QWidget *parent = 0, const char *name = 0);
	~ISDNPageGeneral();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);

private:
	QComboBox *protocol;
	QComboBox *ab_country;
	QCheckBox *disable_isdn;
	QCheckBox *disable_ab1;
	QCheckBox *disable_ab2;
};



class ISDNPageISDN: public QWidget
{
	Q_OBJECT
public:
	ISDNPageISDN(QWidget *parent = 0, const char *name = 0);
	~ISDNPageISDN();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
private:
	QLineEdit *out_msn;
	QCheckBox *suppress_msn;
	QLineEdit *accept_msn[3];
	QComboBox *device_digit;
	QLabel *total_charge;
	QLabel *last_charge;
	QCheckBox *reset_charge;
};



class ISDNPageAB: public QWidget
{
	Q_OBJECT
public:
	ISDNPageAB(QWidget *parent = 0, const char *name = 0);
	~ISDNPageAB();

	void setToolTips(bool enable);

	void setConfig(int ab_port, const mlo_config_t *conf);
	void getConfig(int ab_port, mlo_config_t *conf);
	
private:
	QLineEdit *out_msn;
	QCheckBox *suppress_msn;
	QLineEdit *accept_msn[3];
	QComboBox *device_digit;

	QCheckBox *access_hook;
	QCheckBox *access_flash;

	QComboBox *out_ind;
};



class ISDNPageExtras: public QWidget
{
	Q_OBJECT
public:
	ISDNPageExtras(QWidget *parent = 0, const char *name = 0);
	~ISDNPageExtras();

	void setToolTips(bool enable);

	void setConfig(const mlo_config_t *conf);
	void getConfig(mlo_config_t *conf);
	
protected slots:
	void autoDialAB1Toggled(bool on);
	void autoDialAB2Toggled(bool on);

private:
	QLabel *total_charge[2];
	QLabel *last_charge[2];
	QCheckBox *reset_charge[2];
	QCheckBox *knocking_tone[2];
	QCheckBox *auto_dial[2];
	QLineEdit *auto_dial_number[2];
};



class SetupCtl: public KTabCtl
{
	Q_OBJECT
public:
	SetupCtl(int model, QWidget * parent = 0, const char * name = 0);
	~SetupCtl();

	void setToolTips();
	void setToolTips(bool enable);

	int model();

	void setConfig(const mlo_config_t *conf);
	const mlo_config_t *getConfig();

	void resetTime();

private:
	KConfig *config;
	bool has_tooltips;
	int modem_model;
	mlo_config_t m_conf;

	QWidget *pages[5];
};


inline int SetupCtl::model()
{	return modem_model; }


inline void SetupCtl::resetTime()
{ ((CommonPageGeneral *)pages[0])->resetTime(); }



class SetupWidget: public QWidget
{
	Q_OBJECT
public:
	SetupWidget(int model, QWidget * parent = 0, const char * name = 0);
	~SetupWidget();

	void setToolTips();
	void setToolTips(bool enable);

	int model();

	void setConfig(const mlo_config_t *conf);
	const mlo_config_t *getConfig();

	void resetTime();

private:
	SetupCtl *setup_ctl;
};


inline void SetupWidget::setToolTips()
{	setup_ctl->setToolTips(); }


inline void SetupWidget::setToolTips(bool enable)
{	setup_ctl->setToolTips(enable); }


inline int SetupWidget::model()
{	return setup_ctl->model(); }


inline void SetupWidget::setConfig(const mlo_config_t *conf)
{	setup_ctl->setConfig(conf); }


inline const mlo_config_t *SetupWidget::getConfig()
{	return setup_ctl->getConfig(); }


inline void SetupWidget::resetTime()
{ setup_ctl->resetTime(); }


#endif // SETUPDLG_H
