#ifndef CWIDGET_H
#define CWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdatetime.h>
#include <qwidget.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qframe.h>

class CWidget : public QWidget
{
	Q_OBJECT
	public:
		CWidget();

	public slots:
        void cancel(void);
        void ok(void);
        void daysChanged(int d);
        void browse(void);
        void edit(void);
        void newFile(void);

	signals:
        void changed(void);
	protected:
        void resizeEvent(QResizeEvent *);

    private:
        QString Filename;
        int Days;
        void readConfig(void);
        void writeConfig(void);
        QString getDir(const QString path);

        QPushButton *Cancel,*Ok,*Browse,*Edit,*New;
        QLabel *t3;
        QFrame *line1,*line2;
        QSpinBox *Spinbox;
        QLineEdit *Led;
};

#endif // CWIDGET_H
