/***************************************************************************
                      kstvectordialog_i.h  -  Part of KST
                             -------------------
    begin                :
    copyright            : (C) 2003 The University of Toronto
                           (C) 2003 C. Barth Netterfield
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSTVECTORDIALOGI_H
#define KSTVECTORDIALOGI_H

#include <kcompletion.h>
#include "kstrvector.h"
#include "vectordialog.h"

class KstVectorDialogI : public KstVectorDialog {
  Q_OBJECT
 public:
  KstVectorDialogI(QWidget* parent = 0, const char* name = 0,
                   bool modal = FALSE, WFlags fl = 0 );
  virtual ~KstVectorDialogI();

 public slots:
  /** update no longer does anything */
  void update();

  bool new_I();
  bool edit_I();

  static KstVectorDialogI *globalInstance();

  void updateCompletion();
 signals:
  void modified();
  void vectorCreated(KstVectorPtr v);

 private:
  static KstVectorDialogI *_inst;
  KCompletion *_fieldCompletion;
  KstRVectorPtr _getPtr(const QString &tagin);

  KstRVectorPtr DP;
  bool _newDialog;

 /***********************************/
 /** defined in dataobjectdialog.h **/
 public slots:
  void show_Edit(const QString &field);
  void show_New();
  void OK();
  void Init();
  void close();
  void reject();
 private:
  void _fillFieldsForEdit();
  void _fillFieldsForNew();

};

#endif
