/***************************************************************************
                              kstplotgroup.cpp
                             -------------------
    begin                : Mar 21, 2004
    copyright            : (C) 2004 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <assert.h>

// include files for Qt
#include <qpainter.h>

// include files for KDE
#include <klocale.h>
#include <kpopupmenu.h>

// application specific includes
#include "kstplotgroup.h"

KstPlotGroup::KstPlotGroup() : KstMetaPlot("KstPlotGroup") {
  _standardActions |= Delete | Raise | Zoom | Lower | RaiseToTop | LowerToBottom;
  setTagName("Plot Group"); // FIXME: we need a better naming scheme
  _type = "plotgroup";
}


KstPlotGroup::KstPlotGroup(QDomElement& e) : KstMetaPlot(e) {
  _type = "plotgroup";
}


KstPlotGroup::~KstPlotGroup() {
}


KstObject::UpdateType KstPlotGroup::update() {
  return NO_CHANGE;
}


bool KstPlotGroup::removeChild(KstViewObjectPtr obj, bool recursive) {
  KstViewObjectList::Iterator it;
  bool bRetVal = false;

  if (KstViewObject::removeChild(obj,recursive)) {
    if (_children.count() > 1) {
      QRect gg = _children.first()->geometry();
      for (it = _children.begin(); it != _children.end(); ++it) {
        gg |= (*it)->geometry();
      }

      _geom = gg;
      updateAspect();
      for (KstViewObjectList::Iterator i = _children.begin(); i != _children.end(); ++i) {
        updateAspect( );
      }
    } else {
      flatten();
    }

    bRetVal = true;
  }

  return bRetVal;
}


void KstPlotGroup::flatten() {
  assert(_parent);
  for (KstViewObjectList::Iterator i = _children.begin(); i != _children.end(); ++i) {
    (*i)->setSelected(false);
    (*i)->setFocus(false);
    _parent->insertChildAfter(KstViewObjectPtr(this), *i);
  }
  _parent->removeChild(this);
}


void KstPlotGroup::save(QTextStream& ts) {
  ts << "<" << type() << ">" << endl;
  KstMetaPlot::save(ts);
  ts << "</" << type() << ">" << endl;
}


void KstPlotGroup::saveTag(QTextStream& ts) {
  ts << "<" << type() << ">" << endl;
  KstMetaPlot::saveTag(ts);
  ts << "</" << type() << ">" << endl;
}


void KstPlotGroup::paint(KstPaintType type, QPainter& p) {
  KstMetaPlot::paint(type, p);
}


bool KstPlotGroup::popupMenu(KPopupMenu *menu, const QPoint& pos, KstViewObjectPtr topParent) {
  // FIXME: pass to children based on pos
  KstMetaPlot::popupMenu(menu, pos, topParent);
  KstViewObjectPtr c = findChild(pos + position());
  if (c) {
    KPopupMenu *s = new KPopupMenu(menu);
    if (c->popupMenu(s, pos - c->position(), topParent)) {
      menu->insertItem(c->tagName(), s);
    } else {
      delete s;
    }
  }
  return true;
}


bool KstPlotGroup::layoutPopupMenu(KPopupMenu *menu, const QPoint& pos, KstViewObjectPtr topParent) {
  // FIXME: pass to children based on pos
  KstMetaPlot::layoutPopupMenu(menu, pos, topParent);
  menu->insertItem(i18n("&Ungroup"), this, SLOT(flatten()));
  KstViewObjectPtr c = findChild(pos + position());
  if (c) {
    KPopupMenu *s = new KPopupMenu(menu);
    if (c->layoutPopupMenu(s, pos - c->position(), topParent)) {
      menu->insertItem(c->tagName(), s);
    } else {
      delete s;
    }
  }
  return true;
}


KstViewObjectPtr create_KstPlotGroup() {
  return KstViewObjectPtr(new KstPlotGroup);
}


KstViewObjectFactoryMethod KstPlotGroup::factory() const {
  return &create_KstPlotGroup;
}

#include "kstplotgroup.moc"
// vim: ts=2 sw=2 et
