/***************************************************************************
                      kstiface_impl.h  -  Part of KST
                             -------------------
    begin                : Thu Jun 19 2003
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSTIFACE_IMPL_H
#define KSTIFACE_IMPL_H

#include "kstiface.h"

class KstDoc;
class KstApp;

// Keep in sync with kstiface.h

class KstIfaceImpl : virtual public KstIface {
public:
  KstIfaceImpl(KstDoc *doc, KstApp *app);
  virtual ~KstIfaceImpl();

	virtual void showDataManager();

	virtual QStringList scalarList();
	virtual QStringList vectorList();

	virtual bool plotEquation(const QString& xvector, const QString& equation, const QString& plotName, const QColor& color);

  virtual const QString& generateVector(double from, double to, int points, const QString& name);

private:
  KstDoc *_doc;
  KstApp *_app;
};

#endif
// vim: ts=2 sw=2 et
