/***************************************************************************
                          kstdatacollection-gui.cpp
                             -------------------
    begin                : July 15, 2003
    copyright            : (C) 2003 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstdatacollection.h"
#include <kmessagebox.h>
#include <klocale.h>

bool KST::dataTagNameNotUnique(const QString &tag, bool warn) {
  /* verify that the tag name is not empty */
  if (tag.stripWhiteSpace().isEmpty()) {
      if (warn)
        KMessageBox::sorry(0L, i18n("Empty tag names are not allowed."));
      return true;
  }

  /* verify that the tag name is not used by a data object */
  if (KST::dataObjectList.findTag(tag) != KST::dataObjectList.end()) {
      if (warn)
        KMessageBox::sorry(0L, i18n("%1: this name is already in use. Change it to a unique name.").arg(tag));
      return true;
  }

  return false;
}

bool KST::vectorTagNameNotUnique(const QString &tag, bool warn) {
  /* verify that the tag name is not empty */
  if (tag.stripWhiteSpace().isEmpty()) {
      if (warn)
        KMessageBox::sorry(0L, i18n("Empty tag names are not allowed."));
      return true;
  }

  /* verify that the tag name is not used by a data object */
  if (KST::vectorList.findTag(tag) != KST::vectorList.end() ||
      KST::scalarList.findTag(tag) != KST::scalarList.end()) {
      if (warn)
        KMessageBox::sorry(0L, i18n("%1: this name is already in use. Change it to a unique name.").arg(tag));
      return true;
  }

  return false;
}

