/***************************************************************************
                          karchiveur.h  -  description                              
                             -------------------                                         
    begin                : jeu jun  3 19:43:44 CEST 1999
                                           
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KARCHIVEUR_H
#define KARCHIVEUR_H 


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qlistview.h>
#include <qregexp.h>
#include <qprogressdialog.h>
#include <qmessagebox.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kprocess.h>
#include <drag.h>
#include "kled.h"
#include <kurl.h>
#include <kfm.h>

// application specific includes
#include "karchiveurview.h"
#include "karchiveurdoc.h"
#include "cchoixfichier.h"
#include "cextraction.h"
#include "resource.h"
#include "cprogress.h"
#include "cajoutfichiers.h"
#include "coptions.h"
#include "coptionrepertoire.h"
#include "cutt.h"
#include "processus.h"
#include "cnavigateur.h"
#include "cinfos.h"
#include "cscript.h"
#include "crecherche.h"


#include <math.h>


/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KarchiveurView is
  * created which creates your view.
  */


#define TAR		0
#define UNZIP	1
#define GZIP	2
#define BZIP2 3
#define RAR		4
#define LHA		5

#define LIGNECOMMANDE -2
#define COMPRESSION 0
#define DECOMPRESSION 1
#define DEPLACEMENT 2
#define AJOUT 3
#define AJOUTCREATION 4
#define VISUALISATION 5
#define TAILLEARCHIVE 6
#define CONVERSION 7
#define SCRIPT 8


class KarchiveurApp : public KTMainWindow 
{
  Q_OBJECT

public:
  /** construtor */
  KarchiveurApp(); 
  /** destructor */
  ~KarchiveurApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  /** overloaded for Message box on last window exit */
  bool queryExit();
	/* Search some occurences in the main buffer tampon (all the stdout until the end of the process)
		in order to find where'd the name, time, date ... */
	int preparationListe(QString* source, QString* dest, char c=' ');
	/* Run the compressor in list mode so as to display the archive content */
	void afficheArchiveListe();
	/*Display the datas from the stream*/
	void afficheListe(FILE*);
	/*Display the datas from the stream - Zip archives*/
	void afficheListeZip(FILE*);
	/*Display the datas from the stream - RAR archives*/
	void afficheListeRar(FILE*);
	/*Display the datas from the stream - LHA archives*/
	void afficheListeLha(FILE*);		
	/* Add files to a TAR archive wtih modes update / replace, relatice path */
	void ajoutArchiveTar(QString archive, QStrList fichiersAjout, bool enleverfichiers, int actionfichiers, const char* cheminRelatif=NULL);
	/* Add files in a ZIP archive */
	void ajoutArchiveZip(QString archive, QStrList fichiersAjout, bool enleverfichiers, int actionfichiers, const char* cheminRelatif=NULL);
	/* uncompress .tar.* to .tar so as to add files to archive. Then compress and read archive */
	void ajoutArchive(QString archive, QStrList fichiersAjout, bool enlevefichiers, int actionfichiers, const char* cheminRelatif=NULL);
	/* Create a TAR archive */
	void creerArchiveTar(QString, QStrList, const char* cheminRelatif=NULL);
	/* Create a ZIP archive */
	void creerArchiveZip(QString, QStrList, const char* cheminRelatif=NULL);
	/* compress a .gz or a .bz2 file */
	void compresserArchiveCree(const char* compresseur, const char* nomArchive);
	/* Extract some files from archive to the directory cheminextraction
		if toutextraire==1, extract all files
		if toutextraire==9, the file will be viewed (with kwrite...) and then will be deleted*/
	void extraitArchive(const char* cheminextraction, int toutextraire, const char* fichieraextraire);
	/* Return the size (in bytes) of the compressed file */
	long TailleArchive(const char* nomArchive);
	/* Remove files in a TAR archive */
	void enleveArchiveTar(QString archive, QStrList fichiersEnlever);
	/* Remove files in a ZIP archive */
	void enleveArchiveZip(QString archive, QStrList fichiersEnlever);	
	/* Identify the archive type and then remove files */
	void enleveArchive(QString archive, QStrList fichiersAjout);
	/* Process the command line */
	void traiteLigneCommande();
	/* add a little icon in the list view, examining the suffix */
	void definitIcone(QString nom, QString permissions, QListViewItem* elementListe);
	/*Set the software launched when viewing a file in the archive*/
	const char* programmeAssocie(QString);
  /** Start to convert the archive */
  void faitConversion(int type, const char* repconv);
  /** Open an archive from ftp or http */
  void ouvreRessourceReseau(const char* nom);

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** open a new application window */
  void slotFileNewWindow();
  /** generate a new document in the actual view */
  void slotFileNew();
  /** open a document */
  void slotFileOpen();
  /** open a document in the recent list*/
  void slotFileOpenRecent(int);
	/**
		* open a document by clicking in the archive browser
		* @param int index of file to be recalled
		*/
	void slotOuvreFichierNavigateur(const char*);
	/* Open a file selected in the finder */
	void slotOuvreFichierChercheur(const char* archive);
  /** save a document */
  void slotFileSave();
  /** save a document under a different filename*/
  void slotFileSaveAs();
  /** close the actual file */
  void slotFileClose();
  /** print the actual file */
  void slotFilePrint();
  /** delete a file in archive */
	void slotFileDelete();
  /** close the current window */
  void slotFileCloseWindow();
  /** exits the application */
  void slotFileQuit();
  /* Now we can open the net ressource */
  void slotKFMFinished();
  /** make some or all files of the archive being extracted */
  void extraitFichiers();
  /** add files to an archive*/
  void ajouteFichiers();
  /** View some or all files*/
  void visualiseFichiers();
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
	/* The standard output of the process*/
	void recueSdtout(KProcess*, char*, int);
	/* The process finished */
	void sortie(KProcess*);
	/* a file will be viewed */
	void visualisateur(QListViewItem*);
	/* drop action */
  void slotDropEvent( KDNDDropZone *);
	/* mouse right clic in the list => contextual menu */
	void menuContextActive(int);
	/* display the contextual menu */
	void montremenu(QListViewItem *, const QPoint &, int);
	void dblclicliste(QListViewItem*);
	/*Let's see (vith a viewer ALL selected files */
	void slotVoirToutSelectionnes();
	/* Display the option dialog */
	void slotAfficheOptions();
	/*Display directory option's dialog box*/
	void slotAfficheOptionRepertoire();
	/*Let's the archive become plenty of 1.4Mb blocks !*/
	void decoupeFichiers();
	/* Unsplit an archive */
	void slotUnCutt();
	void dndMouseReleaseEvent ( QMouseEvent * );
	void dndMouseMoveEvent( QMouseEvent * _mouse );
  /** Display some infos on current archive */
  void slotVoirArchiveInfos();
  /** Launch a wizard to do: configure, make
		* make install, or patch a directory */
  void slotExecuteScript();
  /** Search for archives */
  void slotFileRecherche();

protected slots: // Protected slots
  /** Enable / disable the file navigator */
  void slotVoirNavigateur();
	void paintEvent( QPaintEvent * );
		
protected:
    void resizeEvent( QResizeEvent * );
  /** Probe if we are cutting or uncutting */
  void faitCuttUnCutt(QString nom);

private:
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** edit_menu contains all items of the menubar entry "Edit" */
  QPopupMenu *edit_menu;
 /** option_menu contains all items of the menubar entry "Options" */
  QPopupMenu *option_menu;
 /** option_menu contains all items of the menubar entry "Disk" */
  QPopupMenu *disk_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
	QPopupMenu *fichiersRecents_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  KarchiveurView *view;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  KarchiveurDoc *doc;
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
	bool bViewNavigateur;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;
	CProcessus *toto;
	QListView *liste;
	QString tampon;
	QString cheminExtraction;
	QString cheminOuverture;
	int typeCompresseur;
	CChoixFichier* fichier;
	CNavigateur* navigateur;
	int operation;
	int compteur;
	CProgress avancement;
	QString visual;
	QPopupMenu *menucontextuel;
	QString reptmp;
	bool recursif;
	bool cheminabsolu;
	bool ecrasergzip;
	bool ecraserbzip2;
	bool incluretoutchemin;
	KDNDWidget *drag;
	bool pressed;
	FILE* fichierIO;
	QStrList fichiersRecents;
	int optionExtraction;
	int optionOuverture;
	KLed* led;
	/* The search dialog box*/
	CRecherche* recherche;
	/* The kfm object for downloads features*/
	KFM* kfm;
};   

#endif // KARCHIVEUR_H
