/***************************************************************************
                          karchiveur.cpp  -  description                              
                             -------------------                                         
    begin                : jeu jun  3 19:43:44 CEST 1999
                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <karchiveur.h>

KarchiveurApp::KarchiveurApp()
{
  setCaption("kArchiveur " VERSION);

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initToolBar();
  initStatusBar();
  initView();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
	toto=new CProcessus();
	connect(toto,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(recueSdtout(KProcess*, char*, int)));
	connect(toto,SIGNAL(processExited (KProcess*)),this,SLOT(sortie(KProcess*)));
	
	liste=new QListView( this, "liste"  );
	liste->setGeometry(10,63,width()-20,height()-60);
  liste->addColumn(i18n("Name"));
	liste->addColumn(i18n("Size"));
	liste->addColumn(i18n("Time"));
	liste->addColumn(i18n("Date"));
	liste->addColumn(i18n("Owner"));
	liste->addColumn(i18n("Permissions"));
	liste->addColumn(i18n("Path"));
	liste->setMultiSelection(TRUE);
	liste->setColumnWidth(0,100);
	liste->setColumnWidth(6,100);

	tampon="";
	typeCompresseur=TAR;
	fichier=new CChoixFichier(this);
	operation=-1;
	compteur=0;
	operation=-1;
	avancement.nouveauProgress();
	fichier->hide();

  drag=new KDNDWidget();

  KDNDDropZone * dropZone = new KDNDDropZone( this , DndURL);
  connect( dropZone, SIGNAL( dropAction( KDNDDropZone *) ),this, SLOT( slotDropEvent( KDNDDropZone *) ) );

	connect(liste,SIGNAL(doubleClicked(QListViewItem*)),SLOT(visualisateur(QListViewItem*)));
	connect(liste, SIGNAL(rightButtonPressed ( QListViewItem *, const QPoint &, int )), this, SLOT(montremenu ( QListViewItem *, const QPoint &, int )));
	connect(liste, SIGNAL(doubleClicked ( QListViewItem * )), this, SLOT(dblclicliste(QListViewItem*)));
	
	toto->clearArguments();

	reptmp.sprintf("/tmp/karchiveurtmp.%d/",getpid());
	*toto << "mkdir" << (const char*)reptmp;
	toto->start();

	visual="kedit";

	pressed=TRUE;
	navigateur=new CNavigateur();
	navigateur->exec();
	if(!bViewNavigateur)
		navigateur->hide();
	connect(navigateur->QListBox_1, SIGNAL(selected(const char*)), this, SLOT(slotOuvreFichierNavigateur(const char*)));
	view_menu->setItemChecked(ID_VIEW_NAVIGATEUR, bViewNavigateur);
  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);

	led=new KLed(KLed::green,KLed::On,KLed::sunken,this,"led1");
	led->setGeometry(this->width()-30,30,15,15);
	led->raise();
	
	recherche=new CRecherche;
	connect(recherche->archtrouvees, SIGNAL(selected(const char*)), this, SLOT(slotOuvreFichierChercheur(const char*)));
kfm=NULL;	
	traiteLigneCommande();
}

KarchiveurApp::~KarchiveurApp()
{
	toto->clearArguments();
	*toto << "rm" << "-Rf" <<(const char*)reptmp;
	toto->start(KProcess::Block);
	delete recherche;
}

void KarchiveurApp::paintEvent( QPaintEvent * )
{
	int y0=25;
	int largeur;
	int hauteur;
	
	largeur=width()-10;
	hauteur=height();
	
	if(bViewToolbar)
		y0+=20;
	if(bViewStatusbar)
		hauteur-=75;
	else
		hauteur-=55;
	liste->setGeometry(7,53,largeur-5,hauteur);
	led->setGeometry(largeur-20,30,15,15);
	led->update();
  enableToolBar(KToolBar::Toggle,0);	
}

void KarchiveurApp::resizeEvent( QResizeEvent * )
{
	int y0=25;
	int largeur;
	int hauteur;
	
	largeur=width()-10;
	hauteur=height();
	
	if(bViewToolbar)
		y0+=20;
	if(bViewStatusbar)
		hauteur-=75;
	else
		hauteur-=55;
	liste->setGeometry(7,53,largeur-5,hauteur);
	led->setGeometry(largeur-20,30,15,15);
  enableToolBar(KToolBar::Toggle,0);
}

void KarchiveurApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KarchiveurApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KarchiveurApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fichiersRecents_menu
  fichiersRecents_menu= new QPopupMenu();
  connect(fichiersRecents_menu,SIGNAL(activated(int)),this,SLOT(slotFileOpenRecent(int)));
  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(Icon("mini/karchiveurapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("Search..."), ID_FILE_RECHERCHE );
  file_menu->insertSeparator();
	file_menu->insertItem(i18n("Open &recent..."), fichiersRecents_menu);
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm"), i18n("Convert &as"), ID_FILE_SAVE_AS );
  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("C&lose Widow"), ID_FILE_CLOSE_WINDOW);
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_N, ID_FILE_NEW);
  file_menu->setAccel(CTRL+Key_O, ID_FILE_OPEN);
  file_menu->setAccel(CTRL+Key_S, ID_FILE_SAVE);
  file_menu->setAccel(CTRL+Key_W, ID_FILE_CLOSE);
  file_menu->setAccel(CTRL+Key_P, ID_FILE_PRINT);
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  edit_menu = new QPopupMenu();
  edit_menu->insertItem(i18n("Extract To"), ID_EDIT_CUT );
  edit_menu->insertItem(i18n("Add files"), ID_EDIT_COPY );
  edit_menu->insertItem(i18n("View file"), ID_EDIT_PASTE );
	edit_menu->insertItem(i18n("View selected"), ID_ARCHIVE_VOIR_TOUT );
	edit_menu->insertItem(Icon("editcut.xpm"), i18n("Delete Files"), ID_FILE_DELETE );
	edit_menu->insertItem(i18n("View archive infos"), ID_ARCHIVE_INFOS);
	edit_menu->insertItem(i18n("Install / patch"), ID_ARCHIVE_EXECUTER);

	option_menu=new QPopupMenu();
	option_menu->insertItem(i18n("options"),ID_OPTIONS_OPTIONS);
	option_menu->insertItem(i18n("directory"),ID_OPTIONS_REPERTOIRE);

	disk_menu=new QPopupMenu();
	disk_menu->insertItem(i18n("Split"),ID_DISK_SPLIT);
  disk_menu->insertItem(i18n("Unsplit"),ID_DISK_UNSPLIT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );
	view_menu->insertItem(i18n("&File browser"), ID_VIEW_NAVIGATEUR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  view_menu->setItemChecked(ID_VIEW_NAVIGATEUR, bViewNavigateur);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE
  
    menucontextuel=new QPopupMenu();
    menucontextuel->insertItem(i18n("Extract To..."));
  	menucontextuel->insertSeparator(1);
    menucontextuel->insertItem(klocale->translate("View"));
    menucontextuel->insertItem(klocale->translate("Delete"));
    connect(menucontextuel, SIGNAL(activated(int)), this, SLOT(menuContextActive(int)));

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Archive"), edit_menu);
	menuBar()->insertItem(i18n("&Options"), option_menu);
	menuBar()->insertItem(i18n("&Disk"), disk_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(edit_menu);
  CONNECT_CMD(view_menu);
	CONNECT_CMD(disk_menu);
	CONNECT_CMD(option_menu);

}

void KarchiveurApp::initToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New Archive"));
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open Archive"));
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File"));
	toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print"));
  toolBar()->insertSeparator();	
  toolBar()->insertButton(Icon("extraire.xpm"), ID_EDIT_CUT, true, i18n("Extract"));
  toolBar()->insertButton(Icon("compresser.xpm"), ID_EDIT_COPY, true, i18n("Add files"));
  toolBar()->insertButton(Icon("voir.xpm"), ID_EDIT_PASTE, true, i18n("View file"));
  toolBar()->insertButton(Icon("mini/karchiveur_wizard.xpm"), ID_ARCHIVE_EXECUTER, true, i18n("Launch the wizard"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_FILE_DELETE, true, i18n("Delete"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

void KarchiveurApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void KarchiveurApp::initView()
{ 
  doc = new KarchiveurDoc(this);

  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  KApplication *app=KApplication::getKApplication();
  view = new KarchiveurView(app,doc,this);
  setView(view);
}

bool KarchiveurApp::queryExit()
{
	if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2)) {
		operation=-1;
	}
  return true;
}

void KarchiveurApp::saveOptions()
{
  KConfig *config = kapp->getConfig();
  char c[8];


  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
	config->writeEntry("ShowNavigateur",bViewNavigateur);
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());

	config->setGroup("RECENTSFILES");
	for(unsigned int i=0;i<5;i++)
	{
		sprintf(c,"Recent%d",i);
		if(i==fichiersRecents.count())break;
		config->writeEntry(c,fichiersRecents.at(i));
	}
	config->setGroup("LASTDIRS");
	config->writeEntry("Extraction",cheminExtraction);
	config->writeEntry("Ouverture",cheminOuverture);
	config->writeEntry("OptExtraction",optionExtraction);
	config->writeEntry("OptOuverture",optionOuverture);
}

void KarchiveurApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
	QString str;
	char c[8];
  KConfig *config = kapp->getConfig();

 
  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
	bViewNavigateur= config->readBoolEntry("ShowNavigateur", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

  config->setGroup("OPTIONS");
  incluretoutchemin=config->readBoolEntry("ToutChemin",false);
  recursif=config->readBoolEntry("Recursif",true);
	ecrasergzip=config->readBoolEntry("EcraserGzip",true);
	ecraserbzip2=config->readBoolEntry("EcraserBzip2",true);
	cheminabsolu=config->readBoolEntry("CheminAbsolu",false);
	visual=config->readEntry("Visualisateur","kedit");

	config->setGroup("RECENTSFILES");
	for(int i=0;i<5;i++)
	{
		sprintf(c,"Recent%d",i);
		str=config->readEntry(c,NULL);
		if(!str.isNull())
		{
			fichiersRecents_menu->insertItem(str,ID_FILE_RECENT+i);
			fichiersRecents.append((const char*)str);
		}
	}
	config->setGroup("LASTDIRS");
	cheminExtraction=config->readEntry("Extraction",NULL);
	cheminOuverture=config->readEntry("Ouverture",NULL);
	optionExtraction=config->readNumEntry("OptExtraction",0);
	optionOuverture=config->readNumEntry("OptOuverture",0);
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KarchiveurApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KarchiveurApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new archive..."));
	setCaption("kArchiveur " VERSION);
	operation=-1;
	liste->clear();
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening archive..."));
	led->setColor(KLed::red);
	fichier->setCheminAcces(cheminOuverture, optionOuverture);
	if(fichier->OuvreFichier()==NULL)
	{
			slotStatusMsg(IDS_DEFAULT);
			led->setColor(KLed::green);
			return;
	}
	if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		operation=-1;
	cheminOuverture=fichier->getCheminAcces();
	navigateur->setChemin(cheminOuverture);
	repaint();
	afficheArchiveListe();
}

void KarchiveurApp::slotFileOpenRecent(int id)
{
	QString nom;
	
	led->setColor(KLed::red);
	operation=-1;
  slotStatusMsg(i18n("Opening archive..."));
  nom=fichiersRecents.at(id-ID_FILE_RECENT);
	fichier->setNomArchive(nom);
	fichier->setCheminAcces((const char*)nom.left(nom.findRev('/')),optionOuverture);
	cheminOuverture=fichier->getCheminAcces();
	navigateur->setChemin(cheminOuverture);	
	afficheArchiveListe();
	led->setColor(KLed::green);
}

void KarchiveurApp::slotOuvreFichierNavigateur(const char* archive)
{
	QString str;
	led->setColor(KLed::red);
	str=cheminOuverture;
	str+="/";
	str+=archive;
	fichier->setNomArchive(str);
	afficheArchiveListe();
	led->setColor(KLed::green);
}

void KarchiveurApp::slotOuvreFichierChercheur(const char* archive)
{
	QString nom;
	led->setColor(KLed::red);
	
	nom=archive;
	fichier->setCheminAcces((const char*)nom.left(nom.findRev('/')),optionOuverture);
	cheminOuverture=fichier->getCheminAcces();
	navigateur->setChemin(cheminOuverture);	
	fichier->setNomArchive(archive);
	afficheArchiveListe();
	led->setColor(KLed::green);
}

void KarchiveurApp::traiteLigneCommande()
{
		operation=-1;
	  KApplication *app=KApplication::getKApplication();
		int argc=app->argc();
		char **argv=app->argv();
		if(argc>1)
		{
			if(strcmp(argv[1],"--version")==0)
				printf("kArchiveur " VERSION "\n");
			else if(strcmp(argv[1],"--help")==0)
			{
				printf("karchiveur is free software, covered by the GNU General Public License, and you are ");
				printf("welcome to change it and/or distribute copies of it under certain conditions.\n");
				printf("See the COPYING file to see the conditions.\n");
				printf("There is absolutely NO WARRANTY for karchiveur.\n");
				printf("kArchiveur, (c) 2000 Eric Coquelle\n");
			}
			else
			{
				QString s=argv[1];
				QString str="";
		
				fichier->setNomArchive(s);
				
				if(fichier->IdentifieCompresseur()==1)
				{
					str=s.left(s.findRev('.',s.length()-3));
					str=str.right(str.length()-str.findRev('/')-1);
					str="/tmp/"+str;
					KProcess tot;
					tot.clearArguments();
					tot << "mv";
					tot << (const char*)s;
					tot << (const char*)str;
					tot.start(KProcess::Block);
					fichier->setNomArchive(str);
				}
				
				fichier->setCheminAcces((const char*)s.left(s.findRev('/')),optionOuverture);
				navigateur->setChemin(fichier->getCheminAcces());				
				led->setColor(KLed::red);
				if((s="")&&(TailleArchive(argv[1])>2000000)||((TailleArchive(argv[1])>1000000)&&(s.right(3)=="bz2"))||((s.right(3)==".gz")&&(s.right(7)!=".tar.gz")))
				{
					operation=LIGNECOMMANDE;
					KProcess tot; do{
					tot.clearArguments();
					tot << "sleep" << "3";
					}while(tot.start(KProcess::NotifyOnExit)==false);
				}
				else
				{				
				  slotStatusMsg(i18n("Running compressor..."));
					afficheArchiveListe();
				}
				led->setColor(KLed::green);
			}
		}
}

void KarchiveurApp::afficheArchiveListe()
{
	CProcessus processus;
	FILE* flot;
	led->setColor(KLed::red);
	
	if(fichier->IdentifieCompresseur()==1)
	{
		slotStatusMsg(i18n("Unknown archive type"));
		led->setColor(KLed::orange);
		return;
	}

	QString nom="kArchiveur ";
	nom+=fichier->getNomFichier();
	setCaption(nom);
	
	/*Update the recent files list*/
	if((fichiersRecents.find(fichier->getNomFichier())==-1)||(fichiersRecents.isEmpty())) {
		fichiersRecents.insert(0,fichier->getNomFichier());
		fichiersRecents_menu->clear();
		for(unsigned int i=0;i<5;i++)
		{
			if(i==fichiersRecents.count())
				break;
			nom=fichiersRecents.at(i);
			if(!nom.isNull())
				fichiersRecents_menu->insertItem(nom,ID_FILE_RECENT+i);
		}
  }

	liste->clear();
	for(int i=0;i<7;i++)
		liste->setColumnWidth(i,50);
	operation=COMPRESSION;
	toto->clearArguments();
	*toto << fichier->getProgrCompresseur();
	processus << fichier->getProgrCompresseur();
	compteur=0;
	if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
	{
		typeCompresseur=TAR;
		*toto << fichier->getOptionSupp();
		processus << fichier->getOptionSupp();
		avancement.ajoute(0);
		avancement.setTexte(i18n("Reading archive"));
	}
	else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
		typeCompresseur=UNZIP;
	else if(strcmp(fichier->getProgrCompresseur(),"gzip")==0)
		typeCompresseur=GZIP;
	else if(strcmp(fichier->getProgrCompresseur(),"bzip2")==0)
	{
		//Bzip2 can't list a file content (since it handle only one file !
		typeCompresseur=BZIP2;
		QListViewItem *li;
		nom=fichier->getNomFichier();
		nom=nom.left(nom.findRev('.'));
		/*(void)*/li=new QListViewItem(liste,(const char*)nom.right(nom.length()-nom.findRev('/')-1),"","","","","",(const char*)nom.left(nom.findRev('/')+1));
		definitIcone((const char*)nom.right(nom.length()-nom.findRev('/')-1),"",li);
		led->setColor(KLed::green);
		return;
	}
	else if(strcmp(fichier->getProgrCompresseur(),"unrar")==0)
		typeCompresseur=RAR;
	else if(strcmp(fichier->getProgrCompresseur(),"lha")==0)
		typeCompresseur=LHA;
		
	if(typeCompresseur==TAR)
	{
	  slotStatusMsg(i18n("Running compressor..."));
		processus << fichier->getListeur() << fichier->getNomFichier();
		processus.demarrer(&flot,KProcess::Stdout);
		afficheListe(flot);
		led->setColor(KLed::green);
		return;
	}
	else if(typeCompresseur==UNZIP)
	{
	  slotStatusMsg(i18n("Running compressor..."));
		processus << fichier->getListeur() << fichier->getNomFichier();
		processus.demarrer(&flot,KProcess::Stdout);
		afficheListeZip(flot);
		led->setColor(KLed::green);
		return;
	}
	else if(typeCompresseur==RAR)
	{
	  slotStatusMsg(i18n("Running compressor..."));
		processus << fichier->getListeur() << fichier->getNomFichier();
		processus.demarrer(&flot,KProcess::Stdout);
		afficheListeRar(flot);
		led->setColor(KLed::green);
		return;
	}
	else if(typeCompresseur==LHA)
	{
	  slotStatusMsg(i18n("Running compressor..."));
		processus << fichier->getListeur() << fichier->getNomFichier();
		processus.demarrer(&flot,KProcess::Stdout);
		afficheListeLha(flot);
		led->setColor(KLed::green);
		return;
	}
	
//printf("\nAffListe:%s*%s*%s*%s*%s\n",fichier->getNomFichier(),fichier->getProgrCompresseur(),fichier->getOptionSupp(),fichier->getListeur(),fichier->getNomFichier());
	*toto << fichier->getListeur() << fichier->getNomFichier();
	if(toto->start(KProcess::NotifyOnExit,KProcess::Stdout)==FALSE)
		printf("\n*PB PROCESS_Liste*\n");
  slotStatusMsg(i18n("Running compressor..."));
}

void KarchiveurApp::afficheListe(FILE* flot)
{
	QListViewItem* elementListe;
	char tampon[5000];
	char permission[30];
	char proprietaire[256];
	char taille[30];
	char date[12];
	char heure[9];
	char snom[5000];
	QString chemin;
	QString nom;
	QString message;
	int i;
	
	fgets( tampon, 5000, flot );
	while( !feof(flot) )
	{
		sscanf(tampon, " %[-drwxstl] %[0-9a-zA-Z./_] %[0-9] %[0-9-] %[0-9:-] %[^\n]",permission, proprietaire, taille, date, heure, snom );

		nom=snom;
		i=nom.findRev('/');
		if(i!=-1)
		{
			chemin=" "+nom.left(i+1);
		 	nom=nom.remove(0,i+1);
		if(nom=="")nom="..";
		}
		else
			chemin=" ";					
		elementListe=new QListViewItem(liste,(const char*)nom,taille,heure,date,proprietaire,permission,(const char*)chemin);
		definitIcone(nom, permission, elementListe);
		elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
	fclose( flot );
	message=IDS_DEFAULT;
	if(fichier->getNomFichier()!=NULL)
		message.sprintf("%s  -  %i %s",IDS_DEFAULT,TailleArchive(fichier->getNomFichier()),i18n("bytes"));
  slotStatusMsg(message);	
}

void KarchiveurApp::afficheListeZip(FILE* flot)
{
	QListViewItem* elementListe;
	char tampon[5000];
	char permission[30];
	char proprietaire[256];
	char crc[20];
	char taille[30];
	char date[12];
	char heure[7];
	char snom[5000];
	char methode[20];
	QString chemin;
	QString nom;
	QString message;
	int i;
	
	do
		fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "----" )==NULL));
	fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "----" )==NULL))
	{
		sscanf(tampon, "  %[0-9]  %[a-zA-Z:]   %[0-9]  %[0-9%]  %[0-9-]  %[0-9:]  %[a-zA-Z0-9]   %[^\n]",taille, methode, proprietaire, permission, date, heure, crc, snom );

		nom=snom;
		nom=" "+nom;
		i=nom.findRev('/');
		if(i!=-1)
		{
			chemin=nom.left(i+1);
		 	nom=nom.remove(0,i+1);
		if(nom=="")nom="..";
		}
		else
			chemin="";					
		elementListe=new QListViewItem(liste,(const char*)nom,taille,heure,date,proprietaire,permission,(const char*)chemin);
		definitIcone(nom, permission, elementListe);
		elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
	fclose( flot );
	message=IDS_DEFAULT;
	if(fichier->getNomFichier()!=NULL)
		message.sprintf("%s  -  %i %s",IDS_DEFAULT,TailleArchive(fichier->getNomFichier()),i18n("bytes"));
  slotStatusMsg(message);	
}

void KarchiveurApp::afficheListeRar(FILE* flot)
{
	QListViewItem* elementListe;
	char tampon[5000];
	char permission[30];
	char *proprietaire="";
	char crc[20];
	char taille[30];
	char date[12];
	char heure[7];
	char snom[5000];
	char methode[20];
	QString chemin;
	QString nom;
	QString message;
	int i;

		
	do
		fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "-------------------------------------------------------------------------------" )==NULL));
	fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "----" )==NULL))
	{
		sscanf(tampon, " %[a-zA-Z0-9:._-] %[0-9] %[0-9] %[0-9%] %[0-9-] %[0-9:] %[a-zA-Z0-9] %[a-zA-Z0-9] %[a-zA-Z0-9] %[^\n]",snom, taille, crc, permission, date, heure, crc, crc, crc, methode );

		nom=snom;
		nom=" "+nom;
		i=nom.findRev('/');
		if(i!=-1)
		{
			chemin=nom.left(i+1);
		 	nom=nom.remove(0,i+1);
		if(nom=="")nom="..";
		}
		else
			chemin="";					
		elementListe=new QListViewItem(liste,(const char*)nom,taille,heure,date,proprietaire,permission,(const char*)chemin);
		definitIcone(nom, permission, elementListe);
		elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
	fclose( flot );
	message=IDS_DEFAULT;
	if(fichier->getNomFichier()!=NULL)
		message.sprintf("%s  -  %i %s",IDS_DEFAULT,TailleArchive(fichier->getNomFichier()),i18n("bytes"));
  slotStatusMsg(message);	
}

void KarchiveurApp::afficheListeLha(FILE* flot)
{
	QListViewItem* elementListe;
	char tampon[5000];
	char permission[30];
	char proprietaire[256];
	char crc[20];
	char taille[30];
	char date[12];
	char heure[7];
	char snom[5000];
	QString chemin;
	QString nom;
	QString message;
	int i;
		
	do
		fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "--------------------" )==NULL));
	fgets( tampon, 5000, flot );
	while( !feof(flot) && (strstr( tampon, "----" )==NULL))
	{
		sscanf(tampon, " %[rwxst-] %[0-9a-zA-Z/] %[0-9] %[*.0-9%] %[a-zA-Z] %[0-9-] %[0-9:] %[^\n]", permission, proprietaire, taille, crc, crc, date, heure, snom );

		nom=snom;
		nom=" "+nom;
		i=nom.findRev('/');
		if(i!=-1)
		{
			chemin=nom.left(i+1);
		 	nom=nom.remove(0,i+1);
		if(nom=="")
			nom="..";
		}
		else
			chemin="";					
			
		elementListe=new QListViewItem(liste,(const char*)nom,taille,heure,date,proprietaire,permission,(const char*)chemin);
		definitIcone(nom, permission, elementListe);
		elementListe->widthChanged();
		fgets( tampon, 5000, flot );
	}
	fclose( flot );
	message=IDS_DEFAULT;
	if(fichier->getNomFichier()!=NULL)
		message.sprintf("%s  -  %i %s",IDS_DEFAULT,TailleArchive(fichier->getNomFichier()),i18n("bytes"));
  slotStatusMsg(message);	
}

long KarchiveurApp::TailleArchive(const char* nomArchive)
{
	FILE *F1;
	long taillearchive;
	taillearchive=0;
	if ((F1 = fopen(nomArchive, "rb")) == NULL)
		return 0;
	fseek(F1, 0, SEEK_END);
	taillearchive=ftell(F1);
	fclose(F1);
	return taillearchive;
}

void KarchiveurApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));

  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFileSaveAs()
{
	led->setColor(KLed::red);
  slotStatusMsg(i18n("Convert archive format..."));
	if(operation!=-1)
	{
			QString repertoire;
			repertoire=reptmp;
			toto->clearArguments();
			*toto << "rm" << "-fR" <<(const char*)repertoire;
			toto->start(KProcess::Block);
			toto->clearArguments();
			*toto << "mkdir" << (const char*)reptmp;
			toto->start(KProcess::Block);			
			operation=CONVERSION;
			avancement.ajoute(0);
			avancement.setTexte(i18n("Extracting files"));
			avancement.setLongueurProgress(liste->childCount());
			cheminExtraction=reptmp;
	    extraitArchive((const char*)cheminExtraction,0,NULL);
	}
	led->setColor(KLed::green);
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	setCaption("kArchiveur " VERSION);
	operation=-1;
	liste->clear();
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFilePrint()
{
	led->setColor(KLed::red);
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  QListViewItem* vi;
  QString fichiers;
  int k;

  if ((operation!=-1)&&(printer.setup(this)))
    {
      QPainter painter;
      const QPixmap *pix;
      painter.begin( &printer );

      ///////////////////////////////////////////////////////////////////
      // TODO: Define printing by using the QPainter methods here
      painter.drawText(20,10,fichier->getNomFichier());
			vi=liste->firstChild();
			for(k=1;k<liste->childCount()+1;k++)
			{
				fichiers.sprintf("%s\t%s\t%s\t%s\t%s\t%s\t%s",vi->text(0),vi->text(1),vi->text(2),vi->text(3),vi->text(4),vi->text(5),vi->text(6));
				pix=vi->pixmap(0);
				if(pix!=NULL)
					painter.drawPixmap(10,(k%40+2)*14,*pix);
				painter.drawText(30,(k%40+2)*14,(const char*)fichiers);
				vi=vi->nextSibling();
				if((k%40)==0)
					printer.newPage();
			}
      painter.end();
    };

  led->setColor(KLed::green);
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFileDelete()
{
	led->setColor(KLed::red);
  slotStatusMsg(i18n("Deleting selected files..."));

	if(operation!=-1)
	{
		int i;
		int k;
		QListViewItem *li=liste->firstChild();
		QString txt;
		QStrList strlist;

		k=liste->childCount();
		for(i=0;i<k;i++)
		{
			if(liste->isSelected(li))
			{
				txt=li->text(6);
				if(txt=="")
				{
					txt=li->text(0);
					txt=txt.remove(0,1);
				}
				else
				{
					txt=txt.remove(0,1);
					txt+=li->text(0);
				}
					strlist.append(txt);
			}
			if(i!=k)
				li=li->nextSibling();
		}
		operation=-2;
		enleveArchive(fichier->getNomFichier(),strlist);
	}
	
	led->setColor(KLed::green);
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotFileCloseWindow()
{
	operation=-1;
	liste->clear();
  close();
}

void KarchiveurApp::slotFileQuit()
{ 

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

void KarchiveurApp::extraitFichiers()
{	
	if(operation==-1)
	{
		slotStatusMsg(i18n("First open an archive !"));
		led->setColor(KLed::orange);
		return;
	}

  slotStatusMsg(i18n("Extract files..."));

  led->setColor(KLed::red);

	CExtraction extraction;
	if(cheminExtraction!="")
		extraction.setCheminAcces(cheminExtraction, optionExtraction);

	if(extraction.exec())
	{
		operation=DECOMPRESSION;
		avancement.ajoute(0);
		avancement.setTexte(i18n("Extracting files"));
		avancement.setLongueurProgress(liste->childCount());
		cheminExtraction=extraction.getCheminAcces();
    extraitArchive((const char*)cheminExtraction,extraction.toutExtraire(),NULL);
	}
	
  slotStatusMsg(IDS_DEFAULT);
	led->setColor(KLed::green);
}

void KarchiveurApp::extraitArchive(const char* cheminextraction, int toutextraire, const char* fichieraextraire)
{
		int k,l;
		QString programme;
		QString optionRepertoire;
		QString nomextrait;
		QString fichiersaextraire="";
		QListViewItem *vi;
		programme=fichier->getProgrCompresseur();
		//printf("\nEntering Dcompression:%d\n",toutextraire);
		optionRepertoire="";
		compteur=0;

		if(toutextraire==9)
		{
			//Le fichier slectionn est visualis
			avancement.ajoute(0);
			avancement.setTexte(i18n("Prepare for viewing"));
			avancement.setLongueurProgress(1);
		}
		else
		{
			avancement.ajoute(0);
			avancement.setTexte(i18n("Extracting files"));
			avancement.setLongueurProgress(liste->childCount());
		}

		toto->clearArguments();
		*toto << (const char*)programme;

		if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
		{
			typeCompresseur=TAR;
			optionRepertoire="-C";
			optionRepertoire+=cheminextraction;
			*toto << fichier->getOptionSupp();
		}
		else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
		{
			typeCompresseur=UNZIP;
			optionRepertoire="-d";
			optionRepertoire+=cheminextraction;
		}
		else if(strcmp(fichier->getProgrCompresseur(),"gzip")==0)
		{
			typeCompresseur=GZIP;
			if(ecrasergzip)
				*toto << "-fcd";
			else
				*toto << "-cd";
		}
		else if(strcmp(fichier->getProgrCompresseur(),"bzip2")==0)
		{
			typeCompresseur=BZIP2;
			if(ecraserbzip2)
				*toto << "-fcd";
			else
				*toto << "-cd";
		}
		else if(strcmp(fichier->getProgrCompresseur(),"unrar")==0)
		{
			typeCompresseur=RAR;
			*toto << fichier->getDecompresseur();
			optionRepertoire=cheminextraction;
		}
		else if(strcmp(fichier->getProgrCompresseur(),"lha")==0)
		{
			typeCompresseur=LHA;
			optionRepertoire="-xw=";
			optionRepertoire+=cheminextraction;
			*toto <<  (const char*)optionRepertoire;
		}		
//printf("\nExtrArch*%s*%s*%s*%s*%s*\n",(const char*)programme,fichier->getOptionSupp(),fichier->getDecompresseur(),fichier->getNomFichier(),(const char*)optionRepertoire);		

		if(typeCompresseur==TAR)
			*toto << fichier->getDecompresseur();

		*toto << fichier->getNomFichier();
		
		if(typeCompresseur!=LHA)
			*toto << (const char*)optionRepertoire;

		if(((typeCompresseur==TAR)||(typeCompresseur==UNZIP))&&(toutextraire==1))
		{
			l=0;
			vi=liste->firstChild();
			for(k=0;k<liste->childCount();k++)
			{
				if((vi->isSelected())&&(strcmp(vi->text(0),"..")!=0))
				{
					fichiersaextraire+=vi->text(6);
					fichiersaextraire+=vi->text(0);
					fichiersaextraire=fichiersaextraire.right(fichiersaextraire.length()-1);
					*toto << (const char*)fichiersaextraire;
					fichiersaextraire="";
					l++;
				}
				vi=vi->nextSibling();
			}
			avancement.setLongueurProgress(l);
		}
		else if(((typeCompresseur==TAR)||(typeCompresseur==UNZIP))&&(toutextraire==9))
		{
			*toto << fichieraextraire;
		}
		
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		{
			if(cheminextraction[strlen(cheminextraction)-1]!='/')
				strcat((char*)cheminextraction,"/");
			programme=fichier->getNomFichier();
			programme=programme.left(programme.findRev('.'));
			programme=programme.right(programme.length()-programme.findRev('/')-1);
			programme=cheminextraction+programme;
//printf("\nExtrArchGZBZ:%d*%s*\n",toutextraire,(const char*)programme);
			fichierIO=fopen((const char*)programme,"w");
			if(fichierIO==NULL)
				return;
			//toto->demarrer(&fichierIO);
			if(toto->start(KProcess::NotifyOnExit, KProcess::Stdout)==FALSE)printf("\n*PB PROCESS*\n");
		}
		else if((toutextraire!=9)||(typeCompresseur==LHA)||(typeCompresseur==RAR))
		{
			if(toto->start(KProcess::NotifyOnExit,KProcess::Stdout)==FALSE)printf("\n*PB PROCESS*\n");
		}
		else
			if(toto->start(KProcess::Block)==FALSE)printf("\n*PB PROCESS*\n");
		compteur=0;
}

void KarchiveurApp::ajouteFichiers()
{
  slotStatusMsg(i18n("Add files..."));
  led->setColor(KLed::red);

	CAjoutFichiers ajoutfichiers;

	if(ajoutfichiers.exec()==0)
	{
		if(operation!=-1)
		{
			//An archive is yet loaded
			operation=AJOUT;
			QString archive;
			int actionfichiers;
			bool enleverfichiers;
			QStrList fichiersAjout;

			archive=fichier->getNomFichier();
			fichiersAjout=ajoutfichiers.getFichiers();
			actionfichiers=ajoutfichiers.getAction();
			enleverfichiers=ajoutfichiers.getEnleveFichiers();

			ajoutArchive(archive,fichiersAjout,enleverfichiers,actionfichiers);
		}
		else
		{
			//No, so create an archive
			KFileDialog boiteSauver(NULL);
			boiteSauver.setName(i18n("Create archive"));
			QString nomarchive=boiteSauver.getSaveFileName();
			fichier->setNomArchive(nomarchive);
			if(fichier->IdentifieCompresseur()==1)
			{
				slotStatusMsg(i18n("Unknown archive type"));
				return;
			}
			operation=-2;
			if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
			{
				avancement.ajoute(0);
				avancement.setTexte(i18n("Creating archive"));
				avancement.setLongueurProgress(1);
				if(strcmp((const char*)nomarchive.right(3),".gz")==0)
				{
					typeCompresseur=GZIP;
					nomarchive=nomarchive.left(nomarchive.length()-3);
					avancement.setLongueurProgress(2);
				}
				if(strcmp((const char*)nomarchive.right(4),".bz2")==0)
				{
					typeCompresseur=BZIP2;
					nomarchive=nomarchive.left(nomarchive.length()-4);
					avancement.setLongueurProgress(2);
				}
				creerArchiveTar(nomarchive,ajoutfichiers.getFichiers());
				avancement.ajoute(1);
				if(typeCompresseur==GZIP)
				{
					compresserArchiveCree("gzip",(const char*)nomarchive);
        	avancement.ajoute(1);
				}
				if(typeCompresseur==BZIP2)
				{
					compresserArchiveCree("bzip2",(const char*)nomarchive);
					avancement.ajoute(1);
				}
				afficheArchiveListe();
			}
			else
			{
    	QMessageBox::warning( this, "karchiveur",
				i18n("Files can be added only in\n"
				".tar, .tar.gz, .tar.bz2") );
				led->setColor(KLed::orange);
				return;
			}
		}
	}
	
	led->setColor(KLed::green);
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::ajoutArchive(QString archive, QStrList fichiersAjout, bool enlevefichiers, int actionfichiers,const char* cheminRelatif=NULL)
{
	toto->clearArguments();
//printf("\nDebAjoutArch:%s*\n",(const char*)archive.right(3));

	if(strcmp((const char*)archive.right(3),".gz")==0)
	{
		//printf("\nDecompression GZIP\n");
		typeCompresseur=GZIP;
		*toto << "gzip" << "-d" << (const char*)archive;
		toto->start(KProcess::Block);
		archive=archive.left(archive.length()-3);
		//while(toto->isRunning());
		//printf("\nDecompression GZIP OK\n");
		ajoutArchiveTar(archive, fichiersAjout, enlevefichiers, actionfichiers, cheminRelatif);
		//printf("\nADD TAR OK\n");
		toto->clearArguments();
		*toto << "gzip" << (const char*)archive;
		toto->start(KProcess::Block);
		//printf("\nCompression GZIP\n");
	}
	else if(strcmp((const char*)archive.right(4),".bz2")==0)
	{
		//printf("\nDecompression BZ2\n");
		typeCompresseur=BZIP2;
		*toto << "bzip2" << "-d" << (const char*)archive;
		toto->start(KProcess::Block);
		archive=archive.left(archive.length()-4);
		//printf("\nDecompression BZ2 OK\n");
		ajoutArchiveTar(archive, fichiersAjout, enlevefichiers, actionfichiers, cheminRelatif);
		//printf("\nADD TAR OK\n");
		toto->clearArguments();
		*toto << "bzip2" << (const char*)archive;
		toto->start(KProcess::Block);
		//printf("\nCompression BZ2\n");
	}
	else if(strcmp((const char*)archive.right(4),".tar")==0)
	{
		ajoutArchiveTar(archive, fichiersAjout, enlevefichiers, actionfichiers, cheminRelatif);
		//printf("\nADD TAR OK\n");
	}
	else if(strcmp((const char*)archive.right(4),".zip")==0)
	{
		typeCompresseur=UNZIP;
		ajoutArchiveZip(archive, fichiersAjout, enlevefichiers, actionfichiers, cheminRelatif);
	}
	else
		return;
	afficheArchiveListe();
}

void KarchiveurApp::ajoutArchiveTar(QString archive, QStrList fichiersAjout, bool enleverfichiers, int actionfichiers, const char* cheminRelatif=NULL)
{
		toto->clearArguments();
		*toto << "tar";
		if(enleverfichiers)
			*toto << "--remove-files";
		if(!recursif)
			*toto << "--no-recursion";
		if(cheminRelatif!=NULL)
			*toto << "-C" << cheminRelatif;
		switch(actionfichiers)
		{
			case 0:
				//Mode append
				*toto << "-rf";
				break;
			case 1:
				//Mode update
				*toto << "-uf";
				break;
			default:
				*toto << "-rf";
				break;
		}
   *toto << (const char*)archive;
	 for (const char* f = fichiersAjout.first(); f; f = fichiersAjout.next())
  	  {
//printf("\nAjArchTar:%s*\n",f);
    	  *toto << f;
	    }
		toto->start(KProcess::Block);
}

void KarchiveurApp::ajoutArchiveZip(QString archive, QStrList fichiersAjout, bool enleverfichiers, int actionfichiers, const char* cheminRelatif=NULL)
{
		QString s;
		toto->clearArguments();
		*toto << "zip";
		if(enleverfichiers)
			*toto << "-m";
		if(recursif)
			*toto << "-r";
		switch(actionfichiers)
		{
			case 1:
				//Mode update
				*toto << "-u";
				break;
		}

		*toto << "-q";
   *toto << (const char*)archive;
	 for (const char* f = fichiersAjout.first(); f; f = fichiersAjout.next())
		{
				s=f;
				if(s.right(1)=="/")
					s.truncate(s.length()-1);
				if(s.find("file:")==0)
					s.remove(0,5);
//printf("\nAjArchZip:%s*dans:%s*%d*%d\n",(const char*)s,(const char*)archive,recursif,actionfichiers);
    	  *toto << (const char*)s;
		}
		toto->start(KProcess::Block);
}

void KarchiveurApp::enleveArchive(QString archive, QStrList fichiersAjout)
{
	led->setColor(KLed::red);
	toto->clearArguments();

	if(strcmp((const char*)archive.right(3),".gz")==0)
	{
		typeCompresseur=GZIP;
		*toto << "gzip" << "-d" << (const char*)archive;
		toto->start(KProcess::Block);
		archive=archive.left(archive.length()-3);
		enleveArchiveTar(archive, fichiersAjout);
		toto->clearArguments();
		*toto << "gzip" << (const char*)archive;
		toto->start(KProcess::Block);
	}
	else if(strcmp((const char*)archive.right(4),".bz2")==0)
	{
		typeCompresseur=BZIP2;
		*toto << "bzip2" << "-df" << (const char*)archive;
		toto->start(KProcess::Block);
		archive=archive.left(archive.length()-4);
		enleveArchiveTar(archive, fichiersAjout);
		toto->clearArguments();
		*toto << "bzip2" << (const char*)archive;
		toto->start(KProcess::Block);
	}
	else if(strcmp((const char*)archive.right(4),".tar")==0)
	{
		enleveArchiveTar(archive, fichiersAjout);
	}
	else if(strcmp((const char*)archive.right(4),".zip")==0)
	{
		enleveArchiveZip(archive, fichiersAjout);
	}
	else
	{
		led->setColor(KLed::orange);
		return;
	}
	afficheArchiveListe();
	led->setColor(KLed::green);
}

void KarchiveurApp::enleveArchiveTar(QString archive, QStrList fichiersEnlever)
{
		toto->clearArguments();
		*toto << "tar" << "--delete" << "-f";
		*toto << (const char*)archive;
	 for (const char* f = fichiersEnlever.first(); f; f = fichiersEnlever.next())
  	  {
    	  *toto << f;
//printf("\naEnlever:%s*\n",f);
	    }
		toto->start(KProcess::Block);
}

void KarchiveurApp::enleveArchiveZip(QString archive, QStrList fichiersEnlever)
{
		toto->clearArguments();
		*toto << "zip" << "-dq";
		*toto << (const char*)archive;
	 for (const char* f = fichiersEnlever.first(); f; f = fichiersEnlever.next())
  	  {
    	  *toto << f;
	    }
		toto->start(KProcess::Block);
}

void KarchiveurApp::visualiseFichiers()
{
  slotStatusMsg(i18n("View this file..."));
	led->setColor(KLed::red);

	if(operation!=-1)
	{
		operation=VISUALISATION;
		QListViewItem *li=liste->currentItem();

		if(li==0)
		{
			  slotStatusMsg(i18n("First select a file"));
				led->setColor(KLed::orange);
				return;
		}
		QString txt=li->text(6);
		if(!txt.isEmpty())
		{
			txt=txt.remove(0,1);
			txt+=li->text(0);
		}
		else
		{
			txt=li->text(0);
			txt=txt.remove(0,1);
		}
		extraitArchive((const char*)reptmp, 9, (const char*)txt);
		waitpid(toto->getPid(),NULL,WNOHANG);
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		{
			txt=txt.right(txt.length()-txt.findRev('/')-1);
		}
		txt=reptmp+txt;

		led->setColor(KLed::orange);

		const char* prg=programmeAssocie(txt);
		KProcess *visu;
		visu=new KProcess();
		*visu << prg/*(const char*)visual*/ << (const char*)txt;
		if(visu->start()==FALSE)
		{
			txt.sprintf("%s %s",i18n("Can't run"),prg);
			KMsgBox::message(this,"karchiveur",(const char*)txt);
		}
	}

  slotStatusMsg(IDS_DEFAULT);
	led->setColor(KLed::green);
}

void KarchiveurApp::slotVoirToutSelectionnes()
{
  slotStatusMsg(i18n("View all selected files..."));
	if(operation!=-1)
	{
		int i;
		int k;
		QListViewItem *li=liste->firstChild();
		QString txt;
		KProcess *visu;

		if(li==0)
		{
		  slotStatusMsg(i18n("First select a file"));
		  led->setColor(KLed::orange);
			return;
		}
		
		led->setColor(KLed::red);
		
		visu=new KProcess();
		*visu << (const char*)visual;

		k=liste->childCount();
		for(i=0;i<k;i++)
		{
			if(liste->isSelected(li))
			{
				txt=li->text(6);
				txt=txt.remove(0,1);
				txt+=li->text(0);
				extraitArchive((const char*)reptmp, 9, (const char*)txt);
				txt=reptmp+txt;
				*visu << (const char*)txt;
//printf("\n*%s-%d*\n",(const char*)txt,i);
			}
//printf("\n*%d*\n",i);
			if(i!=k)
				li=li->nextSibling();
		}
		visu->start();
	}
	
	led->setColor(KLed::green);
  slotStatusMsg(IDS_DEFAULT);
}

void KarchiveurApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

void KarchiveurApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KarchiveurApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KarchiveurApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KarchiveurApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_NEW,                 slotFileNew())
    ON_CMD(ID_FILE_OPEN,                slotFileOpen())
    ON_CMD(ID_FILE_RECHERCHE,           slotFileRecherche())
    ON_CMD(ID_FILE_SAVE,                slotFileSave())
    ON_CMD(ID_FILE_SAVE_AS,             slotFileSaveAs())
    ON_CMD(ID_FILE_CLOSE,               slotFileClose())
		ON_CMD(ID_FILE_PRINT,               slotFilePrint())
    ON_CMD(ID_FILE_DELETE,              slotFileDelete())
    ON_CMD(ID_FILE_CLOSE_WINDOW,        slotFileCloseWindow())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_EDIT_CUT,                 extraitFichiers())
    ON_CMD(ID_EDIT_COPY,                ajouteFichiers())
    ON_CMD(ID_EDIT_PASTE,               visualiseFichiers())
		ON_CMD(ID_ARCHIVE_VOIR_TOUT,				slotVoirToutSelectionnes())
		ON_CMD(ID_ARCHIVE_INFOS,						slotVoirArchiveInfos())
		ON_CMD(ID_ARCHIVE_EXECUTER,					slotExecuteScript())

		ON_CMD(ID_OPTIONS_OPTIONS,					slotAfficheOptions())
		ON_CMD(ID_OPTIONS_REPERTOIRE,				slotAfficheOptionRepertoire())

		ON_CMD(ID_DISK_SPLIT,								decoupeFichiers())
    ON_CMD(ID_DISK_UNSPLIT,							slotUnCutt())

    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
		ON_CMD(ID_VIEW_NAVIGATEUR,					slotVoirNavigateur())
  }
}

void KarchiveurApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,   i18n("Opens a new application window"))
    ON_STATUS_MSG(ID_FILE_NEW,          i18n("Creates a new archive"))
    ON_STATUS_MSG(ID_FILE_OPEN,         i18n("Opens an existing archive"))
    ON_STATUS_MSG(ID_FILE_RECHERCHE,    i18n("Search for existing archive"))
    ON_STATUS_MSG(ID_FILE_SAVE,         i18n("Save the actual document"))
    ON_STATUS_MSG(ID_FILE_SAVE_AS,      i18n("Save the document as..."))
    ON_STATUS_MSG(ID_FILE_CLOSE,        i18n("Closes the actual file"))
    ON_STATUS_MSG(ID_FILE_PRINT,        i18n("Prints the current document"))
    ON_STATUS_MSG(ID_FILE_CLOSE_WINDOW, i18n("Closes the current window"))
    ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))
    ON_STATUS_MSG(ID_FILE_DELETE,       i18n("Delete selected files"))
    ON_STATUS_MSG(ID_EDIT_CUT,          i18n("Extract to..."))
    ON_STATUS_MSG(ID_EDIT_COPY,         i18n("Add files to this archive"))
    ON_STATUS_MSG(ID_EDIT_PASTE,        i18n("View the current file"))
		ON_STATUS_MSG(ID_ARCHIVE_VOIR_TOUT,	i18n("View all selected files"))
    ON_STATUS_MSG(ID_EDIT_SELECT_ALL,   i18n("Selects the whole document contents"))
    ON_STATUS_MSG(ID_ARCHIVE_INFOS,		  i18n("Display infos on current archive"))
    ON_STATUS_MSG(ID_ARCHIVE_EXECUTER,	i18n("Launch a wizard to configure & compile this archive..."))

		ON_STATUS_MSG(ID_OPTIONS_OPTIONS,		i18n("Modify options of karchiveur"))
		ON_STATUS_MSG(ID_OPTIONS_REPERTOIRE,i18n("Modify default directories of karchiveur"))

    ON_STATUS_MSG(ID_DISK_SPLIT,				i18n("Split archive in 1.4Mb blocks"))
    ON_STATUS_MSG(ID_DISK_UNSPLIT,			i18n("UnSplit archive"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))
		ON_STATUS_MSG(ID_VIEW_NAVIGATEUR,		i18n("Enables / disables the file navigator"))
  }
}

void KarchiveurApp::recueSdtout(KProcess *prpc, char *buffer, int length)
{
	QString inter;
	inter=buffer;
	inter=inter.left(length);
	if((operation==DECOMPRESSION)||(operation==CONVERSION)||(operation==SCRIPT))
	{
		int i=0;
		if(typeCompresseur==UNZIP)
		{
			compteur++;
			avancement.ajoute( compteur/2 );
		}
		else if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		{
			compteur++;
			fwrite(buffer,sizeof(char),length,fichierIO);
		compteur++;
		QString s=i18n("Running compressor...");
		switch(compteur/4%8)
		{
			case 0:
				s+="-";
				break;
			case 1:
				s+="/";
				break;
			case 2:
				s+="|";
				break;
			case 3:
				s+="\\";
				break;
			case 4:
				s+="-";
				break;
			case 5:
				s+="/";
				break;
			case 6:
				s+="|";
				break;
			case 7:
				s+="\\";
				break;		
		}
		slotStatusMsg((const char*)s);			
		}
		else
		{			
			while((i=inter.find('\n',i+1))!=-1){
				compteur++;
				avancement.ajoute( compteur );
			}
		}
		if(avancement.estAnnule())
			toto->kill();		
	}
	else if(operation==COMPRESSION)
	{
		inter=inter.simplifyWhiteSpace();
		tampon+=" ";
		tampon+=inter;
		compteur++;
		QString s=i18n("Running compressor...");
		switch(compteur/4%8)
		{
			case 0:
				s+="-";
				break;
			case 1:
				s+="/";
				break;
			case 2:
				s+="|";
				break;
			case 3:
				s+="\\";
				break;
			case 4:
				s+="-";
				break;
			case 5:
				s+="/";
				break;
			case 6:
				s+="|";
				break;
			case 7:
				s+="\\";
				break;		
		}
		slotStatusMsg((const char*)s);
	}
	else if(operation==AJOUTCREATION)
	{
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		{
			fwrite(buffer,sizeof(char),length,fichierIO);
		}
		else
		{
			compteur++;
			avancement.ajoute( compteur );
			if(avancement.estAnnule())
				toto->kill();
		}
	}
	else if(operation==VISUALISATION)
	{
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		{
			fwrite(buffer,sizeof(char),length,fichierIO);
		}
	}
}

/*inline */int KarchiveurApp::preparationListe(QString* source, QString* dest, char c=' ')
{
	int i;
  int j=0;

	if(c=='\n')
		i=source->find(' ',1);
	else
		i=source->find(c,1);
	if(c=='\n')
	{
		QRegExp chaine;
		chaine="[-dlrwxst] *[-rwxst] *[-rwxst] *[-rwxst] *[-rwxst] *[-rwxst] *[-rwxst] *[-rwxst]";
		j=source->find(chaine,i);
		if(j!=-1)i=j-1;
	}
	else if(c=='\t')
	{
		QRegExp chaine;
		chaine=" +[0123456789]+ +Defl";
		j=source->find(chaine,1);
		if(j!=-1)
			i=j;
		else
			i=source->length()-1;
	}
	if(i==-1)
		return 1;
	*dest=source->left(i);
	*source=source->remove(0,i);
	return 0;
}


void KarchiveurApp::sortie(KProcess*)
{
	if(operation==LIGNECOMMANDE)
	{
		operation=-1;
	  KApplication *app=KApplication::getKApplication();
		int argc=app->argc();
		char **argv=app->argv();
		if(argc>1)
		{
			slotStatusMsg(i18n("Running compressor..."));
			QString s=argv[1];
			afficheArchiveListe();
		}
	}
	else if(operation==DECOMPRESSION)
	{
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
		{
			fclose(fichierIO);
			led->setColor(KLed::green);
		}
		avancement.estAnnule();
	}
	else if(operation==COMPRESSION)
	{
		int i;
    QListViewItem *elementListe=NULL;
		avancement.setLongueurProgress(avancement.getNombrePas());
		tampon+=" ";
		QString permissions;
		QString proprietaire;
		QString taille;
		QString date;
		QString heure;
		QString nom;
		QString chemin;
		QString tampon2;

		slotStatusMsg(i18n("Reading archive"));

		if(typeCompresseur==TAR)
		{
			avancement.setLongueurProgress(compteur);
			avancement.setTexte(i18n("Reading archive"));
			liste->hide();
			compteur=0;
			avancement.initCompteur();
		}
		else if(typeCompresseur==UNZIP)
		{
			for(i=0;i<3;i++)
				tampon=tampon.left(tampon.findRev("------"));
			tampon=tampon.left(tampon.length());
			if(tampon.right(1)!=" ")tampon+=" ";
			for(i=0;i<8;i++)
				tampon=tampon.remove(0,tampon.find("----")+5);
			if(tampon.isEmpty())
				return;
		}
		else if(typeCompresseur==GZIP)
		{
			for(i=0;i<10;i++)
				preparationListe(&tampon,&permissions);
		}
		while(tampon!=" ")
		{
			preparationListe(&tampon,&permissions);
			preparationListe(&tampon,&proprietaire);
			if(typeCompresseur==UNZIP)
				preparationListe(&tampon,&proprietaire);
			if(typeCompresseur==GZIP)
			{
				permissions+=" ";
				permissions+=proprietaire;
				preparationListe(&tampon,&proprietaire);
			}
			preparationListe(&tampon,&taille);
			preparationListe(&tampon,&date);
			preparationListe(&tampon,&heure);
			if(typeCompresseur==TAR)
			{
				preparationListe(&tampon,&nom,'\n');
				avancement.Ajoute();
			}
			else
				preparationListe(&tampon,&nom,' ');
			if(typeCompresseur==UNZIP)
					preparationListe(&tampon,&nom,'\t');
			else
			{
				i=nom.findRev('/');
				if(i!=-1)
				{
					chemin=nom.left(i+1);
					nom=nom.remove(0,i+1);
				if(nom=="")nom="..";
				}
				else
					chemin="";
			}
			if(typeCompresseur==TAR)
				elementListe=new QListViewItem(liste,(const char*)nom,(const char*)taille,(const char*)heure,(const char*)date,(const char*)proprietaire,(const char*)permissions,(const char*)chemin);
			else if(typeCompresseur==UNZIP)
				elementListe=new QListViewItem(liste,(const char*)nom,(const char*)permissions,(const char*)heure,(const char*)date,(const char*)taille,(const char*)proprietaire,"","");
			else if(typeCompresseur==GZIP)
				elementListe=new QListViewItem(liste,(const char*)nom,(const char*)taille,(const char*)proprietaire,(const char*)permissions,(const char*)heure,(const char*)date,(const char*)chemin);
			definitIcone(nom, permissions, elementListe);
			elementListe->widthChanged();
		}
		if(typeCompresseur==TAR)
		{
			avancement.ajoute(avancement.getNombrePas());
      liste->show();
		}
		tampon="";
	}
	if(operation==SCRIPT)
	{
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
			fclose(fichierIO);
		
		avancement.estAnnule();
			
		QString nomfichselect;
		QString repbase;
		QString repbasetmp;	
		CScript objetscript;
		QListViewItem *li;
		int typescript;

		operation=COMPRESSION;
		repbase="";				
		li=liste->currentItem();
		if(li==NULL)
		{
			li=liste->firstChild();
			while(li)
			{
				if(strcmp(li->text(0),"..")!=0)
					break;
				li=li->nextSibling();
			}
		}
		nomfichselect=li->text(0);
		if(nomfichselect=="..")
		{
			led->setColor(KLed::orange);
			return;			
		}
		if((typeCompresseur==TAR)||(typeCompresseur==UNZIP))
		{
			repbasetmp=li->text(6);
			repbasetmp.remove(0,1);
			nomfichselect=repbasetmp+nomfichselect;
			li=liste->firstChild();
			repbase=li->text(6);
			while(li)
			{
				repbasetmp=li->text(6);
				if(repbase.length()>repbasetmp.length())
					repbase=repbasetmp;
				li=li->nextSibling();
			}
			repbase.remove(0,1);
		}

		repbase=reptmp+repbase;
//printf("Dmarrage Wizard:%s*%s*\n",(const char*)nomfichselect,(const char*)repbase);
		typescript=objetscript.demarrerAssistant(nomfichselect,repbase,fichier->getNomFichier());
printf("TypeScript:%d",typescript);					
		if(typescript==2)
		{
			//User has choosed to convert the archive
			faitConversion(objetscript.getTypeConversion(),objetscript.getRepertoireConversion());
		}
		else if(typescript==3)
		{
			//User has choosed to split/unsplit archive
			if(objetscript.getRepertoireCutt()!=NULL)
				faitCuttUnCutt(objetscript.getRepertoireCutt());
		}
		led->setColor(KLed::green);	
	}
	else if(operation==CONVERSION)
	{
//printf("\nEntering Conversion\n");
		QStrList* listeFichiers;
    QStrList listeKDE;
		QString s;
		QString archiveOriginale;
		QDir repertoire=QDir::root();

		repertoire.cd((const char*)reptmp);
		archiveOriginale=fichier->getNomFichier();
		//listeFichiers=repertoire.encodedEntryList(); //Modif QT2.0
		listeFichiers=(QStrList*)repertoire.entryList();
		 for (const char* f = listeFichiers->first(); f; f = listeFichiers->next())
  	  {
				if((strcmp(f,".")==0)||(strcmp(f,"..")==0))
					listeFichiers->remove();
				else
				{
					s="file:";
					s+=f;
					listeKDE.append(s);
				}
	    }

		KFileDialog boiteSauver(NULL);
QString programme=fichier->getNomFichier();		
		boiteSauver.setName(i18n("Convert archive"));
		QString nomarchive=boiteSauver.getSaveFileName();
		if(nomarchive==NULL)
		{
			operation=-2;
			led->setColor(KLed::green);
			return;
		}
		repaint();
//printf("\nconversion:archive*%s*\n",(const char*)nomarchive);
		//operation=AJOUTCREATION;
		operation=-2;
		fichier->setNomArchive(nomarchive);
			if(fichier->IdentifieCompresseur()==1)
			{
				slotStatusMsg(i18n("Unknown archive type"));
				led->setColor(KLed::green);
				return;
			}
		if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
		{
			if(strcmp((const char*)nomarchive.right(3),".gz")==0)
			{
				typeCompresseur=GZIP;
				nomarchive=nomarchive.left(nomarchive.length()-3);
//printf("\nGo GZIP\n");
			}
			if(strcmp((const char*)nomarchive.right(4),".bz2")==0)
			{
				typeCompresseur=BZIP2;
				nomarchive=nomarchive.left(nomarchive.length()-4);
//printf("\nGo GZIP\n");				
			}
			creerArchiveTar(nomarchive,listeKDE,(const char*)reptmp);
//printf("\nConversion:ArchiveCre\n");
			if(typeCompresseur==GZIP)
			{
				compresserArchiveCree("gzip",(const char*)nomarchive);
//printf("\nConversion:ArchiveGZCre\n");
			}
			else if(typeCompresseur==BZIP2)
			{
				compresserArchiveCree("bzip2",(const char*)nomarchive);
			}
			afficheArchiveListe();
		}
		else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
		{
			typeCompresseur=UNZIP;
			creerArchiveZip(nomarchive,listeKDE,(const char*)reptmp);
		}
		else
		{

			programme=programme.left(programme.findRev('.'));
			programme=programme.right(programme.length()-programme.findRev('/')-1);
			programme=reptmp+programme;
//printf("\nConvGZ:%s*vers:%s*\n",(const char*)programme,(const char*)nomarchive);

//printf("\nExtrArchGZBZ:%d*%s*\n",toutextraire,(const char*)programme);
//			fichierIO=fopen((const char*)nomarchive,"w");
//			if(fichierIO==NULL)
//				return;
			toto->clearArguments();
			const char* pr;
			char* ext;
			if(nomarchive.right(3)==".gz")
			{
				typeCompresseur=GZIP;
				pr="gzip";
				ext=".gz";
			}
			else if(nomarchive.right(4)==".bz2")
			{
				typeCompresseur=BZIP2;
				pr="bzip2";
				ext=".bz2";
			}
			else
			{
		  	QMessageBox::warning( this, "karchiveur",
				i18n("Files can be added only in\n"
				".tar, .tar.gz, .tar.bz2") );
				led->setColor(KLed::green);
				return;
			}			
			*toto << pr;
			*toto << "-f";
			*toto << (const char*)programme;
			toto->start(KProcess::Block);
			toto->clearArguments();
			pr="mv";
			*toto << pr;
			programme+=ext;
			*toto << (const char*)programme;
			*toto << (const char*)nomarchive;
			toto->start(KProcess::Block);			
		}
		s.sprintf("%s: %s ?",i18n("Delete"),(const char*)archiveOriginale);
		if(KMsgBox::yesNo(this,"karchiveur",s)==1)
		{
			toto->clearArguments();
			*toto << "rm" << "-f" <<(const char*)archiveOriginale;
			toto->start(KProcess::Block);
		}
		led->setColor(KLed::green);
//printf("\nFin conversion\n");
	}
	else if(operation==AJOUTCREATION)
		{
			afficheArchiveListe();
			avancement.estAnnule();
			fclose(fichierIO);
		}
	else if(operation==VISUALISATION)
	{
		if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2))
			fclose(fichierIO);
	}
	QString message=IDS_DEFAULT;
	if(fichier->getNomFichier()!=NULL)
		message.sprintf("%s  -  %i %s",IDS_DEFAULT,TailleArchive(fichier->getNomFichier()),i18n("bytes"));
  slotStatusMsg(message);
}


void KarchiveurApp::visualisateur(QListViewItem*)
{
}

void KarchiveurApp::slotDropEvent( KDNDDropZone *_dropZone)
{
  QStrList strliste;
	QStrList strlisteDeux;
  QString str;
	QString chemin;
  const char* f;

  strliste=_dropZone->getURLList();
  strlisteDeux.clear();


////printf("Drop:%s*%s\n",(const char*)strliste.first(),rem.tempName());
  for ( f = strliste.first(); f; f = strliste.next())
    {
      str=f;
      if((str.left(6)=="ftp://")||(str.left(7)=="http://"))
      {
      	ouvreRessourceReseau((const char*)str);
      	return;
      }
      str=str.right(str.length()-str.findRev('/',str.length()-2)-1);
			if(str.right(1)=="/")str=str.remove(str.length()-1,1);
//printf("\nListeDrop:*%s*",(const char*)str);
			strlisteDeux.append(str);
			chemin=f;
    }
	chemin=chemin.left(chemin.findRev('/',chemin.length()-2));
	chemin=chemin.right(chemin.length()-chemin.find(':')-1);
	fichier->setCheminAcces(chemin, optionOuverture);
	navigateur->setChemin(fichier->getCheminAcces());	
//printf("\nchemin:%s*operation*%d*\n",(const char*)chemin,operation);
	if(operation!=-1)
	{
		//Un fichier archive est dj charg
		QString archive;

		archive=fichier->getNomFichier();
		if(typeCompresseur==TAR)
		{
			operation=AJOUT;
			if(incluretoutchemin)
				ajoutArchive(archive,strliste,FALSE,0,(const char*)chemin);
			else
				ajoutArchive(archive,strlisteDeux,FALSE,0,(const char*)chemin);
		}
		else if(typeCompresseur==UNZIP)
		{
			operation=AJOUT;
			ajoutArchive(archive,strliste,FALSE,0,(const char*)chemin);
		}
		else
		{
    QMessageBox::warning( this, "karchiveur",
			i18n("Files can be added only in\n"
			".tar, .tar.gz, .tar.bz2") );
			led->setColor(KLed::orange);
			return;
		}
	}
	else
	{
		led->setColor(KLed::red);
		if(strliste.count()==1)
		{
			str=strliste.first();
			str=str.right(str.length()-str.find(':')-1);
			fichier->setNomArchive(str);
//printf("\nArchive*%s*\n",(const char*)str);
			if(fichier->IdentifieCompresseur()==0)
			{
		    afficheArchiveListe();
		    led->setColor(KLed::orange);
				return;
			}
		}
		KFileDialog boiteSauver(NULL);
		boiteSauver.setName(i18n("Create archive"));
		QString nomarchive=boiteSauver.getSaveFileName();
		if(nomarchive.isEmpty())
		{
			led->setColor(KLed::green);
			return;
		}
		fichier->setNomArchive(nomarchive);
		cheminOuverture=fichier->getCheminAcces();
		navigateur->setChemin(cheminOuverture);
		if(fichier->IdentifieCompresseur()==1)
		{
			slotStatusMsg(i18n("Unknown archive type"));
			led->setColor(KLed::orange);
			return;
		}
///		operation=AJOUTCREATION;
		if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
		{
			avancement.ajoute(0);
			avancement.setTexte(i18n("Creating archive"));
			avancement.setLongueurProgress(1);
			if((strcmp((const char*)nomarchive.right(3),".gz")==0)||((strcmp((const char*)nomarchive.right(3),".tgz")==0)))
			{
				typeCompresseur=GZIP;
				nomarchive=nomarchive.left(nomarchive.length()-3);
				avancement.setLongueurProgress(2);
			}
			if(strcmp((const char*)nomarchive.right(4),".bz2")==0)
			{
				typeCompresseur=BZIP2;
				nomarchive=nomarchive.left(nomarchive.length()-4);
				avancement.setLongueurProgress(2);
			}
			if(incluretoutchemin)
				creerArchiveTar(nomarchive,strliste,(const char*)chemin);
			else
				creerArchiveTar(nomarchive,strlisteDeux,(const char*)chemin);
			avancement.ajoute(1);
			if(typeCompresseur==GZIP)
			{
				compresserArchiveCree("gzip",(const char*)nomarchive);
        avancement.ajoute(1);
			}
			if(typeCompresseur==BZIP2)
			{
				compresserArchiveCree("bzip2",(const char*)nomarchive);
				avancement.ajoute(1);
			}
			operation=AJOUTCREATION;
			afficheArchiveListe();
		}
		else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
		{
			creerArchiveZip(nomarchive,strliste/*,(const char*)chemin*/);
			afficheArchiveListe();
		}
		else if((strcmp(fichier->getProgrCompresseur(),"gzip")==0)&&(strliste.count()==1))
		{
			fichierIO=fopen((const char*)nomarchive,"w");
			typeCompresseur=GZIP;
			toto->clearArguments();
			*toto << "gzip" << "-c" << (const char*)str;
			toto->start(KProcess::NotifyOnExit, KProcess::Stdout);
		}
		else if((strcmp(fichier->getProgrCompresseur(),"bzip2")==0)&&(strliste.count()==1))
		{
			fichierIO=fopen((const char*)nomarchive,"w");
			typeCompresseur=BZIP2;
			toto->clearArguments();
			*toto << "bzip2" << "-c" << (const char*)str;
			toto->start(KProcess::NotifyOnExit, KProcess::Stdout);
		}
		else
		{
			led->setColor(KLed::green);
	    QMessageBox::warning( this, "karchiveur",
				i18n("Files can be added only in\n"
				".tar, .tar.gz, .tar.bz2") );
			led->setColor(KLed::orange);
			return;
		}
		led->setColor(KLed::green);
	}		
}

void KarchiveurApp::creerArchiveTar(QString nomArchive, QStrList strliste, const char* cheminRelatif=NULL)
{
	QString str;
//printf("\nDebutCreationTar*%s*%s*\n",(const char*)nomArchive,cheminRelatif);
	toto->clearArguments();
	*toto << "tar" << "-c";
	if(cheminRelatif!=NULL)
		*toto << "-C" << cheminRelatif;
  for (const char* f = strliste.first(); f; f = strliste.next())
    {
      str=f;
      str=str.right(str.length()-str.find(":")-1);
			*toto << (const char*)str;
//printf("\nCreationTAR:%s\n",(const char*)str);
    }
	*toto << "-f" << (const char*)nomArchive;
	toto->start(KProcess::Block);
//printf("\nFinCreationTar\n");
}

void KarchiveurApp::compresserArchiveCree(const char* compresseur, const char* nomArchive)
{
//printf("ComprArchCree:%s",nomArchive);
	toto->clearArguments();
	//gzip et bzip2 acceptent -f
	*toto << compresseur;
	if(((strcmp(compresseur,"gzip")==0)&&ecrasergzip)||((strcmp(compresseur,"bzip2")==0)&&ecraserbzip2))
		*toto << "-f";
	*toto << nomArchive;
	toto->start(KProcess::Block);
}

void KarchiveurApp::creerArchiveZip(QString nomArchive, QStrList strliste, const char* cheminRelatif=NULL)
{
	QString str;
//printf("\nDebutCreationZip*%s*%s*\n",(const char*)nomArchive,cheminRelatif);
	toto->clearArguments();
	*toto << "zip" << "-rD";
	*toto << (const char*)nomArchive;
  for (const char* f = strliste.first(); f; f = strliste.next())
    {
      str=f;
      str=str.right(str.length()-str.find(":")-1);
			if(cheminRelatif!=NULL)
				str=cheminRelatif+str;
			*toto << (const char*)str;
//printf("\nZip:%s*\n",(const char*)str);
    }

	toto->start(KProcess::Block);
//printf("\nFinCreationZip\n");
}

void KarchiveurApp::menuContextActive(int i)
{
	switch(i)
	{
		case 0:
			extraitFichiers();
			break;
		case 2:
			visualiseFichiers();
			break;
		case 3:
			slotFileDelete();
			break;
	}
}

void KarchiveurApp::montremenu(QListViewItem *l, const QPoint &pos, int)
{
	liste->setSelected(l,TRUE);
	menucontextuel->exec(pos);
}

void KarchiveurApp::dblclicliste(QListViewItem*)
{
	menuContextActive(2);
}

void KarchiveurApp::slotAfficheOptions()
{
//printf("\nOpt\n");
	COptions options;
	if(options.exec()==0)
	{
		recursif=options.getRecursif();
		visual=options.getVisualisateur();
		cheminabsolu=options.getCheminAbsolu();
		ecrasergzip=options.getEcraserGzip();
		ecraserbzip2=options.getEcraserBzip2();
		incluretoutchemin=options.getToutChemin();
	}
}

void KarchiveurApp::slotAfficheOptionRepertoire()
{
	COptionRepertoire option;
	if(option.exec()==0)
	{
		if(option.QRadioButton_Extraction_Last->isChecked())
			optionExtraction=0;
		else
		if(option.QRadioButton_Extraction_Home->isChecked())
			optionExtraction=1;
		else
		if(option.QRadioButton_Extraction_Shell->isChecked())
			optionExtraction=2;
		if(option.QRadioButton_Open_Last->isChecked())
			optionOuverture=0;
		else
		if(option.QRadioButton_Open_Home->isChecked())
			optionOuverture=1;
		else
		if(option.QRadioButton_Open_Shell->isChecked())
			optionOuverture=2;
		saveOptions();
	}
}

void KarchiveurApp::decoupeFichiers()
{
	QString nom;
	
	led->setColor(KLed::red);
	
	cuttFichier objCoupe;
	objCoupe.definitProgress(&avancement);
	if(operation==-1)
		nom=KFileDialog::getOpenFileName();
	else
		nom=fichier->getNomFichier();
	if(nom.isNull())
	{
		led->setColor(KLed::orange);
		return;
	}
	
	objCoupe.Debut((const char*)nom,0);
	
	led->setColor(KLed::green);
	
	nom.sprintf("%s %s%s",i18n("archive splitted in"),fichier->getNomFichier(),".01...");
	KMsgBox::message(this,i18n("kArchiveur"),nom);
}

void KarchiveurApp::slotUnCutt()
{
	QString nom;
	
	led->setColor(KLed::red);
	
	cuttFichier objCoupe;
	nom=KFileDialog::getOpenFileName(NULL, "*.01");
	if(nom.isNull())
	{
		led->setColor(KLed::orange);
		return;
	}
	nom=nom.left(nom.length()-3);
	objCoupe.definitProgress(&avancement);
	if(objCoupe.Debut((const char*)nom,1)==0)
	{
		operation=-1;
		fichier->setNomArchive(nom);
		afficheArchiveListe();
	}
	led->setColor(KLed::green);
}

void KarchiveurApp::dndMouseMoveEvent( QMouseEvent * _mouse )
{
// 'pressed' is set in mousePressedEvent(...)
if ( !pressed )
        return;

//int x = _mouse->pos().x();
//int y = _mouse->pos().y();

//if ( abs( x - press_x ) > Dnd_X_Precision || abs( y - press_y ) > Dnd_Y_Precision )
//{
QString data = "Transfer me";
        QPoint p = mapToGlobal( _mouse->pos() );
        QPixmap pixmap( Icon("tgz.xpm") );
        int dx = - pixmap.width() / 2;
        int dy = - pixmap.height() / 2;

        drag->startDrag( new KDNDIcon( pixmap, p.x() + dx, p.y() + dy ), data.data(), data.length(), DndText, dx, dy );
//}
//else
//{
//Do something different
//}
}
void KarchiveurApp::dndMouseReleaseEvent ( QMouseEvent * )
{
	pressed=FALSE;
}

void KarchiveurApp::definitIcone(QString nom, QString permissions, QListViewItem* elementListe)
{
			nom=nom.lower();
			if(nom=="..")
				elementListe->setPixmap(0,Icon("mini/folder.xpm"));
			else if((typeCompresseur==TAR)&&(permissions.contains('x',FALSE)!=0))
				elementListe->setPixmap(0,Icon("mini/exec.xpm"));
			else if(nom.right(2)==".h")
				elementListe->setPixmap(0,Icon("mini/karchiveur_h.xpm"));
			else if((nom.right(4)==".cpp")||(nom.right(3)==".cc")||(nom.right(2)==".c"))
				elementListe->setPixmap(0,Icon("mini/karchiveur_cpp.xpm"));
			else if(nom.right(4)==".txt")
				elementListe->setPixmap(0,Icon("mini/txt.xpm"));
			else if(nom=="makefile")
				elementListe->setPixmap(0,Icon("mini/karchiveur_mak.xpm"));
			else if((nom=="readme")||(nom=="install")||(nom=="authors")||(nom=="copying")||(nom=="todo"))
				elementListe->setPixmap(0,Icon("mini/karchiveur_gnu.xpm"));
			else if((nom=="changelog")||(nom.right(4)==".lsm"))
				elementListe->setPixmap(0,Icon("mini/mini-question.xpm"));			
			else if(nom.right(3)==".ps")
				elementListe->setPixmap(0,Icon("mini/mini-gv.xpm"));
			else if(nom.right(4)==".rpm")
				elementListe->setPixmap(0,Icon("mini/rpmfile.xpm"));
			else if((nom.right(4)==".gif")||(nom.right(4)==".jpg")||(nom.right(4)==".bmp")||(nom.right(4)==".xpm")||(nom.right(4)==".png"))
				elementListe->setPixmap(0,Icon("mini/kpaint.xpm"));
			else if(nom=="configure")
				elementListe->setPixmap(0,Icon("mini/exec.xpm"));
			else if((nom.right(4)==".htm")||(nom.right(5)==".html")||(nom.right(6)==".shtml"))
				elementListe->setPixmap(0,Icon("mini/mini.netscape.xpm"));
			else if((nom.right(4)==".wav")||(nom.right(3)==".au")||(nom.right(3)==".xm")||(nom.right(4)==".s3m")||(nom.right(4)==".mod")||(nom.right(4)==".mp3"))
				elementListe->setPixmap(0,Icon("mini/karchiveur_son.xpm"));
			else if((nom.right(3)==".po")||(nom.right(4)==".gmo")||(nom.right(4)==".pot"))
				elementListe->setPixmap(0,Icon("mini/locale.xpm"));
			else if((nom.right(3)==".in")||(nom.right(3)==".am"))
				elementListe->setPixmap(0,Icon("mini/karchiveur_in.xpm"));
			else if(nom.right(1)=="~")
				elementListe->setPixmap(0,Icon("mini/karchiveur_trash.xpm"));
			else if((nom.right(3)==".gz")||(nom.right(4)==".bz2")||(nom.right(4)==".tar")||(nom.right(4)==".zip")||(nom.right(2)==".z"))
				elementListe->setPixmap(0,Icon("mini/karchiveur.xpm"));
			else if(nom.right(3)==".m4")
				elementListe->setPixmap(0,Icon("mini/karchiveur_m4.xpm"));
			else if((nom.right(5)==".diff")||(nom.left(5)=="patch")||(nom.right(5)=="patch"))
				elementListe->setPixmap(0,Icon("mini/karchiveur_diff.xpm"));
			else if((nom.right(6)==".class")||(nom.right(5)==".java")||(nom.right(4)==".jar"))
				elementListe->setPixmap(0,Icon("mini/karchiveur_java.xpm"));
			else if((nom.right(8)==".kdevprj")||(nom.right(7)==".kdelnk")||(nom.right(8)==".kdevdlg"))
				elementListe->setPixmap(0,Icon("mini/kdevelop.xpm"));
}

const char* KarchiveurApp::programmeAssocie(QString fichier)
{
	fichier=fichier.lower();
	if((fichier.right(4)==".jpg")||(fichier.right(4)==".gif")||(fichier.right(4)==".bmp")||(fichier.right(4)==".png")||(fichier.right(4)==".xpm"))
		return "kview";
	else
	if((fichier.right(4)==".htm")||(fichier.right(5)==".html")||(fichier.right(6)==".shtml"))
		return "netscape";
	if(fichier.right(3)==".ps")
		return "kghostview";
	else
	if((fichier.right(4)==".wav")||(fichier.right(3)==".au"))
		return "kmedia";
	else
	if(fichier.right(4)==".mp3")
		return "kmp3";
	else
	if((fichier.right(4)==".mod")||(fichier.right(4)==".s3m")||(fichier.right(3)==".xm")||(fichier.right(3)==".it"))
		return "kmikmod";
	else
	if((fichier.right(3)==".gz")||(fichier.right(4)==".bz2")||(fichier.right(4)==".zip")||(fichier.right(4)==".tgz")||(fichier.right(4)==".tar")||(fichier.right(2)==".z"))
		return "karchiveur";
	else
	if(fichier.right(4)==".rpm")
		return "kpackage";
	else	
		return visual;
}


/** Enable / disable the file navigator */
void KarchiveurApp::slotVoirNavigateur()
{
	bViewNavigateur=!bViewNavigateur;
	if(bViewNavigateur)
	{
		navigateur->show();
	}
	else
		navigateur->hide();
	view_menu->setItemChecked(ID_VIEW_NAVIGATEUR, bViewNavigateur);
}

/** Display some infos on current archive */
void KarchiveurApp::slotVoirArchiveInfos()
{
	QListViewItem *item;
	QString txt;
	int total;
	int moyenne;
	int ecarttype;
	int taux;
	int taillearchive;
	int nbrefichiers;
	int i;

	if((typeCompresseur==GZIP)||(typeCompresseur==BZIP2)||(operation==-1))
		return;
			
	total=0;
	ecarttype=0;
	
	item=NULL;	
	item=liste->firstChild();
	nbrefichiers= liste->childCount();
	while(item)
	{
		txt=item->text(1);
		i=txt.toInt();
		total+=i;
		ecarttype+=i*i/nbrefichiers;
		item=item->nextSibling();
	}
	
	taillearchive=TailleArchive(fichier->getNomFichier());
	moyenne=total/nbrefichiers;
	taux=100-100*taillearchive/total;

	ecarttype-=moyenne;
	ecarttype=(int)sqrt((float)ecarttype);
	CInfos boiteinfos;
	boiteinfos.initialise(nbrefichiers, taillearchive, total, moyenne, taux, ecarttype);
	boiteinfos.exec();
}

/** Launch a wizard to do: configure, make
make install, or patch a directory */
void KarchiveurApp::slotExecuteScript()
{
//First, we extract all files to reptmp
//Once process exits to Sortie, we launch the wizard
	if(operation!=-1)
	{
		QString repertoire;
			
		led->setColor(KLed::red);
		slotStatusMsg(i18n("Running wizard"));	

		repertoire=reptmp;
		toto->clearArguments();
		*toto << "rm" << "-fR" <<(const char*)repertoire;
		toto->start(KProcess::Block);
		toto->clearArguments();
		*toto << "mkdir" << (const char*)reptmp;
		toto->start(KProcess::Block);

		operation=SCRIPT;
    extraitArchive((const char*)reptmp,0,NULL);
	}	
}

/** Search for archives */
void KarchiveurApp::slotFileRecherche(){
	recherche->setCheminAcces(cheminOuverture, optionOuverture);
	recherche->exec();
}

/** Start to convert the archive */
void KarchiveurApp::faitConversion(int type, const char* repconv)
{
	QStrList* listeFichiers;
  QStrList listeKDE;
	QString s;
	QString archiveOriginale;
	QString nomarchive;
	QDir repertoire=QDir::root();
		
	repertoire.cd((const char*)reptmp);
	archiveOriginale=fichier->getNomFichier();
	//listeFichiers=repertoire.encodedEntryList(); //Modif QT2.0
	listeFichiers=(QStrList*)repertoire.entryList();
	for (const char* f = listeFichiers->first(); f; f = listeFichiers->next())
  {
		if((strcmp(f,".")==0)||(strcmp(f,"..")==0))
			listeFichiers->remove();
		else
		{
			s="file:";
			s+=f;
			listeKDE.append(s);
		}
   }
	KFileDialog boiteSauver(NULL);
	QString programme=fichier->getNomFichier();
//printf("Analyse de:%s, type:%d,reptmp:%s*\n",(const char*)programme,type,repconv);		
	if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
	{
		if(programme.right(7)==".tar.gz")
			programme.truncate(programme.length()-7);
		else if(programme.right(8)==".tar.bz2")
			programme.truncate(programme.length()-8);
		else if(programme.right(4)==".tar")
			programme.truncate(programme.length()-4);
	}
	else if(strcmp(fichier->getProgrCompresseur(),"gzip")==0)
		programme.truncate(programme.length()-3);
	else if(strcmp(fichier->getProgrCompresseur(),"bzip2")==0)
		programme.truncate(programme.length()-4);
	else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
		programme.truncate(programme.length()-4);
		
	switch(type)
	{
		case 0:
			programme+=".tar";
			break;
		case 1:
			programme+=".tar.gz";
			break;
		case 2:
			programme+=".tar.bz2";
			break;
		case 3:
			programme+=".zip";
			break;
		case 4:
			programme+=".gz";
			break;
		case 5:
			programme+=".bz2";
			break;
	}				
	
	nomarchive=programme;
	nomarchive=nomarchive.right(nomarchive.length()-nomarchive.findRev('/'));
//printf("Nomarchive:%s*\n",(const char*)nomarchive);

	nomarchive=repconv+nomarchive;
							
	operation=-2;
	fichier->setNomArchive(nomarchive);

	if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
	{
		if(strcmp((const char*)nomarchive.right(3),".gz")==0)
		{
			typeCompresseur=GZIP;
			nomarchive=nomarchive.left(nomarchive.length()-3);
		}
		if(strcmp((const char*)nomarchive.right(4),".bz2")==0)
		{
			typeCompresseur=BZIP2;
			nomarchive=nomarchive.left(nomarchive.length()-4);
		}
		creerArchiveTar(nomarchive,listeKDE,(const char*)reptmp);
		if(typeCompresseur==GZIP)
		{
			compresserArchiveCree("gzip",(const char*)nomarchive);
		}
		else if(typeCompresseur==BZIP2)
		{
			compresserArchiveCree("bzip2",(const char*)nomarchive);
		}
		afficheArchiveListe();
	}
	else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
	{
		typeCompresseur=UNZIP;
		creerArchiveZip(nomarchive,listeKDE,(const char*)reptmp);
	}
	else
	{
  	programme=programme.left(programme.findRev('.'));
		programme=programme.right(programme.length()-programme.findRev('/')-1);
		programme=reptmp+programme;

		toto->clearArguments();
		const char* pr;
		char* ext;
		if(nomarchive.right(3)==".gz")
		{
			typeCompresseur=GZIP;
			pr="gzip";
			ext=".gz";
		}
		else if(nomarchive.right(4)==".bz2")
		{
			typeCompresseur=BZIP2;
			pr="bzip2";
			ext=".bz2";
		}
		else
		{
	  	QMessageBox::warning( this, "karchiveur",
			i18n("Files can be added only in\n"
			".tar, .tar.gz, .tar.bz2") );
			led->setColor(KLed::green);
			return;
		}			
		*toto << pr;
		*toto << "-f";
		*toto << (const char*)programme;
		toto->start(KProcess::Block);
		toto->clearArguments();
		pr="mv";
		*toto << pr;
		programme+=ext;
		*toto << (const char*)programme;
		*toto << (const char*)nomarchive;
		toto->start(KProcess::Block);			
	}
	s.sprintf("%s: %s ?",i18n("Delete"),(const char*)archiveOriginale);
	if(KMsgBox::yesNo(this,"karchiveur",s)==1)
	{
		toto->clearArguments();
		*toto << "rm" << "-f" <<(const char*)archiveOriginale;
		toto->start(KProcess::Block);
	}
	led->setColor(KLed::green);	
}

/** Open an archive from ftp or http */
void KarchiveurApp::ouvreRessourceReseau(const char* nom)
{

  QString string;
  QString tmpFile;
  QString netFile = nom;
  netFile.detach();

  led->setColor(KLed::red);

    if ( kfm != 0L )
    {
			QMessageBox::information(
				 this,
				 i18n("Sorry"),
				 i18n("Download in progress"),
				 i18n("OK"),
				 "",
				 "",
				 0,0);
			return;
    }
    slotStatusMsg(i18n("Calling KFM"));

    kfm = new KFM;

    if ( !kfm->isOK() )
    {
			QMessageBox::warning(
			     this,
			     i18n("Sorry"),
			     i18n("Could not start or find KFM"),
			     i18n("OK"),
			     "",
			     "",
			     0,0);
			delete kfm;
			kfm = 0L;
			return;
    }

    tmpFile=netFile;
    tmpFile=tmpFile.right(tmpFile.length()-tmpFile.findRev('/'));
    if(tmpFile.left(1)=="/")
    	tmpFile=tmpFile.remove(0,1);
    tmpFile=reptmp+tmpFile;
		fichier->setNomArchive(tmpFile);
    connect( kfm, SIGNAL( finished() ), this, SLOT( slotKFMFinished() ) );
    slotStatusMsg(i18n("Connected"));
    kfm->copy( netFile.data(), tmpFile.data() );
    slotStatusMsg(i18n("Waiting..."));
}

void KarchiveurApp::slotKFMFinished()
{
	QString fich;
	QString str;
	QStrList strliste;

	
	fich=fichier->getNomFichier();

	strliste.append(fich);
	
	fichier->setCheminAcces(reptmp, optionOuverture);
	navigateur->setChemin(fichier->getCheminAcces());	

	if(operation!=-1)
	{
		//Un fichier archive est dj charg
		QString archive;

		archive=fichier->getNomFichier();
		if(typeCompresseur==TAR)
		{
			operation=AJOUT;
			ajoutArchive(archive,strliste,FALSE,0,(const char*)reptmp);
		}
		else if(typeCompresseur==UNZIP)
		{
			operation=AJOUT;
			ajoutArchive(archive,strliste,FALSE,0,(const char*)reptmp);
		}
		else
		{
    QMessageBox::warning( this, "karchiveur",
			i18n("Files can be added only in\n"
			".tar, .tar.gz, .tar.bz2") );
			led->setColor(KLed::orange);
			return;
		}
	}
	else
	{
		led->setColor(KLed::red);

		if(fichier->IdentifieCompresseur()==0)
		{
	    afficheArchiveListe();
	    led->setColor(KLed::orange);
			return;
		}
		KFileDialog boiteSauver(NULL);
		boiteSauver.setName(i18n("Create archive"));
		QString nomarchive=boiteSauver.getSaveFileName();
		if(nomarchive.isEmpty())
		{
			led->setColor(KLed::green);
			return;
		}
		fichier->setNomArchive(nomarchive);
		cheminOuverture=fichier->getCheminAcces();
		navigateur->setChemin(cheminOuverture);
		if(fichier->IdentifieCompresseur()==1)
		{
			slotStatusMsg(i18n("Unknown archive type"));
			led->setColor(KLed::orange);
			return;
		}
///		operation=AJOUTCREATION;
		if(strcmp(fichier->getProgrCompresseur(),"tar")==0)
		{
			avancement.ajoute(0);
			avancement.setTexte(i18n("Creating archive"));
			avancement.setLongueurProgress(1);
			if((strcmp((const char*)nomarchive.right(3),".gz")==0)||((strcmp((const char*)nomarchive.right(3),".tgz")==0)))
			{
				typeCompresseur=GZIP;
				nomarchive=nomarchive.left(nomarchive.length()-3);
				avancement.setLongueurProgress(2);
			}
			if(strcmp((const char*)nomarchive.right(4),".bz2")==0)
			{
				typeCompresseur=BZIP2;
				nomarchive=nomarchive.left(nomarchive.length()-4);
				avancement.setLongueurProgress(2);
			}
			creerArchiveTar(nomarchive,strliste,(const char*)reptmp);
			avancement.ajoute(1);
			if(typeCompresseur==GZIP)
			{
				compresserArchiveCree("gzip",(const char*)nomarchive);
        avancement.ajoute(1);
			}
			if(typeCompresseur==BZIP2)
			{
				compresserArchiveCree("bzip2",(const char*)nomarchive);
				avancement.ajoute(1);
			}
			operation=AJOUTCREATION;
			afficheArchiveListe();
		}
		else if(strcmp(fichier->getProgrCompresseur(),"unzip")==0)
		{
			creerArchiveZip(nomarchive,strliste);
			afficheArchiveListe();
		}
		else if((strcmp(fichier->getProgrCompresseur(),"gzip")==0)&&(strliste.count()==1))
		{
			fichierIO=fopen((const char*)nomarchive,"w");
			typeCompresseur=GZIP;
			toto->clearArguments();
			*toto << "gzip" << "-c" << (const char*)str;
			toto->start(KProcess::NotifyOnExit, KProcess::Stdout);
		}
		else if((strcmp(fichier->getProgrCompresseur(),"bzip2")==0)&&(strliste.count()==1))
		{
			fichierIO=fopen((const char*)nomarchive,"w");
			typeCompresseur=BZIP2;
			toto->clearArguments();
			*toto << "bzip2" << "-c" << (const char*)str;
			toto->start(KProcess::NotifyOnExit, KProcess::Stdout);
		}
		else
		{
			led->setColor(KLed::green);
	    QMessageBox::warning( this, "karchiveur",
				i18n("Files can be added only in\n"
				".tar, .tar.gz, .tar.bz2") );
			led->setColor(KLed::orange);
			return;
		}
		led->setColor(KLed::green);
	}
}

/** Probe if we are cutting or uncutting */
void KarchiveurApp::faitCuttUnCutt(QString nom)
{
	led->setColor(KLed::red);
	
	cuttFichier objCoupe;
	QString str;

	if(nom.right(3)==".01")
	{
		nom=nom.left(nom.length()-3);
		if(objCoupe.Debut((const char*)nom,1)==0)
		{
			operation=-1;
			fichier->setNomArchive(nom);
			afficheArchiveListe();
		}
	}
	else
	{
		str=fichier->getNomFichier();
		str=str.right(str.length()-str.findRev('/')-1);
		if(nom.right(1)!="/")
			nom+="/";
		str=nom+str;	
printf("*%s*%s*\n",(const char*)nom,(const char*)str);		
		objCoupe.Debut((const char*)str,0,(const char*)fichier->getNomFichier());
		
		nom.sprintf("%s %s%s",i18n("archive splitted in"),fichier->getNomFichier(),".01...");
		KMsgBox::message(this,i18n("kArchiveur"),nom);	
	}
	led->setColor(KLed::green);
}
