#ifndef __THEME_H__
#define __THEME_H__

#include <qstring.h>

#include <kconfig.h>

#include "theme_exceptions.h"


/**
 * The Theme class provides the necessary framework for dealing with KDE themes.
 *
 * It is not designed to be self-sufficient, but rather to be used by an
 * interface.  Any application that needs to deal with KDE themes should
 * utilize the Theme class to ensure future compatibility.
 *
 * @short Provides the necessary framework for dealing with KDE themes.
 * @author The KDE Theme Team
 * @version 0.1
 */
class Theme {
public:
    static const QString LOCAL_THEMES_DIR;
    static const QString GLOBAL_THEMES_DIR;

    /**
     * Installs a theme package.
     *
     * @return The name of the theme that is installed.
     * @param fileName  The absolute path of the theme package to install.
     * @param globalInstall  If true installs as a global system theme
     *                       (available for all to use).
     */
    static const QString install(const QString &fileName, bool globalInstall);

    /**
     * Activates an installed theme.
     *
     * @param themeName  The name of the theme to activate.
     * @param isGlobal  If true, the theme is retreived from the global dir,
     *                  otherwise from the local dir.
     */
    static void activate(const QString &themeName, bool isGlobal);

protected:
    /**
     * Changes a sound event in a config file.
     * 
     * @return True if entry is found, otherwise false.
     * @param themeConfig  The config file to read from.
     * @param soundConfig  The config file to write to.
     * @param soundName  The name of the sound events.
     * @param themeName  The name of the theme.
     * @param isGlobal  True of theme is global.
     */
    static bool changeSound(KConfig *themeConfig, KConfig *soundConfig,
                            const QString &soundName, const QString &themeName,
			    bool isGlobal);

    /**
     * Changes a sound event in a config file.
     * 
     * @return True if entry is found, otherwise false.
     * @param themeConfig  The config file to read from.
     * @param displayConfig  The config file to write to.
     * @param displayName  The name of the display...
     * @param themeName  The name of the theme.
     * @param isGlobal  True of theme is global.
     */
    static bool changeDesktop(KConfig *themeConfig, KConfig *displayConfig,
			      const QString &displayName, const QString &themeName,
			      bool isGlobal);

    /**
     * Changes a colour scheme in a config file.
     * 
     * @return True if entry is found, otherwise false.
     * @param themeConfig  The config file to read from.
     * @param colorName  The name of the color scheme.
     * @param entry Under which entry in .kderc
     */
    static bool changeColor(KConfig *themeConfig, const QString &colorName,
                            const char *entry);
};


#endif // __THEME_H__
