#include "ktheme.h"

class KThemeApp : public KControlApplication {
public:
    KThemeApp(int &argc, char **argv, const char *name);

    virtual void init() { }; 
    virtual void apply();

private:
    KTheme *ktheme;
};


KThemeApp::KThemeApp(int &argc, char **argv, const char *name)
    : KControlApplication(argc, argv, name)
{
    ktheme = 0;

    if (runGUI()) {
	if (!pages || pages->contains("ktheme")) {
	    addPage(ktheme = new KTheme(dialog, "ktheme"),
	                                  i18n("&Theme Settings"),
					  "index.html");
	}

	if (ktheme)
	    dialog->show();
	else {
	    fprintf(stderr, i18n("Usage: ktheme [-init | ktheme]\n"));
	    justInit = TRUE;
	}
    }
}


void KThemeApp::apply()
{
    if (ktheme)
	ktheme->applySettings();
}

int main (int argc, char **argv)
{
    KThemeApp app(argc, argv, "ktheme");

    app.setTitle(i18n("Theme Settings"));

    if (app.runGUI())
	return app.exec();
    else
	return(0);
}
