// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//



#ifndef KROT_JAROT_H
#define KROT_JAROT_H



#include "transition.h"

#include <map>
#include <vector>



class CalculationParameter;
typedef class map< QNum, double > mapAssignment;



/**
 * Interface function to jarot.
 *
 * @param param  On input takes the start parameter for the calculation, on
 *               output contains the final parameters.
 * @param lines  Provide an empty vector to fill up with calculated lines.
 * @param asn    Assignments to use for fits. For simulations this might be empty.
 * @return       Success status
 */
extern bool jarot( const CalculationParameter& param, vector< Transition >& lines,
		   const mapAssignment& asn = mapAssignment() );



#include "jarot_inline.h"



#endif
