/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> MN_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"


float IAR_version ;

short JB_stat ;
double JB_ergfactor, JB_itnfactor, JB_fsr ;

FILE *Log_fp ;

short Err ;
short Im_stat ;

char Mol_nm[ CMT_LEN ], Out_flnm[ FLNM_LEN ], Cg_flnm[ FLNM_LEN ] ;
char See_flnm[ ST_NO ][ FLNM_LEN ], Sqn_flnm[ ST_NO ][ FLNM_LEN ], Sdv_flnm[ ST_NO ][ FLNM_LEN ] ;
char Sevr_flnm[ ST_NO ][ FLNM_LEN ], Sevi_flnm[ ST_NO ][ FLNM_LEN ] ;
char St_str[ ST_NO ][ FLNM_LEN ] ;

char Rc_str[ ST_NOPARORI ][ FLNM_LEN ] ;
short Rc_stat[ ST_NO ][ ST_NOPARORI ], Tp_stat[ ST_NO ][ ST_NOPARORI ] ;
double Rc[ ST_NO ][ ST_NOPARORI ], Tp[ ST_NO ][ ST_NOPARORI ], Rc_sd[ ST_NO ][ ST_NOPARORI ] ;

double Hp_mat[ ST_NO ][ 3 ][ 3 ] ;
double The_dc[ ST_NO ], Phi_dc[ ST_NO ], Chi_dc[ ST_NO ] ;
double HamRot_mat[ ST_NO ][ 3 ][ 3 ] ;

long *Aqn_vec ;
double *Aerg_vec ;
double *Erg_vec[ ST_NO ] ;

int Se_fd, Ee_fd, Si_fd, Bt_fd, Jk_fd, Dv_fd, Lf_fd ;




short RdInputPara( char *in_flnm ) ;
short WtInputPara( char *out_flnm ) ;
void DefDftPara( void ) ;
short CgChkFile( void ) ;
short RdAsnLines( void ) ;
short Ham2Trs( void ) ;
short TrsConvert( char *out_flnm ) ;
short PrntTrs( char *out_flnm ) ;
void SimTrans( int st ) ;
short RHamSoln( int st ) ;
short IHamSoln( int st ) ;
short RTrsCalc( void ) ;
short ITrsCalc( void ) ;
short LsfTrs( void ) ;
void LFree1Dim( long **ptpt ) ;
void DFree1Dim( double **ptpt ) ;
void ProgExit( short com_stat, int ascii_stat ) ;







/*MAINLINE START-UP*/
int main( int argc, char *argv[] )
{
   short lsf_stat ;
   char in_flnm[ FLNM_LEN ] ;


/*SET PROGRAM DEFAULT VALUES*/
   DefDftPara() ;


/*CHECK IF INPUT FILE IS NOT A COMMAND LINE ARGUMENT - WITH VERSION NUMBER 1.0 PRESENT, PROMPT FOR INPUT FILENAME*/
   if( argc == 1 || (argc == 2 && !strcmp( argv[ 1 ], "1.0" )) )
      {

   /*IAR OLD VERSION NUMBER*/
      if( argc == 2 && !strcmp( argv[ 1 ], "1.0" ) )
         IAR_version = 1.0 ;

   /*IAR DEFAULT VERSION NUMBER*/
      else
         IAR_version = 2.0 ;

   /*INFORM USER OF IAR VERSION NUMBER*/
      printf( "IAR VERSION %.1f\n", IAR_version ) ;

   /*PROMPT FOR INPUT FILENAME*/
      printf( "INPUT FILENAME ? " ) ;
      scanf( "%s", in_flnm ) ;
      if( RdInputPara( in_flnm ) == E_RT_UNK )
         {
         printf( "BAD INPUT FILENAME OR INPUT FILE FORMAT !\n" ) ;
         ProgExit( E_RT_UNK, 1 ) ;
         }
      }

/*USE FIRST COMMAND LINE ARGUMENT AS THE INPUT FILENAME*/
   else if( argc == 2 || argc == 3 )
      {

   /*CHECK SECOND COMMAND LINE PARAMETER FOR VERSION NUMBER*/
      if( argc == 3 && !strcmp( argv[ 1 ], "1.0" ) )
         {
         IAR_version = 1.0 ;
         strcpy( in_flnm, *(argv + 2) ) ;
         }

   /*IAR DEFAULT VERSION NUMBER*/
      else
         {
         IAR_version = 2.0 ;
         strcpy( in_flnm, *(argv + 1) ) ;
         }

   /*INFORM USER OF IAR VERSION NUMBER*/
      printf( "IAR VERSION %.1f\n", IAR_version ) ;

   /*READ INPUT PARAMTERS*/
      if( RdInputPara( in_flnm ) == E_RT_UNK )
         ProgExit( E_RT_UNK, 1 ) ;
      }

/*EXIT PROGRAM ON ALL OTHER CONDITIONS - NOT REDIRECTED INPUT*/
   else 
      {
      printf( "WRONG USAGE: RUN iar ONLY !\n" ) ;
      ProgExit( E_RT_UNK, 1 ) ;
      }



/*CHECK CLEBSCH GORDAN FILE -> CREATE NEW ONE IF DOES NOT EXIST OR J MAX EXCEEDED*/
   if( CgChkFile() == -1 )
      ProgExit( E_RT_UNK, 1 ) ;


/*READ INPUT PARAMETERS*/
   if( RdAsnLines() == -1 )
      ProgExit( E_RT_UNK, 1 ) ;



/*GENERATE LINESET ONLY BASED ON INPUT PARAMETERS ONLY*/
   if( Lsf_ecycs <= 0 )
      {

   /*LOG EXACT CALCULATION*/
      fprintf( Log_fp, "\n\n========================================" ) ;
      fprintf( Log_fp, "========================================\n" ) ;
      fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXACT ENERGY PHASE " ) ;
      fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
      fprintf( Log_fp, "========================================" ) ;
      fprintf( Log_fp, "========================================\n" ) ;
      fflush( Log_fp ) ;


   /*FILL AND DIAGONALIZE HAMILTONIAN MATRIX AND CALCULATE TRANSITION ENERGIES AND DERIVATIVES*/
      if( Ham2Trs() == E_RT_UNK )
         ProgExit( E_RT_UNK, 1 ) ;

   /*CONVERT INFORMATION TO A FORMAT FOR INPUT TO JB*/
      if( TrsConvert( Out_flnm ) == E_RT_UNK )
         ProgExit( E_RT_UNK, 1 ) ;
      }


/*PERFORM LEAST SQUARES ANALYSIS AND GENERATE LINESET BASED ON BEST FIT PARAMETERS*/
   else
      {

   /*LOG LSF ANALYSIS*/
      fprintf( Log_fp, "\n\n\n========================================" ) ;
      fprintf( Log_fp, "========================================\n" ) ;
      fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>> LINEAR LEAST SQUARES PHASE " ) ;
      fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
      fprintf( Log_fp, "========================================" ) ;
      fprintf( Log_fp, "========================================\n\n" ) ;
      fflush( Log_fp ) ;


   /*NOT ENOUGH OBSERVED LINES FOR LEAST SQUARES ANALYSIS*/
      if( Asn_nolvs < Lsf_noprm )
         {

      /*LOG ERROR MESSAGE*/
         fprintf( Log_fp, "\n# OF ASSIGNED LINES [%ld] MUST BE >= ", Asn_nolvs ) ;
         fprintf( Log_fp, "# OF PARAMETERS TO FIT [%hd] !\n", Lsf_noprm ) ;
         ProgExit( E_RT_NOL, 1 ) ;
         }


   /*LEAST SQUARES ANALYSIS ROUTINE CALLS PHASES AS NEEDED*/
      else if( (lsf_stat = LsfTrs()) == S_RT_FIN )
         {

      /*GENERATE LINESET BASED ON OLD DERIVATIVES AND NEW CONSTANTS*/
         if( TrsConvert( Out_flnm ) == E_RT_UNK )
            ProgExit( E_RT_UNK, 1 ) ;
         }

   /*ERROR IN LEAST SQUARES ROUTINE*/
      else
         ProgExit( lsf_stat, 1 ) ;
      }


/*FREE GLOBAL SPACE*/
   LFree1Dim( &Aqn_vec ) ;
   DFree1Dim( &Aerg_vec ) ;

   fprintf( Log_fp, "========================================" ) ;
   fprintf( Log_fp, "========================================\n\n" ) ;


/*WRITE OUT TRANSITION BAND TYPE, QN'S, INTENSITIES, OBSERVED AND CALCULATED FREQUENCIES IN ASCII FORM*/
   PrntTrs( Out_flnm ) ;

/*WRITE OUT NEW INPUT FILE FOR IAR VERSION 2.0*/
   WtInputPara( Out_flnm ) ;


/*SUCCESSFUL PROGRAM RUN*/
   ProgExit( S_RT_FIN, argc ) ;

   return( 1 );
}









/*FILL HAMILTONINIAN MATRIX, DIAGONALIZE AND CALCULATE TRANSITIONS*/
short Ham2Trs()
{

/*FOR HAMILTONIAN ROTATION, SAVE PRINCIPAL AXIS VALUES FOR ERROR OR LEAST-SQUARES ANALYSIS*/
   Tp[ GND ][ A ] = Rc[ GND ][ A ] ;
   Tp[ GND ][ B ] = Rc[ GND ][ B ] ;
   Tp[ GND ][ C ] = Rc[ GND ][ C ] ;
   Tp[ EXE ][ A ] = Rc[ EXE ][ A ] ;
   Tp[ EXE ][ B ] = Rc[ EXE ][ B ] ;
   Tp[ EXE ][ C ] = Rc[ EXE ][ C ] ;

/*ROTATION OF HAMILTONIAN -> CALCULATE NEW HAMILTONIAN PARAMETERS*/
   SimTrans( GND ) ;
   SimTrans( EXE ) ;

/*LOG PHASE I*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>> GROUND STATE PHASE I " ) ;
   fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n\n" ) ;

/*REAL ELEMENTS -> SOLN TO EIGENVALUE PROBLEM FOR GROUND STATE IN THE SPHERICAL HARMONIC BASIS*/
   if( !Im_stat )
      {
      if( RHamSoln( (int)GND ) == -1 )
         return( E_RT_UNK ) ;
      }

/*IMAGINARY ELEMENTS -> SOLN TO EIGENVALUE PROBLEM FOR GROUND STATE IN THE SPHERICAL HARMONIC BASIS*/
   else
      {
      if( IHamSoln( (int)GND ) == -1 )
         return( E_RT_UNK ) ;
      }

/*LOG PHASE I*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>>>> EXCITED STATE PHASE I " ) ;
   fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n\n" ) ;

/*REAL ELEMENTS -> SOLN TO EIGENVALUE PROBLEM FOR EXCITED STATE IN THE SPHERICAL HARMONIC BASIS*/
   if( !Im_stat )
      {
      if( RHamSoln( (int)EXE ) == -1 )
         return( E_RT_UNK ) ;
      }

/*IMAGINARY ELEMENTS -> SOLN TO EIGENVALUE PROBLEM FOR EXCITED STATE IN THE SPHERICAL HARMONIC BASIS*/
   else
      {
      if( IHamSoln( (int)EXE ) == -1 )
          return( E_RT_UNK ) ;
      }

/*LOG PHASE II*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> PHASE II " ) ;
   fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fflush( Log_fp ) ;


/*REAL ELEMENTS -> CALCULATE TRANSITION ENERGIES AND INTENSITIES*/
   if( !Im_stat )
      {
      if( RTrsCalc() == -1 )
         return( E_RT_UNK ) ;
      }

/*IMAGINARY ELEMENTS -> CALCULATE TRANSITION ENERGIES AND INTENSITIES*/
   else
      {
      if( ITrsCalc() == -1 )
         return( E_RT_UNK ) ;
      }


/*XY ROTATION -> RESTORE PRINCIPAL VALUES FOR LEAST SQUARES FIT -> DERIVATIVES IN PRINCIPAL FRAME*/
   if( Tp_stat[ GND ][ PXPY ] )
      {
      Rc[ GND ][ B ] = Tp[ GND ][ B ] ;
      Rc[ GND ][ C ] = Tp[ GND ][ C ] ;
      Rc[ GND ][ PXPY ] = 0.0 ;
      }

   if( Tp_stat[ EXE ][ PXPY ] )
      {
      Rc[ EXE ][ B ] = Tp[ EXE ][ B ] ;
      Rc[ EXE ][ C ] = Tp[ EXE ][ C ] ;
      Rc[ EXE ][ PXPY ] = 0.0 ;
      }

/*XZ ROTATION -> RESTORE PRINCIPAL VALUES FOR LEAST SQUARES FIT -> DERIVATIVES IN PRINCIPAL FRAME*/
   if( Tp_stat[ GND ][ PXPZ ] )
      {
      Rc[ GND ][ A ] = Tp[ GND ][ A ] ;
      Rc[ GND ][ B ] = Tp[ GND ][ B ] ;
      Rc[ GND ][ PXPZ ] = 0.0 ;
      }

   if( Tp_stat[ EXE ][ PXPZ ] )
      {
      Rc[ EXE ][ A ] = Tp[ EXE ][ A ] ;
      Rc[ EXE ][ B ] = Tp[ EXE ][ B ] ;
      Rc[ EXE ][ PXPZ ] = 0.0 ;
      }

/*YZ ROTATION -> RESTORE PRINCIPAL VALUES FOR LEAST SQUARES FIT -> DERIVATIVES IN PRINCIPAL FRAME*/
   if( Tp_stat[ GND ][ PYPZ ] )
      {
      Rc[ GND ][ A ] = Tp[ GND ][ A ] ;
      Rc[ GND ][ C ] = Tp[ GND ][ C ] ;
      Rc[ GND ][ PYPZ ] = 0.0 ;
      }

   if( Tp_stat[ EXE ][ PYPZ ] )
      {
      Rc[ EXE ][ A ] = Tp[ EXE ][ A ] ;
      Rc[ EXE ][ C ] = Tp[ EXE ][ C ] ;
      Rc[ EXE ][ PYPZ ] = 0.0 ;
      }

/*RETURN SUCCESS*/
   return( S_RT_FIN ) ;
}









/*SET PROGRAM DEFAULT VALUES*/
void DefDftPara()
{

/*DEFINE STRINGS FOR PARAMETER*/
   strcpy( St_str[ GND ], "GROUND" ) ;
   strcpy( St_str[ EXE ], "EXCITED" ) ;
   strcpy( Rc_str[ A ], "A   " ) ;
   strcpy( Rc_str[ B ], "B   " ) ;
   strcpy( Rc_str[ C ], "C   " ) ;
   strcpy( Rc_str[ PX ], "PX  " ) ;
   strcpy( Rc_str[ PY ], "PY  " ) ;
   strcpy( Rc_str[ PZ ], "PZ  " ) ;
   strcpy( Rc_str[ PXPY ], "PXPY" ) ;
   strcpy( Rc_str[ PXPZ ], "PXPZ" ) ;
   strcpy( Rc_str[ PYPZ ], "PYPZ" ) ;
   strcpy( Rc_str[ DK ], "DK  " ) ;
   strcpy( Rc_str[ DJK ], "DJK " ) ;
   strcpy( Rc_str[ DJ ], "DJ  " ) ;
   strcpy( Rc_str[ dK ], "dK  " ) ;
   strcpy( Rc_str[ dJ ], "dJ  " ) ;
   strcpy( Rc_str[ PZ3 ], "PZ3 " ) ;
   strcpy( Rc_str[ ORI ], "ORI " ) ;

/*DEFINE BAND TYPES*/
   Band_chr[ 0 ] = (char)'N' ;
   Band_chr[ 1 ] = (char)'A' ;
   Band_chr[ 2 ] = (char)'B' ;
   Band_chr[ 3 ] = (char)'C' ;
   Band_chr[ 4 ] = (char)'D' ;
   Band_chr[ 5 ] = (char)'Z' ;
   Band_chr[ 6 ] = (char)'Y' ;
   Band_chr[ 7 ] = (char)'X' ;

/*WRITE A LEAST ONE AMPLITUDE -> ACTUALLY INTENSITY*/
   Amp_no = 1 ;

/*ASSIGN FIT STATUS OF A, B AND C PARAMETERS AND ORIGIN TO ONE FOR LEAST SQUARES ANALYSIS*/
   Rc_stat[ GND ][ A ] = Rc_stat[ GND ][ B ] = Rc_stat[ GND ][ C ] = 1 ;
   Rc_stat[ EXE ][ A ] = Rc_stat[ EXE ][ B ] = Rc_stat[ EXE ][ C ] = 1 ;
   Rc_stat[ EXE ][ ORI ] = 1 ;

/*INITIALIZE DERIVATIVE COUNT VARIABLE -> DERIVATIVES OF A, B AND C ALWAYS NECESSARY*/
   St_nodv[ GND ] = 0 ;
   St_nodv[ EXE ] = 0 ;

/*INITIALIZE IMAGINARY ELEMENT STATUS*/
   Im_stat = 0 ;

/*INITIALIZE LINESET WRITE STAT TO WRITE LINESET IN PHASE II*/
   Lsflc_stat = 1 ;
}









/*WRITE FILE CONTAINING NEW PARAMETERS AND STANDARD DEVIATIONS*/
void ProgExit( short com_stat, int ascii_stat )
{
   int par_fd ;
   char par_flnm[ FLNM_LEN ] ;
   long cnt ;


/*MAKE PARAMETER FILENAME*/
   strcpy( par_flnm, Out_flnm ) ;
   strcat( par_flnm, ".p" ) ;

/*OPEN FILE TO PASS NEW PARAMETERS TO JB PROG*/
   if( (par_fd = open( par_flnm, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666)) == -1 )
      {
      printf( "CAN'T CREATE %s FILE !\n", par_flnm ) ;
      exit( 0 ) ;
      }

/*WRITE COMPLETION STATUS INDICATOR*/
   write( par_fd, (char *)&com_stat, sizeof( short ) ) ;

/*WRITE PARAMETERS WHEN SUCCESSFUL RUN*/
   if( com_stat == S_RT_FIN )
      {

   /*WRITE GROUND STATE PARAMETER STATUS, PARAMETER AND STANDARD DEVIATIONS*/
      for( cnt = 0; cnt < ST_NOPAR; cnt++ )
         {
         write( par_fd, (char *)(Rc_stat[ GND ] + cnt), sizeof( short ) ) ;
         write( par_fd, (char *)(Rc[ GND ] + cnt), sizeof( double ) ) ;
         write( par_fd, (char *)(Rc_sd[ GND ] + cnt), sizeof( double ) ) ;
         }

   /*WRITE EXCITED STATE PARAMETER STATUS, PARAMETER AND STANDARD DEVIATIONS*/
      for( cnt = 0; cnt < ST_NOPAR; cnt++ )
         {
         write( par_fd, (char *)(Rc_stat[ EXE ] + cnt), sizeof( short ) ) ;
         write( par_fd, (char *)(Rc[ EXE ] + cnt), sizeof( double ) ) ;
         write( par_fd, (char *)(Rc_sd[ EXE ] + cnt), sizeof( double ) ) ;
         }

   /*WRITE BAND ORIGIN STATUS, PARAMETER AND STANDARD DEVIATION*/
      write( par_fd, (char *)(Rc_stat[ EXE ] + ST_NOPAR), sizeof( short ) ) ;
      write( par_fd, (char *)(Rc[ EXE ] + ST_NOPAR), sizeof( double ) ) ;
      write( par_fd, (char *)(Rc_sd[ EXE ] + ST_NOPAR), sizeof( double ) ) ;


   /*WRITE # OF ASSIGNED LEVELS ACCEPTED AND OMC STANDARD DEVIATION*/
      write( par_fd, (char *)&Trs_nolvs, sizeof( long ) ) ;
      write( par_fd, (char *)&Acp_nolvs, sizeof( long ) ) ;
      write( par_fd, (char *)&Omc_stdv, sizeof( float ) ) ;
      }

/*CLOSE FILE*/
   close( par_fd ) ;


/*REMOVE PHASE I FILES*/
   unlink( See_flnm[ GND ] ) ;
   unlink( Sqn_flnm[ GND ] ) ;
   unlink( Sdv_flnm[ GND ] ) ;
   unlink( Sevr_flnm[ GND ] ) ;
   unlink( "CG" ) ;

/*MICROWAVE - SAME AS GND STATE FILES - FOR MW/UV FITS, EXCITED STATE FILES FROM UV FIT SURVIVE - RENAMED*/
   if( Rc[ EXE ][ ORI ] )
      {
      unlink( See_flnm[ EXE ] ) ;
      unlink( Sqn_flnm[ EXE ] ) ;
      unlink( Sdv_flnm[ EXE ] ) ;
      unlink( Sevr_flnm[ EXE ] ) ;
      }

/*REMOVE IMAGINARY VECTORS*/
   if( Im_stat )
      {
      unlink( Sevi_flnm[ GND ] ) ;

   /*MICROWAVE - SAME AS GND STATE FILES - FOR MW/UV FITS, EXCITED STATE FILES FROM UV FIT SURVIVE - RENAMED*/
      if( Rc[ EXE ][ ORI ] )
         unlink( Sevi_flnm[ EXE ] ) ;
      }

/*REMOVE PHASE III & IV FILES*/
   unlink( "IAR.se" ) ;
   unlink( "IAR.lf" ) ;

/*DO NOT SAVE PHASE II AND III FILES -> OTHERWISE (0) SAVE FILES TO RUN DERIVATIVE APPROXIMATION*/
   if( Lsf_ecycs )
      {

   /*REMOVE PHASE III FILES*/
      unlink( "IAR.ee" ) ;
      unlink( "IAR.si" ) ;
      unlink( "IAR.bt" ) ;
      unlink( "IAR.jk" ) ;

   /*REMOVE PHASE IV FILE*/
      unlink( "IAR.dv" ) ;
      unlink( "IAR.re" ) ;
      }

/*CLOSE LOG FILE*/
   fclose( Log_fp ) ;

/*PROGRAM RUN WITHOUT COMMAND LINE ARGUMENTS - REMOVE ALL BINARY FILES BUT KEEP ASCII FILES*/
   if( ascii_stat == 1 || (IAR_version == 1.0 && ascii_stat == 2) )
      {
      unlink( par_flnm ) ;
      strcpy( par_flnm, Out_flnm ) ;
      strcat( par_flnm, ".f" ) ;
      unlink( par_flnm ) ;
      strcpy( par_flnm, Out_flnm ) ;
      strcat( par_flnm, ".m" ) ;
      unlink( par_flnm ) ;
      strcpy( par_flnm, Out_flnm ) ;
      strcat( par_flnm, ".q" ) ;
      unlink( par_flnm ) ;
      if( com_stat != S_RT_FIN )
         printf( "PROGRAM TERMINATED ABNORMALLY => CHECK INPUT AND LOG FILE !\n" ) ;
      }

/*EXIT PROGRAM*/
   exit( 0 ) ;
}
