/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> IO_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"


char Band_chr[ FLNM_LEN ], Band_str[ FLNM_LEN ] ;
char Parity_str[ FLNM_LEN ], ParKa_str[ FLNM_LEN ], ParKc_str[ FLNM_LEN ] ;
short Band_type, A_type, B_type, C_type ;
short Amp_stat, Amp_no ;

long J_max, Dk_order ;
short TM_method, TM_frame ;
double A_prj, B_prj, C_prj ;
double TM_ori[ 3 ], TM_prj[ 3 ], Tm_ang ;
short Ka_parity, Kc_parity, Parity_stat ;

char Asn_flnm[ FLNM_LEN ] ;
long Asn_jmax, Asn_kmax ;
long Asn_nolvs, Acp_nolvs, Rej_nolvs ;

long Trs_nolvs ;
double Kap[ ST_NO ] ;
short St_nodv[ ST_NO ] ;
double Temp, Itn_cut ;

short Lsf_noprm, Lsf_stat[ ST_NO ][ ST_NOPARORI ], Lsf_ecycs, Lsf_acycs, Lsflc_stat ;
float Omc_stdv ;
double Lsf_rejlv ;
long Prt_ee[ ST_NO ], Prt_ev[ ST_NO ] ;


short RdInputPara( char *in_flnm ) ;
short WtInputPara( char *out_flnm ) ;
void RdHamPara( int st, FILE *fp ) ;
void WtHamPara( int st, FILE *out_fp ) ;
char *InLine( FILE *fp, char *line, short arg_no ) ;
void EulerGenMat( double rot_mat[ 3 ][ 3 ], double phi, double the, double chi ) ;
short TransMomentOrient( short tm_method, short tm_frame, double tm_ori[ 3 ], double par_mat[ 3 ][ 3 ], double tm_prj[ 3 ] ) ;







/*READ INPUT PARAMETERS*/
short RdInputPara( char *in_flnm )
   {
   FILE *in_fp ;
   char tstr[ FLNM_LEN ], line_str[ CMT_LEN ] ;
   long cnt, cts, st ;


/*OPEN INPUT FILE*/
   if( (in_fp = fopen( in_flnm, "r" )) == NULL )
      return( E_RT_UNK ) ;


/*USE OLD IAR VERSION 1.0 INPUT FORMAT*/
   if( IAR_version == 1.0 )
      {

   /*READ COMMENT LINE*/
      fscanf( in_fp, "%s", Mol_nm ) ;
      fgets( Mol_nm + strlen( Mol_nm ), CMT_LEN - strlen( Mol_nm ) - 1, in_fp ) ;

   /*READ OUTPUT FILENAME*/
      fscanf( in_fp, "%s", Out_flnm ) ;

   /*READ ASSIGNMENT FILENAME*/
      fscanf( in_fp, "%s", Asn_flnm ) ;
   
   /*READ J AND K MAXIMUM TO CALCULATE*/
      fscanf( in_fp, "%ld%ld", &Asn_jmax, &Asn_kmax ) ;

   /*READ J MAX TO CALCULATE*/
      fscanf( in_fp, "%ld", &J_max ) ;

   /*READ AND CALCULATE GROUND STATE HAMILTONIAN PARAMETERS*/
      RdHamPara( GND, in_fp ) ;

   /*READ AND CALCULATE EXCITED STATE HAMILTONIAN PARAMETERS*/
      RdHamPara( EXE, in_fp ) ;

   /*READ IN ORIGIN ENERGY AND LEAST SQUARES FIT STATUS*/
      fscanf( in_fp, "%lf%hd", Rc[ EXE ] + ORI, Lsf_stat[ EXE ] + ORI ) ;

   /*READ BAND TYPE, DELTA K ORDER TO CALCULATE AND AMPLITUDE STATUS FLAG*/
      fscanf( in_fp, "%s%ld%hd", Band_str, &Dk_order, &Amp_stat ) ;

   /*TRANSITION MOMENT ORIENTATION WITH RESPECT TO A AXIS OR B AXIS*/
      fscanf( in_fp, "%lf", &Tm_ang ) ;


   /*USE TRANSITION MOMENT MAGNITUDE AND ANGLES METHOD RELATIVE TO GROUND STATE AXIS SYSTEM*/
      TM_method = 0 ;
      TM_frame = 0 ;
      TM_ori[ 0 ] = 1.0 ;

   /*A TYPE (PROLATE LIMIT)*/
      if( !strcmp( Band_str, "A" ) )
         {
         TM_ori[ 1 ] = 0.0 ;
         TM_ori[ 2 ] = 0.0 ;
         }

   /*B TYPE (PROLATE LIMIT)*/
      else if( !strcmp( Band_str, "B" ) )
         {
         TM_ori[ 1 ] = 90.0 ;
         TM_ori[ 2 ] = 0.0 ;
         }

   /*C TYPE (PROLATE LIMIT)*/
      else if( !strcmp( Band_str, "C" ) )
         {
         TM_ori[ 1 ] = 90.0 ;
         TM_ori[ 2 ] = 90.0 ;
         }

   /*HYBRID BAND -> AB TYPE (PROLATE LIMIT) -> TM MEASURED WITH RESPECT TO A AXIS*/
      else if( !strcmp( Band_str, "B/A" ) )
         {
         TM_ori[ 1 ] = Tm_ang ;
         TM_ori[ 2 ] = 0.0 ;
         }

   /*HYBRID BAND -> AC TYPE (PROLATE LIMIT) -> TM MEASURED WITH RESPECT TO A AXIS*/
      else if( !strcmp( Band_str, "C/A" ) )
         {
         TM_ori[ 1 ] = Tm_ang ;
         TM_ori[ 2 ] = 90.0 ;
         }

   /*HYBRID BAND -> BC TYPE (PROLATE LIMIT) -> TM MEASURED WITH RESPECT TO B AXIS*/
      else if( !strcmp( Band_str, "C/B" ) )
         {
         TM_ori[ 1 ] = 90.0 ;
         TM_ori[ 2 ] = Tm_ang ;
         }

   /*NO SUCH BAND TYPE - RETURN ERROR*/
      else
         {
         fprintf( Log_fp, "\nIMPROPER BAND TYPE %s !\n", Band_str ) ;
         return( E_RT_UNK ) ;
         }

   /*READ IN TEMPERATURE (KELVIN) AND INTENSITY CUTOFF*/
      fscanf( in_fp, "%lf%lf", &Temp, &Itn_cut ) ;

   /*ASSUME JB_STAT IS SET AND READ IN OLD FORMAT OF ENERGY SCALAR FACTOR AND FSR*/
      JB_stat = 1 ;
      JB_itnfactor = 100.0 ;
      fscanf( in_fp, "%lf%lf", &JB_ergfactor, &JB_fsr ) ;

   /*READ IN PARITY SELECTION RULE INDICATOR*/
      fscanf( in_fp, "%s", Parity_str ) ;

   /*READ IN GROUND KA TIMES EXCITED KA OVERALL PARITY*/
      fscanf( in_fp, "%s", ParKa_str ) ;

   /*READ IN GROUND KC TIMES EXCITED KA OVERALL PARITY*/
      fscanf( in_fp, "%s", ParKc_str ) ;

   /*READ IN # OF EXACT, APPROXIMATE CYCLES AND REJECTION LEVEL FOR LEAST SQUARES ANALYSIS*/
      fscanf( in_fp, "%hd%hd%lf", &Lsf_ecycs, &Lsf_acycs, &Lsf_rejlv ) ;

   /*READ PRINT INDICATORS FOR EIGENENERGIES AND EIGENVECTORS*/
      fscanf( in_fp, "%ld%ld", &Prt_ee[ 0 ], &Prt_ee[ 1 ] ) ;
      fscanf( in_fp, "%ld%ld", &Prt_ev[ 0 ], &Prt_ev[ 1 ] ) ;

   /*READ ERROR ANALYSIS INDICATOR*/
      fscanf( in_fp, "%hd", &Err ) ;
      }




/*NEW IAR 2.0 INPUT FORMAT*/
   else if( IAR_version == 2.0 )
      {

   /*READ COMMENT LINE*/
      InLine( in_fp, Mol_nm, 0 ) ;

   /*READ OUTPUT FILENAME*/
      sscanf( InLine( in_fp, line_str, 1 ), "%s", Out_flnm ) ;

   /*READ ASSIGNMENT FILENAME*/
      sscanf( InLine( in_fp, line_str, 1 ), "%s", Asn_flnm ) ;
   
   /*READ J AND K MAXIMUM TO CALCULATE*/
      sscanf( InLine( in_fp, line_str, 2 ), "%ld%ld", &Asn_jmax, &Asn_kmax ) ;

   /*READ J MAX TO CALCULATE*/
      sscanf( InLine( in_fp, line_str, 1 ), "%ld", &J_max ) ;

   /*READ AND CALCULATE GROUND STATE HAMILTONIAN PARAMETERS*/
      RdHamPara( GND, in_fp ) ;

   /*READ AND CALCULATE EXCITED STATE HAMILTONIAN PARAMETERS*/
      RdHamPara( EXE, in_fp ) ;

   /*READ IN ORIGIN ENERGY AND LEAST SQUARES FIT STATUS*/
      sscanf( InLine( in_fp, line_str, 1 ), "%lf", Rc[ EXE ] + ORI ) ;
      sscanf( InLine( in_fp, line_str, 1 ), "%hd", Lsf_stat[ EXE ] + ORI ) ;

   /*READ TRANSITION MOMENT METHOD AND REFERENCE FRAME*/
      sscanf( InLine( in_fp, line_str, 2 ), "%hd%hd", &TM_method, &TM_frame ) ;

   /*READ TRANSITION MOMENT MAGNITUDE AND EULER ANGLES OR PRINCIPAL AXIS PROJECTIONS*/
      sscanf( InLine( in_fp, line_str, 3 ), "%lf%lf%lf", TM_ori + 0, TM_ori + 1, TM_ori + 2 ) ;

   /*READ DELTA K ORDER TO CALCULATE AND AMPLITUDE STATUS FLAG*/
      sscanf( InLine( in_fp, line_str, 2 ), "%ld%hd", &Dk_order, &Amp_stat ) ;

   /*READ IN TEMPERATURE (KELVIN) AND INTENSITY CUTOFF*/
      sscanf( InLine( in_fp, line_str, 2 ), "%lf%lf", &Temp, &Itn_cut ) ;

   /*READ IN JB INDICATOR FOR OLD FORMAT WITH ENERGY AND INTENSITY SCALAR FACTORS AND FSR*/
      sscanf( InLine( in_fp, line_str, 4 ), "%hd%lf%lf%lf", &JB_stat, &JB_ergfactor, &JB_itnfactor, &JB_fsr ) ;

   /*READ IN PARITY SELECTION RULE INDICATOR, GROUND KA X EXCITED KA AND GROUND KC X EXCITED KA OVERALL PARITY*/
      sscanf( InLine( in_fp, line_str, 3 ), "%s%s%s", Parity_str, ParKa_str, ParKc_str ) ;

   /*READ IN # OF EXACT, APPROXIMATE CYCLES AND REJECTION LEVEL FOR LEAST SQUARES ANALYSIS*/
      sscanf( InLine( in_fp, line_str, 3 ), "%hd%hd%lf", &Lsf_ecycs, &Lsf_acycs, &Lsf_rejlv ) ;

   /*READ PRINT INDICATORS FOR EIGENENERGIES AND EIGENVECTORS*/
      sscanf( InLine( in_fp, line_str, 2 ), "%ld%ld", &Prt_ee[ 0 ], &Prt_ee[ 1 ] ) ;
      sscanf( InLine( in_fp, line_str, 2 ), "%ld%ld", &Prt_ev[ 0 ], &Prt_ev[ 1 ] ) ;

   /*READ ERROR ANALYSIS INDICATOR*/
      sscanf( InLine( in_fp, line_str, 1 ), "%hd", &Err ) ;
      }

/*CLOSE INPUT FILE*/
   fclose( in_fp ) ;




/*CREATE FILENAME TO PRINT LOG INFO*/
   strcpy( tstr, Out_flnm ) ;
   strcat( tstr, ".log" ) ;

/*CREATE FILE TO PRINT LOG INFO*/
   if( (Log_fp = fopen( tstr, "w" )) == NULL )
      {
      printf( "\nRDINPUTPARA -> CAN'T CREATE %s FILE !\n", tstr ) ;
      return( E_RT_UNK ) ;
      }


/*LOG PROGRAM HEADER*/
   fprintf( Log_fp, "========================================" ) ;
   fprintf( Log_fp, "========================================\n" ) ;
   fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>> INTERNAL AXIS ROTOR PROGRAM -> iar " ) ;
   fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
   fprintf( Log_fp, "========================================" ) ;
   fprintf( Log_fp, "========================================\n\n" ) ;


/*LOG INPUT PARAMETERS*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> INPUT PHASE " ) ;
   fprintf( Log_fp, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" ) ;
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n\n" ) ;

/*LOG COMMENT LINE - FGETS GET NEW LINE TOO*/
   fprintf( Log_fp, "%s\n", Mol_nm ) ;


/*LOOP THROUGH BOTH STATES*/
   for( st = 0; st < ST_NO; st++ )
      {

   /*LOG EULER ANGLES FOR PRINCIPAL AXIS ROTATION ONLY*/
      if( Phi_dc[ st ] != 0.0 || The_dc[ st ] != 0.0 || Chi_dc[ st ] != 0.0 )
         {
         fprintf( Log_fp, "----------------------------------------" ) ;
         fprintf( Log_fp, "----------------------------------------\n" ) ;
         fprintf( Log_fp, "             %s STATE EULER ANGLES [F TO g: HAM CCW(+) & CW(-)] !\n", St_str[ st ] ) ;
         fprintf( Log_fp, "----------------------------------------" ) ;
         fprintf( Log_fp, "----------------------------------------\n" ) ;
         fprintf( Log_fp, "PHI                               THETA                             CHI\n" ) ;
         fprintf( Log_fp, "%-34.3f%-34.3f%-.3f\n", Phi_dc[ st ], The_dc[ st ], Chi_dc[ st ] ) ;
         fflush( Log_fp ) ;
         }

   /*LOG DIRECTION COSINE MATRIX ELEMENTS FOR PRINCIPAL AXIS ROTATION ONLY*/
      if( Phi_dc[ st ] != 0.0 || The_dc[ st ] != 0.0 || Chi_dc[ st ] != 0.0 )
         {
         fprintf( Log_fp, "----------------------------------------" ) ;
         fprintf( Log_fp, "----------------------------------------\n" ) ;
         fprintf( Log_fp, "                 %s STATE DIRECTION COSINE MATRIX (g TO F) !\n", St_str[ st ] ) ;
         fprintf( Log_fp, "----------------------------------------" ) ;
         fprintf( Log_fp, "----------------------------------------\n" ) ;
         fprintf( Log_fp, "X                                 Y                                 Z\n" ) ;
         for( cnt = 0; cnt < 3; cnt++ )
            fprintf( Log_fp, "%-34.6f%-34.6f%.6f\n", HamRot_mat[ st ][ cnt ][ 0 ], HamRot_mat[ st ][ cnt ][ 1 ], HamRot_mat[ st ][ cnt ][ 2 ] ) ;
         }
      }


   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "MAXIMUM J AND K CALCULATED = %ld\n", J_max ) ;

/*LOG INITIAL PARAMETERS*/
   fprintf( Log_fp, "----------------------------------------" ) ;
   fprintf( Log_fp, "----------------------------------------\n" ) ;
   fprintf( Log_fp, "                             HAMILTONIAN PARAMETERS !\n" ) ;
   PrntPrm() ;



/*SET IMAGINARY ELEMENT STATUS TO ACTIVE WHEN PERTURBATION INVOLVES PY*/
   if( Rc_stat[ st ][ PY ] || Rc_stat[ st ][ PXPY ] || Rc_stat[ st ][ PYPZ ] )
      Im_stat = 1 ;

/*<PX> PERTURBATION ON -> LABEL LINES WITH X CHARACTER*/
   if( Rc_stat[ GND ][ PX ] || Rc_stat[ EXE ][ PX ] )
      Band_type = 7 ;

/*<PY> PERTURBATION ON -> LABEL LINES WITH X CHARACTER*/
   if( Rc_stat[ GND ][ PY ] || Rc_stat[ EXE ][ PY ] )
      Band_type = 7 ;

/*<PZ> PERTURBATION ON -> LABEL LINES WITH Z CHARACTER*/
   if( Rc_stat[ GND ][ PZ ] || Rc_stat[ EXE ][ PZ ] )
      Band_type = 5 ;


/*<PXPY + PYPX> PERTURBATION ON -> LABEL LINES WITH X CHARACTER*/
   if( Rc_stat[ GND ][ PXPY ] || Rc_stat[ EXE ][ PXPY ] )
      Band_type = 7 ;

/*<PXPZ + PZPX> PERTURBATION ON -> LABEL LINES WITH X CHARACTER*/
   if( Rc_stat[ GND ][ PXPZ ] || Rc_stat[ EXE ][ PXPZ ] )
      Band_type = 7 ;

/*<PYPZ + PZPY> PERTURBATION ON -> LABEL LINES WITH Y CHARACTER*/
   if( Rc_stat[ GND ][ PYPZ ] || Rc_stat[ EXE ][ PYPZ ] )
      Band_type = 6 ;


/*CALCULATE PROJECTIONS OF TRANSITION MOMENT VECTOR FROM EULER ANGLES - INCLUDE ANY AXIS ROTATION*/
   TransMomentOrient( TM_method, TM_frame, TM_ori, HamRot_mat[ TM_frame ], TM_prj ) ;


/*CHECK PARITY SELECTION RULE INDICATOR*/
   if( !strcmp( Parity_str, "N" ) )
      Parity_stat = 0 ;
   else if( !strcmp( Parity_str, "Y" ) )
      Parity_stat = 1 ;
   else
      {
      fprintf( Log_fp, "PARITY SELECTION STATUS '%s' INCORRECT -> Y OR N ONLY !\n", Parity_str ) ;
      return( E_RT_UNK ) ;
      }

/*CHECK GROUND KA TIMES EXCITED KA OVERALL PARITY*/
   if( !strcmp( ParKa_str, "E" ) )
      Ka_parity = 0 ;
   else if( !strcmp( ParKa_str, "O" ) )
      Ka_parity = 1 ;
   else
      {
      fprintf( Log_fp, "IMPROPER OVERALL KA PARITY '%s' !\n", ParKa_str ) ;
      return( E_RT_UNK ) ;
      }


/*CHECK GROUND KC TIMES EXCITED KA OVERALL PARITY*/
   if( !strcmp( ParKc_str, "E" ) )
      Kc_parity = 0 ;
   else if( !strcmp( ParKc_str, "O" ) )
      Kc_parity = 1 ;
   else
      {
      fprintf( Log_fp, "IMPROPER OVERALL KC PARITY '%s' !\n", ParKc_str ) ;
      return( E_RT_UNK ) ;
      }


/*MICROWAVE - ORIGIN ASSIGNED TO ZERO - NEEDED IN HL_IAR.C AND TRS_IAR.C*/
   if( !Rc[ EXE ][ ORI ] )
      {
      St_nodv[ 1 ] = St_nodv[ 0 ] ;
      Rc_stat[ EXE ][ A ] = Rc_stat[ EXE ][ B ] = Rc_stat[ EXE ][ C ] = 0 ;
      }

/*DETERMINE TOTAL # OF PARAMETERS TO FIT -> CHECK STATUS OF PARAMETER -> ORIGIN ALWAYS LAST*/
   for( Lsf_noprm = 0, cnt = 0; cnt < ST_NO; cnt++ )
      for( cts = 0; cts < ST_NOPAR + cnt; cts++ )
         if( Rc_stat[ cnt ][ cts ] && Lsf_stat[ cnt ][ cts ] )
            Lsf_noprm++ ;


/*RETURN SUCCESS*/
   return( S_RT_FIN ) ;
   }









/*READ AND CALCULATE HAMILTONIAN PARAMETERS*/
void RdHamPara( int st, FILE *fp )
   {
   long cnt ;
   char line_str[ CMT_LEN ] ;


/*OLD JB INPUT FORMAT*/
   if( IAR_version == 1.0 )
      {

   /*READ ROTATIONAL CONSTANT PARAMETERS FOR GROUND STATE*/
      fscanf( fp, "%lf%lf%lf", Rc[ st ] + A, Rc[ st ] + B, Rc[ st ] + C ) ;

   /*READ IN GROUND STATE DIRECTIONAL COSINE ANGLES OF TRANSFORMATION FOR HAMILTONIAN*/
      fscanf( fp, "%lf%lf%lf", Phi_dc + st, The_dc + st, Chi_dc + st ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      fscanf( fp, "%hd%hd%hd", Lsf_stat[ st ] + A, Lsf_stat[ st ] + B, Lsf_stat[ st ] + C ) ;


   /*READ STATUS OF <PX>, <PY> AND <PZ> PERTURBATION ELEMENT*/
      fscanf( fp, "%hd%hd%hd", Rc_stat[ st ] + PX, Rc_stat[ st ] + PY, Rc_stat[ st ] + PZ ) ;

   /*READ PARAMETERS VALUES OF <PX>, <PY> AND <PZ> PERTURBATION ELEMENT*/
      fscanf( fp, "%lf%lf%lf", Rc[ st ] + PX, Rc[ st ] + PY, Rc[ st ] + PZ ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      fscanf( fp, "%hd%hd%hd", Lsf_stat[ st ] + PX, Lsf_stat[ st ] + PY, Lsf_stat[ st ] + PZ ) ;


   /*READ STATUS OF <PXPY + PYPX>, <PXPZ + PZPX> AND <PYPZ + PZPY> PERTURBATION ELEMENT*/
      fscanf( fp, "%hd%hd%hd", Rc_stat[ st ] + PXPY, Rc_stat[ st ] + PXPZ, Rc_stat[ st ] + PYPZ ) ;

   /*READ PARAMETERS VALUES OF <PXPY + PYPX>, <PXPZ + PZPX> AND <PYPZ + PZPY> PERTURBATION ELEMENT*/
      fscanf( fp, "%lf%lf%lf", Rc[ st ] + PXPY, Rc[ st ] + PXPZ, Rc[ st ] + PYPZ ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      fscanf( fp, "%hd%hd%hd", Lsf_stat[ st ] + PXPY, Lsf_stat[ st ] + PXPZ, Lsf_stat[ st ] + PYPZ ) ;


   /*READ STATUS OF <DJ> DISTORTION ELEMENT AND <PZ**3> DISTORTION ELEMENT*/
      fscanf( fp, "%hd%hd", Rc_stat[ st ] + DJ, Rc_stat[ st ] + PZ3 ) ;

   /*READ PARAMETERS VALUES OF <DJ> PERTURBATION ELEMENT> AND <PZ**3> PERTURBATION ELEMENT*/
      fscanf( fp, "%lf%lf", Rc[ st ] + DJ, Rc[ st ] + PZ3 ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      fscanf( fp, "%hd%hd", Lsf_stat[ st ] + DJ, Lsf_stat[ st ] + PZ3 ) ;

   /*SET THESE PARAMETER VALUES TO ZERO*/
      Rc_stat[ st ][ DK ] = Rc_stat[ st ][ DJK ] = Rc_stat[ st ][ dK ] = Rc_stat[ st ][ dJ ] = 0 ;
      Rc[ st ][ DK ] = Rc[ st ][ DJK ] = Rc[ st ][ dK ] = Rc[ st ][ dJ ] = 0.0 ;
      Lsf_stat[ st ][ DK ] = Lsf_stat[ st ][ DJK ] = Lsf_stat[ st ][ dK ] = Lsf_stat[ st ][ dJ ] = 0 ;
      }



/*NEW INPUT FORMAT*/
   else if( IAR_version == 2.0 )
      {

   /*READ ROTATIONAL CONSTANT PARAMETERS FOR GROUND STATE*/
      sscanf( InLine( fp, line_str, 3 ), "%lf%lf%lf", Rc[ st ] + A, Rc[ st ] + B, Rc[ st ] + C ) ;

   /*READ IN GROUND STATE DIRECTIONAL COSINE ANGLES OF TRANSFORMATION FOR HAMILTONIAN*/
      sscanf( InLine( fp, line_str, 3 ), "%lf%lf%lf", Phi_dc + st, The_dc + st, Chi_dc + st ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Lsf_stat[ st ] + A, Lsf_stat[ st ] + B, Lsf_stat[ st ] + C ) ;


   /*READ STATUS OF <PX>, <PY> AND <PZ> PERTURBATION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Rc_stat[ st ] + PX, Rc_stat[ st ] + PY, Rc_stat[ st ] + PZ ) ;

   /*READ PARAMETERS VALUES OF <PX>, <PY> AND <PZ> PERTURBATION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%lf%lf%lf", Rc[ st ] + PX, Rc[ st ] + PY, Rc[ st ] + PZ ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Lsf_stat[ st ] + PX, Lsf_stat[ st ] + PY, Lsf_stat[ st ] + PZ ) ;


   /*READ STATUS OF <PXPY + PYPX>, <PXPZ + PZPX> AND <PYPZ + PZPY> PERTURBATION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Rc_stat[ st ] + PXPY, Rc_stat[ st ] + PXPZ, Rc_stat[ st ] + PYPZ ) ;

   /*READ PARAMETERS VALUES OF <PXPY + PYPX>, <PXPZ + PZPX> AND <PYPZ + PZPY> PERTURBATION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%lf%lf%lf", Rc[ st ] + PXPY, Rc[ st ] + PXPZ, Rc[ st ] + PYPZ ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Lsf_stat[ st ] + PXPY, Lsf_stat[ st ] + PXPZ, Lsf_stat[ st ] + PYPZ ) ;


   /*READ STATUS OF <DK>, <DJK>, <DJ> DISTORTION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Rc_stat[ st ] + DK, Rc_stat[ st ] + DJK, Rc_stat[ st ] + DJ ) ;

   /*READ PARAMETERS VALUES OF <DK>, <DJK> AND <DJ> PERTURBATION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%lf%lf%lf", Rc[ st ] + DK, Rc[ st ] + DJK, Rc[ st ] + DJ ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Lsf_stat[ st ] + DK, Lsf_stat[ st ] + DJK, Lsf_stat[ st ] + DJ ) ;

   /*READ STATUS OF <dK>, <dJ>, <PZ**3> DISTORTION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Rc_stat[ st ] + dK, Rc_stat[ st ] + dJ, Rc_stat[ st ] + PZ3 ) ;

   /*READ PARAMETERS VALUES OF <dK>, <dJ> AND <PZ**3> PERTURBATION ELEMENT*/
      sscanf( InLine( fp, line_str, 3 ), "%lf%lf%lf", Rc[ st ] + dK, Rc[ st ] + dJ, Rc[ st ] + PZ3 ) ;

   /*READ LEAST SQUARES FIT STATUS*/
      sscanf( InLine( fp, line_str, 3 ), "%hd%hd%hd", Lsf_stat[ st ] + dK, Lsf_stat[ st ] + dJ, Lsf_stat[ st ] + PZ3 ) ;
      }


/*GENERATE EULER TRANSFORMATION MATRIX FOR ROTATION OF HAMILTONIAN AND BACK ROTATION OF DERIVATIVES*/
   EulerGenMat( HamRot_mat[ st ], Phi_dc[ st ], The_dc[ st ], Chi_dc[ st ] ) ;

/*COUNT # OF DERIVATIVES NEEDED IN ENERGY CALCULATION - ORIGIN PARAMETER NOT COUNTED HERE BUT IS LAST*/
   for( cnt = 0; cnt < ST_NOPAR; cnt++ )
      if( Rc_stat[ st ][ cnt ] )
         (St_nodv[ st ])++ ;
   }









/*WRITE OUT NEW INPUT PARAMETERS FOR IAR VERSION 2.0*/
short WtInputPara( char *out_flnm )
   {
   FILE *out_fp ;
   char innew_flnm[ FLNM_LEN ] ;


/*CREATE FILENAME TO WRITE NEW INPUT FILE*/
   strcpy( innew_flnm, out_flnm ) ;
   strcat( innew_flnm, ".in" ) ;

/*CREATE FILE TO PRINT LOG INFO*/
   if( (out_fp = fopen( innew_flnm, "w" )) == NULL )
      {
      printf( "\nWTOUTPUTPARA -> CAN'T CREATE %s FILE !\n", innew_flnm ) ;
      return( E_RT_UNK ) ;
      }


/*WRITE VERSION NUMBER*/
   fprintf( out_fp, "########################################" ) ;
   fprintf( out_fp, "########################################\n" ) ;
   fprintf( out_fp, "#                         IAR INPUT FILE : VERSION 2.0" ) ;
   fprintf( out_fp, "                         #\n" ) ;
   fprintf( out_fp, "########################################" ) ;
   fprintf( out_fp, "########################################\n\n" ) ;

/*WRITE COMMENT LINE*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# COMMENT LINE (< 200 CHARACTERS WITH NEW LINE END):\n" ) ;
   fprintf( out_fp, "  %s", Mol_nm ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE OUTPUT FILENAME*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# OUTPUT FILENAME (EXTENSIONS WILL BE ADDED):\n" ) ;
   fprintf( out_fp, "  %s\n", Out_flnm ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE ASSIGNMENT FILENAME*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# ASSIGNMENT FILENAME:\n" ) ;
   fprintf( out_fp, "  %s\n", Asn_flnm ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE J AND K MAXIMUM TO CALCULATE*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# J & K MAXIMUM OF ASSIGNED LINES TO FIT:\n" ) ;
   fprintf( out_fp, "  %-18ld%ld\n", Asn_jmax, Asn_kmax ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE J MAX TO CALCULATE*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# MAXIMUM J TO CALCULATE:\n" ) ;
   fprintf( out_fp, "  %ld\n", J_max ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n\n" ) ;

/*WRITE GROUND STATE HAMILTONIAN PARAMETERS*/
   WtHamPara( GND, out_fp ) ;

/*WRITE EXCITED STATE HAMILTONIAN PARAMETERS*/
   WtHamPara( EXE, out_fp ) ;

/*WRITE IN ORIGIN ENERGY AND LEAST SQUARES FIT STATUS*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# ORIGIN FREQUENCY AND FIT INDICATOR: 0|1=FIT|FIXED\n" ) ;
   fprintf( out_fp, "  %.8e\n  %hd\n", Rc[ EXE ][ ORI ], Lsf_stat[ EXE ][ ORI ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE TRANSITION MOMENT METHOD AND REFERENCE FRAME*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# TRANSITION MOMENT METHOD & REFERENCE FRAME: 0|1=ANG|%%INT & 0|1=GND|EXE FRAME\n" ) ;
   fprintf( out_fp, "  %-18hd%hd\n", TM_method, TM_frame ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE TRANSITION MOMENT MAGNITUDE AND EULER ANGLES OR PRINCIPAL AXIS PROJECTIONS*/
   fprintf( out_fp, "# TRANSITION MOMENT (CCW+): TM MAG/THETA/CHI FROM A | %%INT ON A(Z) & B(X) & C(Y)\n" ) ;
   fprintf( out_fp, "  %-18f%-18f%-18f\n", TM_ori[ 0 ], TM_ori[ 1 ], TM_ori[ 2 ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE DELTA K ORDER TO CALCULATE AND AMPLITUDE STATUS FLAG*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# DELTA K ORDER & AMPLITUDE STATUS: 1|3|5=ORDER & 0|1=AMP STATUS OFF|ON\n" ) ;
   fprintf( out_fp, "  %-18ld%hd\n", Dk_order, Amp_stat ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE TEMPERATURE (KELVIN) AND INTENSITY CUTOFF*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# TEMPERATURE IN KELVIN (TO MHZ) & INTENSITY CUTOFF: 3.0 & 0.01\n" ) ;
   fprintf( out_fp, "  %-18f%f\n", Temp, Itn_cut ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE JB INDICATOR FOR OLD FORMAT WITH ENERGY AND INTENSITY SCALAR FACTORS AND FSR*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# OUTPUT FORMAT INDICATOR & ERG & ITN SCALARS & FSR: 0|1=JB FORMAT OFF|ON\n" ) ;
   fprintf( out_fp, "  %-18hd%-18.2f%-18.2f%f\n", JB_stat, JB_ergfactor, JB_itnfactor, JB_fsr ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE PARITY SELECTION RULE INDICATOR, GROUND KA X EXCITED KA AND GROUND KC X EXCITED KA OVERALL PARITY*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# PARITY STAT & GND & EXE KaKc PARITY PRODUCTS: Y|N=OFF|ON & E|O & E|O\n" ) ;
   fprintf( out_fp, "  %-18s%-18s%s\n", Parity_str, ParKa_str, ParKc_str ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE # OF EXACT, APPROXIMATE CYCLES AND REJECTION LEVEL FOR LEAST SQUARES ANALYSIS*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# LS FIT EXACT CYCLES & APPROX & REJ LEVEL: 0(-1)|1=OFF|ON & 1|.. & 1|..\n" ) ;
   fprintf( out_fp, "  %-18hd%-18hd%f\n", Lsf_ecycs, Lsf_acycs, Lsf_rejlv ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE PRINT INDICATORS FOR EIGENENERGIES AND EIGENVECTORS*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# LOWER & UPPER EIGENVALUES & EIGENVECTORS LOGGED: 0|.. TO -1|.. & 0|.. TO -1|..\n" ) ;
   fprintf( out_fp, "  %-18ld%ld\n", Prt_ee[ 0 ], Prt_ee[ 1 ] ) ;
   fprintf( out_fp, "  %-18ld%ld\n", Prt_ev[ 0 ], Prt_ev[ 1 ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;

/*WRITE ERROR ANALYSIS INDICATOR*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# DEBUG PRINT STATUS: 0|1=OFF|ON\n" ) ;
   fprintf( out_fp, "  %hd\n", Err ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;


/*RETURN SUCCESS*/
   return( S_RT_FIN ) ;
   }









/*READ AND CALCULATE HAMILTONIAN PARAMETERS*/
void WtHamPara( int st, FILE *out_fp )
   {

/*WRITE ROTATIONAL CONSTANT PARAMETERS FOR GROUND STATE*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# %s STATE A, B AND C ROTATIONAL CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-17.8e %-17.8e %.8e\n", Rc[ st ][ A ], Rc[ st ][ B ], Rc[ st ][ C ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE GROUND STATE DIRECTIONAL COSINE ANGLES OF TRANSFORMATION FOR INERTIAL TENSOR*/
   fprintf( out_fp, "# %s STATE PHI, THETA AND CHI EULER ANGLES (UHU-1 CCW+):\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18f%-18f%f\n", Phi_dc[ st ], The_dc[ st ], Chi_dc[ st ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE LEAST SQUARES FIT STATUS*/
   fprintf( out_fp, "# %s STATE FIT INDICATORS: 0|1=OFF|ON\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Lsf_stat[ st ][ A ], Lsf_stat[ st ][ B ], Lsf_stat[ st ][ C ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;


/*WRITE STATUS OF <PX>, <PY> AND <PZ> PERTURBATION ELEMENT*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# %s STATE STATUS OF CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Rc_stat[ st ][ PX ], Rc_stat[ st ][ PY ], Rc_stat[ st ][ PZ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE PARAMETERS VALUES OF <PX>, <PY> AND <PZ> PERTURBATION ELEMENT*/
   fprintf( out_fp, "# %s STATE <PX>(B), <PY>(C) & <PZ>(A) CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-17.8e %-17.8e %.8e\n", Rc[ st ][ PX ], Rc[ st ][ PY ], Rc[ st ][ PZ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE LEAST SQUARES FIT STATUS*/
   fprintf( out_fp, "# %s STATE FIT INDICATORS: 0|1=OFF|ON\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Lsf_stat[ st ][ PX ], Lsf_stat[ st ][ PY ], Lsf_stat[ st ][ PZ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;


/*WRITE STATUS OF <PXPY + PYPX>, <PXPZ + PZPX> & <PYPZ + PZPY> PERTURBATION ELEMENT*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# %s STATE STATUS OF CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Rc_stat[ st ][ PXPY ], Rc_stat[ st ][ PXPZ ], Rc_stat[ st ][ PYPZ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE PARAMETERS VALUES OF <PXPY + PYPX>, <PXPZ + PZPX> AND <PYPZ + PZPY> PERTURBATION ELEMENT*/
   fprintf( out_fp, "# %s STATE <PXPY + PYPX>, <PXPZ + PZPX> & <PYPZ + PZPX> CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-17.8e %-17.8e %.8e\n", Rc[ st ][ PXPY ], Rc[ st ][ PXPZ ], Rc[ st ][ PYPZ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE LEAST SQUARES FIT STATUS*/
   fprintf( out_fp, "# %s STATE FIT INDICATORS: 0|1=OFF|ON\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Lsf_stat[ st ][ PXPY ], Lsf_stat[ st ][ PXPZ ], Lsf_stat[ st ][ PYPZ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;


/*WRITE STATUS OF <DK>, <DJK>, <DJ> DISTORTION ELEMENT*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# %s STATE STATUS OF CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Rc_stat[ st ][ DK ], Rc_stat[ st ][ DJK ], Rc_stat[ st ][ DJ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE PARAMETERS VALUES OF <DK>, <DJK> AND <DJ> PERTURBATION ELEMENT*/
   fprintf( out_fp, "# %s STATE <DK>, <DJK> & <DJ> WATSON D DISTORTION CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-17.8e %-17.8e %.8e\n", Rc[ st ][ DK ], Rc[ st ][ DJK ], Rc[ st ][ DJ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE LEAST SQUARES FIT STATUS*/
   fprintf( out_fp, "# %s STATE FIT INDICATORS: 0|1=OFF|ON\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Lsf_stat[ st ][ DK ], Lsf_stat[ st ][ DJK ], Lsf_stat[ st ][ DJ ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;


/*WRITE STATUS OF <dK>, <dJ>, <PZ**3> DISTORTION ELEMENT*/
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;
   fprintf( out_fp, "# %s STATE STATUS OF CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Rc_stat[ st ][ dK ], Rc_stat[ st ][ dJ ], Rc_stat[ st ][ PZ3 ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE PARAMETERS VALUES OF <dK>, <dJ> AND <PZ**3> PERTURBATION ELEMENT*/
   fprintf( out_fp, "# %s STATE <dK> & <dJ> WATSON D DISTORTION & <PZ**3> CONSTANTS:\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-17.8e %-17.8e %.8e\n", Rc[ st ][ dK ], Rc[ st ][ dJ ], Rc[ st ][ PZ3 ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n" ) ;

/*WRITE LEAST SQUARES FIT STATUS*/
   fprintf( out_fp, "# %s STATE FIT INDICATORS: 0|1=OFF|ON\n", St_str[ st ] ) ;
   fprintf( out_fp, "  %-18hd%-18hd%hd\n", Lsf_stat[ st ][ dK ], Lsf_stat[ st ][ dJ ], Lsf_stat[ st ][ PZ3 ], St_str[ st ] ) ;
   fprintf( out_fp, "#---------------------------------------" ) ;
   fprintf( out_fp, "----------------------------------------\n\n" ) ;
   }









/*IAR VERSION 2.0 - READ INPUT FILE AND RETURN CHARACTER STRING THAT IS NOT A COMMENT*/
char *InLine( FILE *fp, char *line, short arg_no )
   {
   char tstr[ CMT_LEN ] ;
   short arg_cnt ;


/*TRUNCATE LINE STRING AND READ UNTIL FIND A NON COMMENT LINE OR TILL EOF*/
   for( strcpy( line, "" ), arg_cnt = 0; fscanf( fp, "%s", tstr ) != EOF; )
      {

   /*COMMENT LINE, GET LINE AND CONTINUE*/
      if( tstr[ 0 ] == '#' )
         {
         fgets( tstr, CMT_LEN - strlen( tstr ) - 1, fp ) ;
         continue ;
         }

   /*COPY INTO LINE*/
      strcat( line, tstr ) ;

   /*GET WHOLE LINE - INPUT FILE COMMENT LINE*/
      if( !arg_no )
         fgets( line + strlen( line ), CMT_LEN - strlen( line ) - 1, fp ) ;

   /*INCREAMENT NUMBER OF ARGUMENTS IN LINE STRING AND RETURN LINE WHEN CORRECT NUMBER*/
      if( ++arg_cnt >= arg_no  )
         return( line ) ;

   /*ADD SEPARATOR*/
      strcat( line, " " ) ;
      }

/*INFORM USER OF INCORRECT FILE*/
   printf( "INPUT FILE HAS INCORRECT FORMAT !\n" ) ;
   fflush( stdout ) ;

/*EXIT PROGRAM - INPUT FILE HAS BAD FORMAT*/
   exit( 0 ) ;
   }



