/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> HLR_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"


int gv_fd, ev_fd ;
extern int gd_fd, ed_fd ;
extern int cg_fd ;
extern long Asn_split ;

extern long gv_dim, ev_dim, gv_bssz, ev_bssz, gd_dim, ed_dim ;
double *gv_mat, *ev_mat ;
extern double *gd_mat, *ed_mat ;

extern long cg_dim ;
extern long ap_cg_dim, bcp_cg_dim ;
extern long aq_cg_dim, bcq_cg_dim ;
extern long ar_cg_dim, bcr_cg_dim ;

extern double *cg_vec ;
extern double *ap_cg_vec, *bp_cg_vec, *cp_cg_vec ;
extern double *aq_cg_vec, *bq_cg_vec, *cq_cg_vec ;
extern double *ar_cg_vec, *br_cg_vec, *cr_cg_vec ;


short RTrsCalc( void ) ;
short RTrsInit( void ) ;
short TrsOut( void ) ;

void SFree1Dim( short **ptpt ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;





/*CALCULATE TRANSITION INTENSITIES BETWEEN GROUND AND EXCITED STATE*/
short RTrsCalc()
   {
   char band_chr ;

   short jk_vec[ 6 ] ;
   short *kag_pt, *kae_pt, *kcg_pt, *kce_pt, ka_lbl, kc_lbl ;

   long cnt ;
   short gno_ders, eno_ders ;
   long gv_ct, ev_ct, g_ofs, e_ofs ;
   long g_ct, e_ct, a_ct, bc_ct, w_ct ;
   long asnwt_stat ;

/*MICROWAVE*/
   static long asn_ct ;

   long jg_qn, je_qn, kg_qn, ke_qn, kg_ofs, ke_ofs ;
   long dk_span, ev_beg, ev_end, j_ofs, jj_ofs, jjk_ofs, jjkk_ofs ;

   float abc_itnf, abc_ampf ;
   double trs_erg ;
   double abc_itn, c_itn, ori_erg ;
   double abr_amp, ar_amp, br_amp, ci_amp ;
   double boltz_amp = 1.0 ;

   double *g_pt, *e_pt, der ;


/*REASSIGN POINTERS FOR CLARITY*/
   kag_pt = Ka_ary[ GND ] ;
   kae_pt = Ka_ary[ EXE ] ;
   kcg_pt = Kc_ary[ GND ] ;
   kce_pt = Kc_ary[ EXE ] ;

/*DEREFERENCE FOR SPEED*/
   gno_ders = St_nodv[ GND ] ;
   eno_ders = St_nodv[ EXE ] ;
   ori_erg = Rc[ EXE ][ ORI ] ;



/*ON LAST LINEAR LEAST SQUARES CYCLE OPEN FILES TO WRITE SIMULATION INFO*/
   if( Lsflc_stat )
      if( TrsOut() == -1 )
         return( -1 ) ;


/*OPEN NEEDED FILES AND ALLOCATE NEEDED SPACE FOR ALL ARRAYS*/
   if( RTrsInit() == -1 )
      return( -1 ) ;



/*INITIALIZE TRANSITION COUNTER AND REJECTED LINE COUNTER*/
   Trs_nolvs = Rej_nolvs = 0 ;


/*MICROWAVE*/
   if( Dual_Fit && !Rc[ EXE ][ ORI ] )
      asn_ct = Asn_split ;
   else
      asn_ct = 0 ;


/*LOOP THROUGH ALL J IN GROUND STATE -> CALCULATE RANGE OF KE VALUES TO CONSIDER FROM DELTA K ORDER*/
   for( asnwt_stat = 0, dk_span = 4 * Dk_order + 2, jg_qn = 0; jg_qn <= J_max; jg_qn++ )
      {

   /*STORE GROUND J OFFSET*/
      j_ofs = (jg_qn << 24) ;


   /*GROUND STATE -> DEFINE ROW/COLUMN DIMENSION AND TOTAL # OF EIGENVECTOR ELEMENTS*/
      gv_dim = 2 * jg_qn + 1 ;
      gv_bssz = gv_dim * gv_dim ;
      gd_dim = (2 * jg_qn + 1) * gno_ders ;


   /*READ NEXT J BLOCK OF GROUND STATE EIGENVECTORS -> KETS VECTORS IN ROW FORM*/
      read( gv_fd, (char *)gv_mat, gv_bssz * sizeof( double ) ) ;

   /*READ NEXT J BLOCK OF GROUND STATE DERVATIVES*/
      read( gd_fd, (char *)gd_mat, gd_dim * sizeof( double ) ) ;

   /*MICROWAVE - CHANGE SIGN OF LOWER STATE DERIVATIVES*/
      for( cnt = 0; cnt < gd_dim; cnt++ )
         *(gd_mat + cnt) *= -1.0 ;



   /*FILL ARRAY WITH WIGNER 3-J SYMBOLS FOR P, Q AND R BRANCHES*/
      if( jg_qn != 0 )
         {


      /*READ IN WIGNER 3-J SYMBOLS FOR P, Q AND R BRANCHES FOR GIVEN J*/
         cg_dim = 18 * jg_qn + 1 ;
         read( cg_fd, (char *)cg_vec, cg_dim * sizeof( double ) ) ;



      /*P BRANCH -> SORT CLEBSCH GORDAN TO ALLOW SEPARATE CALCULATION OF PARALLEL AND PERPENDICULAR*/
         ap_cg_dim = 2 * (jg_qn - 1) + 1 ;
         bcp_cg_dim = 2 * ap_cg_dim ;
         for( w_ct = 0, bc_ct = 0, a_ct = 0; a_ct < ap_cg_dim; a_ct++, bc_ct += 2, w_ct += 3 )
            {

         /*UPPER TRIDIAGONAL ELEMENTS (K' - K'' = +1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(bp_cg_vec + bc_ct) = *(cg_vec + w_ct + 0) ;
            *(cp_cg_vec + bc_ct) = *(cg_vec + w_ct + 0) ;

         /*MID TRIDIAGONAL ELEMENTS (K' - K'' = 0) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(ap_cg_vec + a_ct) = *(cg_vec + w_ct + 1) ;

         /*LOWER TRIDIAGONAL ELEMENTS (K' - K'' = -1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(bp_cg_vec + bc_ct + 1) = *(cg_vec + w_ct + 2) ;
            *(cp_cg_vec + bc_ct + 1) = *(cg_vec + w_ct + 2) ;
            }


      /*Q BRANCH -> SORT CLEBSCH GORDAN TO ALLOW SEPARATE CALCULATION OF PARALLEL AND PERPENDICULAR*/
         aq_cg_dim = 2 * jg_qn + 1 ;
         bcq_cg_dim = 4 * jg_qn ;
         for( bc_ct = 0, a_ct = 0; a_ct < aq_cg_dim - 1; a_ct++, bc_ct += 2, w_ct += 3 )
            {

         /*UPPER TRIDIAGONAL ELEMENTS (K' - K'' = +1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(bq_cg_vec + bc_ct) = *(cg_vec + w_ct + 1) ;
            *(cq_cg_vec + bc_ct) = *(cg_vec + w_ct + 1) ;

         /*MID TRIDIAGONAL ELEMENTS (K' - K'' = 0) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(aq_cg_vec + a_ct) = *(cg_vec + w_ct + 0) ;

         /*LOWER TRIDIAGONAL ELEMENTS (K' - K'' = -1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(bq_cg_vec + bc_ct + 1) = *(cg_vec + w_ct + 2) ;
            *(cq_cg_vec + bc_ct + 1) = *(cg_vec + w_ct + 2) ;
            }

      /*LAST DIAGONAL ELEMENT*/
         *(aq_cg_vec + a_ct) = *(cg_vec + w_ct + 0) ;



      /*R BRANCH -> SORT CLEBSCH GORDAN TO ALLOW SEPARATE CALCULATION OF PARALLEL AND PERPENDICULAR*/
         ar_cg_dim = 2 * jg_qn + 1 ;
         bcr_cg_dim = 2 * ar_cg_dim ;
         for( ++w_ct, bc_ct = 0, a_ct = 0; a_ct < ar_cg_dim; a_ct++, bc_ct += 2, w_ct += 3 )
            {

         /*LOWER TRIDIAGONAL ELEMENTS (K' - K'' = -1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(br_cg_vec + bc_ct) = *(cg_vec + w_ct + 0) ;
            *(cr_cg_vec + bc_ct) = *(cg_vec + w_ct + 0) ;

         /*MID TRIDIAGONAL ELEMENTS (K' - K'' = 0) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(ar_cg_vec + a_ct) = *(cg_vec + w_ct + 1) ;

         /*UPPER TRIDIAGONAL ELEMENTS (K' - K'' = +1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
            *(br_cg_vec + bc_ct + 1) = *(cg_vec + w_ct + 2) ;
            *(cr_cg_vec + bc_ct + 1) = *(cg_vec + w_ct + 2) ;
            }


      /*SET JE_QN FOR P BRANCH TRANSITION*/
         je_qn = jg_qn - 1 ;


      /*EXCITED STATE EV FILE OFFSET TO FIRST BLOCK FOR P TYPE TRANSITION*/
         e_ofs = (je_qn > 0) ? (je_qn - 1) * (4 * (je_qn - 1) * (je_qn - 1) +
               12 * (je_qn - 1) + 11) / 3 + 1 : 0 ;

      /*SEEK TO POSITION OF FIRST P ELEMENT IN EXCITED STATE EIGENVECTOR FILE*/
         lseek( ev_fd, (long)(e_ofs * sizeof( double )), 0 ) ;


      /*EXCITED STATE EV FILE OFFSET TO FIRST BLOCK FOR P TYPE TRANSITION*/
         e_ofs = je_qn * je_qn * eno_ders ;

      /*SEEK TO POSITION OF FIRST P ELEMENT IN EXCITED STATE DERIVATIVE FILE*/
         lseek( ed_fd, (long)(e_ofs * sizeof( double )), 0 ) ;
         }



   /*J EQUALS ZERO CASE -> R(0) LINE ONLY*/
      else
         {

      /*READ J MAX FOR FILE -> INTEGER*/
         read( cg_fd, (char *)&a_ct, sizeof( long ) ) ;


      /*FILL ARRAY WITH 3 WIGNER 3-J SYMBOLS FOR R(0) LINE*/
         read( cg_fd, (char *)cg_vec, 3 * sizeof( double ) ) ;

      /*R BRANCH -> SORT CLEBSCH GORDAN TO ALLOW SEPARATE CALCULATION OF PARALLEL AND PERPENDICULAR*/
         ar_cg_dim = 2 * jg_qn + 1 ;
         bcr_cg_dim = 2 * ar_cg_dim ;

      /*LOWER TRIDIAGONAL ELEMENTS (K' - K'' = -1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
         *(br_cg_vec + 0) = *(cg_vec + 0) ;
         *(cr_cg_vec + 0) = *(cg_vec + 0) ;

      /*MID TRIDIAGONAL ELEMENTS (K' - K'' = 0) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
         *(ar_cg_vec + 0) = *(cg_vec + 1) ;

      /*UPPER TRIDIAGONAL ELEMENTS (K' - K'' = +1) OF <J''K''|CG|J'K'> MATRIX -> TOP LABELS J'K'*/
         *(br_cg_vec + 0 + 1) = *(cg_vec + 2) ;
         *(cr_cg_vec + 0 + 1) = *(cg_vec + 2) ;



      /*Q(0) AND P(0) DO NOT EXIST -> SET JE_QN FOR R(0) LINE*/
         je_qn = 1 ;


      /*EXCITED STATE EV FILE OFFSET TO FIRST BLOCK FOR P TYPE TRANSITION*/
         e_ofs = 1 ;

      /*SEEK TO POSITION OF FIRST P ELEMENT IN EXCITED STATE EIGENVECTOR FILE*/
         lseek( ev_fd, (long)(e_ofs * sizeof( double )), 0 ) ;


      /*EXCITED STATE EV FILE OFFSET TO FIRST BLOCK FOR P TYPE TRANSITION*/
         e_ofs = 1 * eno_ders ;

      /*SEEK TO POSITION OF FIRST P ELEMENT IN EXCITED STATE DERIVATIVE FILE*/
         lseek( ed_fd, (long)(e_ofs * sizeof( double )), 0 ) ;
         }




   /*LOOP THROUGH EXCITED J BLOCK OF VECTORS FOR P, Q, R BRANCHS -> Q(0) AND P(0) DO NOT EXIST*/
      for( ;je_qn <= jg_qn + 1 && je_qn <= J_max; je_qn++ )
         {


      /*QUANTUM # COMPACTED -> ADD EXCITED J OFFSET*/
         jj_ofs = j_ofs + (je_qn << 16) ;


      /*EXCITED STATE -> DEFINE ROW/COLUMN DIMENSION AND TOTAL # OF EIGENVECTOR ELEMENTS*/
         ev_dim = 2 * je_qn + 1 ;
         ev_bssz = ev_dim * ev_dim ;
         ed_dim = (2 * je_qn + 1) * eno_ders ;


      /*READ IN J BLOCK OF EIGENVECTORS -> KETS VECTORS IN ROW FORM*/
         read( ev_fd, (char *)ev_mat, ev_bssz * sizeof( double ) ) ;

      /*READ NEXT J BLOCK OF EXCITED STATE DERVATIVES*/
         read( ed_fd, (char *)ed_mat, ed_dim * sizeof( double ) ) ;


      /*CALCULATE OFFSETS*/
         kg_ofs = jg_qn * jg_qn ;
         ke_ofs = je_qn * je_qn ;



      /*ERROR ANALYSIS*/
         if( Err == 2 )
            {
            g_ofs = (jg_qn > 0) ? (jg_qn - 1) * (4 * (jg_qn - 1) * (jg_qn - 1) +
                  12 * (jg_qn - 1) + 11) / 3 + 1 : 0 ;

            e_ofs = (je_qn > 0) ? (je_qn - 1) * (4 * (je_qn - 1) * (je_qn - 1) +
                  12 * (je_qn - 1) + 11) / 3 + 1 : 0 ;

            printf( "\n\n\n" ) ;
            printf( "JG_QN>  %ld  JE_QN>  %ld  KG_OFS> %ld  KE_OFS> %ld  ", jg_qn, je_qn, kg_ofs, ke_ofs ) ;
            printf( "GV_OFS> %ld  EV_OFS> %ld  GV_DIM> %ld  EV_DIM> %ld\n", g_ofs, e_ofs, gv_dim, ev_dim ) ;
            fflush( stdout ) ;
            }



      /*LOOP THROUGH ALL GROUND STATE K VALUES -> KA KC (PROLATE) JG 0, JG 1, JG-1 1, ...*/
         for( kg_qn = kg_ofs, gv_ct = 0; gv_ct < gv_dim; gv_ct++, kg_qn++ )
            {

         /*ADD GROUND TAU OFFSET*/
            jjk_ofs = jj_ofs + ((jg_qn + *(kag_pt + kg_qn) - *(kcg_pt + kg_qn)) << 8) ;


        /*CALCULATE BEGINNING AND END KE LEVELS TO CONSIDER FROM DELTA K ORDER*/
            ev_beg = ((ev_end = 2 * (kag_pt[ kg_qn ] - Dk_order) - 1) > 0) ? ev_end : 0 ;
            ev_end = ((ev_end += dk_span) < ev_dim) ? ev_end : ev_dim ;


         /*LOOP THROUGH SELECTED EXCITED STATE K VALUES -> KA KC (PROLATE) JE 0, JE 1, JE-1 1, ...*/
            for( ke_qn = ke_ofs + ev_beg, ev_ct = ev_beg; ev_ct < ev_end; ev_ct++, ke_qn++ )
               {

            /*ERROR ANALYSIS*/
               if( Err == 2 )
                  {
                  printf( "\nKAG_QN> %hd  KCG_QN> %hd  ", kag_pt[ kg_qn ], kcg_pt[ kg_qn ] ) ;
                  printf( "KAE_QN> %hd  KCE_QN> %hd  ", kae_pt[ ke_qn ], kce_pt[ ke_qn ] ) ;
                  printf( "GV_CT> %ld  EV_CT> %ld  ", gv_ct, ev_ct ) ;
                  printf( "KG_OFS> %ld  KE_OFS> %ld \n", kg_qn, ke_qn ) ;
                  fflush( stdout ) ;
                  }


            /*DO NOT TEST PARITY OR APPLY PARITY SELECTION RULES*/
               if( !Parity_stat ||
                     (!((*(kag_pt + kg_qn) + *(kae_pt + ke_qn) + Ka_parity) % 2) &&
                     !((*(kcg_pt + kg_qn) + *(kce_pt + ke_qn) + Kc_parity) % 2)) )
                  {


               /*INITIALIZE AMPLITUDE FOR RUNNING SUM*/
                  ar_amp = br_amp = ci_amp = c_itn = 0.0 ;

               /*REASSIGN ARRAY ADDRESSES TO ZERO OFFSET POINTERS*/
                  g_pt = gv_mat + gv_ct * gv_dim ;
                  e_pt = ev_mat + ev_ct * ev_dim ;



               /*P BRANCH -> LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                  if( jg_qn == je_qn + 1 )
                     {


                  /*CALCULATE MUE A CONTRIBUTION TO GIVEN INTENSITY*/
                     if( A_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( g_ct = 1, e_ct = 0, w_ct = 0; w_ct < ap_cg_dim; w_ct++, e_ct++, g_ct++ )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> DIAGONAL*/
                           ar_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(ap_cg_vec + w_ct) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        ar_amp *= A_prj ;
                        }


                  /*CALCULATE MUE B CONTRIBUTION TO GIVEN INTENSITY*/
                     if( B_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( w_ct = 0, g_ct = 0, e_ct = 0; w_ct < bcp_cg_dim;
                                 e_ct++, g_ct++, w_ct += 2 )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> LOWER(-1) - UPPER(+1)*/
                           br_amp += *(g_pt + g_ct + 2) * *(e_pt + e_ct) * *(bp_cg_vec + w_ct + 1) -
                                *(g_pt + g_ct) * *(e_pt + e_ct) * *(bp_cg_vec + w_ct) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        br_amp *= B_prj ;
                        }


                  /*CALCULATE MUE C CONTRIBUTION TO GIVEN INTENSITY*/
                     if( C_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( w_ct = 0, g_ct = 0, e_ct = 0; w_ct < bcp_cg_dim;
                                 e_ct++, g_ct++, w_ct += 2 )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> UPPER(+1) + LOWER(-1)*/
                           ci_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(cp_cg_vec + w_ct) +
                                *(g_pt + g_ct + 2) * *(e_pt + e_ct) * *(cp_cg_vec + w_ct + 1) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        ci_amp *= C_prj ;

                     /*SQUARE C AMPLITUDE FOR INTENSITY -> NEVER MIX WITH A OR B WITHOUT IMAG OPERATOR*/
                        c_itn = ci_amp * ci_amp ;
                        }
                     }



               /*Q BRANCH -> LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                  if( jg_qn == je_qn )
                     {


                  /*CALCULATE MUE A CONTRIBUTION TO GIVEN INTENSITY*/
                     if( A_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( g_ct = 0, e_ct = 0, w_ct = 0; w_ct < aq_cg_dim; w_ct++, e_ct++, g_ct++ )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> DIAGONAL*/
                           ar_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(aq_cg_vec + w_ct) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        ar_amp *= A_prj ;
                        }


                  /*CALCULATE MUE B CONTRIBUTION TO GIVEN INTENSITY*/
                     if( B_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( g_ct = 0, e_ct = 1, w_ct = 0; w_ct < bcq_cg_dim;
                                 w_ct += 2, e_ct++, g_ct++ )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> LOWER(-1) - UPPER(+1)*/
                           br_amp += *(g_pt + e_ct) * *(e_pt + g_ct) * *(bq_cg_vec + w_ct + 1) -
                                *(g_pt + g_ct) * *(e_pt + e_ct) * *(bq_cg_vec + w_ct) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        br_amp *= B_prj ;
                        }


                  /*CALCULATE MUE C CONTRIBUTION TO GIVEN INTENSITY*/
                     if( C_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( g_ct = 0, e_ct = 1, w_ct = 0; w_ct < bcq_cg_dim;
                                 w_ct += 2, e_ct++, g_ct++ )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> UPPER(+1) + LOWER(-1)*/
                           ci_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(cq_cg_vec + w_ct) +
                                *(g_pt + e_ct) * *(e_pt + g_ct) * *(cq_cg_vec + w_ct + 1) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        ci_amp *= C_prj ;

                     /*SQUARE C AMPLITUDE FOR INTENSITY -> NEVER MIX WITH A OR B WITHOUT IMAG OPERATOR*/
                        c_itn = ci_amp * ci_amp ;
                        }
                     }




               /*R BRANCH -> LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                  if( jg_qn + 1 == je_qn )
                     {


                  /*CALCULATE MUE A CONTRIBUTION TO GIVEN INTENSITY*/
                     if( A_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( g_ct = 0, e_ct = 1, w_ct = 0; w_ct < ar_cg_dim; w_ct++, e_ct++, g_ct++ )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> DIAGONAL*/
                           ar_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(ar_cg_vec + w_ct) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        ar_amp *= A_prj ;
                        }


                  /*CALCULATE MUE B CONTRIBUTION TO GIVEN INTENSITY*/
                     if( B_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( w_ct = 0, g_ct = 0, e_ct = 0; w_ct < bcr_cg_dim;
                                 e_ct++, g_ct++, w_ct += 2 )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> LOWER(-1) - UPPER(+1)*/
                           br_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(br_cg_vec + w_ct) -
                                *(g_pt + g_ct) * *(e_pt + e_ct + 2) * *(br_cg_vec + w_ct + 1) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        br_amp *= B_prj ;
                        }


                  /*CALCULATE MUE C CONTRIBUTION TO GIVEN INTENSITY*/
                     if( C_type )
                        {

                     /*LOOP THROUGH GROUND AND EXCITED STATE EIGENVECTORS*/
                        for( w_ct = 0, g_ct = 0, e_ct = 0; w_ct < bcr_cg_dim;
                                 e_ct++, g_ct++, w_ct += 2 )
                           {

                        /*ACCUMULATE EIGENVECTOR WEIGHTED CG AMPLITUDE -> LOWER(-1) + UPPER(+1)*/
                           ci_amp += *(g_pt + g_ct) * *(e_pt + e_ct) * *(cr_cg_vec + w_ct) +
                                *(g_pt + g_ct) * *(e_pt + e_ct + 2) * *(cr_cg_vec + w_ct + 1) ;
                           }

                     /*CORRECT AMPLITUDE FOR TRANSITION MOMENT PROJECTION AND AXIS ROTATION*/
                        ci_amp *= C_prj ;

                     /*SQUARE C AMPLITUDE FOR INTENSITY -> NEVER MIX WITH A OR B WITHOUT IMAG OPERATOR*/
                        c_itn = ci_amp * ci_amp ;
                        }
                     }



               /*ACCUMULATE NET AMPLITUDE -> A AND B INTERFERENCE EFFECTS POSSIBLE*/
                  abr_amp = ar_amp + br_amp ;

               /*SQUARE SUM OF A AND B AMPLITUDES FOR INTENSITY AND ADD C INTENSITY ON*/
                  abc_itn = abr_amp * abr_amp + c_itn ;


               /*ERROR ANALYSIS*/
                  if( Err == 2 )
                     {
                     printf( "A AMP> %f   B AMP> %f", ar_amp / A_prj, br_amp / B_prj ) ;
                     printf( "   C AMP> %f\n", ci_amp / C_prj ) ;
                     printf( "A PRJ> %f   B PRJ> %f   C PRJ> %f\n", ar_amp, br_amp, ci_amp ) ;
                     printf( "** A+B+C AMP> %f  A+B+C ITN = %f  ", abr_amp + ci_amp, abc_itn ) ;
                     fflush( stdout ) ;
                     }



               /*MULTIPLY BY BOLTZMANN FACTOR - REDEFINE TEMPERATURE (K) IN MHZ*/
                  if( Temp > 0.0 )
                     abc_itn *= (boltz_amp = exp( -Erg_vec[ GND ][ kg_qn ] / (Temp * BOLTZMANN) )) ;



               /*CHECK FOR MATCH OF ASSIGNED LINE Q# WITH SIMULATED LINE Q#*/
                  if( asn_ct < Asn_nolvs )
                     {

                  /*ADD EXCITED TAU OFFSET*/
                     jjkk_ofs = jjk_ofs + je_qn + *(kae_pt + ke_qn) - *(kce_pt + ke_qn) ;


                  /*SKIP ASSIGNED LINE(S) -> CORRESPONDING SIMULATED LINE(S) MISSING*/
                     if( asn_ct < Asn_split )
                        {
                        while( asn_ct < Asn_nolvs && jjkk_ofs > *(Aqn_vec + asn_ct) )
                           {
                           printf( "REJECT = %ld %f\n", asn_ct, Aerg_vec[ asn_ct ] ) ;
                           asn_ct++ ;
                           Rej_nolvs++ ;
                           }
                        }


                  /*ASSIGNED LINE MATCHED WITH SIMULATED LINE*/
                     if( asn_ct < Asn_nolvs && jjkk_ofs == *(Aqn_vec + asn_ct) )
                        {

                     /*CALCULATE SIMULATED TRANSITION ENERGY*/
                        trs_erg = ori_erg + Erg_vec[ EXE ][ ke_qn ] - Erg_vec[ GND ][ kg_qn ] ;

                     /*WRITE INDEX INTO SIMULATION ARRAY*/
                        write( Lf_fd, (char *)&Trs_nolvs, sizeof( long ) ) ;

                     /*WRITE CALCULATED AND OBSERVED ENERGIES FOR LEAST SQUARES ANALYSIS*/
                        write( Lf_fd, (char *)&trs_erg, sizeof( double ) ) ;
                        write( Lf_fd, (char *)(Aerg_vec + asn_ct), sizeof( double ) ) ;


                     /*MICROWAVE - WRITE DIFFERENCE OF DERIVATIVES FOR LEAST SQUARES ANALYSIS*/
                        if( !Rc[ EXE ][ ORI ] )
                           {
                           for( cnt = 0; cnt < gno_ders; cnt++ )
                              {
                              der = *(gd_mat + gv_ct * gno_ders + cnt) + *(ed_mat + ev_ct * eno_ders + cnt) ;
                              write( Lf_fd, (char *)&der, sizeof( double ) ) ;
                              }

                        /*MICROWAVE - WRITE SAME NUMBER OF DERVATIVES AS WITH UV*/
                           if( Dual_Fit )
                              {
                              der = 0.0 ;
                              for( cnt = 0; cnt < eno_ders; cnt++ )
                                 write( Lf_fd, (char *)&der, sizeof( double ) ) ;
                              }
                           }

                     /*WRITE DERIVATIVES FOR LEAST SQUARES ANALYSIS FOR BOTH STATES*/
                        else
                           {
                           write( Lf_fd, (char *)(gd_mat + gv_ct * gno_ders), gno_ders * sizeof( double ) ) ;
                           write( Lf_fd, (char *)(ed_mat + ev_ct * eno_ders), eno_ders * sizeof( double ) ) ;
                           }


                     /*SET FLAG TO WRITE ALL ASSIGNED LINES REGARDLESS OF INTENSITY ON LAST LSF CYCLE*/
                        if( Lsflc_stat )
                           {
                           asnwt_stat = 1 ;

                        /*WRITE INDEX INTO SIMULATION ARRAY AND EXPERIMENTAL FREQUENCY*/
                           write( Ee_fd, (char *)&Trs_nolvs, sizeof( long ) ) ;
                           write( Ee_fd, (char *)(Aerg_vec + asn_ct), sizeof( double ) ) ;
                           }


                     /*INCREAMENT ASSIGNED LINE COUNT*/
                        asn_ct++ ;
                        }
                     }




               /*WRITE LINE WHEN LINE INTENSITY EXCEEDS CUTOFF OR HAS ASSIGNED LINE AND LAST LSF CYCLE*/
                  if( Lsflc_stat && (abc_itn > Itn_cut || asnwt_stat) )
                     {

                  /*RESET ASSIGNED WRITE FLAG*/
                     asnwt_stat = 0 ;


                  /*CONVERT SIMULATED INTENSITY TO SHORT INTEGER FORM*/
                     abc_itnf = (float)abc_itn ;

                  /*CALCULATE SIMULATED TRANSITION ENERGY AND CONVERT TO INTEGER FORM*/
                     trs_erg = ori_erg + Erg_vec[ EXE ][ ke_qn ] - Erg_vec[ GND ][ kg_qn ] ;

                  /*REASSIGN QUANTUM #'S TO SINGLE ARRAY*/
                     *(jk_vec + 0) = (short)je_qn ;
                     *(jk_vec + 1) = (short)*(kae_pt + ke_qn) ;
                     *(jk_vec + 2) = (short)*(kce_pt + ke_qn) ;
                     *(jk_vec + 3) = (short)jg_qn ;
                     *(jk_vec + 4) = (short)*(kag_pt + kg_qn) ;
                     *(jk_vec + 5) = (short)*(kcg_pt + kg_qn) ;

                  /*WRITE Q#'S SIM ERG, AND SIM INTENSITY INFO*/
                     write( Jk_fd, (char *)jk_vec, 6 * sizeof( short ) ) ;
                     write( Se_fd, (char *)&trs_erg, sizeof( double ) ) ;
                     write( Si_fd, (char *)&abc_itnf, sizeof( float ) ) ;

                  /*MICROWAVE - WRITE DIFFERENCE OF DERIVATIVES FOR LEAST SQUARES ANALYSIS*/
                     if( !Rc[ EXE ][ ORI ] )
                        {
                        for( cnt = 0; cnt < gno_ders; cnt++ )
                           {
                           der = *(gd_mat + gv_ct * gno_ders + cnt) + *(ed_mat + ev_ct * eno_ders + cnt) ;
                           write( Dv_fd, (char *)&der, sizeof( double ) ) ;
                           }

                     /*MICROWAVE - WRITE SAME NUMBER OF DERVATIVES AS WITH UV*/
                        if( Dual_Fit )
                           {
                           der = 0.0 ;
                           for( cnt = 0; cnt < eno_ders; cnt++ )
                              write( Dv_fd, (char *)&der, sizeof( double ) ) ;
                           }
                        }

                  /*WRITE DERIVATIVES FOR BOTH GROUND AND EXCITED STATE*/
                     else
                        {
                        write( Dv_fd, (char *)(gd_mat + gv_ct * gno_ders), gno_ders * sizeof( double ) ) ;
                        write( Dv_fd, (char *)(ed_mat + ev_ct * eno_ders), eno_ders * sizeof( double ) ) ;
                        }



                  /*AMPLITUDE STATUS OFF -> WRITE BAND TYPE ACCORDING TO OVERALL PARITY OF KA AND KC*/
                     if( !Amp_stat )
                        {

                     /*CALCULATE PARITY OF KA AND KC COMBINATIONS*/
                        ka_lbl = (*(kag_pt + kg_qn) + *(kae_pt + ke_qn)) % 2 ;
                        kc_lbl = (*(kcg_pt + kg_qn) + *(kce_pt + ke_qn)) % 2 ;

                     /*WRITE BAND TYPE -> A (EO)*/
                        if( !ka_lbl && kc_lbl )
                           write( Bt_fd, (char *)&Band_chr[ 1 ], sizeof( char ) ) ;

                     /*WRITE BAND TYPE -> B (OO)*/
                        else if( ka_lbl && kc_lbl )
                           write( Bt_fd, (char *)&Band_chr[ 2 ], sizeof( char ) ) ;

                     /*WRITE BAND TYPE -> C (OE)*/
                        else if( ka_lbl && !kc_lbl )
                           write( Bt_fd, (char *)&Band_chr[ 3 ], sizeof( char ) ) ;

                     /*WRITE BAND TYPE -> D (EE)*/
                        else
                           write( Bt_fd, (char *)&Band_chr[ 4 ], sizeof( char ) ) ;
                        }


                  /*AMPLITUDE STATUS ON -> WRITE AMPLITUDE OF BAND TYPES AND TOTAL INTENSITY FOR LINE*/
                     else
                        {

                     /*WRITE BAND TYPE ACCORDING TO PERTURBATION TERM ON -> X OR Y OR Z*/
                        write( Bt_fd, (char *)&Band_chr[ Band_type ], sizeof( char ) ) ;


                     /*ADD ONE SO JB ORDERS PRINT OUT OF AMPLITUDES FROM TOP TO BOTTOM*/
                        trs_erg += 0.0001 ;

                     /*INCLUDE BOLTZMANN FACTOR AND INTENSITY SCALAR IN AMPLITUDE*/
                        boltz_amp = sqrt( boltz_amp ) ;


                     /*WRITE MUE A AMPLITUDE CONTRIBUTION TO GIVEN INTENSITY*/
                        if( A_type )
                           {

                        /*CONVERT SIMULATED INTENSITY TO SHORT INTEGER FORM*/
                           abc_ampf = (float)(boltz_amp * ar_amp) ;

                        /*WRITE SMALL CASE -> USED IN JB TO DISTINGUISH AMPLITUDES FROM INTENSITIES*/
                           band_chr = tolower( Band_chr[ 1 ] ) ;


                        /*WRITE Q#'S SIM ERG, AND SIM INTENSITY INFO*/
                           write( Jk_fd, (char *)jk_vec, 6 * sizeof( short ) ) ;
                           write( Se_fd, (char *)&trs_erg, sizeof( double ) ) ;
                           write( Si_fd, (char *)&abc_ampf, sizeof( float ) ) ;

                        /*WRITE BAND TYPE -> A (EO)*/
                           write( Bt_fd, (char *)&band_chr, sizeof( char ) ) ;

                        /*INCREAMENT LINE COUNT*/
                           Trs_nolvs++ ;
                           }


                     /*WRITE MUE B AMPLITUDE CONTRIBUTION TO GIVEN INTENSITY*/
                        if( B_type )
                           {

                        /*CONVERT SIMULATED INTENSITY TO SHORT INTEGER FORM*/
                           abc_ampf = (float)(boltz_amp * br_amp) ;

                        /*WRITE SMALL CASE -> USED IN JB TO DISTINGUISH AMPLITUDES FROM INTENSITIES*/
                           band_chr = tolower( Band_chr[ 2 ] ) ;


                        /*WRITE Q#'S SIM ERG, AND SIM INTENSITY INFO*/
                           write( Jk_fd, (char *)jk_vec, 6 * sizeof( short ) ) ;
                           write( Se_fd, (char *)&trs_erg, sizeof( double ) ) ;
                           write( Si_fd, (char *)&abc_ampf, sizeof( float ) ) ;

                        /*WRITE BAND TYPE -> B (OO)*/
                           write( Bt_fd, (char *)&band_chr, sizeof( char ) ) ;

                        /*INCREAMENT LINE COUNT*/
                           Trs_nolvs++ ;
                           }


                     /*WRITE MUE A AMPLITUDE CONTRIBUTION TO GIVEN INTENSITY*/
                        if( C_type )
                           {

                        /*CONVERT SIMULATED INTENSITY TO SHORT INTEGER FORM*/
                           abc_ampf = (float)(boltz_amp * ci_amp) ;

                        /*WRITE SMALL CASE -> USED IN JB TO DISTINGUISH AMPLITUDES FROM INTENSITIES*/
                           band_chr = tolower( Band_chr[ 3 ] ) ;


                        /*WRITE Q#'S SIM ERG, AND SIM INTENSITY INFO*/
                           write( Jk_fd, (char *)jk_vec, 6 * sizeof( short ) ) ;
                           write( Se_fd, (char *)&trs_erg, sizeof( double ) ) ;
                           write( Si_fd, (char *)&abc_ampf, sizeof( float ) ) ;

                        /*WRITE BAND TYPE -> C (OE)*/
                           write( Bt_fd, (char *)&band_chr, sizeof( char ) ) ;

                        /*INCREAMENT LINE COUNT*/
                           Trs_nolvs++ ;
                           }
                        }


                  /*INCREAMENT LINE COUNT*/
                     Trs_nolvs++ ;
                     }
                  }
               }
            }
         }
      }


/*REDEFINE TOTAL # OF ASSIGNED LEVELS*/
   Acp_nolvs = Asn_nolvs - Rej_nolvs ;


/*CLOSE LOCAL FILES*/
   close( gv_fd ) ;
   close( ev_fd ) ;
   close( gd_fd ) ;
   close( ed_fd ) ;
   close( cg_fd ) ;


/*FREE LOCAL SPACE*/
   DFree1Dim( &gv_mat ) ;
   DFree1Dim( &ev_mat ) ;
   DFree1Dim( &gd_mat ) ;
   DFree1Dim( &ed_mat ) ;
   DFree1Dim( &cg_vec ) ;
   DFree1Dim( &ap_cg_vec ) ;
   DFree1Dim( &bp_cg_vec ) ;
   DFree1Dim( &cp_cg_vec ) ;
   DFree1Dim( &aq_cg_vec ) ;
   DFree1Dim( &bq_cg_vec ) ;
   DFree1Dim( &cq_cg_vec ) ;
   DFree1Dim( &ar_cg_vec ) ;
   DFree1Dim( &br_cg_vec ) ;
   DFree1Dim( &cr_cg_vec ) ;


/*FREE GLOBAL SPACE*/
   DFree1Dim( &Erg_vec[ GND ] ) ;
   DFree1Dim( &Erg_vec[ EXE ] ) ;
   SFree1Dim( &Ka_ary[ GND ] ) ;
   SFree1Dim( &Ka_ary[ EXE ] ) ;
   SFree1Dim( &Kc_ary[ GND ] ) ;
   SFree1Dim( &Kc_ary[ EXE ] ) ;


/*CLOSE LINEAR LEAST SQUARES ANALYSIS FILE*/
   close( Lf_fd ) ;


/*ON LAST LEAST SQUARES CYCLE*/
   if( Lsflc_stat )
      {

   /*CLOSE ALL FILES FOR WRITING*/
      close( Se_fd ) ;
      close( Si_fd ) ;
      close( Bt_fd ) ;
      close( Jk_fd ) ;
      close( Dv_fd ) ;
      if( Ee_fd )
         close( Ee_fd ) ;


   /*NO TRANSITIONS CALCULATED*/
      if( Trs_nolvs == 0 )
         {

      /*INFORM USER*/
         fprintf( Log_fp, "\nNO TRANSITIONS CALCULATED !\n" ) ;

      /*RETURN FAILURE*/
         return( -1 ) ;
         }
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*OPEN NEEDED FILES AND ALLOCATE NEEDED SPACE FOR ALL ARRAYS*/
short RTrsInit()
   {


/*PRINT BAND TYPE AS SINGLE LETTER -> PERTURBATION ON*/
   if( Amp_stat )
      fprintf( Log_fp, "\nBAND LABEL     = %c\n", Band_chr[ Band_type ] ) ;

/*LOG BAND TYPE, TM ORIENTATION, DEL K ORDER, TEMPERATURE AND INTENSITY CUTOFF*/
   fprintf( Log_fp, "DELTA K ORDER  = %ld\n", Dk_order ) ;
   fprintf( Log_fp, "TEMPERATURE(K) = %.3f\n", Temp ) ;
   fprintf( Log_fp, "INTENSITY CUT  = %.3f\n\n", Itn_cut ) ;


/*GROUND STATE -> DEFINE SPACE FOR LARGEST EIGENVECTOR MATRIX*/
   gv_bssz = (2 * J_max + 1) * (2 * J_max + 1) ;

/*ALLOCATE SPACE FOR LARGEST GROUND STATE EIGENVECTOR MATRIX*/
   gv_mat = NULL ;
   if( DAlloc1Dim( &gv_mat, gv_bssz ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (GV_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*DEFINE SPACE FOR LARGEST EXCITED STATE EIGENVECTOR MATRIX*/
   ev_bssz = (2 * J_max + 1) * (2 * J_max + 1) ;

/*EXCITED STATE -> ALLOCATE SPACE FOR LARGEST EIGENVECTOR MATRIX*/
   ev_mat = NULL ;
   if( DAlloc1Dim( &ev_mat, ev_bssz ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (EV_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*GROUND STATE -> DEFINE SPACE FOR LARGEST EIGENVECTOR MATRIX*/
   gd_dim = (2 * J_max + 1) * St_nodv[ GND ] ;

/*ALLOCATE SPACE FOR LARGEST GROUND STATE EIGENVECTOR MATRIX*/
   gd_mat = NULL ;
   if( DAlloc1Dim( &gd_mat, gd_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (GD_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*DEFINE SPACE FOR LARGEST EXCITED STATE EIGENVECTOR MATRIX*/
   ed_dim = (2 * J_max + 1) * St_nodv[ EXE ] ;

/*EXCITED STATE -> ALLOCATE SPACE FOR LARGEST EIGENVECTOR MATRIX*/
   ed_mat = NULL ;
   if( DAlloc1Dim( &ed_mat, ed_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (ED_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR LARGEST WIGNER 3J ARRAY*/
   cg_dim = 18 * J_max + 1 ;

/*INITIALIZE POINTER*/
   cg_vec = NULL ;
   if( DAlloc1Dim( &cg_vec, cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*P BRANCH -> INITIALIZE POINTER, CALCULATE DIMENSION AND ALLOCATE SPACE*/
   ap_cg_vec = NULL ;
   ap_cg_dim = 2 * (J_max - 1) + 1 ;
   if( DAlloc1Dim( &ap_cg_vec, ap_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (AP_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*P BRANCH -> INITIALIZE POINTER, CALCULATE DIMENSION AND ALLOCATE SPACE*/
   bp_cg_vec = NULL ;
   bcp_cg_dim = 2 * (2 * (J_max - 1) + 1) ;
   if( DAlloc1Dim( &bp_cg_vec, bcp_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (BP_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*P BRANCH -> INITIALIZE POINTER AND ALLOCATE SPACE*/
   cp_cg_vec = NULL ;
   if( DAlloc1Dim( &cp_cg_vec, bcp_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (CP_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }




/*Q BRANCH -> INITIALIZE POINTER, CALCULATE DIMENSION AND ALLOCATE SPACE*/
   aq_cg_vec = NULL ;
   aq_cg_dim = 2 * J_max + 1 ;
   if( DAlloc1Dim( &aq_cg_vec, aq_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (AQ_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*Q BRANCH -> INITIALIZE POINTER, CALCULATE DIMENSION AND ALLOCATE SPACE*/
   bq_cg_vec = NULL ;
   bcq_cg_dim = 4 * J_max ;
   if( DAlloc1Dim( &bq_cg_vec, bcq_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (BQ_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*Q BRANCH -> INITIALIZE POINTER AND ALLOCATE SPACE*/
   cq_cg_vec = NULL ;
   if( DAlloc1Dim( &cq_cg_vec, bcq_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (CQ_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }



/*R BRANCH -> INITIALIZE POINTER, CALCULATE DIMENSION AND ALLOCATE SPACE*/
   ar_cg_vec = NULL ;
   ar_cg_dim = 2 * J_max + 1 ;
   if( DAlloc1Dim( &ar_cg_vec, ar_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (AR_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*R BRANCH -> INITIALIZE POINTER, CALCULATE DIMENSION AND ALLOCATE SPACE*/
   br_cg_vec = NULL ;
   bcr_cg_dim = 2 * (2 * J_max + 1) ;
   if( DAlloc1Dim( &br_cg_vec, bcr_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (BR_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*R BRANCH -> INITIALIZE POINTER AND ALLOCATE SPACE*/
   cr_cg_vec = NULL ;
   if( DAlloc1Dim( &cr_cg_vec, bcr_cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT (CR_CG_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }



/*GROUND STATE -> OPEN FILE CONTAINING EIGENVECTORS*/
   if( (gv_fd = open( Sevr_flnm[ GND ], O_RDONLY | O_BINARY ) ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT -> CAN'T OPEN '%s' FILE !\n", Sevr_flnm[ GND ] ) ;
      return( -1 ) ;
      }


/*EXCITED STATE -> OPEN FILE CONTAINING EIGENVECTORS*/
   if( (ev_fd = open( Sevr_flnm[ EXE ], O_RDONLY | O_BINARY ) ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT -> CAN'T OPEN '%s' FILE !\n", Sevr_flnm[ EXE ] ) ;
      return( -1 ) ;
      }



/*GROUND STATE -> OPEN FILE CONTAINING DERVATIVES*/
   if( (gd_fd = open( Sdv_flnm[ GND ], O_RDONLY | O_BINARY ) ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT -> CAN'T OPEN '%s' FILE !\n", Sdv_flnm[ GND ] ) ;
      return( -1 ) ;
      }


/*GROUND STATE -> OPEN FILE CONTAINING DERVATIVES*/
   if( (ed_fd = open( Sdv_flnm[ EXE ], O_RDONLY | O_BINARY ) ) == -1 )
      {
      fprintf( Log_fp, "\nRTRSINIT -> CAN'T OPEN '%s' FILE !\n", Sdv_flnm[ EXE ] ) ;
      return( -1 ) ;
      }


/*OPEN CG FILE*/
   if( (cg_fd = open( Cg_flnm, O_RDONLY | O_BINARY )) == -1 )
      {
      fprintf( Log_fp, "RTRSINIT -> CAN'T OPEN FILE '%s' FOR READING !\n", Cg_flnm ) ;
      return( -1 ) ;
      }


/*MICROWAVE - APPEND TO FILE FOR LEAST SQUARES ANALYSIS INFORMATION*/
   if( Dual_Fit && !Rc[ EXE ][ ORI ] )
      {
      if( (Lf_fd = open( "IAR.lf", O_WRONLY | O_APPEND | O_BINARY, 0666 )) == -1 )
         {
         fprintf( Log_fp, "\nTRSSETUP -> CAN'T APPEND TO 'IAR.lf' FILE !\n" ) ;
         return( -1 ) ;
         }
      }

/*CREATE FILE FOR LEAST SQUARES ANALYSIS INFORMATION*/
   else
      {
      if( (Lf_fd = open( "IAR.lf", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
         {
         fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.lf' FILE !\n" ) ;
         return( -1 ) ;
         }
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*OPEN FILES TO WRITE SIMULATION INFORMATION*/
short TrsOut()
   {


/*CREATE FILE TO STORE SIMULATED ENERGIES*/
   if( (Se_fd = open( "IAR.se", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.se' FILE !\n" ) ;
      return( -1 ) ;
      }


/*CREATE FILE TO STORE MATCHING INDEX AND EXPERIMENTAL ENERGIES*/
   if( Asn_nolvs > 0 )
      {
      if( (Ee_fd = open( "IAR.ee", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
         {
         fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.ee' FILE !\n" ) ;
         return( -1 ) ;
         }
      }
   else
      Ee_fd = 0 ;


/*CREATE FILE TO STORE SIMULATED INTENSITIES*/
   if( (Si_fd = open( "IAR.si", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.si' FILE !\n" ) ;
      return( -1 ) ;
      }


/*CREATE FILE TO STORE QUANTUM #'S*/
   if( (Jk_fd = open( "IAR.jk", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.jk' FILE !\n" ) ;
      return( -1 ) ;
      }


/*CREATE FILE TO STORE BAND TYPES*/
   if( (Bt_fd = open( "IAR.bt", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.bt' FILE !\n" ) ;
      return( -1 ) ;
      }


/*CREATE FILE TO DERIVATIVES*/
   if( (Dv_fd = open( "IAR.dv", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {
      fprintf( Log_fp, "\nTRSSETUP -> CAN'T CREATE 'IAR.dv' FILE !\n" ) ;
      return( -1 ) ;
      }


/*RETURN SUCCESS*/
   return( 1 ) ;
   }






/*
                     /ERROR ANALYSIS/
                        if( Err == 2 )
                           {
                           printf( "GND DER> " ) ;
                           for( cts = 0; cts < gno_ders; cts++ )
                              printf( "%.4lf ", *(gd_mat + gv_ct * gno_ders + cts) ) ;
                           printf( "\nEXE DER> " ) ;
                           for( cts = 0; cts < eno_ders; cts++ )
                              printf( "%.4lf ", *(ed_mat + ev_ct * eno_ders + cts) ) ;
                           printf( "\n" ) ;
                           fflush( stdout ) ;
                           }
                  if( Err == 2 )
                     {
                     printf( "BTZ ITN> %lf\n", abc_itn ) ;
                     fflush( stdout ) ;
                     }
*/
